/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.boot;

import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.internal.boot.PlatformURLConnection;
import org.eclipse.core.internal.boot.PlatformURLHandler;
import org.eclipse.core.internal.boot.PlatformURLHandlerFactoryProxy;

public class PlatformURLHandlerFactory
implements URLStreamHandlerFactory {
    private static Hashtable handlers = new Hashtable();
    private static final String ECLIPSE_HANDLER_FACTORY = "org.eclipse.protocol.handler.factory";

    public PlatformURLHandlerFactory() {
        handlers.put("platform", new PlatformURLHandler());
    }

    public URLStreamHandler createURLStreamHandler(String protocol) {
        URLStreamHandler handler = null;
        Object element = handlers.get(protocol);
        if (element == null) {
            return null;
        }
        if (element instanceof URLStreamHandler) {
            handler = (URLStreamHandler)element;
        } else {
            URLStreamHandlerFactory f = (URLStreamHandlerFactory)element;
            handler = f.createURLStreamHandler(protocol);
            if (handler != null) {
                handlers.put(protocol, handler);
            } else {
                handlers.remove(protocol);
            }
        }
        return handler;
    }

    public static void register(String protocol, URLStreamHandlerFactory factory) {
        if (protocol.equals("platform")) {
            return;
        }
        handlers.put(protocol, factory);
    }

    public static void shutdown() {
        PlatformURLHandlerFactoryProxy p = PlatformURLHandlerFactoryProxy.getFactoryProxy();
        if (p != null) {
            p.setFactory(null);
        }
        PlatformURLConnection.shutdown();
    }

    public static void startup(String location) {
        PlatformURLHandlerFactoryProxy p;
        block3: {
            p = PlatformURLHandlerFactoryProxy.getFactoryProxy();
            if (p == null) {
                p = new PlatformURLHandlerFactoryProxy();
                try {
                    URL.setURLStreamHandlerFactory(p);
                }
                catch (Error e) {
                    Properties props = System.getProperties();
                    ((Hashtable)props).put(ECLIPSE_HANDLER_FACTORY, p);
                    System.setProperties(props);
                    if (!BootLoader.inDebugMode()) break block3;
                    System.out.println("WARNING: Unable to set URLStreamHandlerFactory.");
                    System.out.println("WARNING: Starting in toleration mode.");
                }
            }
        }
        p.setFactory(new PlatformURLHandlerFactory());
        PlatformURLConnection.startup(location);
    }
}

