/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.boot;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Hashtable;
import org.eclipse.core.internal.boot.PlatformURLConnection;
import org.eclipse.core.internal.boot.Policy;

public class PlatformURLHandler
extends URLStreamHandler {
    private static Hashtable connectionType = new Hashtable();
    public static final String PROTOCOL = "platform";
    public static final String FILE = "file";
    public static final String JAR = "jar";
    public static final String JAR_SEPARATOR = "!/";
    public static final String PROTOCOL_SEPARATOR = ":";
    static /* synthetic */ Class class$java$net$URL;

    protected PlatformURLHandler() {
    }

    public URLConnection openConnection(URL url) throws IOException {
        int ix;
        String spec = url.getFile().trim();
        if (spec.startsWith("/")) {
            spec = spec.substring(1);
        }
        if ((ix = spec.indexOf("/")) == -1) {
            String message = Policy.bind("url.invalidURL", url.toString());
            throw new MalformedURLException(message);
        }
        String type = spec.substring(0, ix);
        Constructor construct = (Constructor)connectionType.get(type);
        if (construct == null) {
            String message = Policy.bind("url.badVariant", url.toString());
            throw new MalformedURLException(message);
        }
        PlatformURLConnection c = null;
        try {
            c = (PlatformURLConnection)construct.newInstance(url);
        }
        catch (Exception e) {
            String message = Policy.bind("url.createConnection", url.toString());
            throw new IOException(message);
        }
        c.setResolvedURL(c.resolve());
        return c;
    }

    public static void register(String type, Class connectionClass) {
        try {
            Constructor c = connectionClass.getConstructor(class$java$net$URL == null ? (class$java$net$URL = PlatformURLHandler.class$("java.net.URL")) : class$java$net$URL);
            connectionType.put(type, c);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

