/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.boot;

import com.ibm.oti.vm.VM;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.internal.boot.InternalBootLoader;
import org.eclipse.core.internal.boot.PlatformClassLoader;
import org.eclipse.core.internal.boot.PlatformURLConnection;
import org.eclipse.core.internal.boot.ResourceEnumeration;
import org.eclipse.core.internal.boot.ResourceLoader;
import org.eclipse.core.internal.boot.URLContentFilter;

public abstract class DelegatingURLClassLoader
extends URLClassLoader {
    protected URL base;
    protected DelegateLoader[] imports = null;
    protected URLClassLoader resourceLoader = null;
    private Hashtable filterTable = new Hashtable();
    public static String devClassPath = null;
    public static boolean DEBUG = false;
    public static boolean DEBUG_SHOW_CREATE = true;
    public static boolean DEBUG_SHOW_ACTIVATE = true;
    public static boolean DEBUG_SHOW_ACTIONS = true;
    public static boolean DEBUG_SHOW_SUCCESS = true;
    public static boolean DEBUG_SHOW_FAILURE = true;
    public static String[] DEBUG_FILTER_CLASS = new String[0];
    public static String[] DEBUG_FILTER_LOADER = new String[0];
    public static String[] DEBUG_FILTER_RESOURCE = new String[0];
    public static String[] DEBUG_FILTER_NATIVE = new String[0];
    public static final String PLUGIN = "plugin";
    private static boolean isHotSwapEnabled = InternalBootLoader.inDevelopmentMode() & ((class$com$ibm$oti$vm$VM == null ? (class$com$ibm$oti$vm$VM = DelegatingURLClassLoader.class$("com.ibm.oti.vm.VM")) : class$com$ibm$oti$vm$VM).getModifiers() & 0x400) == 0;
    private static String[] JAR_VARIANTS = DelegatingURLClassLoader.buildJarVariants();
    private static String[] LIBRARY_VARIANTS = DelegatingURLClassLoader.buildLibraryVariants();
    static /* synthetic */ Class class$com$ibm$oti$vm$VM;

    private static String[] buildJarVariants() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("ws/" + InternalBootLoader.getWS() + "/");
        result.add("os/" + InternalBootLoader.getOS() + "/" + InternalBootLoader.getOSArch() + "/");
        result.add("os/" + InternalBootLoader.getOS() + "/");
        String nl = InternalBootLoader.getNL();
        nl = nl.replace('_', '/');
        while (nl.length() > 0) {
            result.add("nl/" + nl + "/");
            int i = nl.lastIndexOf(47);
            String string = nl = i < 0 ? "" : nl.substring(0, i);
        }
        result.add("");
        return result.toArray(new String[result.size()]);
    }

    private static String[] buildLibraryVariants() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("ws/" + InternalBootLoader.getWS() + "/");
        result.add("os/" + InternalBootLoader.getOS() + "/" + InternalBootLoader.getOSArch() + "/");
        result.add("os/" + InternalBootLoader.getOS() + "/");
        String nl = InternalBootLoader.getNL();
        nl = nl.replace('_', '/');
        while (nl.length() > 0) {
            result.add("nl/" + nl + "/");
            int i = nl.lastIndexOf(47);
            String string = nl = i < 0 ? "" : nl.substring(0, i);
        }
        result.add("");
        return result.toArray(new String[result.size()]);
    }

    public DelegatingURLClassLoader(URL[] codePath, URLContentFilter[] codeFilters, URL[] resourcePath, URLContentFilter[] resourceFilters, ClassLoader parent) {
        super(DelegatingURLClassLoader.mungeJarURLs(codePath), parent);
        int i;
        resourcePath = DelegatingURLClassLoader.mungeJarURLs(resourcePath);
        if (resourcePath != null && resourcePath.length > 0) {
            this.resourceLoader = new ResourceLoader(resourcePath);
        }
        if (codePath != null) {
            if (codeFilters == null || codeFilters.length != codePath.length) {
                throw new DelegatingLoaderException();
            }
            this.setHotSwapPath(this, codePath);
            i = 0;
            while (i < codePath.length) {
                if (codeFilters[i] != null) {
                    this.filterTable.put(codePath[i], codeFilters[i]);
                }
                ++i;
            }
        }
        if (resourcePath != null) {
            if (resourceFilters == null || resourceFilters.length != resourcePath.length) {
                throw new DelegatingLoaderException();
            }
            i = 0;
            while (i < resourcePath.length) {
                if (resourceFilters[i] != null) {
                    this.filterTable.put(resourcePath[i], resourceFilters[i]);
                }
                ++i;
            }
        }
    }

    public void addURLs(URL[] codePath, URLContentFilter[] codeFilters, URL[] resourcePath, URLContentFilter[] resourceFilters) {
        URL path;
        int i;
        Set keys = this.filterTable.keySet();
        codePath = DelegatingURLClassLoader.mungeJarURLs(codePath);
        if ((resourcePath = DelegatingURLClassLoader.mungeJarURLs(resourcePath)) != null && resourcePath.length > 0) {
            this.resourceLoader = new ResourceLoader(resourcePath);
        }
        if (codePath != null) {
            if (codeFilters == null || codeFilters.length != codePath.length) {
                throw new DelegatingLoaderException();
            }
            this.setHotSwapPath(this, codePath);
            i = 0;
            while (i < codePath.length) {
                path = codePath[i];
                if (!keys.contains(path)) {
                    this.addURL(path);
                    this.filterTable.put(path, codeFilters[i]);
                }
                ++i;
            }
        }
        if (resourcePath != null) {
            if (resourceFilters == null || resourceFilters.length != resourcePath.length) {
                throw new DelegatingLoaderException();
            }
            i = 0;
            while (i < resourcePath.length) {
                path = resourcePath[i];
                if (resourceFilters[i] != null && !keys.contains(path)) {
                    this.filterTable.put(path, resourceFilters[i]);
                }
                ++i;
            }
        }
    }

    private static URL mungeJarURL(URL url) {
        String file;
        if (url.getProtocol().equals("jar") && (file = url.getFile()).startsWith("file:")) {
            int ix = file.indexOf("!/");
            if (ix != -1) {
                file = file.substring(0, ix);
            }
            try {
                url = new URL(file);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return url;
    }

    private static URL[] mungeJarURLs(URL[] urls) {
        if (urls == null) {
            return null;
        }
        int i = 0;
        while (i < urls.length) {
            urls[i] = DelegatingURLClassLoader.mungeJarURL(urls[i]);
            ++i;
        }
        return urls;
    }

    protected Class checkClassVisibility(Class result, DelegatingURLClassLoader requestor, boolean inCache) {
        if (result == null) {
            return null;
        }
        if (this.isClassVisible(result, requestor)) {
            if (DEBUG && DEBUG_SHOW_SUCCESS && this.debugClass(result.getName())) {
                this.debug("found " + result.getName() + " in " + (inCache ? "cache" : this.getURLforClass(result).toExternalForm()));
            }
        } else {
            if (DEBUG && DEBUG_SHOW_ACTIONS && this.debugClass(result.getName())) {
                this.debug("skip " + result.getName() + " in " + (inCache ? "cache" : this.getURLforClass(result).toExternalForm()));
            }
            return null;
        }
        return result;
    }

    protected URL checkResourceVisibility(String name, URL result, DelegatingURLClassLoader requestor) {
        if (result == null) {
            return null;
        }
        if (this.isResourceVisible(name, result, requestor)) {
            if (DEBUG && DEBUG_SHOW_SUCCESS && this.debugResource(name)) {
                this.debug("found " + result);
            }
        } else {
            if (DEBUG && DEBUG_SHOW_ACTIONS && this.debugResource(name)) {
                this.debug("skip " + result);
            }
            result = null;
        }
        return result;
    }

    protected void debug(String s) {
        System.out.println(this.toString() + "^" + Integer.toHexString(Thread.currentThread().hashCode()) + " " + s);
    }

    protected boolean debugClass(String name) {
        if (this.debugLoader()) {
            return this.debugMatchesFilter(name, DEBUG_FILTER_CLASS);
        }
        return false;
    }

    protected void debugConstruction() {
        if (DEBUG && DEBUG_SHOW_CREATE && this.debugLoader()) {
            URL[] urls = this.getURLs();
            this.debug("Class Loader Created");
            this.debug("> baseURL=" + this.base);
            if (urls == null || urls.length == 0) {
                this.debug("> empty search path");
            } else {
                int i = 0;
                while (i < urls.length) {
                    this.debug("> searchURL=" + urls[i].toString());
                    URLContentFilter filter = (URLContentFilter)this.filterTable.get(urls[i]);
                    if (filter != null) {
                        this.debug(">    export=" + filter.toString());
                    }
                    ++i;
                }
            }
        }
    }

    protected String debugId() {
        return "";
    }

    protected boolean debugLoader() {
        return this.debugMatchesFilter(this.debugId(), DEBUG_FILTER_LOADER);
    }

    private boolean debugMatchesFilter(String name, String[] filter) {
        if (filter.length == 0) {
            return false;
        }
        int i = 0;
        while (i < filter.length) {
            if (filter[i].equals("*")) {
                return true;
            }
            if (name.startsWith(filter[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean debugNative(String name) {
        if (this.debugLoader()) {
            return this.debugMatchesFilter(name, DEBUG_FILTER_NATIVE);
        }
        return false;
    }

    protected boolean debugResource(String name) {
        if (this.debugLoader()) {
            return this.debugMatchesFilter(name, DEBUG_FILTER_RESOURCE);
        }
        return false;
    }

    protected void enableHotSwap(ClassLoader cl, Class clazz) {
        if (isHotSwapEnabled) {
            VM.enableClassHotSwap(clazz);
        }
    }

    protected Class findClassParents(String name, boolean resolve) {
        try {
            ClassLoader parent = this.getParent();
            if (parent == null) {
                return this.findSystemClass(name);
            }
            return parent.loadClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    protected abstract Class findClassParentsSelf(String var1, boolean var2, DelegatingURLClassLoader var3, boolean var4);

    protected Class findClassPlatform(String name, boolean resolve, DelegatingURLClassLoader requestor, boolean checkParents) {
        PlatformClassLoader platform = PlatformClassLoader.getDefault();
        if (this == platform) {
            return null;
        }
        return ((DelegatingURLClassLoader)platform).findClassParentsSelf(name, resolve, requestor, false);
    }

    protected Class findClassPrerequisites(String name, DelegatingURLClassLoader requestor, Vector seen) {
        if (this.imports == null) {
            return null;
        }
        if (seen == null) {
            seen = new Vector<DelegatingURLClassLoader>();
        }
        seen.addElement(this);
        DelegateLoader[] loaders = this.imports;
        int i = 0;
        while (i < loaders.length) {
            Class result = loaders[i].loadClass(name, this, requestor, seen);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    protected URL findClassResource(String name) {
        return super.findResource(name);
    }

    protected String findLibrary(String libName) {
        URL foundPath;
        URL[] searchList;
        if (libName.length() == 0) {
            return null;
        }
        if (libName.charAt(0) == '/' || libName.charAt(0) == '\\') {
            libName = libName.substring(1);
        }
        libName = System.mapLibraryName(libName);
        if (DEBUG && DEBUG_SHOW_ACTIONS && this.debugNative(libName)) {
            this.debug("findLibrary(" + libName + ")");
        }
        if (this.base == null) {
            return null;
        }
        String libFileName = null;
        if (this.base.getProtocol().equals("file")) {
            libFileName = (this.base.getFile() + libName).replace('/', File.separatorChar);
        } else if (this.base.getProtocol().equals("platform") && (searchList = this.getSearchURLs(this.base)) != null && searchList.length != 0 && (foundPath = this.searchVariants(searchList, LIBRARY_VARIANTS, libName)) != null) {
            libFileName = foundPath.getFile();
        }
        if (libFileName == null) {
            return null;
        }
        return new File(libFileName).getAbsolutePath();
    }

    public URL findResource(String name) {
        return this.findResource(name, this, null);
    }

    protected URL findResource(String name, DelegatingURLClassLoader requestor, Vector seen) {
        if (seen != null && seen.contains(this)) {
            return null;
        }
        if (DEBUG && DEBUG_SHOW_ACTIONS && this.debugResource(name)) {
            this.debug("findResource(" + name + ")");
        }
        URL result = super.findResource(name);
        if ((result = this.checkResourceVisibility(name, result, requestor)) != null) {
            return result;
        }
        if (this.resourceLoader != null) {
            result = this.resourceLoader.findResource(name);
            if ((result = this.checkResourceVisibility(name, result, requestor)) != null) {
                return result;
            }
        }
        if (this.imports != null) {
            if (seen == null) {
                seen = new Vector<DelegatingURLClassLoader>();
            }
            seen.addElement(this);
            int i = 0;
            while (i < this.imports.length && result == null) {
                result = this.imports[i].findResource(name, this, requestor, seen);
                ++i;
            }
        }
        return result;
    }

    public Enumeration findResources(String name) throws IOException {
        return this.findResources(name, this, null);
    }

    private Enumeration findResources(String name, DelegatingURLClassLoader requestor, Vector seen) {
        if (seen != null && seen.contains(this)) {
            return null;
        }
        if (DEBUG && DEBUG_SHOW_ACTIONS && this.debugResource(name)) {
            this.debug("findResources(" + name + ")");
        }
        Enumeration<URL> e = null;
        try {
            e = super.findResources(name);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        ResourceEnumeration result = new ResourceEnumeration(name, e, this, requestor);
        if (this.imports != null) {
            if (seen == null) {
                seen = new Vector<DelegatingURLClassLoader>();
            }
            seen.addElement(this);
            int i = 0;
            while (i < this.imports.length) {
                result.add(this.imports[i].findResources(name, this, requestor, seen));
                ++i;
            }
        }
        return result;
    }

    protected String getFileFromURL(URL target) {
        try {
            URL url = InternalBootLoader.resolve(target);
            String protocol = url.getProtocol();
            if (protocol.equals("file")) {
                return url.getFile();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private URL[] getSearchURLs(URL base) {
        URL[] auxList = null;
        ArrayList<URL> result = new ArrayList<URL>();
        PlatformURLConnection c = null;
        try {
            c = (PlatformURLConnection)base.openConnection();
            result.add(c.getURLAsLocal());
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            auxList = c.getAuxillaryURLs();
            int auxLength = auxList == null ? 0 : auxList.length;
            int i = 0;
            while (i < auxLength) {
                try {
                    c = (PlatformURLConnection)auxList[i].openConnection();
                    result.add(c.getURLAsLocal());
                }
                catch (IOException e) {
                    // empty catch block
                }
                ++i;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return result.toArray(new URL[result.size()]);
    }

    private URL searchVariants(URL[] basePaths, String[] variants, String path) {
        int i = 0;
        while (i < variants.length) {
            int j = 0;
            while (j < basePaths.length) {
                String fileName = basePaths[j].getFile() + variants[i] + path;
                File file = new File(fileName);
                if (!file.exists()) {
                    if (DEBUG && DEBUG_SHOW_FAILURE) {
                        this.debug("not found " + file.getAbsolutePath());
                    }
                } else {
                    if (DEBUG && DEBUG_SHOW_SUCCESS) {
                        this.debug("found " + path + " as " + file.getAbsolutePath());
                    }
                    try {
                        return new URL("file:" + fileName);
                    }
                    catch (MalformedURLException e) {
                        // empty catch block
                    }
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public URL getResource(String name) {
        URL result;
        if (DEBUG && DEBUG_SHOW_ACTIONS && this.debugResource(name)) {
            this.debug("getResource(" + name + ")");
        }
        if ((result = super.getResource(name)) == null && DEBUG && DEBUG_SHOW_FAILURE && this.debugResource(name)) {
            this.debug("not found " + name);
        }
        return result;
    }

    private URL getURLforClass(Class clazz) {
        CodeSource cs;
        ProtectionDomain pd = clazz.getProtectionDomain();
        if (pd != null && (cs = pd.getCodeSource()) != null) {
            return cs.getLocation();
        }
        if (DEBUG && DEBUG_SHOW_ACTIONS && this.debugClass(clazz.getName())) {
            this.debug("*** " + clazz.getName());
        }
        return null;
    }

    public void initializeImportedLoaders() {
    }

    boolean isClassVisible(Class clazz, DelegatingURLClassLoader requestor) {
        URL lib = this.getURLforClass(clazz);
        if (lib == null) {
            return true;
        }
        URLContentFilter filter = (URLContentFilter)this.filterTable.get(lib);
        if (filter == null) {
            if (DEBUG && DEBUG_SHOW_ACTIONS && this.debugClass(clazz.getName())) {
                this.debug("*** Unable to find library filter for " + clazz.getName() + " from " + lib);
            }
            return false;
        }
        return filter.isClassVisible(clazz, this, requestor);
    }

    boolean isResourceVisible(String name, URL resource, DelegatingURLClassLoader requestor) {
        URL lib = null;
        String file = resource.getFile();
        try {
            lib = new URL(resource.getProtocol(), resource.getHost(), file.substring(0, file.length() - name.length()));
        }
        catch (MalformedURLException e) {
            if (DEBUG) {
                this.debug("Unable to determine resource lib for " + name + " from " + resource);
            }
            return false;
        }
        URLContentFilter filter = (URLContentFilter)this.filterTable.get(lib);
        if (filter == null) {
            filter = (URLContentFilter)this.filterTable.get(DelegatingURLClassLoader.mungeJarURL(lib));
        }
        if (filter == null) {
            if (DEBUG) {
                this.debug("Unable to find library filter for " + name + " from " + lib);
            }
            return false;
        }
        return filter.isResourceVisible(name, this, requestor);
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class result;
        if (DEBUG && DEBUG_SHOW_ACTIONS && this.debugClass(name)) {
            this.debug("loadClass(" + name + ")");
        }
        if ((result = this.loadClass(name, resolve, this, null, true)) == null) {
            if (DEBUG && DEBUG_SHOW_FAILURE && this.debugClass(name)) {
                this.debug("not found " + name);
            }
            throw new ClassNotFoundException(name);
        }
        return result;
    }

    private Class loadClass(String name, boolean resolve, DelegatingURLClassLoader requestor, Vector seen, boolean checkParents) {
        if (seen != null && seen.contains(this)) {
            return null;
        }
        Class result = this.findClassParentsSelf(name, resolve, requestor, checkParents);
        if (result == null) {
            result = this.findClassPlatform(name, resolve, requestor, false);
        }
        if (result == null) {
            result = this.findClassPrerequisites(name, requestor, seen);
        }
        if (result != null && resolve) {
            this.resolveClass(result);
        }
        return result;
    }

    private void setHotSwapPath(ClassLoader cl, URL[] urls) {
        if (!isHotSwapEnabled) {
            return;
        }
        StringBuffer path = new StringBuffer();
        int i = 0;
        while (i < urls.length) {
            String file = this.getFileFromURL(urls[i]);
            if (file != null) {
                if (file.charAt(0) == '/') {
                    file = file.substring(1, file.length());
                }
                if (file.charAt(file.length() - 1) == '/') {
                    file = file.substring(0, file.length() - 1);
                }
                if (path.length() > 0) {
                    path.append(";");
                }
                path.append(file);
            }
            ++i;
        }
        if (path.length() > 0) {
            VM.setClassPathImpl(cl, path.toString());
        }
    }

    protected void setImportedLoaders(DelegateLoader[] loaders) {
        this.imports = loaders;
        if (DEBUG && DEBUG_SHOW_CREATE && this.debugLoader()) {
            this.debug("Imports");
            if (this.imports == null || this.imports.length == 0) {
                this.debug("> none");
            } else {
                int i = 0;
                while (i < this.imports.length) {
                    this.debug("> " + this.imports[i].loader.toString() + " export=" + this.imports[i].isExported);
                    ++i;
                }
            }
        }
    }

    public String toString() {
        return "Loader [" + this.debugId() + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class DelegatingLoaderException
    extends RuntimeException {
        Exception e = null;

        public DelegatingLoaderException() {
        }

        public DelegatingLoaderException(String message) {
            super(message);
        }

        public DelegatingLoaderException(String message, Exception e) {
            super(message);
            this.e = e;
        }

        public Throwable getException() {
            return this.e;
        }

        public void printStackTrace() {
            this.printStackTrace(System.err);
        }

        public void printStackTrace(PrintStream output) {
            PrintStream printStream = output;
            synchronized (printStream) {
                if (this.e != null) {
                    output.print("org.eclipse.core.internal.boot.DelegatingLoaderException: ");
                    this.e.printStackTrace(output);
                } else {
                    super.printStackTrace(output);
                }
            }
        }

        public void printStackTrace(PrintWriter output) {
            PrintWriter printWriter = output;
            synchronized (printWriter) {
                if (this.e != null) {
                    output.print("org.eclipse.core.internal.boot.DelegatingLoaderException: ");
                    this.e.printStackTrace(output);
                } else {
                    super.printStackTrace(output);
                }
            }
        }
    }

    protected static class DelegateLoader {
        private DelegatingURLClassLoader loader;
        private boolean isExported;

        public DelegateLoader(DelegatingURLClassLoader loader, boolean isExported) {
            this.loader = loader;
            this.isExported = isExported;
        }

        public Class loadClass(String name, DelegatingURLClassLoader current, DelegatingURLClassLoader requestor, Vector seen) {
            if (this.isExported || current == requestor) {
                return this.loader.loadClass(name, false, requestor, seen, false);
            }
            return null;
        }

        public URL findResource(String name, DelegatingURLClassLoader current, DelegatingURLClassLoader requestor, Vector seen) {
            if (this.isExported || current == requestor) {
                return this.loader.findResource(name, requestor, seen);
            }
            return null;
        }

        public Enumeration findResources(String name, DelegatingURLClassLoader current, DelegatingURLClassLoader requestor, Vector seen) {
            if (this.isExported || current == requestor) {
                return this.loader.findResources(name, requestor, seen);
            }
            return null;
        }
    }
}

