/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.pm.OS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public abstract class Widget {
    int style;
    int state;
    EventTable eventTable;
    Object data;
    String[] keys;
    Object[] values;
    static final int DISABLED = 64;
    static final int HIDDEN = 128;
    static final int DISPOSED = 1024;
    static final int CANVAS = 4096;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;
    static final char Mnemonic = '&';

    Widget() {
    }

    public Widget(Widget parent, int style) {
        this.checkSubclass();
        this.checkParent(parent);
        this.style = style;
    }

    public void addListener(int eventType, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(eventType, listener);
    }

    public void addDisposeListener(DisposeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(12, typedListener);
    }

    static int checkBits(int style, int int0, int int1, int int2, int int3, int int4, int int5) {
        int mask = int0 | int1 | int2 | int3 | int4 | int5;
        if ((style & mask) == 0) {
            style |= int0;
        }
        if ((style & int0) != 0) {
            style = style & ~mask | int0;
        }
        if ((style & int1) != 0) {
            style = style & ~mask | int1;
        }
        if ((style & int2) != 0) {
            style = style & ~mask | int2;
        }
        if ((style & int3) != 0) {
            style = style & ~mask | int3;
        }
        if ((style & int4) != 0) {
            style = style & ~mask | int4;
        }
        if ((style & int5) != 0) {
            style = style & ~mask | int5;
        }
        return style;
    }

    void checkParent(Widget parent) {
        if (parent == null) {
            this.error(4);
        }
        if (!parent.isValidThread()) {
            this.error(22);
        }
        if (parent.isDisposed()) {
            this.error(5);
        }
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    protected void checkWidget() {
        if (!this.isValidThread()) {
            this.error(22);
        }
        if (this.isDisposed()) {
            this.error(24);
        }
    }

    void destroyWidget() {
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (!this.isValidThread()) {
            this.error(22);
        }
        this.releaseChild();
        this.releaseWidget();
        this.destroyWidget();
    }

    void error(int code) {
        SWT.error(code);
    }

    public Object getData() {
        this.checkWidget();
        return this.data;
    }

    public Object getData(String key) {
        this.checkWidget();
        if (key == null) {
            this.error(4);
        }
        if (this.keys == null) {
            return null;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].equals(key)) {
                return this.values[i];
            }
            ++i;
        }
        return null;
    }

    public abstract Display getDisplay();

    String getName() {
        String string = this.getClass().getName();
        int index = string.lastIndexOf(46);
        if (index == -1) {
            return string;
        }
        return string.substring(index + 1, string.length());
    }

    String getNameText() {
        return "";
    }

    public int getStyle() {
        this.checkWidget();
        return this.style;
    }

    boolean hooks(int eventType) {
        if (this.eventTable == null) {
            return false;
        }
        return this.eventTable.hooks(eventType);
    }

    public boolean isDisposed() {
        return (this.state & 0x400) != 0;
    }

    protected boolean isListening(int eventType) {
        this.checkWidget();
        return this.hooks(eventType);
    }

    boolean isValidSubclass() {
        return Display.isValidClass(this.getClass());
    }

    boolean isValidThread() {
        return this.getDisplay().isValidThread();
    }

    public void notifyListeners(int eventType, Event event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        this.sendEvent(eventType, event);
    }

    void postEvent(int eventType, Event event) {
        if (this.eventTable == null) {
            return;
        }
        Display display = this.getDisplay();
        event.type = eventType;
        event.widget = this;
        event.display = display;
        if (event.time == 0) {
            event.time = OS.WinQueryMsgTime(display.hab);
        }
        display.postEvent(event);
    }

    void postEvent(int eventType) {
        if (this.eventTable == null) {
            return;
        }
        this.postEvent(eventType, new Event());
    }

    void releaseChild() {
    }

    void releaseHandle() {
    }

    void releaseWidget() {
        this.sendEvent(12);
        this.state |= 0x400;
        this.eventTable = null;
        this.data = null;
        this.keys = null;
        this.values = null;
    }

    public void removeListener(int eventType, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, listener);
    }

    protected void removeListener(int eventType, SWTEventListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(12, listener);
    }

    void sendEvent(Event event) {
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.sendEvent(event);
    }

    void sendEvent(int eventType, Event event) {
        if (this.eventTable == null) {
            return;
        }
        Display display = this.getDisplay();
        event.type = eventType;
        event.display = display;
        event.widget = this;
        if (event.time == 0) {
            event.time = OS.WinQueryMsgTime(display.hab);
        }
        this.eventTable.sendEvent(event);
    }

    void sendEvent(int eventType) {
        if (this.eventTable == null) {
            return;
        }
        this.sendEvent(eventType, new Event());
    }

    public void setData(Object data) {
        this.checkWidget();
        this.data = data;
    }

    public void setData(String key, Object value) {
        this.checkWidget();
        if (key == null) {
            this.error(4);
        }
        if (value == null) {
            if (this.keys == null) {
                return;
            }
            int index = 0;
            while (index < this.keys.length && !this.keys[index].equals(key)) {
                ++index;
            }
            if (index == this.keys.length) {
                return;
            }
            if (this.keys.length == 1) {
                this.keys = null;
                this.values = null;
            } else {
                String[] newKeys = new String[this.keys.length - 1];
                Object[] newValues = new Object[this.values.length - 1];
                System.arraycopy(this.keys, 0, newKeys, 0, index);
                System.arraycopy(this.keys, index + 1, newKeys, index, newKeys.length - index);
                System.arraycopy(this.values, 0, newValues, 0, index);
                System.arraycopy(this.values, index + 1, newValues, index, newValues.length - index);
                this.keys = newKeys;
                this.values = newValues;
            }
            return;
        }
        if (this.keys == null) {
            this.keys = new String[]{key};
            this.values = new Object[]{value};
            return;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].equals(key)) {
                this.values[i] = value;
                return;
            }
            ++i;
        }
        String[] newKeys = new String[this.keys.length + 1];
        Object[] newValues = new Object[this.values.length + 1];
        System.arraycopy(this.keys, 0, newKeys, 0, this.keys.length);
        System.arraycopy(this.values, 0, newValues, 0, this.values.length);
        newKeys[this.keys.length] = key;
        newValues[this.values.length] = value;
        this.keys = newKeys;
        this.values = newValues;
    }

    public String toString() {
        String string = "*Disposed*";
        if (!this.isDisposed()) {
            string = "*Wrong Thread*";
            if (this.isValidThread()) {
                string = this.getNameText();
            }
        }
        return this.getName() + " {" + string + "}";
    }
}

