/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.internal.pm.CLASSINFO;
import org.eclipse.swt.internal.pm.MRESULT;
import org.eclipse.swt.internal.pm.OS;
import org.eclipse.swt.internal.pm.PSZ;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TypedListener;

public class TabFolder
extends Composite {
    TabItem[] items;
    static final int TabFolderProc;
    static final PSZ TabFolderClass;

    public TabFolder(Composite parent, int style) {
        super(parent, TabFolder.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int callWindowProc(int msg, int mp1, int mp2) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.WinCallWindowProc(TabFolderProc, this.handle, msg, mp1, mp2);
    }

    static int checkStyle(int style) {
        return style & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createItem(TabItem item, int index) {
        int count = OS.WinSendMsg(this.handle, 856, 0, 512);
        if (0 > index || index > count) {
            this.error(6);
        }
        if (count == this.items.length) {
            TabItem[] newItems = new TabItem[this.items.length + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        int pageID = OS.WinSendMsg(this.handle, 853, 0, OS.MPFROM2SHORT((short)321, (short)4));
        System.arraycopy(this.items, index, this.items, index + 1, count - index);
        this.items[index] = item;
        if (count == 0) {
            Event event = new Event();
            event.item = this.items[0];
            this.sendEvent(13, event);
        }
    }

    void createHandle() {
        super.createHandle();
        this.state &= 0xFFFFEFFF;
    }

    void createWidget() {
        super.createWidget();
        this.items = new TabItem[4];
    }

    void destroyItem(TabItem item) {
        int count = OS.WinSendMsg(this.handle, 856, 0, 512);
        int index = 0;
        while (index < count) {
            if (this.items[index] == item) break;
            ++index;
        }
        if (index == count) {
            return;
        }
        int selectionIndex = OS.WinSendMsg(this.handle, 857, 0, OS.MPFROM2SHORT((short)32, (short)64));
        if (OS.WinSendMsg(this.handle, 852, selectionIndex, 4) == 0) {
            this.error(15);
        }
        System.arraycopy(this.items, index + 1, this.items, index, --count - index);
        this.items[count] = null;
        if (count == 0) {
            this.items = new TabItem[4];
        }
        if (count > 0 && index == selectionIndex) {
            this.setSelection(Math.max(0, selectionIndex - 1));
            selectionIndex = this.getSelectionIndex();
            if (selectionIndex != -1) {
                Event event = new Event();
                event.item = this.items[selectionIndex];
                this.sendEvent(13, event);
            }
        }
    }

    public TabItem getItem(int index) {
        this.checkWidget();
        int count = OS.WinSendMsg(this.handle, 856, 0, 512);
        if (0 > index || index >= count) {
            this.error(6);
        }
        return this.items[index];
    }

    public int getItemCount() {
        this.checkWidget();
        return OS.WinSendMsg(this.handle, 856, 0, 512);
    }

    public TabItem[] getItems() {
        this.checkWidget();
        int count = OS.WinSendMsg(this.handle, 856, 0, 512);
        TabItem[] result = new TabItem[count];
        System.arraycopy(this.items, 0, result, 0, count);
        return result;
    }

    public TabItem[] getSelection() {
        this.checkWidget();
        int pageID = OS.WinSendMsg(this.handle, 857, 0, OS.MPFROM2SHORT((short)32, (short)64));
        int index = this.getTabIndex(pageID);
        if (index == -1) {
            return new TabItem[0];
        }
        return new TabItem[]{this.items[index]};
    }

    public int getSelectionIndex() {
        this.checkWidget();
        int pageID = OS.WinSendMsg(this.handle, 857, 0, OS.MPFROM2SHORT((short)32, (short)64));
        return this.getTabIndex(pageID);
    }

    public int indexOf(TabItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        int count = OS.WinSendMsg(this.handle, 856, 0, 512);
        int i = 0;
        while (i < count) {
            if (this.items[i] == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    boolean mnemonicHit(char key) {
        int i = 0;
        while (i < this.items.length) {
            TabItem item = this.items[i];
            if (item != null) {
                char ch = this.findMnemonic(item.getText());
                if (Character.toUpperCase(key) == Character.toUpperCase(ch) && this.setFocus()) {
                    this.setSelection(i, true);
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    boolean mnemonicMatch(char key) {
        int i = 0;
        while (i < this.items.length) {
            TabItem item = this.items[i];
            if (item != null) {
                char ch = this.findMnemonic(item.getText());
                if (Character.toUpperCase(key) == Character.toUpperCase(ch)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    void releaseWidget() {
        int count = OS.WinSendMsg(this.handle, 856, 0, 512);
        int i = 0;
        while (i < count) {
            TabItem item = this.items[i];
            if (!item.isDisposed()) {
                item.releaseWidget();
            }
            ++i;
        }
        this.items = null;
        super.releaseWidget();
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setSelection(TabItem[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        if (items.length == 0) {
            this.setSelection(-1);
            return;
        }
        int i = items.length - 1;
        while (i >= 0) {
            int index = this.indexOf(items[i]);
            if (index != -1) {
                this.setSelection(index);
            }
            --i;
        }
    }

    public void setSelection(int index) {
        this.checkWidget();
        this.setSelection(index, false);
    }

    void setSelection(int index, boolean notify) {
        int oldIndex = this.getSelectionIndex();
        if (oldIndex != -1) {
            TabItem item = this.items[oldIndex];
            Control control = item.control;
            if (control != null && !control.isDisposed()) {
                control.setVisible(false);
            }
        }
        OS.WinSendMsg(this.handle, 855, this.getPageID(index), 0);
        int newIndex = this.getSelectionIndex();
        if (newIndex != -1) {
            TabItem item = this.items[newIndex];
            Control control = item.control;
            if (control != null && !control.isDisposed()) {
                control.setBounds(this.getClientArea());
                control.setVisible(true);
            }
            if (notify) {
                Event event = new Event();
                event.item = item;
                this.sendEvent(13, event);
            }
        }
    }

    int getTabIndex(int pageID) {
        int total = OS.WinSendMsg(this.handle, 856, 0, 64);
        int diff = OS.WinSendMsg(this.handle, 856, pageID, 512);
        return total - diff;
    }

    int getPageID(int index) {
        int firstID;
        int id = firstID = OS.WinSendMsg(this.handle, 857, 0, OS.MPFROM2SHORT((short)4, (short)64));
        int i = 0;
        while (i <= index) {
            id = OS.WinSendMsg(this.handle, 857, id, OS.MPFROM2SHORT((short)8, (short)64));
            ++i;
        }
        return id;
    }

    boolean traversePage(boolean next) {
        int count = this.getItemCount();
        if (count == 0) {
            return false;
        }
        int index = this.getSelectionIndex();
        if (index == -1) {
            index = 0;
        } else {
            int offset = next ? 1 : -1;
            index = (index + offset + count) % count;
        }
        this.setSelection(index, true);
        return index == this.getSelectionIndex();
    }

    int widgetStyle() {
        int bits = super.widgetStyle() | Integer.MIN_VALUE | 0x20000000 | 0x800 | 0x40 | 0x10000000;
        return bits;
    }

    PSZ windowClass() {
        return TabFolderClass;
    }

    int windowProc() {
        return TabFolderProc;
    }

    MRESULT wmControlChild(int mp1, int mp2) {
        int code = mp1 >> 16;
        switch (code) {
            case 130: 
            case 134: {
                Control control;
                TabItem item = null;
                int pageID = OS.WinSendMsg(this.handle, 857, 0, OS.MPFROM2SHORT((short)32, (short)64));
                int index = this.getTabIndex(pageID);
                if (index != -1) {
                    item = this.items[index];
                }
                if (item != null && (control = item.control) != null && !control.isDisposed()) {
                    if (code == 130) {
                        control.setBounds(this.getClientArea());
                    }
                    control.setVisible(code == 130);
                }
                if (code != 130) break;
                Event event = new Event();
                event.item = item;
                this.postEvent(13, event);
            }
        }
        return super.wmControlChild(mp1, mp2);
    }

    static {
        TabFolderClass = PSZ.getAtom(-65496);
        CLASSINFO pclsiClassInfo = new CLASSINFO();
        OS.WinQueryClassInfo(0, TabFolderClass, pclsiClassInfo);
        TabFolderProc = pclsiClassInfo.pfnWindowProc;
    }
}

