/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.pm.CLASSINFO;
import org.eclipse.swt.internal.pm.MRESULT;
import org.eclipse.swt.internal.pm.OS;
import org.eclipse.swt.internal.pm.PSZ;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Slider
extends Control {
    int increment;
    int pageIncrement;
    static final int ScrollBarProc;
    static final PSZ ScrollBarClass;

    public Slider(Composite parent, int style) {
        super(parent, Slider.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int callWindowProc(int msg, int mp1, int mp2) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.WinCallWindowProc(ScrollBarProc, this.handle, msg, mp1, mp2);
    }

    static int checkStyle(int style) {
        return Widget.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int border = this.getBorderWidth();
        int width = border * 2;
        int height = border * 2;
        if ((this.style & 0x100) != 0) {
            width += OS.WinQuerySysValue(this.handle, 25) * 10;
            height += OS.WinQuerySysValue(this.handle, 23);
        } else {
            width += OS.WinQuerySysValue(this.handle, 22);
            height += OS.WinQuerySysValue(this.handle, 24) * 10;
        }
        if (wHint != -1) {
            width = wHint + border * 2;
        }
        if (hHint != -1) {
            height = hHint + border * 2;
        }
        return new Point(width, height);
    }

    void createWidget() {
        super.createWidget();
        this.increment = 1;
        this.pageIncrement = 10;
    }

    int defaultBackground() {
        return OS.WinQuerySysColor(this.handle, -25, 0);
    }

    int defaultForeground() {
        return OS.WinQuerySysColor(this.handle, -25, 0);
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 0x40) == 0;
    }

    public int getIncrement() {
        this.checkWidget();
        return this.increment;
    }

    public int getMaximum() {
        this.checkWidget();
        int mr = OS.WinSendMsg(this.handle, 419, 0, 0);
        return OS.SHORT2FROMMP(mr);
    }

    public int getMinimum() {
        this.checkWidget();
        int mr = OS.WinSendMsg(this.handle, 419, 0, 0);
        return OS.SHORT1FROMMP(mr);
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public int getSelection() {
        this.checkWidget();
        int usSliderPos = OS.WinSendMsg(this.handle, 418, 0, 0);
        return usSliderPos;
    }

    public int getThumb() {
        this.checkWidget();
        Point size = this.getSize();
        int prop = 0;
        int mr = OS.WinSendMsg(this.handle, 419, 0, 0);
        short min = OS.SHORT1FROMMP(mr);
        short max = OS.SHORT2FROMMP(mr);
        prop = (this.style & 0x100) != 0 ? (max - min) / size.x : (max - min) / size.y;
        return prop;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void setBounds(int x, int y, int width, int height, int flags) {
        super.setBounds(x, y, width, height, flags);
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        OS.WinEnableWindow(this.handle, enabled);
        this.state &= 0xFFFFFFBF;
        if (!enabled) {
            this.state |= 0x40;
        }
    }

    public void setIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        this.increment = value;
    }

    public void setMaximum(int value) {
        int usMinimum = 0;
        boolean hwnd = false;
        int usSliderPos = 0;
        this.checkWidget();
        if (value < 0) {
            return;
        }
        usMinimum = this.getMinimum();
        if (value - usMinimum < 1) {
            return;
        }
        usSliderPos = this.getSelection();
        OS.WinSendMsg(this.handle, 416, usSliderPos, OS.MPFROM2SHORT((short)usMinimum, (short)(value + 1)));
    }

    public void setMinimum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        int max = this.getMaximum();
        int pos = this.getSelection();
        OS.WinSendMsg(this.handle, 416, pos, OS.MPFROM2SHORT((short)value, (short)(max + 1)));
    }

    public void setPageIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        this.pageIncrement = value;
    }

    public void setSelection(int selection) {
        this.checkWidget();
        if (selection < 0) {
            return;
        }
        OS.WinSendMsg(this.handle, 417, selection, 0);
    }

    public void setThumb(int value) {
        short min;
        this.checkWidget();
        if (value < 1) {
            return;
        }
        int mr = OS.WinSendMsg(this.handle, 419, 0, 0);
        short max = OS.SHORT2FROMMP(mr);
        if (max - (min = OS.SHORT2FROMMP(mr)) - value < 0) {
            return;
        }
        OS.WinSendMsg(this.handle, 422, OS.MPFROM2SHORT((short)value, (short)(max + 1)), 0);
    }

    public void setValues(int selection, int minimum, int maximum, int thumb, int increment, int pageIncrement) {
        this.checkWidget();
        if (selection < 0) {
            return;
        }
        if (minimum < 0) {
            return;
        }
        if (maximum < 0) {
            return;
        }
        if (thumb < 1) {
            return;
        }
        if (maximum - minimum - thumb < 0) {
            return;
        }
        if (increment < 1) {
            return;
        }
        if (pageIncrement < 1) {
            return;
        }
        this.increment = increment;
        this.pageIncrement = pageIncrement;
        OS.WinSendMsg(this.handle, 416, selection, OS.MPFROM2SHORT((short)minimum, (short)maximum));
        this.setThumb(thumb);
    }

    int widgetStyle() {
        int bits = super.widgetStyle() | 0x20000;
        if ((this.style & 0x100) != 0) {
            return bits | 0;
        }
        return bits | 1;
    }

    PSZ windowClass() {
        return ScrollBarClass;
    }

    int windowProc() {
        return ScrollBarProc;
    }

    MRESULT wmScrollChild(int mp1, int mp2) {
        short pos = OS.SHORT1FROMMP(mp2);
        short code = OS.SHORT2FROMMP(mp2);
        int min = this.getMinimum();
        int max = this.getMaximum();
        if (code == 7) {
            return null;
        }
        Event event = new Event();
        int oldPos = 0;
        int newPos = 0;
        switch (code) {
            case 5: {
                if (pos == max) {
                    event.detail = 0x1000008;
                    break;
                }
                if (pos == min) {
                    event.detail = 0x1000007;
                    break;
                }
                event.detail = 1;
                break;
            }
            case 2: {
                event.detail = 0x1000002;
                oldPos = OS.WinSendMsg(this.handle, 418, 0, 0);
                newPos = oldPos + this.increment;
                OS.WinSendMsg(this.handle, 417, newPos, 0);
                break;
            }
            case 1: {
                event.detail = 0x1000001;
                oldPos = OS.WinSendMsg(this.handle, 418, 0, 0);
                newPos = Math.max(min, oldPos - this.increment);
                OS.WinSendMsg(this.handle, 417, newPos, 0);
                break;
            }
            case 4: {
                event.detail = 0x1000006;
                oldPos = OS.WinSendMsg(this.handle, 418, 0, 0);
                newPos = oldPos + this.pageIncrement;
                OS.WinSendMsg(this.handle, 417, newPos, 0);
                break;
            }
            case 3: {
                event.detail = 0x1000005;
                oldPos = OS.WinSendMsg(this.handle, 418, 0, 0);
                newPos = Math.max(min, oldPos - this.pageIncrement);
                OS.WinSendMsg(this.handle, 417, newPos, 0);
            }
        }
        this.sendEvent(13, event);
        return null;
    }

    static {
        ScrollBarClass = PSZ.getAtom(-65528);
        CLASSINFO pclsiClassInfo = new CLASSINFO();
        OS.WinQueryClassInfo(0, ScrollBarClass, pclsiClassInfo);
        ScrollBarProc = pclsiClassInfo.pfnWindowProc;
    }
}

