/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.internal.pm.MENUITEM;
import org.eclipse.swt.internal.pm.OS;
import org.eclipse.swt.internal.pm.PSZ;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Menu
extends Widget {
    public int handle;
    int x;
    int y;
    boolean hasLocation;
    MenuItem cascade;
    Decorations parent;

    public Menu(Control parent) {
        this(Menu.checkNull(parent).getShell(), 8);
    }

    public Menu(Decorations parent, int style) {
        super(parent, Menu.checkStyle(style));
        this.parent = parent;
        this.createWidget();
    }

    public Menu(Menu parentMenu) {
        this(Menu.checkNull((Menu)parentMenu).parent, 4);
    }

    public Menu(MenuItem parentItem) {
        this(Menu.checkNull((MenuItem)parentItem).parent);
    }

    public void addHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(28, typedListener);
    }

    public void addMenuListener(MenuListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(23, typedListener);
        this.addListener(22, typedListener);
    }

    static Control checkNull(Control control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    static Menu checkNull(Menu menu) {
        if (menu == null) {
            SWT.error(4);
        }
        return menu;
    }

    static MenuItem checkNull(MenuItem item) {
        if (item == null) {
            SWT.error(4);
        }
        return item;
    }

    static int checkStyle(int style) {
        return Widget.checkBits(style, 8, 2, 4, 0, 0, 0);
    }

    void createHandle() {
        if ((this.style & 2) != 0) {
            System.out.println("Menu:createHandle:  Menu Bar");
            this.handle = OS.WinCreateWindow(this.parent.frameHandle, PSZ.getAtom(-65532), null, 1, 0, 0, 0, 0, this.parent.frameHandle, 3, 32773, 0, 0);
        } else if ((this.style & 8) != 0) {
            this.handle = OS.WinCreateWindow(this.parent.handle, PSZ.getAtom(-65532), null, 0, 0, 0, 0, 0, this.parent.handle, 3, 0, 0, 0);
        } else if ((this.style & 4) != 0) {
            System.out.println("Menu:createHandle:  Menu DropDown");
            this.handle = OS.WinCreateWindow(1, PSZ.getAtom(-65532), null, 0, 0, 0, 0, 0, 1, 3, 32773, 0, 0);
        }
        if (this.handle == 0) {
            this.error(2);
        }
    }

    void createItem(MenuItem item, int index) {
        int count = this.GetMenuItemCount(this.handle);
        if (0 > index || index > count) {
            this.error(6);
        }
        this.parent.add(item);
        boolean success = false;
        MENUITEM info = new MENUITEM();
        info.iPosition = (short)-1;
        info.afStyle = 1;
        info.afAttribute = 0;
        info.id = (short)item.id;
        System.out.println("Menu:createItem ID = " + info.id);
        info.hwndSubMenu = 0;
        info.hItem = 0;
        int rc = OS.WinSendMsg(this.handle, 384, info, new PSZ(" "));
        if (rc != -1 && rc != -1) {
            success = true;
        }
        if (!success) {
            this.parent.remove(item);
            this.error(14);
        }
        this.redraw();
    }

    void createWidget() {
        this.createHandle();
        this.parent.add(this);
    }

    int defaultBackground() {
        return OS.WinQuerySysColor(this.handle, -21, 0);
    }

    int defaultForeground() {
        return OS.WinQuerySysColor(this.handle, -18, 0);
    }

    void destroyAcceleratorTable() {
        this.parent.destroyAcceleratorTable();
    }

    void destroyItem(MenuItem item) {
        int count = this.GetMenuItemCount(this.handle);
        int rc = OS.WinSendMsg(this.handle, 385, OS.MPFROM2SHORT((short)item.id, (short)1), 0);
        if (rc == count) {
            this.error(15);
        }
        this.redraw();
    }

    void destroyWidget() {
        int hMenu = this.handle;
        this.releaseHandle();
    }

    public MenuItem getDefaultItem() {
        this.checkWidget();
        int id = OS.WinSendMsg(this.handle, 1073, 0, 0);
        if (id == 0) {
            return null;
        }
        MENUITEM info = new MENUITEM();
        if (OS.WinSendMsg(this.handle, 386, OS.MPFROM2SHORT((short)id, (short)1), info)) {
            return this.parent.findMenuItem(info.id);
        }
        return null;
    }

    public Display getDisplay() {
        Decorations parent = this.parent;
        if (parent == null) {
            this.error(24);
        }
        return parent.getDisplay();
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 0x40) == 0;
    }

    public MenuItem getItem(int index) {
        this.checkWidget();
        MENUITEM info = new MENUITEM();
        int id = OS.WinSendMsg(this.handle, 400, (int)((short)index), 0);
        if (id == -1) {
            this.error(6);
        }
        OS.WinSendMsg(this.handle, 386, OS.MPFROM2SHORT((short)id, (short)1), info);
        return this.parent.findMenuItem(info.id);
    }

    public int getItemCount() {
        this.checkWidget();
        return OS.WinSendMsg(this.handle, 388, 0, 0);
    }

    public MenuItem[] getItems() {
        this.checkWidget();
        int index = 0;
        int length = OS.WinSendMsg(this.handle, 388, 0, 0);
        MenuItem[] items = new MenuItem[length];
        MENUITEM info = new MENUITEM();
        int idItem = 0;
        while ((idItem = OS.WinSendMsg(this.handle, 400, index, 0)) != -1) {
            if (index == items.length) {
                MenuItem[] newItems = new MenuItem[index + 4];
                System.arraycopy(items, 0, newItems, 0, index);
                items = newItems;
            }
            OS.WinSendMsg(this.handle, 386, OS.MPFROM2SHORT((short)idItem, (short)1), info);
            items[index++] = this.parent.findMenuItem(info.id);
        }
        if (index == items.length) {
            return items;
        }
        MenuItem[] result = new MenuItem[index];
        System.arraycopy(items, 0, result, 0, index);
        return result;
    }

    int GetMenuItemCount(int handle) {
        this.checkWidget();
        return OS.WinSendMsg(handle, 388, 0, 0);
    }

    String getNameText() {
        String result = "";
        MenuItem[] items = this.getItems();
        int length = items.length;
        if (length > 0) {
            int i = 0;
            while (i < length - 1) {
                result = result + items[i].getNameText() + ", ";
                ++i;
            }
            result = result + items[length - 1].getNameText();
        }
        return result;
    }

    public Decorations getParent() {
        this.checkWidget();
        return this.parent;
    }

    public MenuItem getParentItem() {
        this.checkWidget();
        return this.cascade;
    }

    public Menu getParentMenu() {
        this.checkWidget();
        if (this.cascade != null) {
            return this.cascade.parent;
        }
        return null;
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    public boolean getVisible() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return this == this.parent.menuShell().menuBar;
        }
        return this == this.getShell().activeMenu;
    }

    public int indexOf(MenuItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        int index = 0;
        MENUITEM info = new MENUITEM();
        int idItem = 0;
        while ((idItem = OS.WinSendMsg(this.handle, 400, index, 0)) != -1) {
            OS.WinSendMsg(this.handle, 386, OS.MPFROM2SHORT((short)idItem, (short)1), info);
            if (info.id == item.id) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public boolean isEnabled() {
        this.checkWidget();
        Menu parentMenu = this.getParentMenu();
        if (parentMenu == null) {
            return this.getEnabled();
        }
        return this.getEnabled() && parentMenu.isEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    void redraw() {
        if ((this.style & 2) != 0) {
            OS.WinSendMsg(this.parent.frameHandle, 66, 4, 0);
            return;
        }
    }

    void releaseChild() {
        super.releaseChild();
        if (this.cascade != null) {
            this.cascade.setMenu(null);
        }
        if ((this.style & 2) != 0 && this == this.parent.menuBar) {
            this.parent.setMenuBar(null);
        }
    }

    void releaseHandle() {
        this.handle = 0;
    }

    void releaseWidget() {
        MenuItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            MenuItem item = items[i];
            if (!item.isDisposed()) {
                item.releaseWidget();
            }
            ++i;
        }
        super.releaseWidget();
        if (this.parent != null) {
            this.parent.remove(this);
        }
        this.parent = null;
        this.cascade = null;
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, listener);
    }

    public void removeMenuListener(MenuListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(23, listener);
        this.eventTable.unhook(22, listener);
    }

    public void setDefaultItem(MenuItem item) {
        this.checkWidget();
        int command = -1;
        if (item != null) {
            if (item.isDisposed()) {
                this.error(5);
            }
            command = item.id;
        }
        OS.WinSendMsg(this.handle, 1074, command, 0);
        this.redraw();
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        this.state &= 0xFFFFFFBF;
        if (!enabled) {
            this.state |= 0x40;
        }
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        this.x = x;
        this.y = y;
        this.hasLocation = true;
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        int n = this.parent.handle;
    }
}

