/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.pm.CLASSINFO;
import org.eclipse.swt.internal.pm.FONTMETRICS;
import org.eclipse.swt.internal.pm.LBOXINFO;
import org.eclipse.swt.internal.pm.MRESULT;
import org.eclipse.swt.internal.pm.OS;
import org.eclipse.swt.internal.pm.PSZ;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class List
extends Scrollable {
    static final int ListProc;
    static final PSZ ListClass;

    public List(Composite parent, int style) {
        super(parent, List.checkStyle(style));
    }

    public void add(String string) {
        PSZ buffer;
        int result;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((result = OS.WinSendMsg(this.handle, 353, -2, buffer = new PSZ(string))) == -2) {
            this.error(14);
        }
        if (result == -3) {
            this.error(14);
        }
    }

    public void add(String string, int index) {
        PSZ buffer;
        int result;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (index == -1) {
            this.error(6);
        }
        if ((result = OS.WinSendMsg(this.handle, 353, index, buffer = new PSZ(string))) == -2) {
            this.error(14);
        }
        if (result == -3) {
            int count = OS.WinSendMsg(this.handle, 352, 0, 0);
            if (0 <= index && index <= count) {
                this.error(14);
            } else {
                this.error(6);
            }
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int callWindowProc(int msg, int mp1, int mp2) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.WinCallWindowProc(ListProc, this.handle, msg, mp1, mp2);
    }

    static int checkStyle(int style) {
        return Widget.checkBits(style, 4, 2, 0, 0, 0, 0);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int count = OS.WinSendMsg(this.handle, 352, 0, 0);
        return new Point(0, 0);
    }

    int defaultBackground() {
        return OS.WinQuerySysColor(this.handle, -47, 0);
    }

    public void deselect(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if (indices.length == 0) {
            return;
        }
        if ((this.style & 4) != 0) {
            int oldIndex = OS.WinSendMsg(this.handle, 357, 0, 0);
            if (oldIndex == -1) {
                return;
            }
            int i = 0;
            while (i < indices.length) {
                if (oldIndex == indices[i]) {
                    OS.WinSendMsg(this.handle, 356, oldIndex, 0);
                    return;
                }
                ++i;
            }
            return;
        }
        int i = 0;
        while (i < indices.length) {
            int index = indices[i];
            if (index != -1) {
                OS.WinSendMsg(this.handle, 356, index, 0);
            }
            ++i;
        }
    }

    public void deselect(int index) {
        this.checkWidget();
        if (index == -1) {
            return;
        }
        if ((this.style & 4) != 0) {
            int oldIndex = OS.WinSendMsg(this.handle, 357, 0, 0);
            if (oldIndex == -1) {
                return;
            }
            if (oldIndex == index) {
                OS.WinSendMsg(this.handle, 356, index, 0);
            }
            return;
        }
        OS.WinSendMsg(this.handle, 356, index, 0);
    }

    public void deselect(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        if ((this.style & 4) != 0) {
            int oldIndex = OS.WinSendMsg(this.handle, 357, 0, 0);
            if (oldIndex == -1) {
                return;
            }
            if (start <= oldIndex && oldIndex <= end) {
                OS.WinSendMsg(this.handle, 356, oldIndex, 0);
            }
            return;
        }
        int count = OS.WinSendMsg(this.handle, 352, 0, 0);
        if (start < 0 && end < 0) {
            return;
        }
        if (start >= count && end >= count) {
            return;
        }
        start = Math.min(count - 1, Math.max(0, start));
        end = Math.min(count - 1, Math.max(0, end));
        int i = start;
        while (i <= end) {
            OS.WinSendMsg(this.handle, 356, i, 0);
            ++i;
        }
    }

    public void deselectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int oldIndex = OS.WinSendMsg(this.handle, 357, 0, 0);
            if (oldIndex == -1) {
                return;
            }
            OS.WinSendMsg(this.handle, 356, oldIndex, 0);
            return;
        }
        int count = OS.WinSendMsg(this.handle, 352, 0, 0);
        int index = 0;
        int i = 0;
        while (i < count) {
            index = OS.WinSendMsg(this.handle, 357, index, 0);
            OS.WinSendMsg(this.handle, 356, index, 0);
            ++i;
        }
    }

    public int getFocusIndex() {
        this.checkWidget();
        return OS.WinSendMsg(this.handle, 357, -4, 0);
    }

    public String getItem(int index) {
        this.checkWidget();
        int length = OS.WinSendMsg(this.handle, 359, (int)((short)index), 0);
        if (length != -3) {
            PSZ buffer = new PSZ(length + 1);
            int result = OS.WinSendMsg(this.handle, 360, OS.MPFROM2SHORT((short)length, (short)index), buffer);
            if (result != 0) {
                return buffer.toString();
            }
        }
        int count = OS.WinSendMsg(this.handle, 352, 0, 0);
        if (0 <= index && index < count) {
            this.error(8);
        } else {
            this.error(6);
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        int result = OS.WinSendMsg(this.handle, 352, 0, 0);
        if (result == -3) {
            this.error(36);
        }
        return result;
    }

    public int getItemHeight() {
        this.checkWidget();
        int hps = this.hps;
        if (hps == 0) {
            hps = OS.WinGetPS(this.handle);
        }
        FONTMETRICS fm = new FONTMETRICS();
        OS.GpiQueryFontMetrics(hps, 228, fm);
        int result = fm.lMaxBaselineExt;
        if (this.hps == 0) {
            OS.WinReleasePS(hps);
        }
        return result;
    }

    public String[] getItems() {
        this.checkWidget();
        int count = this.getItemCount();
        String[] result = new String[count];
        int i = 0;
        while (i < count) {
            result[i] = this.getItem(i);
            ++i;
        }
        return result;
    }

    public String[] getSelection() {
        this.checkWidget();
        int[] indices = this.getSelectionIndices();
        String[] result = new String[indices.length];
        int i = 0;
        while (i < indices.length) {
            result[i] = this.getItem(indices[i]);
            ++i;
        }
        return result;
    }

    public int getSelectionCount() {
        this.checkWidget();
        int length = OS.WinSendMsg(this.handle, 352, 0, 0);
        int index = 0;
        int result = 0;
        int i = 0;
        while (i < length) {
            if ((index = OS.WinSendMsg(this.handle, 357, index, 0)) != -1) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    public int getSelectionIndex() {
        this.checkWidget();
        int index = OS.WinSendMsg(this.handle, 357, -1, 0);
        if (index == -1) {
            return -1;
        }
        return index;
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        int length = OS.WinSendMsg(this.handle, 352, 0, 0);
        int[] indices = new int[length];
        int index = 0;
        int i = 0;
        while (i < length) {
            if ((index = OS.WinSendMsg(this.handle, 357, index, 0)) != -1) {
                indices[i] = index;
                ++i;
            }
            ++i;
        }
        return indices;
    }

    public int getTopIndex() {
        this.checkWidget();
        return OS.WinSendMsg(this.handle, 365, 0, 0);
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int start) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.length() == 0) {
            int count = this.getItemCount();
            int i = start;
            while (i < count) {
                if (string.equals(this.getItem(i))) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
        int count = OS.WinSendMsg(this.handle, 352, 0, 0);
        if (0 > start || start >= count) {
            return -1;
        }
        int index = 0;
        PSZ buffer = new PSZ(string);
        index = OS.WinSendMsg(this.handle, 363, OS.MPFROM2SHORT((short)4, (short)start), buffer);
        if (index == -3 || index < start) {
            return -1;
        }
        return index;
    }

    public boolean isSelected(int index) {
        this.checkWidget();
        int result = OS.WinSendMsg(this.handle, 357, index, 0);
        return result != 0 && result != -1;
    }

    public void remove(int[] indices) {
        int index;
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        int[] newIndices = new int[indices.length];
        System.arraycopy(indices, 0, newIndices, 0, indices.length);
        this.sort(newIndices);
        int count = OS.WinSendMsg(this.handle, 352, 0, 0);
        int topIndex = OS.WinSendMsg(this.handle, 365, 0, 0);
        int i = 0;
        int topCount = 0;
        int last = -1;
        while (i < newIndices.length) {
            index = newIndices[i];
            if (index != last || i == 0) {
                int result = OS.WinSendMsg(this.handle, 355, index, 0);
                if (index < topIndex) {
                    ++topCount;
                }
                last = index;
            }
            ++i;
        }
        if (topCount > 0) {
            OS.WinSendMsg(this.handle, 354, (int)((short)(topIndex -= topCount)), 0);
        }
        if (i < newIndices.length) {
            index = newIndices[i];
            if (0 <= index && index < count) {
                this.error(15);
            }
            this.error(6);
        }
    }

    public void remove(int index) {
        int result;
        this.checkWidget();
        PSZ buffer = null;
        if ((this.style & 0x100) != 0) {
            int length = OS.WinSendMsg(this.handle, 359, (int)((short)index), 0);
            if (length == -3) {
                this.error(15);
            }
            buffer = new PSZ(length + 1);
            result = OS.WinSendMsg(this.handle, 360, OS.MPFROM2SHORT((short)length, (short)index), buffer);
            if (result <= 0) {
                this.error(15);
            }
        }
        int topIndex = OS.WinSendMsg(this.handle, 365, 0, 0);
        result = OS.WinSendMsg(this.handle, 355, (int)((short)index), 0);
        if (result <= 0) {
            int count = OS.WinSendMsg(this.handle, 352, 0, 0);
            if (0 <= index && index < count) {
                this.error(15);
            }
            this.error(6);
        }
        if (index < topIndex) {
            OS.WinSendMsg(this.handle, 354, (int)((short)(topIndex - 1)), 0);
        }
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        int count = OS.WinSendMsg(this.handle, 352, 0, 0);
        int topIndex = OS.WinSendMsg(this.handle, 365, 0, 0);
        int index = start;
        while (index <= end) {
            int result;
            PSZ buffer = null;
            if ((this.style & 0x100) != 0) {
                int length = OS.WinSendMsg(this.handle, 359, (int)((short)start), 0);
                if (length == -3) break;
                buffer = new PSZ(length + 1);
                int result2 = OS.WinSendMsg(this.handle, 360, OS.MPFROM2SHORT((short)length, (short)start), buffer);
                if (result2 <= 0) break;
            }
            if ((result = OS.WinSendMsg(this.handle, 355, (int)((short)start), 0)) <= 0) break;
            ++index;
        }
        if (end < topIndex) {
            OS.WinSendMsg(this.handle, 354, (int)((short)(topIndex -= end - start + 1)), 0);
        }
        if (index <= end) {
            if (0 <= index && index < count) {
                this.error(15);
            }
            this.error(6);
        }
    }

    public void remove(String string) {
        this.checkWidget();
        int index = this.indexOf(string, 0);
        if (index == -1) {
            this.error(5);
        }
        this.remove(index);
    }

    public void removeAll() {
        this.checkWidget();
        OS.WinSendMsg(this.handle, 366, 0, 0);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void select(int[] indices) {
        this.checkWidget();
        int focusIndex = this.getFocusIndex();
        int i = 0;
        while (i < indices.length) {
            int index = indices[i];
            if (index != -1) {
                OS.WinSendMsg(this.handle, 356, (int)((short)index), 1);
            }
            ++i;
        }
        if (focusIndex != -1) {
            this.setFocusIndex(focusIndex);
        }
    }

    public void select(int index) {
        this.checkWidget();
        if (index == -1) {
            return;
        }
        int n = OS.WinSendMsg(this.handle, 356, (int)((short)index), 1);
    }

    public void select(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        int count = OS.WinSendMsg(this.handle, 352, 0, 0);
        if (start < 0 && end < 0) {
            return;
        }
        if (start >= count && end >= count) {
            return;
        }
        if ((start = Math.min(count - 1, Math.max(0, start))) == (end = Math.min(count - 1, Math.max(0, end)))) {
            this.select(start);
            return;
        }
        int i = start;
        while (i <= end) {
            this.select(i);
            ++i;
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        int count = OS.WinSendMsg(this.handle, 352, 0, 0);
        int i = 0;
        while (i < count) {
            this.select(i);
            ++i;
        }
    }

    void setFocusIndex(int index) {
        OS.WinSendMsg(this.handle, 356, (int)((short)index), 1);
    }

    public void setFont(Font font) {
        this.checkWidget();
        super.setFont(font);
    }

    public void setItem(int index, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int topIndex = this.getTopIndex();
        boolean isSelected = this.isSelected(index);
        this.remove(index);
        this.add(string, index);
        if (isSelected) {
            this.select(index);
        }
        this.setTopIndex(topIndex);
    }

    public void setItems(String[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        OS.WinSendMsg(this.handle, 366, 0, 0);
        PSZ[] items2 = new PSZ[items.length];
        LBOXINFO lboxdata = new LBOXINFO();
        lboxdata.lItemIndex = 0;
        lboxdata.ulItemCount = items.length;
        int i = 0;
        while (i < items.length) {
            items2[i] = new PSZ(items[i]);
            ++i;
        }
        int count = OS.WinSendMsg(this.handle, 367, lboxdata, items2);
    }

    public void setSelection(int[] indices) {
        int focusIndex;
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            this.deselectAll();
        }
        this.select(indices);
        if ((this.style & 2) != 0 && indices.length != 0 && (focusIndex = indices[0]) != -1) {
            this.setFocusIndex(focusIndex);
        }
    }

    public void setSelection(String[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            this.deselectAll();
        }
        int focusIndex = -1;
        int i = items.length - 1;
        while (i >= 0) {
            String string = items[i];
            int index = 0;
            if (string != null) {
                int localFocus = -1;
                while ((index = this.indexOf(string, index)) != -1) {
                    if (localFocus == -1) {
                        localFocus = index;
                    }
                    this.select(index);
                    if ((this.style & 4) != 0 && this.isSelected(index)) {
                        return;
                    }
                    ++index;
                }
                if (localFocus != -1) {
                    focusIndex = localFocus;
                }
            }
            --i;
        }
        if ((this.style & 4) != 0) {
            this.deselectAll();
        }
        if ((this.style & 2) != 0 && focusIndex != -1) {
            this.setFocusIndex(focusIndex);
        }
    }

    public void setSelection(int index) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            this.deselectAll();
        }
        this.select(index);
        if ((this.style & 2) != 0 && index != -1) {
            this.setFocusIndex(index);
        }
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            this.deselectAll();
        }
        this.select(start, end);
        if ((this.style & 2) != 0 && start != -1) {
            this.setFocusIndex(start);
        }
    }

    public void setTopIndex(int index) {
        this.checkWidget();
        int result = OS.WinSendMsg(this.handle, 354, (int)((short)index), 0);
        if (result == 0) {
            int count = OS.WinSendMsg(this.handle, 352, 0, 0);
            index = Math.min(count - 1, Math.max(0, index));
            OS.WinSendMsg(this.handle, 354, (int)((short)index), 0);
        }
    }

    public void showSelection() {
        int result;
        this.checkWidget();
        int index = result = OS.WinSendMsg(this.handle, 357, -1, 0);
        if (result == -1) {
            return;
        }
        OS.WinSendMsg(this.handle, 354, (int)((short)index), 0);
    }

    int widgetStyle() {
        int bits = super.widgetStyle() | 4;
        if ((this.style & 4) != 0) {
            return bits;
        }
        if ((this.style & 2) != 0) {
            bits = (this.style & 0x40) != 0 ? (bits |= 1) : (bits |= 0x10);
        }
        if ((this.style & 0x100) != 0) {
            bits |= 8;
        }
        return bits;
    }

    PSZ windowClass() {
        return ListClass;
    }

    int windowProc() {
        return ListProc;
    }

    MRESULT wmControlChild(int mp1, int mp2) {
        int code = mp1 >> 16;
        switch (code) {
            case 1: {
                this.postEvent(13);
                break;
            }
            case 5: {
                this.postEvent(14);
            }
        }
        return super.wmControlChild(mp1, mp2);
    }

    MRESULT wmScroll(int msg, int mp1, int mp2) {
        int code = this.callWindowProc(msg, mp1, mp2);
        if (code == 0) {
            return MRESULT.ZERO;
        }
        return new MRESULT(code);
    }

    static {
        ListClass = PSZ.getAtom(-65529);
        CLASSINFO pclsiClassInfo = new CLASSINFO();
        OS.WinQueryClassInfo(0, ListClass, pclsiClassInfo);
        ListProc = pclsiClassInfo.pfnWindowProc;
    }
}

