/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.pm.CLASSINFO;
import org.eclipse.swt.internal.pm.FONTMETRICS;
import org.eclipse.swt.internal.pm.OS;
import org.eclipse.swt.internal.pm.PSZ;
import org.eclipse.swt.internal.pm.RECTL;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class Label
extends Control {
    String text = "";
    Image image;
    int font;
    static final int LabelProc;
    static final PSZ LabelClass;

    public Label(Composite parent, int style) {
        super(parent, Label.checkStyle(style));
    }

    int callWindowProc(int msg, int mp1, int mp2) {
        if (this.handle == 0) {
            return 0;
        }
        if (msg == 15) {
            return 0;
        }
        return OS.WinCallWindowProc(LabelProc, this.handle, msg, mp1, mp2);
    }

    static int checkStyle(int style) {
        if ((style & 2) != 0) {
            return style;
        }
        return Widget.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    byte[] computeWindowTextSize(int hps, FONTMETRICS fm, Point size) {
        size.x = 0;
        size.y = fm.lMaxBaselineExt;
        int length = OS.WinQueryWindowTextLength(this.handle);
        byte[] text = null;
        if (length != 0) {
            PSZ buffer = new PSZ(length);
            OS.WinQueryWindowText(this.handle, length + 1, buffer);
            RECTL rect = new RECTL();
            text = buffer.getBytes();
            int[] pnts = new int[10];
            int extX = 0;
            int dx = 0;
            int is = 0;
            while (is < length) {
                int ie = is + 512;
                if (ie > length) {
                    ie = length;
                }
                if (is != 0) {
                    System.arraycopy(text, is, text, 0, ie - is);
                }
                OS.GpiQueryTextBox(hps, ie - is, text, 5, pnts);
                extX += pnts[8];
                dx = pnts[4];
                if (dx < pnts[8]) {
                    dx = pnts[8];
                }
                dx -= pnts[8];
                is = ie;
            }
            size.x = extX + dx;
        }
        text = this.patchMnemonics(this.text).getBytes();
        return text;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        int border = this.getBorderWidth();
        if ((this.style & 2) != 0) {
            int lineWidth = OS.WinQuerySysValue(1, 26);
            if ((this.style & 0x100) != 0) {
                width = 64;
                height = lineWidth * 2;
            } else {
                width = lineWidth * 2;
                height = 64;
            }
            if (wHint != -1) {
                width = wHint;
            }
            if (hHint != -1) {
                height = hHint;
            }
            return new Point(width += border * 2, height += border * 2);
        }
        int extra = 0;
        int bits = OS.WinQueryWindowULong(this.handle, -2);
        if (this.image == null) {
            Point size = new Point(0, 0);
            int hps = this.hps;
            if (hps == 0) {
                hps = OS.WinGetPS(this.handle);
            }
            FONTMETRICS fm = new FONTMETRICS();
            OS.GpiQueryFontMetrics(hps, 228, fm);
            if (this.computeWindowTextSize(hps, fm, size) != null) {
                extra = Math.max(8, fm.lAveCharWidth);
                width += size.x;
            }
            height += size.y;
            if (this.hps == 0) {
                OS.WinReleasePS(hps);
            }
        } else {
            Rectangle rect = this.image.getBounds();
            width = rect.width;
            height = rect.height;
            extra = 4;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width += border * 2, height += border * 2);
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return 0;
        }
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    boolean getWrap() {
        int bits = OS.WinQueryWindowULong(this.handle, -2);
        if ((bits & 0x300) != 0) {
            return true;
        }
        return (bits & 0x4000) != 0;
    }

    boolean mnemonicHit(char key) {
        Composite control = this.parent;
        while (control != null) {
            Control[] children = control._getChildren();
            int index = 0;
            while (index < children.length) {
                if (children[index] == this) break;
                ++index;
            }
            if (++index < children.length && children[index].setFocus()) {
                return true;
            }
            control = control.parent;
        }
        return false;
    }

    boolean mnemonicMatch(char key) {
        char mnemonic = this.findMnemonic(this.getText());
        if (mnemonic == '\u0000') {
            return false;
        }
        return Character.toUpperCase(key) == Character.toUpperCase(mnemonic);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.image = null;
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= alignment & 0x1024000;
        int bits = OS.WinQueryWindowULong(this.handle, -2);
        bits &= 0xFFFFBCFF;
        if ((this.style & 0x4000) != 0 && (this.style & 0x40) != 0) {
            bits |= 0x4000;
        }
        if ((this.style & 0x1000000) != 0) {
            bits |= 0x100;
        }
        if ((this.style & 0x20000) != 0) {
            bits |= 0x200;
        }
        OS.WinSetWindowULong(this.handle, -2, bits);
        OS.WinInvalidateRect(this.handle, null, false);
    }

    public boolean setFocus() {
        this.checkWidget();
        return false;
    }

    public void setImage(Image image) {
        int newBits;
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        boolean hImage = false;
        int imageBits = 0;
        if (image != null) {
            if (image.isDisposed()) {
                this.error(5);
            }
            switch (image.type) {
                case 0: {
                    imageBits = 4;
                    break;
                }
                case 1: {
                    imageBits = 3;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        this.image = image;
        int oldBits = newBits = OS.WinQueryWindowULong(this.handle, -2);
        newBits &= 0xFFFFFFF8;
        if ((newBits |= imageBits) != oldBits) {
            OS.WinSetWindowULong(this.handle, -2, newBits);
        }
        OS.WinSendMsg(this.handle, 256, image.handle, 0);
        OS.WinInvalidateRect(this.handle, null, false);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        int bits = OS.WinQueryWindowULong(this.handle, -2);
        bits |= 1;
        if ((this.style & 0x4000) != 0) {
            bits |= 0;
        }
        if ((this.style & 0x1000000) != 0) {
            bits |= 0x500;
        }
        if ((this.style & 0x20000) != 0) {
            bits |= 0x200;
        }
        OS.WinSetWindowULong(this.handle, -2, bits);
        this.text = string = this.patchMnemonics(string);
        PSZ title = new PSZ(string);
        OS.WinSetWindowText(this.handle, title);
    }

    void setWrap(boolean wrap) {
        int bits = OS.WinQueryWindowULong(this.handle, -2);
        if ((bits & 0x300) != 0) {
            return;
        }
        bits &= 0x4000;
        if (!wrap) {
            bits |= 0xFFFFBFFF;
        }
        OS.WinSetWindowULong(this.handle, -2, bits);
        OS.WinInvalidateRect(this.handle, null, false);
    }

    int widgetStyle() {
        int bits = super.widgetStyle() | 1;
        if ((this.style & 0x1000000) != 0) {
            return bits | 0x100 | 0x800;
        }
        if ((this.style & 0x20000) != 0) {
            return bits | 0x200;
        }
        if ((this.style & 0x40) != 0) {
            return bits | 0x4000;
        }
        if ((this.style & 0x4000) != 0) {
            return bits | 0;
        }
        return bits;
    }

    PSZ windowClass() {
        return LabelClass;
    }

    int windowProc() {
        return LabelProc;
    }

    static {
        LabelClass = PSZ.getAtom(-65531);
        CLASSINFO pclsiClassInfo = new CLASSINFO();
        OS.WinQueryClassInfo(0, LabelClass, pclsiClassInfo);
        LabelProc = pclsiClassInfo.pfnWindowProc;
    }
}

