/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.pm.CLASSINFO;
import org.eclipse.swt.internal.pm.FONTMETRICS;
import org.eclipse.swt.internal.pm.OS;
import org.eclipse.swt.internal.pm.PSZ;
import org.eclipse.swt.internal.pm.RECTL;
import org.eclipse.swt.widgets.Composite;

public class Group
extends Composite {
    String text = "";
    static final int GroupProc;
    static final PSZ GroupClass;

    public Group(Composite parent, int style) {
        super(parent, Group.checkStyle(style));
    }

    int callWindowProc(int msg, int mp1, int mp2) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.WinCallWindowProc(GroupProc, this.handle, msg, mp1, mp2);
    }

    static int checkStyle(int style) {
        return (style |= 0x80000) & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    byte[] computeWindowTextSize(int hps, FONTMETRICS fm, Point size) {
        size.x = 0;
        size.y = fm.lMaxBaselineExt;
        int length = OS.WinQueryWindowTextLength(this.handle);
        byte[] text = null;
        if (length != 0) {
            PSZ buffer = new PSZ(length);
            OS.WinQueryWindowText(this.handle, length + 1, buffer);
            RECTL rect = new RECTL();
            text = buffer.getBytes();
            int[] pnts = new int[10];
            int extX = 0;
            int dx = 0;
            int is = 0;
            while (is < length) {
                int ie = is + 512;
                if (ie > length) {
                    ie = length;
                }
                if (is != 0) {
                    System.arraycopy(text, is, text, 0, ie - is);
                }
                OS.GpiQueryTextBox(hps, ie - is, text, 5, pnts);
                extX += pnts[8];
                dx = pnts[4];
                if (dx < pnts[8]) {
                    dx = pnts[8];
                }
                dx -= pnts[8];
                is = ie;
            }
            size.x = extX + dx;
        }
        text = this.patchMnemonics(this.text).getBytes();
        return text;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        Point sizeRect = new Point(0, 0);
        int hps = this.hps;
        if (hps == 0) {
            hps = OS.WinGetPS(this.handle);
        }
        FONTMETRICS fm = new FONTMETRICS();
        OS.GpiQueryFontMetrics(hps, 228, fm);
        this.computeWindowTextSize(hps, fm, sizeRect);
        if (this.hps == 0) {
            OS.WinReleasePS(hps);
        }
        Point size = this.layout != null ? this.layout.computeSize(this, wHint, hHint, changed) : this.minimumSize();
        width = size.x;
        height = size.y;
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, width, height);
        width = Math.max(trim.width, sizeRect.x + 6);
        height = trim.height;
        return new Point(width, height);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        Rectangle trim = super.computeTrim(x, y, width, height);
        boolean oldFont = false;
        Point size = new Point(0, 0);
        int hps = this.hps;
        if (hps == 0) {
            hps = OS.WinGetPS(this.handle);
        }
        FONTMETRICS fm = new FONTMETRICS();
        OS.GpiQueryFontMetrics(hps, 228, fm);
        if (this.hps == 0) {
            OS.WinReleasePS(hps);
        }
        int inset = 3;
        trim.x -= inset;
        trim.y -= fm.lEmHeight;
        trim.width += inset * 2;
        trim.height += fm.lEmHeight + inset;
        return trim;
    }

    void createHandle() {
        super.createHandle();
        this.state &= 0xFFFFEFFF;
    }

    public Rectangle getClientArea() {
        int inset;
        this.checkWidget();
        RECTL rcl = new RECTL();
        OS.WinQueryWindowRect(this.handle, rcl);
        int hps = this.hps;
        if (hps == 0) {
            hps = OS.WinGetPS(this.handle);
        }
        FONTMETRICS fm = new FONTMETRICS();
        OS.GpiQueryFontMetrics(hps, 228, fm);
        if (this.hps == 0) {
            OS.WinReleasePS(hps);
        }
        int x = inset = 3;
        int y = fm.lEmHeight;
        return new Rectangle(x, y, rcl.xRight - rcl.xLeft - inset * 2, rcl.yTop - rcl.yBottom - y - inset);
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    boolean mnemonicHit(char key) {
        return this.setFocus();
    }

    boolean mnemonicMatch(char key) {
        char mnemonic = this.findMnemonic(this.getText());
        if (mnemonic == '\u0000') {
            return false;
        }
        return Character.toUpperCase(key) == Character.toUpperCase(mnemonic);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.text = string = this.patchMnemonics(string);
        PSZ title = new PSZ(string);
        OS.WinSetWindowText(this.handle, title);
    }

    int widgetStyle() {
        return super.widgetStyle() | 2;
    }

    PSZ windowClass() {
        return GroupClass;
    }

    int windowProc() {
        return GroupProc;
    }

    static {
        GroupClass = PSZ.getAtom(-65531);
        CLASSINFO pclsiClassInfo = new CLASSINFO();
        OS.WinQueryClassInfo(0, GroupClass, pclsiClassInfo);
        GroupProc = pclsiClassInfo.pfnWindowProc;
    }
}

