/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.pm.FATTRS;
import org.eclipse.swt.internal.pm.OS;
import org.eclipse.swt.internal.pm.PIB;
import org.eclipse.swt.internal.pm.PSZ;
import org.eclipse.swt.internal.pm.QMSG;
import org.eclipse.swt.internal.pm.SWP;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swt.widgets.WidgetTable;

public class Display
extends Device {
    int hab;
    int hmq;
    QMSG qmsg = new QMSG();
    Event[] eventQueue;
    Callback windowCallback;
    Callback windowFrameCallback;
    int windowProc;
    int windowFrameProc;
    PSZ windowClass;
    static int windowClassCount = 0;
    static final String WindowName = "SWT_Window";
    EventTable eventTable;
    Synchronizer synchronizer = new Synchronizer(this);
    Thread thread;
    Runnable[] disposeList;
    int timerCount;
    int[] timerIds;
    Runnable[] timerList;
    boolean accelKeyHit;
    boolean mnemonicKeyHit;
    int hwndShell;
    Object data;
    String[] keys;
    Object[] values;
    static final int[][] KeyTable = new int[][]{{11, 65536}, {12, 65536}, {9, 131072}, {10, 262144}, {22, 0x1000001}, {24, 0x1000002}, {21, 0x1000003}, {23, 0x1000004}, {17, 0x1000005}, {18, 0x1000006}, {20, 0x1000007}, {19, 0x1000008}, {26, 0x1000009}, {32, 0x100000A}, {33, 0x100000B}, {34, 0x100000C}, {35, 0x100000D}, {36, 0x100000E}, {37, 0x100000F}, {38, 0x1000010}, {39, 0x1000011}, {40, 0x1000012}, {41, 0x1000013}, {42, 0x1000014}, {43, 0x1000015}};
    static Display Default;
    static Display[] Displays;
    Shell[] ModalWidgets;
    static boolean TrimEnabled;
    static final String PACKAGE_PREFIX = "org.eclipse.swt.widgets.";

    static void setDevice(Device device) {
        Device.CurrentDevice = device;
    }

    public Display() {
        this(null);
    }

    public Display(DeviceData data) {
        super(data);
    }

    public void addListener(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(eventType, listener);
    }

    public void asyncExec(Runnable runnable) {
        if (this.isDisposed()) {
            this.error(45);
        }
        this.synchronizer.asyncExec(runnable);
    }

    public void beep() {
        this.checkDevice();
        OS.WinAlarm(1, 0);
    }

    protected void checkSubclass() {
        if (!Display.isValidClass(this.getClass())) {
            this.error(43);
        }
    }

    protected void checkDevice() {
        if (!this.isValidThread()) {
            this.error(22);
        }
        if (this.isDisposed()) {
            this.error(45);
        }
    }

    static synchronized void checkDisplay(Thread thread) {
        int i = 0;
        while (i < Displays.length) {
            if (Displays[i] != null && Display.Displays[i].thread == thread) {
                SWT.error(22);
            }
            ++i;
        }
    }

    public void close() {
        this.checkDevice();
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit) {
            this.dispose();
        }
    }

    protected String composeFontNameSize(FATTRS fa) {
        return super.composeFontNameSize(fa);
    }

    protected void create(DeviceData data) {
        this.checkSubclass();
        this.thread = Thread.currentThread();
        Display.checkDisplay(this.thread);
        this.createDisplay(data);
        Display.register(this);
        if (Default == null) {
            Default = this;
        }
    }

    void createDisplay(DeviceData data) {
    }

    static synchronized void deregister(Display display) {
        int i = 0;
        while (i < Displays.length) {
            if (display == Displays[i]) {
                Display.Displays[i] = null;
            }
            ++i;
        }
    }

    protected void destroy() {
        if (this == Default) {
            Default = null;
        }
        Display.deregister(this);
        this.destroyDisplay();
    }

    void destroyDisplay() {
    }

    public void disposeExec(Runnable runnable) {
        this.checkDevice();
        if (this.disposeList == null) {
            this.disposeList = new Runnable[4];
        }
        int i = 0;
        while (i < this.disposeList.length) {
            if (this.disposeList[i] == null) {
                this.disposeList[i] = runnable;
                return;
            }
            ++i;
        }
        Runnable[] newDisposeList = new Runnable[this.disposeList.length + 4];
        System.arraycopy(this.disposeList, 0, newDisposeList, 0, this.disposeList.length);
        newDisposeList[this.disposeList.length] = runnable;
        this.disposeList = newDisposeList;
    }

    void error(int code) {
        SWT.error(code);
    }

    boolean filterMessage(QMSG qmsg) {
        Control control;
        int hwnd = qmsg.hwnd;
        int wndProc = OS.WinQueryWindowPtr(hwnd, -3);
        if (wndProc == Decorations.FrameProc) {
            return false;
        }
        int msg = qmsg.msg;
        if (msg == 122 && (control = this.findControl(qmsg.hwnd)) != null) {
            if (this.translateAccelerator(qmsg, control)) {
                return true;
            }
            if (this.translateMnemonic(qmsg, control)) {
                return true;
            }
            if (this.translateTraversal(qmsg, control)) {
                return true;
            }
        }
        if (hwnd == 0 && msg == 94 && this.hPalette != 0) {
            Shell[] shells = this.getShells();
            int i = 0;
            while (i < shells.length) {
                shells[i].selectPalette(this.hPalette);
                ++i;
            }
            return true;
        }
        return false;
    }

    public Widget findWidget(int handle) {
        this.checkDevice();
        return WidgetTable.get(handle);
    }

    Control findControl(int handle) {
        if (handle == 0) {
            return null;
        }
        do {
            Control control;
            if ((control = WidgetTable.get(handle)) == null || control.handle != handle) continue;
            return control;
        } while ((handle = OS.WinQueryWindow(handle, 5)) != 0);
        return null;
    }

    public static synchronized Display findDisplay(Thread thread) {
        int i = 0;
        while (i < Displays.length) {
            Display display = Displays[i];
            if (display != null && display.thread == thread) {
                return display;
            }
            ++i;
        }
        return null;
    }

    public Shell getActiveShell() {
        this.checkDevice();
        Control control = this.findControl(OS.WinQueryActiveWindow(1));
        if (control instanceof Shell) {
            return (Shell)control;
        }
        return null;
    }

    public Rectangle getBounds() {
        this.checkDevice();
        int width = OS.WinQuerySysValue(1, 20);
        int height = OS.WinQuerySysValue(1, 21);
        return new Rectangle(0, 0, width, height);
    }

    public static synchronized Display getCurrent() {
        return Display.findDisplay(Thread.currentThread());
    }

    public Rectangle getClientArea() {
        this.checkDevice();
        SWP swp = new SWP();
        OS.WinGetMaxPosition(this.hwndShell, swp);
        return new Rectangle(swp.x, this.getHeight() - (swp.y + swp.cy), swp.cx, swp.cy);
    }

    public static synchronized Display getDefault() {
        if (Default == null) {
            Default = new Display();
        }
        return Default;
    }

    int getHeight() {
        return OS.WinQuerySysValue(1, 21);
    }

    static boolean isValidClass(Class clazz) {
        String name = clazz.getName();
        int index = name.lastIndexOf(46);
        return name.substring(0, index + 1).equals(PACKAGE_PREFIX);
    }

    public Object getData(String key) {
        this.checkDevice();
        if (key == null) {
            this.error(4);
        }
        if (this.keys == null) {
            return null;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].equals(key)) {
                return this.values[i];
            }
            ++i;
        }
        return null;
    }

    public Object getData() {
        this.checkDevice();
        return this.data;
    }

    public int getDoubleClickTime() {
        this.checkDevice();
        return OS.WinQuerySysValue(1, 1);
    }

    public Control getFocusControl() {
        this.checkDevice();
        return this.findControl(OS.WinQueryFocus(1));
    }

    Shell getModalShell() {
        if (this.ModalWidgets == null) {
            return null;
        }
        int index = this.ModalWidgets.length;
        while (--index >= 0) {
            Shell shell = this.ModalWidgets[index];
            if (shell == null) continue;
            return shell;
        }
        return null;
    }

    public Shell[] getShells() {
        this.checkDevice();
        int count = 0;
        Shell[] shells = WidgetTable.shells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (!shell.isDisposed() && this == shell.getDisplay()) {
                ++count;
            }
            ++i;
        }
        if (count == shells.length) {
            return shells;
        }
        int index = 0;
        Shell[] result = new Shell[count];
        int i2 = 0;
        while (i2 < shells.length) {
            Shell shell = shells[i2];
            if (!shell.isDisposed() && this == shell.getDisplay()) {
                result[index++] = shell;
            }
            ++i2;
        }
        return result;
    }

    public Thread getSyncThread() {
        if (this.isDisposed()) {
            this.error(45);
        }
        return this.synchronizer.syncThread;
    }

    public Color getSystemColor(int id) {
        this.checkDevice();
        int pixel = 0x2000000;
        switch (id) {
            case 23: {
                pixel = OS.WinQuerySysColor(1, -19, 0);
                break;
            }
            case 24: {
                pixel = OS.WinQuerySysColor(1, -17, 0);
                break;
            }
            case 25: {
                pixel = OS.WinQuerySysColor(1, -20, 0);
                break;
            }
            case 26: {
                pixel = OS.WinQuerySysColor(1, -44, 0);
                break;
            }
            case 27: {
                pixel = OS.WinQuerySysColor(1, -45, 0);
                break;
            }
            default: {
                return super.getSystemColor(id);
            }
        }
        return Color.pm_new(this, pixel);
    }

    public Thread getThread() {
        if (this.isDisposed()) {
            this.error(45);
        }
        return this.thread;
    }

    public int internal_new_GC(GCData data) {
        int hps;
        if (this.isDisposed()) {
            SWT.error(45);
        }
        if ((hps = OS.WinGetScreenPS(1)) == 0) {
            SWT.error(2);
        }
        if (data != null) {
            data.device = this;
            data.hdc = OS.GpiQueryDevice(hps);
            if (data.hdc == 0) {
                SWT.error(2);
            }
        }
        return hps;
    }

    protected void init() {
        super.init();
        PIB pib = new PIB();
        int[] ppib = new int[1];
        OS.DosGetInfoBlocks(null, ppib);
        OS.objcpy(pib, ppib[0]);
        if (pib.pib_ultype != 3) {
            pib.pib_ultype = 3;
            OS.objcpy(ppib[0], pib);
        }
        this.hab = OS.WinInitialize(0);
        if (this.hab == 0) {
            this.error(2);
        }
        this.hmq = OS.WinCreateMsgQueue(this.hab, 0);
        if (this.hmq == 0) {
            this.error(2);
        }
        this.windowCallback = new Callback(this, "windowProc", 4);
        this.windowProc = this.windowCallback.getAddress();
        if (this.windowProc == 0) {
            this.error(3);
        }
        this.windowFrameCallback = new Callback(this, "windowFrameProc", 4);
        this.windowFrameProc = this.windowFrameCallback.getAddress();
        if (this.windowFrameProc == 0) {
            this.error(3);
        }
        this.windowClass = new PSZ(WindowName + windowClassCount++);
        OS.WinRegisterClass(this.hab, this.windowClass, this.windowProc, 0, 4);
        this.hwndShell = OS.WinCreateWindow(1, this.windowClass, null, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0);
    }

    public void internal_dispose_GC(int hps, GCData data) {
        OS.WinReleasePS(hps);
    }

    public static int internal_get_HAB() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display.hab;
    }

    boolean isValidThread() {
        return this.thread == Thread.currentThread();
    }

    boolean isVirtualKey(int key) {
        switch (key) {
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 30: 
            case 41: {
                return true;
            }
        }
        return false;
    }

    protected FATTRS matchFont(String fontNameSize) {
        return super.matchFont(fontNameSize);
    }

    void postEvent(Event event) {
        if (this.eventQueue == null) {
            this.eventQueue = new Event[4];
        }
        int index = 0;
        int length = this.eventQueue.length;
        while (index < length) {
            if (this.eventQueue[index] == null) break;
            ++index;
        }
        if (index == length) {
            Event[] newQueue = new Event[length + 4];
            System.arraycopy(this.eventQueue, 0, newQueue, 0, length);
            this.eventQueue = newQueue;
        }
        this.eventQueue[index] = event;
    }

    public boolean readAndDispatch() {
        this.checkDevice();
        if (OS.WinPeekMsg(this.hab, this.qmsg, 0, 0, 0, 1)) {
            if (!this.filterMessage(this.qmsg)) {
                OS.WinDispatchMsg(this.hab, this.qmsg);
            }
            this.runDeferredEvents();
            return true;
        }
        return this.runAsyncMessages();
    }

    static synchronized void register(Display display) {
        int i = 0;
        while (i < Displays.length) {
            if (Displays[i] == null) {
                Display.Displays[i] = display;
                return;
            }
            ++i;
        }
        Display[] newDisplays = new Display[Displays.length + 4];
        System.arraycopy(Displays, 0, newDisplays, 0, Displays.length);
        newDisplays[Display.Displays.length] = display;
        Displays = newDisplays;
    }

    protected void release() {
        this.sendEvent(12, new Event());
        Shell[] shells = WidgetTable.shells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (!shell.isDisposed() && this == shell.getDisplay()) {
                shell.dispose();
            }
            ++i;
        }
        while (this.readAndDispatch()) {
        }
        if (this.disposeList != null) {
            int i2 = 0;
            while (i2 < this.disposeList.length) {
                if (this.disposeList[i2] != null) {
                    this.disposeList[i2].run();
                }
                ++i2;
            }
        }
        this.disposeList = null;
        this.synchronizer.releaseSynchronizer();
        this.synchronizer = null;
        this.releaseDisplay();
        super.release();
    }

    void releaseDisplay() {
        if (this.hwndShell != 0) {
            OS.WinDestroyWindow(this.hwndShell);
        }
        this.hwndShell = 0;
        this.windowClass = null;
        this.windowFrameCallback.dispose();
        this.windowFrameCallback = null;
        this.windowCallback.dispose();
        this.windowCallback = null;
        this.thread = null;
        this.qmsg = null;
        this.data = null;
        this.keys = null;
        this.values = null;
        OS.WinDestroyMsgQueue(this.hmq);
        OS.WinTerminate(this.hab);
    }

    public void removeListener(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, listener);
    }

    boolean runAsyncMessages() {
        return this.synchronizer.runAsyncMessages();
    }

    boolean runDeferredEvents() {
        while (this.eventQueue != null) {
            Widget item;
            Event event = this.eventQueue[0];
            if (event == null) break;
            int length = this.eventQueue.length;
            System.arraycopy(this.eventQueue, 1, this.eventQueue, 0, --length);
            this.eventQueue[length] = null;
            Widget widget = event.widget;
            if (widget == null || widget.isDisposed() || (item = event.item) != null && item.isDisposed()) continue;
            widget.sendEvent(event);
        }
        this.eventQueue = null;
        return true;
    }

    void sendEvent(int eventType, Event event) {
        if (this.eventTable == null) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.display = this;
        event.type = eventType;
        if (event.time == 0) {
            event.time = OS.WinQueryMsgTime(this.hab);
        }
        this.eventTable.sendEvent(event);
    }

    public void setData(String key, Object value) {
        this.checkDevice();
        if (key == null) {
            this.error(4);
        }
        if (value == null) {
            if (this.keys == null) {
                return;
            }
            int index = 0;
            while (index < this.keys.length && !this.keys[index].equals(key)) {
                ++index;
            }
            if (index == this.keys.length) {
                return;
            }
            if (this.keys.length == 1) {
                this.keys = null;
                this.values = null;
            } else {
                String[] newKeys = new String[this.keys.length - 1];
                Object[] newValues = new Object[this.values.length - 1];
                System.arraycopy(this.keys, 0, newKeys, 0, index);
                System.arraycopy(this.keys, index + 1, newKeys, index, newKeys.length - index);
                System.arraycopy(this.values, 0, newValues, 0, index);
                System.arraycopy(this.values, index + 1, newValues, index, newValues.length - index);
                this.keys = newKeys;
                this.values = newValues;
            }
            return;
        }
        if (this.keys == null) {
            this.keys = new String[]{key};
            this.values = new Object[]{value};
            return;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].equals(key)) {
                this.values[i] = value;
                return;
            }
            ++i;
        }
        String[] newKeys = new String[this.keys.length + 1];
        Object[] newValues = new Object[this.values.length + 1];
        System.arraycopy(this.keys, 0, newKeys, 0, this.keys.length);
        System.arraycopy(this.values, 0, newValues, 0, this.values.length);
        newKeys[this.keys.length] = key;
        newValues[this.values.length] = value;
        this.keys = newKeys;
        this.values = newValues;
    }

    public void setData(Object data) {
        this.checkDevice();
        this.data = data;
    }

    public static void setAppName(String name) {
    }

    void setModal(Shell shell) {
        if (this.ModalWidgets == null) {
            this.ModalWidgets = new Shell[4];
        }
        int index = 0;
        int length = this.ModalWidgets.length;
        while (index < length) {
            if (this.ModalWidgets[index] == shell) {
                return;
            }
            if (this.ModalWidgets[index] == null) break;
            ++index;
        }
        if (index == length) {
            Shell[] newModalWidgets = new Shell[length + 4];
            System.arraycopy(this.ModalWidgets, 0, newModalWidgets, 0, length);
            this.ModalWidgets = newModalWidgets;
        }
        this.ModalWidgets[index] = shell;
        if (!TrimEnabled) {
            return;
        }
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            shells[i].updateModal();
            ++i;
        }
    }

    public void setSynchronizer(Synchronizer synchronizer) {
        this.checkDevice();
        if (synchronizer == null) {
            this.error(4);
        }
        if (this.synchronizer != null) {
            this.synchronizer.runAsyncMessages();
        }
        this.synchronizer = synchronizer;
    }

    public boolean sleep() {
        this.checkDevice();
        return OS.WinWaitMsg(this.hab, 0, 0);
    }

    public void syncExec(Runnable runnable) {
        if (this.isDisposed()) {
            this.error(45);
        }
        this.synchronizer.syncExec(runnable);
    }

    protected FATTRS systemFont() {
        return super.systemFont();
    }

    boolean translateAccelerator(QMSG qmsg, Control control) {
        this.accelKeyHit = true;
        boolean result = control.translateAccelerator(qmsg);
        this.accelKeyHit = false;
        return result;
    }

    static int translateKey(int key) {
        int i = 0;
        while (i < KeyTable.length) {
            if (KeyTable[i][0] == key) {
                return KeyTable[i][1];
            }
            ++i;
        }
        return 0;
    }

    boolean translateMnemonic(QMSG qmsg, Control control) {
        if ((OS.SHORT1FROMMP(qmsg.mp1) & 1) != 0 || (OS.WinGetKeyState(1, 11) & 0x8000) != 0 || (OS.WinGetKeyState(1, 12) & 0x8000) != 0) {
            return control.translateMnemonic(qmsg);
        }
        return false;
    }

    boolean translateTraversal(QMSG qmsg, Control control) {
        if ((OS.SHORT1FROMMP(qmsg.mp1) & 0x40) == 0) {
            switch (OS.SHORT2FROMMP(qmsg.mp2)) {
                case 6: 
                case 7: 
                case 8: 
                case 15: 
                case 17: 
                case 18: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 30: {
                    return control.translateTraversal(qmsg);
                }
            }
        }
        return false;
    }

    static int untranslateKey(int key) {
        int i = 0;
        while (i < KeyTable.length) {
            if (KeyTable[i][1] == key) {
                return KeyTable[i][0];
            }
            ++i;
        }
        return 0;
    }

    public void update() {
        this.checkDevice();
        Shell[] shells = WidgetTable.shells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (!shell.isDisposed() && this == shell.getDisplay()) {
                shell.update();
            }
            ++i;
        }
    }

    public void wake() {
        if (this.isDisposed()) {
            this.error(45);
        }
        if (this.thread == Thread.currentThread()) {
            return;
        }
        OS.WinPostQueueMsg(this.hmq, 0, 0, 0);
    }

    int windowProc(int hwnd, int msg, int mp1, int mp2) {
        Control control = WidgetTable.get(hwnd);
        if (control != null) {
            return control.windowProc(msg, mp1, mp2);
        }
        if (hwnd == this.hwndShell) {
            // empty if block
        }
        return OS.WinDefWindowProc(hwnd, msg, mp1, mp2);
    }

    int windowFrameProc(int hwnd, int msg, int mp1, int mp2) {
        Decorations decorations = (Decorations)WidgetTable.get(hwnd);
        if (decorations != null) {
            return decorations.windowFrameProc(msg, mp1, mp2);
        }
        return OS.WinDefWindowProc(hwnd, msg, mp1, mp2);
    }

    static String withCrLf(String string) {
        int length = string.length();
        if (length == 0) {
            return string;
        }
        int i = string.indexOf(10, 0);
        if (i == -1) {
            return string;
        }
        if (i > 0 && string.charAt(i - 1) == '\r') {
            return string;
        }
        ++i;
        int count = 1;
        while (i < length) {
            if ((i = string.indexOf(10, i)) == -1) break;
            ++count;
            ++i;
        }
        i = 0;
        StringBuffer result = new StringBuffer(count += length);
        while (i < length) {
            int j = string.indexOf(10, i);
            if (j == -1) {
                j = length;
            }
            result.append(string.substring(i, j));
            i = j;
            if (i >= length) continue;
            result.append("\r\n");
            ++i;
        }
        return result.toString();
    }

    static {
        Displays = new Display[4];
        TrimEnabled = false;
        Device.DeviceFinder = new Runnable(){

            public void run() {
                Display device = Display.getCurrent();
                if (device == null) {
                    device = Display.getDefault();
                }
                Display.setDevice(device);
            }
        };
    }
}

