/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.pm.ACCEL;
import org.eclipse.swt.internal.pm.ACCELTABLE;
import org.eclipse.swt.internal.pm.CLASSINFO;
import org.eclipse.swt.internal.pm.FRAMECDATA;
import org.eclipse.swt.internal.pm.MRESULT;
import org.eclipse.swt.internal.pm.OS;
import org.eclipse.swt.internal.pm.PSZ;
import org.eclipse.swt.internal.pm.QMSG;
import org.eclipse.swt.internal.pm.RECTL;
import org.eclipse.swt.internal.pm.SWP;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.WidgetTable;

public class Decorations
extends Canvas {
    Menu menuBar;
    Menu[] menus;
    MenuItem[] items;
    Control savedFocus;
    Button defaultButton;
    Button saveDefault;
    int swFlags;
    int hAccel;
    int nAccel;
    static final int ID_START = 100;
    int frameHandle;
    static final int FrameProc;
    static final PSZ FrameClass;
    static final PSZ EmptyTitle;

    Decorations() {
    }

    public Decorations(Composite parent, int style) {
        super(parent, Decorations.checkStyle(style));
    }

    void add(Menu menu) {
        if (this.menus == null) {
            this.menus = new Menu[4];
        }
        int i = 0;
        while (i < this.menus.length) {
            if (this.menus[i] == null) {
                this.menus[i] = menu;
                return;
            }
            ++i;
        }
        Menu[] newMenus = new Menu[this.menus.length + 4];
        newMenus[this.menus.length] = menu;
        System.arraycopy(this.menus, 0, newMenus, 0, this.menus.length);
        this.menus = newMenus;
    }

    void add(MenuItem item) {
        if (this.items == null) {
            this.items = new MenuItem[12];
        }
        int i = 0;
        while (i < this.items.length) {
            if (this.items[i] == null) {
                item.id = i + 100;
                this.items[i] = item;
                return;
            }
            ++i;
        }
        item.id = this.items.length + 100;
        MenuItem[] newItems = new MenuItem[this.items.length + 12];
        newItems[this.items.length] = item;
        System.arraycopy(this.items, 0, newItems, 0, this.items.length);
        this.items = newItems;
    }

    void bringToTop() {
        OS.WinSetWindowPos(this.frameHandle, 3, 0, 0, 0, 0, 132);
    }

    static int checkStyle(int style) {
        if ((style & 0x4C0) != 0) {
            style |= 0x20;
        }
        return style;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    Control computeTabGroup() {
        return this;
    }

    Control computeTabRoot() {
        return this;
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        RECTL rcl = new RECTL();
        rcl.xLeft = x;
        rcl.yBottom = y;
        rcl.xRight = x + width;
        rcl.yTop = y + height;
        OS.WinCalcFrameRect(this.frameHandle, rcl, false);
        return new Rectangle(rcl.xLeft, rcl.yBottom, rcl.xRight - rcl.xLeft, rcl.yTop - rcl.yBottom);
    }

    void createAcceleratorTable() {
        this.nAccel = 0;
        this.hAccel = 0;
        int maxAccel = 0;
        if (this.menuBar == null || this.items == null) {
            return;
        }
        maxAccel = this.items.length;
        ACCELTABLE pacctAccelTable = new ACCELTABLE();
        ACCEL[] accelList = new ACCEL[maxAccel];
        if (this.menuBar != null && this.items != null) {
            int i = 0;
            while (i < this.items.length) {
                MenuItem item = this.items[i];
                if (item != null && item.accelerator != 0) {
                    Menu parent = item.parent;
                    while (parent != null && parent != this.menuBar) {
                        parent = parent.getParentMenu();
                    }
                    if (parent == this.menuBar) {
                        ACCEL accel = new ACCEL();
                        item.fillAccel(accel);
                        accelList[this.nAccel] = accel;
                        ++this.nAccel;
                    }
                }
                ++i;
            }
            pacctAccelTable.cAccel = (short)this.nAccel;
            pacctAccelTable.codepage = (short)437;
            pacctAccelTable.aaccel = new ACCEL[this.nAccel];
            int i2 = 0;
            while (i2 < this.nAccel) {
                pacctAccelTable.aaccel[i2] = accelList[i2];
                ++i2;
            }
        }
        this.hAccel = OS.WinCreateAccelTable(this.getDisplay().hab, pacctAccelTable);
        System.out.println("Decorations:createAcceleratorTable - Handle of accelerator table = " + this.hAccel);
        if (!OS.WinSetAccelTable(this.getDisplay().hab, this.hAccel, this.frameHandle)) {
            System.out.println("Decorations:createAcceleratorTable - Thread did not attach accelerator table to the frame");
            if (!OS.WinDestroyAccelTable(this.hAccel)) {
                System.out.println("Decorations:createAcceleratorTable - The accelerator table was not destroyed");
            }
        }
    }

    void createHandle() {
        int hwndOwner = 0;
        if (this.parent != null) {
            hwndOwner = this.parent instanceof Shell ? ((Shell)this.parent).frameHandle : this.parent.handle;
        }
        int hwndParent = 1;
        if (this.handle != 0) {
            hwndParent = this.handle;
        } else if (this.parent != null) {
            hwndParent = this.parent instanceof Shell ? ((Shell)this.parent).frameHandle : this.parent.handle;
        }
        this.frameHandle = OS.WinCreateWindow(hwndParent, this.windowFrameClass(), null, this.widgetFrameStyle(), 0, this.getParentHeight(), 0, 0, hwndOwner, 3, 0, 0, 0);
        if (this.frameHandle == 0) {
            this.error(2);
        }
        FRAMECDATA fcdata = new FRAMECDATA();
        fcdata.flCreateFlags = this.widgetFrameFlags();
        OS.WinCreateFrameControls(this.frameHandle, fcdata, null);
        OS.WinSendMsg(this.frameHandle, 66, fcdata.flCreateFlags, 0);
        this.handle = OS.WinCreateWindow(this.frameHandle, this.windowClass(), EmptyTitle, this.widgetStyle(), 0, 0, 0, 0, this.frameHandle, 4, 32776, 0, 0);
        if (this.handle == 0) {
            this.error(2);
        }
        this.state |= 0x1000;
    }

    void destroyAcceleratorTable() {
        if (this.hAccel != 0 && this.hAccel != -1) {
            OS.WinDestroyAccelTable(this.hAccel);
        }
        this.hAccel = -1;
    }

    void destroyWidget() {
        int hwnd = this.frameHandle;
        this.releaseHandle();
        if (hwnd != 0) {
            OS.WinDestroyWindow(hwnd);
        }
    }

    Menu findMenu(int hMenu) {
        if (this.menus == null) {
            return null;
        }
        int i = 0;
        while (i < this.menus.length) {
            Menu menu = this.menus[i];
            if (menu != null && menu != null && hMenu == menu.handle) {
                return menu;
            }
            ++i;
        }
        return null;
    }

    MenuItem findMenuItem(int id) {
        if (this.items == null) {
            return null;
        }
        if (0 <= (id -= 100) && id < this.items.length) {
            return this.items[id];
        }
        return null;
    }

    int getBounds(SWP swp) {
        if ((OS.WinQueryWindowULong(this.frameHandle, -2) & 0x1000000) != 0) {
            int parentHeight = this.getParentHeight();
            swp.x = OS.WinQueryWindowUShort(this.frameHandle, 12);
            swp.y = OS.WinQueryWindowUShort(this.frameHandle, 14);
            swp.cx = OS.WinQueryWindowUShort(this.frameHandle, 16);
            swp.cy = OS.WinQueryWindowUShort(this.frameHandle, 18);
            swp.y = parentHeight - (swp.y + swp.cy);
            return parentHeight;
        }
        int parentHeight = this.getParentHeight();
        OS.WinQueryWindowPos(this.frameHandle, swp);
        swp.y = parentHeight - (swp.y + swp.cy);
        return parentHeight;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        int bits = OS.WinQueryWindowULong(this.frameHandle, -2);
        if ((bits & 0x1000000) != 0) {
            SWP swp = new SWP();
            this.getBounds(swp);
            RECTL rcl = new RECTL();
            rcl.xLeft = 0;
            rcl.yBottom = 0;
            rcl.xRight = swp.cx;
            rcl.yTop = swp.cy;
            OS.WinSetWindowULong(this.frameHandle, -2, bits & 0xFEFFFFFF);
            OS.WinSendMsg(this.frameHandle, 83, rcl, 1);
            OS.WinSetWindowULong(this.frameHandle, -2, bits);
            return new Rectangle(0, 0, rcl.xRight - rcl.xLeft, rcl.yTop - rcl.yBottom);
        }
        RECTL rcl = new RECTL();
        OS.WinQueryWindowRect(this.handle, rcl);
        return new Rectangle(0, 0, rcl.xRight, rcl.yTop);
    }

    public Button getDefaultButton() {
        this.checkWidget();
        return this.defaultButton;
    }

    public boolean getMaximized() {
        this.checkWidget();
        return (OS.WinQueryWindowULong(this.frameHandle, -2) & 0x800000) != 0;
    }

    public Menu getMenuBar() {
        this.checkWidget();
        return this.menuBar;
    }

    public boolean getMinimized() {
        this.checkWidget();
        return (OS.WinQueryWindowULong(this.frameHandle, -2) & 0x1000000) != 0;
    }

    String getNameText() {
        return this.getText();
    }

    int getParentHeight() {
        return this.parent.getHeight();
    }

    public String getText() {
        this.checkWidget();
        int length = OS.WinQueryWindowTextLength(this.frameHandle);
        if (length == 0) {
            return "";
        }
        PSZ buffer = new PSZ(length);
        OS.WinQueryWindowText(this.frameHandle, length + 1, buffer);
        return buffer.toString();
    }

    boolean isTabGroup() {
        return true;
    }

    boolean isTabItem() {
        return false;
    }

    Decorations menuShell() {
        return this;
    }

    void redrawTrimmings() {
        if (!OS.WinIsWindowVisible(this.frameHandle)) {
            return;
        }
        RECTL rcl = new RECTL();
        OS.WinQueryWindowRect(this.frameHandle, rcl);
        int width = rcl.xRight;
        int height = rcl.yTop;
        SWP swp = new SWP();
        OS.WinQueryWindowPos(this.handle, swp);
        rcl.xRight = swp.x;
        OS.WinInvalidateRect(this.frameHandle, rcl, true);
        rcl.xRight = width;
        rcl.yTop = swp.y;
        OS.WinInvalidateRect(this.frameHandle, rcl, true);
        rcl.yBottom = swp.y + swp.cy;
        rcl.yTop = height;
        OS.WinInvalidateRect(this.frameHandle, rcl, true);
        rcl.xLeft = swp.x + swp.cx;
        rcl.yBottom = 0;
        OS.WinInvalidateRect(this.frameHandle, rcl, true);
    }

    public void redraw() {
        this.checkWidget();
        this.redrawTrimmings();
        super.redraw();
    }

    public void redraw(int x, int y, int width, int height, boolean all) {
        this.checkWidget();
        if (width <= 0 || height <= 0) {
            return;
        }
        this.redrawTrimmings();
        super.redraw(x, y, width, height, all);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.frameHandle = 0;
    }

    void releaseWidget() {
        if (this.menuBar != null) {
            this.menuBar.releaseWidget();
            this.menuBar.releaseHandle();
        }
        this.menuBar = null;
        if (this.menus != null) {
            int i = 0;
            while (i < this.menus.length) {
                Menu menu = this.menus[i];
                if (menu != null && !menu.isDisposed()) {
                    menu.dispose();
                }
                ++i;
            }
        }
        this.menus = null;
        super.releaseWidget();
    }

    void remove(Menu menu) {
        if (this.menus == null) {
            return;
        }
        int i = 0;
        while (i < this.menus.length) {
            if (this.menus[i] == menu) {
                this.menus[i] = null;
                return;
            }
            ++i;
        }
    }

    void remove(MenuItem item) {
        if (this.items == null) {
            return;
        }
        this.items[item.id - 100] = null;
        item.id = -1;
    }

    boolean restoreFocus() {
        if (this.savedFocus != null && this.savedFocus.isDisposed()) {
            this.savedFocus = null;
        }
        if (this.savedFocus != null && this.savedFocus.forceFocus()) {
            return true;
        }
        return this.defaultButton != null && !this.defaultButton.isDisposed() && this.defaultButton.setFocus();
    }

    void saveFocus() {
        Control control = this.getDisplay().getFocusControl();
        if (control != null) {
            this.setSavedFocus(control);
        }
    }

    void setBounds(int x, int y, int width, int height, int flags) {
        if ((OS.WinQueryWindowULong(this.frameHandle, -2) & 0x1000000) != 0) {
            SWP swp = new SWP();
            int parentHeight = this.getBounds(swp);
            if ((flags & 2) != 0) {
                swp.x = x;
                swp.y = y;
            }
            if ((flags & 1) != 0) {
                swp.cx = width;
                swp.cy = height;
                flags |= 2;
                OS.WinSetWindowUShort(this.frameHandle, 16, (short)swp.cx);
                OS.WinSetWindowUShort(this.frameHandle, 18, (short)swp.cy);
            }
            if ((flags & 2) != 0) {
                swp.y = parentHeight - (swp.y + swp.cy);
                OS.WinSetWindowUShort(this.frameHandle, 12, (short)swp.x);
                OS.WinSetWindowUShort(this.frameHandle, 14, (short)swp.y);
            }
            return;
        }
        SWP swp = new SWP();
        int parentHeight = this.getBounds(swp);
        if ((flags & 2) != 0) {
            swp.x = x;
            swp.y = y;
        }
        if ((flags & 1) != 0) {
            swp.cx = width;
            swp.cy = height;
            flags |= 2;
        }
        swp.y = parentHeight - (swp.y + swp.cy);
        OS.WinSetWindowPos(this.frameHandle, 0, swp.x, swp.y, swp.cx, swp.cy, flags);
    }

    public void setDefaultButton(Button button) {
        this.checkWidget();
        this.setDefaultButton(button, true);
    }

    void setDefaultButton(Button button, boolean save) {
        if (button == null) {
            if (this.defaultButton == this.saveDefault) {
                return;
            }
        } else {
            if (button.isDisposed()) {
                this.error(5);
            }
            if ((button.style & 8) == 0) {
                return;
            }
            if (button == this.defaultButton) {
                return;
            }
        }
        if (this.defaultButton != null && !this.defaultButton.isDisposed()) {
            this.defaultButton.setDefault(false);
        }
        if ((this.defaultButton = button) == null) {
            this.defaultButton = this.saveDefault;
        }
        if (this.defaultButton != null && !this.defaultButton.isDisposed()) {
            this.defaultButton.setDefault(true);
        }
        if (save || this.saveDefault == null) {
            this.saveDefault = this.defaultButton;
        }
        if (this.saveDefault != null && this.saveDefault.isDisposed()) {
            this.saveDefault = null;
        }
    }

    void setDefaultFont() {
    }

    public void setMaximized(boolean maximized) {
        this.checkWidget();
        if (maximized == ((OS.WinQueryWindowULong(this.frameHandle, -2) & 0x800000) != 0)) {
            return;
        }
        int flags = maximized ? 2176 : 4096;
        OS.WinSetWindowPos(this.frameHandle, 0, 0, 0, 0, 0, flags);
    }

    public void setMenuBar(Menu menu) {
        this.checkWidget();
        if (this.menuBar == menu) {
            return;
        }
        if (menu != null) {
            if (menu.isDisposed()) {
                this.error(5);
            }
            if ((menu.style & 2) == 0) {
                this.error(33);
            }
            if (menu.parent != this) {
                this.error(32);
            }
        }
        this.menuBar = menu;
        int hMenu = 0;
        if (this.menuBar != null) {
            hMenu = this.menuBar.handle;
        }
        OS.WinSendMsg(this.frameHandle, 66, 4, 0);
        this.destroyAcceleratorTable();
    }

    public void setMinimized(boolean minimized) {
        this.checkWidget();
        if (minimized == ((OS.WinQueryWindowULong(this.frameHandle, -2) & 0x1000000) != 0)) {
            return;
        }
        int flags = minimized ? 1024 : 4096;
        OS.WinSetWindowPos(this.frameHandle, 0, 0, 0, 0, 0, flags);
    }

    public void setRedraw(boolean redraw) {
        this.checkWidget();
        if (redraw) {
            if (--this.drawCount == 0) {
                OS.WinEnableWindowUpdate(this.frameHandle, true);
                OS.WinInvalidateRect(this.frameHandle, null, true);
            }
        } else if (this.drawCount++ == 0) {
            OS.WinEnableWindowUpdate(this.frameHandle, false);
        }
    }

    void setSavedFocus(Control control) {
        if (this == control) {
            this.savedFocus = null;
            return;
        }
        if (this != control.menuShell()) {
            return;
        }
        this.savedFocus = control;
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        PSZ title = string.length() > 0 ? new PSZ(string) : EmptyTitle;
        OS.WinSetWindowText(this.frameHandle, title);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if (OS.WinIsWindowVisible(this.frameHandle) == visible) {
            return;
        }
        if (visible) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
        }
        OS.WinShowWindow(this.frameHandle, visible);
        if (!visible) {
            this.sendEvent(23);
            if (this.isDisposed()) {
                return;
            }
        }
    }

    boolean translateAccelerator(QMSG qmsg) {
        if (!this.isEnabled() || !this.isActive()) {
            return false;
        }
        if (this.menuBar != null && !this.menuBar.isEnabled()) {
            return false;
        }
        if (this.hAccel == -1) {
            this.createAcceleratorTable();
        }
        if (this.hAccel == 0) {
            return false;
        }
        return OS.WinTranslateAccel(this.getDisplay().hab, this.handle, this.hAccel, qmsg);
    }

    boolean traverseItem(boolean next) {
        return false;
    }

    boolean traverseReturn() {
        if (this.defaultButton == null || this.defaultButton.isDisposed()) {
            return false;
        }
        if (!this.defaultButton.isVisible() || !this.defaultButton.isEnabled()) {
            return false;
        }
        this.defaultButton.click();
        return true;
    }

    int windowProc(int msg, int mp1, int mp2) {
        switch (msg) {
            case 4096: 
            case 4097: {
                if (this.hAccel == -1) {
                    this.createAcceleratorTable();
                }
                return msg == 4096 ? this.nAccel : this.hAccel;
            }
        }
        return super.windowProc(msg, mp1, mp2);
    }

    int widgetFrameFlags() {
        int bits = 0;
        if ((this.style & 8) != 0) {
            return bits;
        }
        if ((this.style & 0x20) != 0) {
            bits |= 1;
        }
        if ((this.style & 0x80) != 0) {
            bits |= 0x10;
        }
        if ((this.style & 0x400) != 0) {
            bits |= 0x20;
        }
        if ((this.style & 0x40) != 0) {
            bits |= 0x4000002;
        }
        return bits;
    }

    int widgetFrameStyle() {
        int bits = super.widgetStyle();
        bits &= 0x7FFDFFFF;
        bits &= 0xFFFFFEFF;
        if ((this.style & 8) != 0) {
            return bits;
        }
        bits = (this.style & 0x10) != 0 ? (bits |= 0x800) : ((this.style & 0x800) == 0 ? (bits |= 0x100) : (bits |= 0x80));
        return bits | 0x20 | 0x10;
    }

    PSZ windowFrameClass() {
        return FrameClass;
    }

    int windowFrameProc() {
        return FrameProc;
    }

    int windowFrameProc(int msg, int mp1, int mp2) {
        MRESULT result = null;
        switch (msg) {
            case 13: {
                result = this.FRAME_WM_ACTIVATE(mp1, mp2);
                break;
            }
            case 8: {
                result = this.FRAME_WM_ADJUSTWINDOWPOS(mp1, mp2);
                break;
            }
            case 94: {
                result = this.FRAME_WM_REALIZEPALETTE(mp1, mp2);
                break;
            }
            case 85: {
                result = this.FRAME_WM_WINDOWPOSCHANGED(mp1, mp2);
                break;
            }
            case 122: {
                result = this.FRAME_WM_CHAR(mp1, mp2);
            }
        }
        if (result != null) {
            return result.value;
        }
        return this.callWindowFrameProc(msg, mp1, mp2);
    }

    int callWindowFrameProc(int msg, int mp1, int mp2) {
        if (this.frameHandle == 0) {
            return 0;
        }
        return OS.WinCallWindowProc(FrameProc, this.frameHandle, msg, mp1, mp2);
    }

    void subclass() {
        super.subclass();
        int oldProc = this.windowFrameProc();
        int newProc = this.getDisplay().windowFrameProc;
        if (oldProc == newProc) {
            return;
        }
        OS.WinSetWindowPtr(this.frameHandle, -3, newProc);
    }

    void unsubclass() {
        int oldProc = this.getDisplay().windowFrameProc;
        int newProc = this.windowFrameProc();
        if (oldProc == newProc) {
            return;
        }
        OS.WinSetWindowPtr(this.frameHandle, -3, newProc);
        super.unsubclass();
    }

    void register() {
        super.register();
        WidgetTable.put(this.frameHandle, this);
    }

    void deregister() {
        WidgetTable.remove(this.frameHandle);
        super.deregister();
    }

    MRESULT FRAME_WM_ACTIVATE(int mp1, int mp2) {
        if (OS.SHORT1FROMMP(mp1) == 0) {
            Shell shell = this.getShell();
            shell.setActiveControl(null);
            if (this.isDisposed()) {
                return MRESULT.ZERO;
            }
            this.sendEvent(27);
            if (this.isDisposed()) {
                return MRESULT.ZERO;
            }
            this.saveFocus();
        } else {
            this.sendEvent(26);
            if (this.isDisposed()) {
                return MRESULT.ZERO;
            }
            this.restoreFocus();
        }
        return null;
    }

    MRESULT FRAME_WM_ADJUSTWINDOWPOS(int mp1, int mp2) {
        SWP swp = new SWP();
        OS.objcpy(swp, mp1);
        if ((swp.fl & 0x400) != 0) {
            this.sendEvent(19);
        } else if ((swp.fl & 0x1000) != 0 && this.getMinimized()) {
            this.sendEvent(20);
        }
        return null;
    }

    MRESULT FRAME_WM_CHAR(int mp1, int mp2) {
        return MRESULT.ZERO;
    }

    MRESULT FRAME_WM_REALIZEPALETTE(int mp1, int mp2) {
        return null;
    }

    MRESULT FRAME_WM_WINDOWPOSCHANGED(int mp1, int mp2) {
        int result = this.callWindowFrameProc(85, mp1, mp2);
        SWP swpNew = new SWP();
        OS.objcpy(swpNew, mp1);
        SWP swpOld = new SWP();
        OS.objcpy(swpOld, mp1 + 36);
        if (swpNew.x != swpOld.x || swpNew.y + swpNew.cy != swpOld.y + swpOld.cy) {
            this.sendEvent(10);
        }
        return new MRESULT(result);
    }

    MRESULT WM_CLOSE(int mp1, int mp2) {
        MRESULT result = super.WM_CLOSE(mp1, mp2);
        if (result != null) {
            return result;
        }
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit && !this.isDisposed()) {
            this.dispose();
        }
        return MRESULT.ZERO;
    }

    MRESULT WM_SETFOCUS(int mp1, int mp2) {
        boolean gotFocus;
        MRESULT result = super.WM_SETFOCUS(mp1, mp2);
        boolean bl = gotFocus = OS.SHORT1FROMMP(mp2) > 0;
        if (gotFocus) {
            this.restoreFocus();
        } else {
            this.saveFocus();
        }
        return result;
    }

    static {
        FrameClass = PSZ.getAtom(-65535);
        CLASSINFO pclsiClassInfo = new CLASSINFO();
        OS.WinQueryClassInfo(0, FrameClass, pclsiClassInfo);
        FrameProc = pclsiClassInfo.pfnWindowProc;
        EmptyTitle = new PSZ(" ");
    }
}

