/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.pm.FATTRS;
import org.eclipse.swt.internal.pm.MENUITEM;
import org.eclipse.swt.internal.pm.MRESULT;
import org.eclipse.swt.internal.pm.OS;
import org.eclipse.swt.internal.pm.PSZ;
import org.eclipse.swt.internal.pm.QMSG;
import org.eclipse.swt.internal.pm.RECTL;
import org.eclipse.swt.internal.pm.SWP;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swt.widgets.WidgetTable;

public abstract class Control
extends Widget
implements Drawable {
    public int handle;
    int hps;
    Composite parent;
    int drawCount;
    int hCursor;
    int foreground;
    int background;
    Menu menu;
    String toolTipText;
    Object layoutData;
    Accessible accessible;
    static final short[] ACCENTS = new short[]{126, 96, 39, 94, 34};

    Control() {
    }

    public Control(Composite parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.createWidget();
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addFocusListener(FocusListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(15, typedListener);
        this.addListener(16, typedListener);
    }

    public void addHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(28, typedListener);
    }

    public void addKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    public void addMouseListener(MouseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(3, typedListener);
        this.addListener(4, typedListener);
        this.addListener(8, typedListener);
    }

    public void addMouseTrackListener(MouseTrackListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(6, typedListener);
        this.addListener(7, typedListener);
        this.addListener(32, typedListener);
    }

    public void addMouseMoveListener(MouseMoveListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(5, typedListener);
    }

    public void addPaintListener(PaintListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(9, typedListener);
    }

    public void addTraverseListener(TraverseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(31, typedListener);
    }

    abstract int callWindowProc(int var1, int var2, int var3);

    public Point computeSize(int wHint, int hHint) {
        return this.computeSize(wHint, hHint, true);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 64;
        int height = 64;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        return new Point(width += border * 2, height += border * 2);
    }

    Control computeTabGroup() {
        if (this.isTabGroup()) {
            return this;
        }
        return this.parent.computeTabGroup();
    }

    Control computeTabRoot() {
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int index = 0;
            while (index < tabList.length) {
                if (tabList[index] == this) break;
                ++index;
            }
            if (index == tabList.length && this.isTabGroup()) {
                return this;
            }
        }
        return this.parent.computeTabRoot();
    }

    Control[] computeTabList() {
        if (this.isTabGroup() && this.getVisible() && this.getEnabled()) {
            return new Control[]{this};
        }
        return new Control[0];
    }

    void createHandle() {
        this.handle = OS.WinCreateWindow(this.parent.handle, this.windowClass(), this.windowTitle(), this.widgetStyle(), 0, this.parent.getHeight(), 0, 0, this.parent.handle, 4, 0, 0, 0);
        if (this.handle == 0) {
            this.error(2);
        }
        OS.WinSetWindowUShort(this.handle, -1, (short)(this.handle & 0xFFFF));
    }

    void createWidget() {
        this.createHandle();
        this.register();
        this.subclass();
        this.setDefaultFont();
        this.setForegroundPixel(-3);
        this.setBackgroundPixel(-3);
    }

    int defaultBackground() {
        return -34;
    }

    int defaultForeground() {
        return -17;
    }

    void deregister() {
        WidgetTable.remove(this.handle);
    }

    void destroyWidget() {
        int hwnd = this.handle;
        this.releaseHandle();
        if (hwnd != 0) {
            OS.WinDestroyWindow(hwnd);
        }
    }

    void drawBackground(int hps) {
        RECTL rcl = new RECTL();
        OS.WinQueryWindowRect(this.handle, rcl);
        this.drawBackground(hps, rcl);
    }

    void drawBackground(int hps, RECTL rcl) {
        if (hps != 0) {
            Display display = this.getDisplay();
            int hPalette = display.hPalette;
            if (hPalette != 0) {
                if (this.hps != hps) {
                    OS.GpiSelectPalette(hps, hPalette);
                }
                int[] cclr = new int[1];
                OS.WinRealizePalette(this.handle, hps, cclr);
            }
        } else {
            hps = this.hps;
        }
        OS.WinFillRect(hps, rcl, this.getBackgroundPixel());
    }

    char findMnemonic(String string) {
        int index = 0;
        int length = string.length();
        while (true) {
            if (index < length && string.charAt(index) != '&') {
                ++index;
                continue;
            }
            if (++index >= length) {
                return '\u0000';
            }
            if (string.charAt(index) != '&') {
                return string.charAt(index);
            }
            if (++index >= length) break;
        }
        return '\u0000';
    }

    public boolean forceFocus() {
        this.checkWidget();
        Decorations shell = this.menuShell();
        shell.setSavedFocus(this);
        if (!(this.isEnabled() && this.isVisible() && this.isActive())) {
            return false;
        }
        if (this.isFocusControl()) {
            return true;
        }
        shell.bringToTop();
        OS.WinSetFocus(1, this.handle);
        return this.isFocusControl();
    }

    public Accessible getAccessible() {
        this.checkWidget();
        if (this.accessible == null) {
            this.accessible = this.new_Accessible(this);
        }
        return this.accessible;
    }

    public Color getBackground() {
        this.checkWidget();
        return Color.pm_new(this.getDisplay(), this.getBackgroundPixel());
    }

    int getBackgroundPixel() {
        if (this.background == -3) {
            return this.defaultBackground();
        }
        return this.background;
    }

    public int getBorderWidth() {
        this.checkWidget();
        return 0;
    }

    int getBounds(SWP swp) {
        if (this.parent != null && this.parent.pswp != 0) {
            Control.endDeferWindowPos(this.parent);
            int count = this.parent.getChildrenCount();
            Control.beginDeferWindowPos(this.parent, count);
        }
        int parentHeight = this.parent.getHeight();
        OS.WinQueryWindowPos(this.handle, swp);
        swp.y = parentHeight - (swp.y + swp.cy);
        return parentHeight;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        SWP swp = new SWP();
        this.getBounds(swp);
        return new Rectangle(swp.x, swp.y, swp.cx, swp.cy);
    }

    public Display getDisplay() {
        Composite parent = this.parent;
        if (parent == null) {
            this.error(24);
        }
        return parent.getDisplay();
    }

    public boolean getEnabled() {
        this.checkWidget();
        return OS.WinIsWindowEnabled(this.handle);
    }

    public Font getFont() {
        this.checkWidget();
        byte[] fontBytes = new byte[32];
        int len = OS.WinQueryPresParam(this.handle, 15, 0, null, fontBytes.length, fontBytes, 0);
        String fontNameSize = len != 0 ? new PSZ(fontBytes).toString() : null;
        Display display = this.getDisplay();
        FATTRS hFont = display.matchFont(fontNameSize);
        return Font.pm_new(display, hFont);
    }

    public Color getForeground() {
        this.checkWidget();
        return Color.pm_new(this.getDisplay(), this.getForegroundPixel());
    }

    int getForegroundPixel() {
        if (this.foreground == -3) {
            return this.defaultForeground();
        }
        return this.foreground;
    }

    int getHeight() {
        RECTL rcl = new RECTL();
        OS.WinQueryWindowRect(this.handle, rcl);
        return rcl.yTop;
    }

    public Object getLayoutData() {
        this.checkWidget();
        return this.layoutData;
    }

    public Point getLocation() {
        this.checkWidget();
        SWP swp = new SWP();
        this.getBounds(swp);
        return new Point(swp.x, swp.y);
    }

    public Composite getParent() {
        this.checkWidget();
        return this.parent;
    }

    Control[] getPath() {
        int count = 0;
        Shell shell = this.getShell();
        Control control = this;
        while (control != shell) {
            ++count;
            control = control.parent;
        }
        control = this;
        Control[] result = new Control[count];
        while (control != shell) {
            result[--count] = control;
            control = control.parent;
        }
        return result;
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    public Point getSize() {
        this.checkWidget();
        SWP swp = new SWP();
        this.getBounds(swp);
        return new Point(swp.cx, swp.cy);
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public boolean getVisible() {
        this.checkWidget();
        int bits = OS.WinQueryWindowULong(this.handle, -2);
        return (bits & Integer.MIN_VALUE) != 0;
    }

    boolean hasFocus() {
        int hwndFocus = OS.WinQueryFocus(1);
        while (hwndFocus != 0) {
            if (hwndFocus == this.handle) {
                return true;
            }
            if (WidgetTable.get(hwndFocus) != null) {
                return false;
            }
            hwndFocus = OS.WinQueryWindow(hwndFocus, 5);
        }
        return false;
    }

    public int internal_new_GC(GCData data) {
        this.checkWidget();
        int hwnd = data == null || data.hwnd == 0 ? this.handle : data.hwnd;
        int hps = data == null || data.rcl == null ? OS.WinGetPS(hwnd) : OS.WinBeginPaint(hwnd, data.hps, data.rcl);
        if (hps == 0) {
            SWT.error(2);
        }
        if (data != null) {
            Display display = this.getDisplay();
            data.device = display;
            data.hdc = OS.GpiQueryDevice(hps);
            if (data.hdc == 0) {
                SWT.error(2);
            }
            data.foreground = this.getForegroundPixel();
            data.background = this.getBackgroundPixel();
            byte[] fontBytes = new byte[32];
            int len = OS.WinQueryPresParam(hwnd, 15, 0, null, fontBytes.length, fontBytes, 0);
            String fontNameSize = len >= 0 ? new PSZ(fontBytes).toString() : null;
            data.hFont = display.matchFont(fontNameSize);
            data.hwnd = hwnd;
        }
        return hps;
    }

    public void internal_dispose_GC(int hps, GCData data) {
        this.checkWidget();
        if (data == null || data.rcl == null) {
            OS.WinReleasePS(hps);
        } else {
            OS.WinEndPaint(hps);
        }
    }

    boolean isActive() {
        Display display = this.getDisplay();
        Shell modal = display.getModalShell();
        if (modal != null && modal != this) {
            Shell shell;
            if ((modal.style & 0x8000) != 0 && modal.parent == (shell = this.getShell())) {
                return false;
            }
            int bits = 196608;
            if ((modal.style & bits) != 0) {
                Control control = this;
                while (control != null) {
                    if (control == modal) break;
                    control = control.parent;
                }
                if (control != modal) {
                    return false;
                }
            }
        }
        return this.getShell().getEnabled();
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    public boolean isFocusControl() {
        this.checkWidget();
        return this.hasFocus();
    }

    boolean isShowing() {
        return OS.WinIsWindowShowing(this.handle);
    }

    boolean isTabGroup() {
        int bits;
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                if (tabList[i] == this) {
                    return true;
                }
                ++i;
            }
        }
        return ((bits = OS.WinQueryWindowULong(this.handle, -2)) & 0x20000) != 0;
    }

    boolean isTabItem() {
        int bits;
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                if (tabList[i] == this) {
                    return false;
                }
                ++i;
            }
        }
        if (((bits = OS.WinQueryWindowULong(this.handle, -2)) & 0x20000) != 0) {
            return false;
        }
        int code = OS.WinSendMsg(this.handle, 58, 0, 0);
        if ((code & 8) != 0) {
            return false;
        }
        return (code & 0x400) == 0;
    }

    public boolean isVisible() {
        this.checkWidget();
        return OS.WinIsWindowVisible(this.handle);
    }

    Decorations menuShell() {
        return this.parent.menuShell();
    }

    boolean mnemonicHit(char key) {
        return false;
    }

    boolean mnemonicMatch(char key) {
        return false;
    }

    Accessible new_Accessible(Control control) {
        return Accessible.internal_new_Accessible(this);
    }

    public void pack() {
        this.checkWidget();
        this.pack(true);
    }

    public void pack(boolean changed) {
        this.checkWidget();
        this.setSize(this.computeSize(-1, -1, changed));
    }

    /*
     * Unable to fully structure code
     */
    String patchMnemonics(String string) {
        buf = new StringBuffer(string);
        mnemonicIdx = string.lastIndexOf(38);
        lastIsMnemonic = false;
        i = 0;
        while (i < buf.length()) {
            v0 = isMnemonic = buf.charAt(i) == '&';
            if (!lastIsMnemonic) ** GOTO lbl24
            if (isMnemonic) {
                buf.deleteCharAt(i--);
                if (mnemonicIdx >= 0) {
                    --mnemonicIdx;
                }
                lastIsMnemonic = false;
            } else {
                if (i - 1 == mnemonicIdx) {
                    buf.replace(i - 1, i, "~");
                    mnemonicIdx = -1;
                } else {
                    buf.deleteCharAt(i-- - 1);
                    if (mnemonicIdx >= 0) {
                        --mnemonicIdx;
                    }
                }
lbl24:
                // 5 sources

                if (!isMnemonic && buf.charAt(i) == '~') {
                    buf.insert(i++, '~');
                    if (mnemonicIdx >= 0) {
                        ++mnemonicIdx;
                    }
                }
                lastIsMnemonic = isMnemonic;
            }
            ++i;
        }
        if (lastIsMnemonic) {
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }

    public void redraw() {
        this.checkWidget();
        if (!OS.WinIsWindowVisible(this.handle)) {
            return;
        }
        OS.WinInvalidateRect(this.handle, null, false);
    }

    public void redraw(int x, int y, int width, int height, boolean all) {
        this.checkWidget();
        if (width <= 0 || height <= 0) {
            return;
        }
        if (!OS.WinIsWindowVisible(this.handle)) {
            return;
        }
        RECTL rcl = new RECTL();
        rcl.xLeft = x;
        rcl.xRight = x + width;
        rcl.yTop = this.getHeight() - y;
        rcl.yBottom = rcl.yTop - height;
        OS.WinInvalidateRect(this.handle, rcl, all);
    }

    void register() {
        WidgetTable.put(this.handle, this);
    }

    void releaseHandle() {
        this.handle = 0;
    }

    void releaseWidget() {
        if (this.hps != 0) {
            if (this.getDisplay().hPalette != 0) {
                OS.GpiSelectPalette(this.hps, 0);
            }
            this.internal_dispose_GC(this.hps, null);
        }
        super.releaseWidget();
        this.toolTipText = null;
        this.deregister();
        this.unsubclass();
        this.parent = null;
        this.layoutData = null;
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, listener);
        this.eventTable.unhook(11, listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(15, listener);
        this.eventTable.unhook(16, listener);
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, listener);
        this.eventTable.unhook(1, listener);
    }

    public void removeMouseTrackListener(MouseTrackListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(6, listener);
        this.eventTable.unhook(7, listener);
        this.eventTable.unhook(32, listener);
    }

    public void removeMouseListener(MouseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(3, listener);
        this.eventTable.unhook(4, listener);
        this.eventTable.unhook(8, listener);
    }

    public void removeMouseMoveListener(MouseMoveListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(5, listener);
    }

    public void removePaintListener(PaintListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(9, listener);
    }

    public void removeTraverseListener(TraverseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(31, listener);
    }

    boolean sendKeyEvent(int type, int msg, int mp1, int mp2) {
        Event event = new Event();
        switch (msg) {
            case 122: {
                short fsflags = OS.SHORT1FROMMP(mp1);
                short usch = OS.SHORT1FROMMP(mp2);
                short usvk = OS.SHORT2FROMMP(mp2);
                if ((usvk == 9 || usvk == 11 || usvk == 12 || usvk == 10 || usvk == 14 || usvk == 29 || usvk == 28) && (fsflags & 0x80) != 0) {
                    return true;
                }
                event.character = new String(new byte[]{(byte)usch}).charAt(0);
                if ((fsflags & 2) == 0) break;
                if (usvk == 27) {
                    event.character = (char)127;
                    break;
                }
                event.keyCode = Display.translateKey(usvk);
                if (event.keyCode == 0) break;
                event.character = '\u0000';
            }
        }
        if (event.keyCode == 0 && event.character == '\u0000') {
            return true;
        }
        if (!this.setInputState(event, type)) {
            return true;
        }
        return this.sendKeyEvent(type, msg, mp1, mp2, event);
    }

    boolean sendKeyEvent(int type, int msg, int mp1, int mp2, Event event) {
        this.postEvent(type, event);
        return true;
    }

    public void setBackground(Color color) {
        this.checkWidget();
        int pixel = -3;
        if (color != null) {
            if (color.isDisposed()) {
                SWT.error(5);
            }
            pixel = color.handle;
        }
        this.setBackgroundPixel(pixel);
    }

    void setBackgroundPixel(int pixel) {
        if (this.background == pixel) {
            return;
        }
        this.background = pixel;
        this.setPresBackground();
        OS.WinInvalidateRect(this.handle, null, true);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.checkWidget();
        this.setBounds(x, y, Math.max(0, width), Math.max(0, height), 3);
    }

    static void beginDeferWindowPos(Composite parent, int count) {
        parent.pswp = OS.malloc(36 * count);
        OS.memset(parent.pswp, 0, 36 * count);
        parent.pswpHandles = new int[count];
    }

    static void endDeferWindowPos(Composite parent) {
        int pswp = parent.pswp;
        int count = parent.pswpHandles.length;
        int hab = parent.getDisplay().hab;
        int diff = 0;
        int i = 0;
        while (i < count) {
            if (!OS.WinIsWindow(hab, parent.pswpHandles[i])) {
                int j = i - diff;
                OS.memcpy(pswp + 36 * j, pswp + 36 * (j + 1), 36 * (count - i - 1));
                ++diff;
            }
            ++i;
        }
        parent.pswp = 0;
        parent.pswpHandles = null;
        OS.WinSetMultWindowPos(hab, pswp, count -= diff);
        OS.free(pswp);
    }

    static void deferWindowPos(Composite parent, SWP swp) {
        int free = -1;
        int count = parent.pswpHandles.length;
        int i = 0;
        while (i < count) {
            if (parent.pswpHandles[i] == swp.hwnd) break;
            if (parent.pswpHandles[i] == 0 && free < 0) {
                free = i;
            }
            ++i;
        }
        if (i == count) {
            if (free >= 0) {
                i = free;
            } else {
                int pswpNew = OS.malloc(36 * (count + 4));
                OS.memcpy(pswpNew, parent.pswp, 36 * count);
                OS.memset(pswpNew + 36 * count, 0, 144);
                int[] pswpHandlesNew = new int[count + 4];
                System.arraycopy(parent.pswpHandles, 0, pswpHandlesNew, 0, count);
                OS.free(parent.pswp);
                parent.pswp = pswpNew;
                parent.pswpHandles = pswpHandlesNew;
                i = count;
            }
            parent.pswpHandles[i] = swp.hwnd;
        }
        OS.objcpy(parent.pswp + 36 * i, swp);
    }

    static int getDeferredWindowPos(Composite parent, SWP swp) {
        int count = parent.pswpHandles.length;
        int i = 0;
        while (i < count) {
            if (parent.pswpHandles[i] == swp.hwnd) break;
            ++i;
        }
        if (i == count) {
            return -1;
        }
        int parentHeight = parent.getHeight();
        OS.objcpy(swp, parent.pswp + 36 * i);
        swp.y = parentHeight - (swp.y + swp.cy);
        return parentHeight;
    }

    void setBounds(int x, int y, int width, int height, int flags) {
        SWP swp = new SWP();
        int parentHeight = -1;
        if (this.parent != null && this.parent.pswp != 0) {
            parentHeight = Control.getDeferredWindowPos(this.parent, swp);
        }
        if (parentHeight == -1) {
            parentHeight = this.getBounds(swp);
        }
        if ((flags & 2) != 0) {
            swp.x = x;
            swp.y = y;
        }
        if ((flags & 1) != 0) {
            swp.cx = width;
            swp.cy = height;
            flags |= 2;
        }
        swp.y = parentHeight - (swp.y + swp.cy);
        if (this.parent == null) {
            OS.WinSetWindowPos(this.handle, 0, swp.x, swp.y, swp.cx, swp.cy, flags);
            return;
        }
        swp.hwnd = this.handle;
        swp.fl = flags;
        int count = this.parent.getChildrenCount();
        if (this.parent.pswp == 0) {
            OS.WinSetWindowPos(this.handle, 0, swp.x, swp.y, swp.cx, swp.cy, flags);
            return;
        }
        Control.deferWindowPos(this.parent, swp);
    }

    public void setBounds(Rectangle rect) {
        this.checkWidget();
        if (rect == null) {
            this.error(4);
        }
        this.setBounds(rect.x, rect.y, rect.width, rect.height);
    }

    void setDefaultFont() {
        Display display = this.getDisplay();
        String fontName = display.composeFontNameSize(display.systemFont());
        byte[] fontBytes = new PSZ(fontName).getBytes();
        OS.WinSetPresParam(this.handle, 15, fontBytes.length, fontBytes);
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        OS.WinEnableWindow(this.handle, enabled);
    }

    public boolean setFocus() {
        this.checkWidget();
        return this.forceFocus();
    }

    public void setFont(Font font) {
        FATTRS hFont;
        this.checkWidget();
        Display display = this.getDisplay();
        if (font != null) {
            if (font.isDisposed()) {
                SWT.error(5);
            }
            hFont = font.internal_get_handle();
        } else {
            hFont = display.systemFont();
        }
        String fontName = display.composeFontNameSize(hFont);
        byte[] fontBytes = new PSZ(fontName).getBytes();
        OS.WinSetPresParam(this.handle, 15, fontBytes.length, fontBytes);
    }

    public void setForeground(Color color) {
        this.checkWidget();
        int pixel = -3;
        if (color != null) {
            if (color.isDisposed()) {
                SWT.error(5);
            }
            pixel = color.handle;
        }
        this.setForegroundPixel(pixel);
    }

    void setForegroundPixel(int pixel) {
        if (this.foreground == pixel) {
            return;
        }
        this.foreground = pixel;
        this.setPresForeground();
        OS.WinInvalidateRect(this.handle, null, true);
    }

    boolean setInputState(Event event, int type) {
        if ((OS.WinGetKeyState(1, 11) & 0x8000) != 0) {
            event.stateMask |= 0x10000;
        }
        if ((OS.WinGetKeyState(1, 12) & 0x8000) != 0) {
            event.stateMask |= 0x10000;
        }
        if ((OS.WinGetKeyState(1, 9) & 0x8000) != 0) {
            event.stateMask |= 0x20000;
        }
        if ((OS.WinGetKeyState(1, 10) & 0x8000) != 0) {
            event.stateMask |= 0x40000;
        }
        if ((OS.WinGetKeyState(1, 1) & 0x8000) != 0) {
            event.stateMask |= 0x80000;
        }
        if ((OS.WinGetKeyState(1, 2) & 0x8000) != 0) {
            event.stateMask |= 0x100000;
        }
        if ((OS.WinGetKeyState(1, 3) & 0x8000) != 0) {
            event.stateMask |= 0x200000;
        }
        switch (type) {
            case 1: 
            case 31: {
                if (event.keyCode == 65536) {
                    event.stateMask &= 0xFFFEFFFF;
                }
                if (event.keyCode == 131072) {
                    event.stateMask &= 0xFFFDFFFF;
                }
                if (event.keyCode != 262144) break;
                event.stateMask &= 0xFFFBFFFF;
                break;
            }
            case 2: {
                if (event.keyCode == 65536) {
                    event.stateMask |= 0x10000;
                }
                if (event.keyCode == 131072) {
                    event.stateMask |= 0x20000;
                }
                if (event.keyCode != 262144) break;
                event.stateMask |= 0x40000;
            }
        }
        return true;
    }

    public void setLayoutData(Object layoutData) {
        this.checkWidget();
        this.layoutData = layoutData;
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        this.setBounds(x, y, 0, 0, 2);
    }

    public void setLocation(Point location) {
        this.checkWidget();
        if (location == null) {
            this.error(4);
        }
        this.setLocation(location.x, location.y);
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        if (menu != null) {
            if (menu.isDisposed()) {
                SWT.error(5);
            }
            if ((menu.style & 8) == 0) {
                this.error(37);
            }
            if (menu.parent != this.menuShell()) {
                this.error(32);
            }
        }
        this.menu = menu;
    }

    void setPresBackground() {
        int[] value = new int[]{this.getBackgroundPixel()};
        int index = value[0] < 0 || this.getDisplay().hPalette != 0 ? 4 : 3;
        OS.WinSetPresParam(this.handle, index, 4, value);
        if (index == 4) {
            OS.WinSetPresParam(this.handle, 3, 4, new int[]{OS.WinQuerySysColor(1, value[0], 0)});
        }
        index = index == 4 ? 12 : 11;
        OS.WinSetPresParam(this.handle, index, 4, value);
    }

    void setPresForeground() {
        int[] value = new int[]{this.getForegroundPixel()};
        int index = value[0] < 0 || this.getDisplay().hPalette != 0 ? 2 : 1;
        OS.WinSetPresParam(this.handle, index, 4, value);
        index = index == 2 ? 10 : 9;
        OS.WinSetPresParam(this.handle, index, 4, value);
    }

    boolean setRadioFocus() {
        return false;
    }

    public void setRedraw(boolean redraw) {
        this.checkWidget();
        if (redraw) {
            if (--this.drawCount == 0) {
                OS.WinEnableWindowUpdate(this.handle, true);
                OS.WinInvalidateRect(this.handle, null, true);
            }
        } else if (this.drawCount++ == 0) {
            OS.WinEnableWindowUpdate(this.handle, false);
        }
    }

    public void setSize(int width, int height) {
        this.checkWidget();
        this.setBounds(0, 0, Math.max(0, width), Math.max(0, height), 1);
    }

    public void setSize(Point size) {
        this.checkWidget();
        if (size == null) {
            this.error(4);
        }
        this.setSize(size.x, size.y);
    }

    boolean setTabGroupFocus() {
        return this.setTabItemFocus();
    }

    boolean setTabItemFocus() {
        if (!this.isShowing()) {
            return false;
        }
        return this.setFocus();
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if (OS.WinIsWindowVisible(this.handle) == visible) {
            return;
        }
        if (visible) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
        }
        OS.WinShowWindow(this.handle, visible);
        if (!visible) {
            this.sendEvent(23);
            if (this.isDisposed()) {
                return;
            }
        }
    }

    void sort(int[] items) {
        int length = items.length;
        int gap = length / 2;
        while (gap > 0) {
            int i = gap;
            while (i < length) {
                int j = i - gap;
                while (j >= 0) {
                    if (items[j] <= items[j + gap]) {
                        int swap = items[j];
                        items[j] = items[j + gap];
                        items[j + gap] = swap;
                    }
                    j -= gap;
                }
                ++i;
            }
            gap /= 2;
        }
    }

    void subclass() {
        int newProc;
        int oldProc = this.windowProc();
        if (oldProc == (newProc = this.getDisplay().windowProc)) {
            return;
        }
        OS.WinSetWindowPtr(this.handle, -3, newProc);
    }

    boolean translateAccelerator(QMSG qmsg) {
        return this.menuShell().translateAccelerator(qmsg);
    }

    boolean translateMnemonic(char key) {
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        Event event = new Event();
        event.doit = this.mnemonicMatch(key);
        event.detail = 128;
        event.keyCode = 0;
        event.character = key;
        if (!this.setInputState(event, 31)) {
            return false;
        }
        return this.traverse(event);
    }

    boolean translateMnemonic(QMSG qmsg) {
        int code;
        int hwnd = qmsg.hwnd;
        if ((OS.WinGetKeyState(1, 11) & 0x8000) == 0 && (OS.WinGetKeyState(1, 12) & 0x8000) == 0 && ((code = OS.WinSendMsg(hwnd, 58, 0, 0)) & 2) == 0) {
            return false;
        }
        Decorations shell = this.menuShell();
        if (shell.isVisible() && shell.isEnabled()) {
            short usch = OS.SHORT1FROMMP(qmsg.mp2);
            char ch = new String(new byte[]{(byte)usch}).charAt(0);
            return ch != '\u0000' && shell.translateMnemonic(ch);
        }
        return false;
    }

    boolean translateTraversal(QMSG qmsg) {
        short fsflags = OS.SHORT1FROMMP(qmsg.mp1);
        short usvk = OS.SHORT2FROMMP(qmsg.mp2);
        int hwnd = qmsg.hwnd;
        int detail = 0;
        boolean doit = true;
        boolean all = false;
        int keyCode = 0;
        int character = 0;
        int code = OS.WinSendMsg(hwnd, 58, 0, 0);
        switch (usvk) {
            case 15: {
                all = true;
                character = 27;
                if ((code & 0x400) != 0) {
                    doit = false;
                }
                detail = 2;
                break;
            }
            case 8: 
            case 30: {
                all = true;
                character = 13;
                if ((code & 0x400) != 0) {
                    doit = false;
                }
                detail = 4;
                break;
            }
            case 6: 
            case 7: {
                boolean next;
                character = 9;
                boolean bl = next = usvk == 6 && (fsflags & 8) == 0;
                if ((code & 0x400) != 0 && next && (fsflags & 0x10) == 0) {
                    doit = false;
                }
                detail = next ? 16 : 8;
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                this.getDisplay();
                keyCode = Display.translateKey(usvk);
                if ((code & 0x400) != 0) {
                    doit = false;
                }
                boolean next = usvk == 24 || usvk == 23;
                detail = next ? 64 : 32;
                break;
            }
            case 17: 
            case 18: {
                all = true;
                this.getDisplay();
                keyCode = Display.translateKey(usvk);
                if ((OS.WinGetKeyState(1, 10) & 0x8000) == 0) {
                    return false;
                }
                if ((code & 0x400) != 0) {
                    doit = false;
                }
                detail = usvk == 17 ? 256 : 512;
                break;
            }
            default: {
                return false;
            }
        }
        Event event = new Event();
        event.doit = doit;
        event.detail = detail;
        event.keyCode = keyCode;
        event.character = (char)character;
        if (!this.setInputState(event, 31)) {
            return false;
        }
        Shell shell = this.getShell();
        Control control = this;
        do {
            if (control.traverse(event)) {
                return true;
            }
            if (!event.doit && control.hooks(31)) {
                return false;
            }
            if (control == shell) {
                return false;
            }
            control = control.parent;
        } while (all && control != null);
        return false;
    }

    boolean traverse(Event event) {
        this.sendEvent(31, event);
        if (this.isDisposed()) {
            return false;
        }
        if (!event.doit) {
            return false;
        }
        switch (event.detail) {
            case 0: {
                return true;
            }
            case 2: {
                return this.traverseEscape();
            }
            case 4: {
                return this.traverseReturn();
            }
            case 16: {
                return this.traverseGroup(true);
            }
            case 8: {
                return this.traverseGroup(false);
            }
            case 64: {
                return this.traverseItem(true);
            }
            case 32: {
                return this.traverseItem(false);
            }
            case 128: {
                return this.traverseMnemonic(event.character);
            }
            case 512: {
                return this.traversePage(true);
            }
            case 256: {
                return this.traversePage(false);
            }
        }
        return false;
    }

    public boolean traverse(int traversal) {
        this.checkWidget();
        if (!this.isFocusControl() && !this.setFocus()) {
            return false;
        }
        Event event = new Event();
        event.doit = true;
        event.detail = traversal;
        return this.traverse(event);
    }

    boolean traverseEscape() {
        return false;
    }

    boolean traverseGroup(boolean next) {
        Control root = this.computeTabRoot();
        Control group = this.computeTabGroup();
        Control[] list = root.computeTabList();
        int length = list.length;
        int index = 0;
        while (index < length) {
            if (list[index] == group) break;
            ++index;
        }
        if (index == length) {
            return false;
        }
        int start = index;
        int offset = next ? 1 : -1;
        while ((index = (index + offset + length) % length) != start) {
            Control control = list[index];
            if (control.isDisposed() || !control.setTabGroupFocus() || this.isDisposed() || this.isFocusControl()) continue;
            return true;
        }
        if (group.isDisposed()) {
            return false;
        }
        return group.setTabGroupFocus();
    }

    boolean traverseItem(boolean next) {
        Control[] children = this.parent._getChildren();
        int length = children.length;
        int index = 0;
        while (index < length) {
            if (children[index] == this) break;
            ++index;
        }
        int start = index;
        int offset = next ? 1 : -1;
        while ((index = (index + offset + length) % length) != start) {
            Control child = children[index];
            if (child.isDisposed() || !child.isTabItem() || !child.setTabItemFocus()) continue;
            return true;
        }
        return false;
    }

    boolean traverseMnemonic(char key) {
        return this.mnemonicHit(key);
    }

    boolean traversePage(boolean next) {
        return false;
    }

    boolean traverseReturn() {
        return false;
    }

    void unsubclass() {
        int oldProc = this.getDisplay().windowProc;
        int newProc = this.windowProc();
        if (oldProc == newProc) {
            return;
        }
        OS.WinSetWindowPtr(this.handle, -3, newProc);
    }

    public void update() {
        this.checkWidget();
        OS.WinUpdateWindow(this.handle);
    }

    void updateFont(Font oldFont, Font newFont) {
        Font font = this.getFont();
        if (font.equals(oldFont)) {
            this.setFont(newFont);
        }
    }

    int widgetStyle() {
        return -1879048192;
    }

    public boolean setParent(Composite parent) {
        this.checkWidget();
        if (parent == null) {
            this.error(4);
        }
        if (parent.isDisposed()) {
            SWT.error(5);
        }
        if (!OS.WinSetParent(this.handle, parent.handle, true)) {
            return false;
        }
        this.parent = parent;
        return true;
    }

    abstract PSZ windowClass();

    abstract int windowProc();

    int windowProc(int msg, int mp1, int mp2) {
        MRESULT result = null;
        switch (msg) {
            case 9: {
                result = this.WM_CALCVALIDRECTS(mp1, mp2);
                break;
            }
            case 122: {
                result = this.WM_CHAR(mp1, mp2);
                break;
            }
            case 41: {
                result = this.WM_CLOSE(mp1, mp2);
                break;
            }
            case 32: {
                result = this.WM_COMMAND(mp1, mp2);
                break;
            }
            case 1060: {
                result = this.WM_CONTEXTMENU(mp1, mp2);
                break;
            }
            case 48: {
                result = this.WM_CONTROL(mp1, mp2);
                break;
            }
            case 79: {
                result = this.WM_ERASEBACKGROUND(mp1, mp2);
                break;
            }
            case 67: {
                result = this.WM_FOCUSCHANGE(mp1, mp2);
                break;
            }
            case 58: {
                result = this.WM_QUERYDLGCODE(mp1, mp2);
                break;
            }
            case 50: {
                result = this.WM_HSCROLL(mp1, mp2);
                break;
            }
            case 51: {
                result = this.WM_INITMENU(mp1, mp2);
                break;
            }
            case 55: {
                result = this.WM_MEASUREITEM(mp1, mp2);
                break;
            }
            case 53: {
                result = this.WM_MENUEND(mp1, mp2);
                break;
            }
            case 52: {
                result = this.WM_MENUSELECT(mp1, mp2);
                break;
            }
            case 35: {
                result = this.WM_PAINT(mp1, mp2);
                break;
            }
            case 15: {
                result = this.WM_SETFOCUS(mp1, mp2);
                break;
            }
            case 7: {
                result = this.WM_SIZE(mp1, mp2);
                break;
            }
            case 49: {
                result = this.WM_VSCROLL(mp1, mp2);
                break;
            }
            case 85: {
                result = this.WM_WINDOWPOSCHANGED(mp1, mp2);
            }
        }
        if (result != null) {
            return result.value;
        }
        return this.callWindowProc(msg, mp1, mp2);
    }

    PSZ windowTitle() {
        return null;
    }

    MRESULT WM_CALCVALIDRECTS(int mp1, int mp2) {
        return null;
    }

    MRESULT WM_CHAR(int mp1, int mp2) {
        boolean keyUp = (OS.SHORT1FROMMP(mp1) & 0x40) != 0;
        this.sendKeyEvent(keyUp ? 2 : 1, 122, mp1, mp2);
        return null;
    }

    MRESULT WM_CLOSE(int mp1, int mp2) {
        return null;
    }

    MRESULT WM_COMMAND(int mp1, int mp2) {
        switch (OS.SHORT1FROMMP(mp2)) {
            case 2: {
                int id;
                MenuItem item;
                Decorations shell = this.menuShell();
                if (!shell.isEnabled() || (item = shell.findMenuItem(id = mp1)) == null || !item.isEnabled()) break;
                return item.wmCommandChild(mp1, mp2);
            }
            case 3: {
                System.out.println("Control:WM_COMMAND - CMDSRC_ACCELERATOR");
                break;
            }
            case 1: {
                System.out.println("Control:WM_COMMAND - CMDSRC_PUSHBUTTON");
                break;
            }
            case 4: {
                System.out.println("Control:WM_COMMAND - CMDSRC_FONTDLG");
                break;
            }
            case 5: {
                System.out.println("Control:WM_COMMAND - CMDSRC_FILEDLG");
                break;
            }
            case 0: {
                System.out.println("Control:WM_COMMAND - CMDSRC_OTHER");
            }
        }
        int hwndChild = OS.WinWindowFromID(this.handle, OS.SHORT1FROMMP(mp1));
        Control control = WidgetTable.get(hwndChild);
        if (control == null) {
            return null;
        }
        return control.wmCommandChild(mp1, mp2);
    }

    MRESULT WM_CONTEXTMENU(int mp1, int mp2) {
        short flOptions = 582;
        boolean rc = OS.WinPopupMenu(this.handle, this.handle, this.menu.handle, 0, OS.SHORT1FROMMP(mp1), OS.SHORT2FROMMP(mp1), flOptions);
        return MRESULT.TRUE;
    }

    MRESULT WM_CONTROL(int mp1, int mp2) {
        int hwndChild = OS.WinWindowFromID(this.handle, OS.SHORT1FROMMP(mp1));
        Control control = WidgetTable.get(hwndChild);
        if (control == null) {
            return null;
        }
        return control.wmControlChild(mp1, mp2);
    }

    MRESULT WM_ERASEBACKGROUND(int mp1, int mp2) {
        return null;
    }

    MRESULT WM_MEASUREITEM(int mp1, int mp2) {
        return null;
    }

    MRESULT WM_QUERYDLGCODE(int mp1, int mp2) {
        return null;
    }

    MRESULT WM_HSCROLL(int mp1, int mp2) {
        int hwndChild = OS.WinWindowFromID(this.handle, OS.SHORT1FROMMP(mp1));
        Control control = WidgetTable.get(hwndChild);
        if (control == null) {
            return null;
        }
        return control.wmScrollChild(mp1, mp2);
    }

    MRESULT WM_INITMENU(int mp1, int mp2) {
        Display display = this.getDisplay();
        if (display.accelKeyHit) {
            return null;
        }
        Shell shell = this.getShell();
        Menu oldMenu = shell.activeMenu;
        Menu newMenu = null;
        Menu menu = newMenu = this.menuShell().findMenu(mp2);
        while (menu != null && menu != oldMenu) {
            menu = menu.getParentMenu();
        }
        if (menu == null) {
            menu = shell.activeMenu;
            while (menu != null) {
                menu.sendEvent(23);
                if (menu.isDisposed()) break;
                menu = menu.getParentMenu();
                Menu ancestor = newMenu;
                while (ancestor != null && ancestor != menu) {
                    ancestor = ancestor.getParentMenu();
                }
                if (ancestor != null) break;
            }
        }
        if (newMenu != null && newMenu.isDisposed()) {
            newMenu = null;
        }
        shell.activeMenu = newMenu;
        if (newMenu != null && newMenu != oldMenu) {
            display.runDeferredEvents();
            newMenu.sendEvent(22);
        }
        return null;
    }

    MRESULT WM_MENUSELECT(int mp1, int mp2) {
        if (OS.SHORT2FROMMP(mp1) == 0) {
            return MRESULT.FALSE;
        }
        Shell shell = this.getShell();
        int sState = OS.WinSendMsg(mp2, 401, OS.MPFROM2SHORT(OS.SHORT1FROMMP(mp1), (short)1), 32768);
        if ((sState & 0x8000) != 0) {
            MenuItem item = null;
            Decorations menuShell = this.menuShell();
            MENUITEM info = new MENUITEM();
            OS.WinSendMsg(mp2, 386, OS.MPFROM2SHORT(OS.SHORT1FROMMP(mp1), (short)1), info);
            if ((info.afStyle & 0x10) != 0) {
                Menu newMenu = menuShell.findMenu(info.hwndSubMenu);
                if (newMenu != null) {
                    item = newMenu.cascade;
                }
            } else {
                Menu oldMenu;
                Menu newMenu = menuShell.findMenu(mp2);
                if (newMenu != null) {
                    short id = OS.SHORT1FROMMP(mp1);
                    item = menuShell.findMenuItem(id);
                }
                if ((oldMenu = shell.activeMenu) != null) {
                    Menu ancestor = oldMenu;
                    while (ancestor != null && ancestor != newMenu) {
                        ancestor = ancestor.getParentMenu();
                    }
                    if (ancestor == newMenu) {
                        ancestor = oldMenu;
                        while (ancestor != newMenu) {
                            ancestor.sendEvent(23);
                            if (ancestor.isDisposed()) break;
                            ancestor = ancestor.getParentMenu();
                        }
                        if (!shell.isDisposed()) {
                            if (newMenu != null && newMenu.isDisposed()) {
                                newMenu = null;
                            }
                            shell.activeMenu = newMenu;
                        }
                        if (item != null && item.isDisposed()) {
                            item = null;
                        }
                    }
                }
            }
            if (item != null) {
                item.sendEvent(30);
            }
        }
        return MRESULT.TRUE;
    }

    MRESULT WM_PAINT(int mp1, int mp2) {
        if (!this.hooks(9)) {
            return null;
        }
        GCData data = new GCData();
        if (this.hps == 0) {
            this.hps = this.internal_new_GC(data);
            if (this.hps == 0) {
                SWT.error(2);
            }
            data.doInit = true;
        }
        int hrgn = OS.GpiCreateRegion(this.hps, 0, null);
        OS.WinQueryUpdateRegion(this.handle, hrgn);
        this.callWindowProc(35, mp1, mp2);
        int bits = OS.WinQueryWindowULong(this.handle, -2);
        OS.WinSetWindowULong(this.handle, -2, bits & 0xFDFFFFFF);
        OS.WinInvalidateRegion(this.handle, hrgn, false);
        OS.WinSetWindowULong(this.handle, -2, bits);
        OS.GpiDestroyRegion(this.hps, hrgn);
        data.rcl = new RECTL();
        data.hps = this.hps;
        GC gc = GC.pm_new(this, data);
        Event event = new Event();
        event.gc = gc;
        event.x = data.rcl.xLeft;
        event.y = this.getHeight() - data.rcl.yTop;
        event.width = data.rcl.xRight - data.rcl.xLeft;
        event.height = data.rcl.yTop - data.rcl.yBottom;
        this.sendEvent(9, event);
        event.gc = null;
        gc.dispose();
        return MRESULT.ZERO;
    }

    MRESULT WM_SETFOCUS(int mp1, int mp2) {
        boolean gotFocus;
        this.callWindowProc(15, mp1, mp2);
        Shell shell = this.getShell();
        boolean bl = gotFocus = OS.SHORT1FROMMP(mp2) > 0;
        if (gotFocus) {
            this.sendEvent(15);
        } else {
            this.sendEvent(16);
        }
        if (!shell.isDisposed()) {
            if (gotFocus) {
                shell.setActiveControl(this);
            } else {
                Display display = this.getDisplay();
                Control control = display.findControl(mp1);
                if (control == null || shell != control.getShell()) {
                    shell.setActiveControl(null);
                }
            }
        }
        return MRESULT.ZERO;
    }

    MRESULT WM_MENUEND(int mp1, int mp2) {
        return null;
    }

    MRESULT WM_SIZE(int mp1, int mp2) {
        if (this.hps != 0) {
            int[] matrix = new int[]{65536, 0, 0, 0, -65536, 0, 0, 0, 1};
            matrix[7] = OS.SHORT2FROMMP(mp2) - 1;
            OS.GpiSetDefaultViewMatrix(this.hps, matrix.length, matrix, 0);
        }
        this.sendEvent(11);
        return null;
    }

    MRESULT WM_VSCROLL(int mp1, int mp2) {
        int hwndChild = OS.WinWindowFromID(this.handle, OS.SHORT1FROMMP(mp1));
        Control control = WidgetTable.get(hwndChild);
        if (control == null) {
            return null;
        }
        return control.wmScrollChild(mp1, mp2);
    }

    MRESULT WM_WINDOWPOSCHANGED(int mp1, int mp2) {
        int result = this.callWindowProc(85, mp1, mp2);
        SWP swpNew = new SWP();
        OS.objcpy(swpNew, mp1);
        if ((swpNew.fl & 0x40) == 0) {
            SWP swpOld = new SWP();
            OS.objcpy(swpOld, mp1 + 36);
            if (swpNew.x != swpOld.x || swpNew.y + swpNew.cy != swpOld.y + swpOld.cy) {
                this.sendEvent(10);
            }
            if (swpNew.cx != swpOld.cx || swpNew.cy != swpOld.cy) {
                this.WM_SIZE(swpOld.cy << 16 | swpOld.cx, swpNew.cy << 16 | swpNew.cx);
            }
        }
        return new MRESULT(result);
    }

    MRESULT WM_FOCUSCHANGE(int mp1, int mp2) {
        this.callWindowProc(67, mp1, mp2);
        return MRESULT.ZERO;
    }

    MRESULT wmCommandChild(int mp1, int mp2) {
        return null;
    }

    MRESULT wmControlChild(int mp1, int mp2) {
        return null;
    }

    MRESULT wmDrawChild(int mp1, int mp2) {
        return null;
    }

    MRESULT wmScrollChild(int mp1, int mp2) {
        return null;
    }
}

