/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.pm.MRESULT;
import org.eclipse.swt.internal.pm.OS;
import org.eclipse.swt.internal.pm.RECTL;
import org.eclipse.swt.internal.pm.RGNRECT;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.WidgetTable;

public class Composite
extends Scrollable {
    Layout layout;
    int pswp;
    int[] pswpHandles;
    Control[] tabList;

    Composite() {
    }

    public Composite(Composite parent, int style) {
        super(parent, style);
    }

    /*
     * Unable to fully structure code
     */
    Control[] _getChildren() {
        count = 0;
        hwndChild = OS.WinQueryWindow(this.handle, 2);
        if (hwndChild != 0) ** GOTO lbl7
        return new Control[0];
lbl-1000:
        // 1 sources

        {
            ++count;
            hwndChild = OS.WinQueryWindow(hwndChild, 0);
lbl7:
            // 2 sources

            ** while (hwndChild != 0)
        }
lbl8:
        // 1 sources

        children = new Control[count];
        index = 0;
        hwndChild = OS.WinQueryWindow(this.handle, 2);
        while (hwndChild != 0) {
            control = WidgetTable.get(hwndChild);
            if (control != null && control != this) {
                children[index++] = control;
            }
            hwndChild = OS.WinQueryWindow(hwndChild, 0);
        }
        if (count == index) {
            return children;
        }
        newChildren = new Control[index];
        System.arraycopy(children, 0, newChildren, 0, index);
        return newChildren;
    }

    Control[] _getTabList() {
        if (this.tabList == null) {
            return this.tabList;
        }
        int count = 0;
        int i = 0;
        while (i < this.tabList.length) {
            if (!this.tabList[i].isDisposed()) {
                ++count;
            }
            ++i;
        }
        if (count == this.tabList.length) {
            return this.tabList;
        }
        Control[] newList = new Control[count];
        int index = 0;
        int i2 = 0;
        while (i2 < this.tabList.length) {
            if (!this.tabList[i2].isDisposed()) {
                newList[index++] = this.tabList[i2];
            }
            ++i2;
        }
        this.tabList = newList;
        return this.tabList;
    }

    protected void checkSubclass() {
    }

    Control[] computeTabList() {
        Control[] result = super.computeTabList();
        if (result.length == 0) {
            return result;
        }
        Control[] list = this.tabList != null ? this._getTabList() : this._getChildren();
        int i = 0;
        while (i < list.length) {
            Control child = list[i];
            Control[] childList = child.computeTabList();
            if (childList.length != 0) {
                Control[] newResult = new Control[result.length + childList.length];
                System.arraycopy(result, 0, newResult, 0, result.length);
                System.arraycopy(childList, 0, newResult, result.length, childList.length);
                result = newResult;
            }
            ++i;
        }
        return result;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point size = this.layout != null ? (wHint == -1 || hHint == -1 ? this.layout.computeSize(this, wHint, hHint, changed) : new Point(wHint, hHint)) : this.minimumSize();
        if (size.x == 0) {
            size.x = 64;
        }
        if (size.y == 0) {
            size.y = 64;
        }
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        return new Point(trim.width, trim.height);
    }

    void createHandle() {
        super.createHandle();
        this.state |= 0x1000;
    }

    void drawBackground(int hps, RECTL rcl) {
        if ((this.state & 0x1000) != 0 && (this.style & 0x40000) != 0) {
            return;
        }
        super.drawBackground(hps, rcl);
    }

    public Control[] getChildren() {
        this.checkWidget();
        return this._getChildren();
    }

    int getChildrenCount() {
        int count = 0;
        int hwndChild = OS.WinQueryWindow(this.handle, 2);
        while (hwndChild != 0) {
            ++count;
            hwndChild = OS.WinQueryWindow(hwndChild, 0);
        }
        return count;
    }

    public Layout getLayout() {
        this.checkWidget();
        return this.layout;
    }

    public Control[] getTabList() {
        this.checkWidget();
        Control[] tabList = this._getTabList();
        if (tabList == null) {
            int count = 0;
            Control[] list = this._getChildren();
            int i = 0;
            while (i < list.length) {
                if (list[i].isTabGroup()) {
                    ++count;
                }
                ++i;
            }
            tabList = new Control[count];
            int index = 0;
            int i2 = 0;
            while (i2 < list.length) {
                if (list[i2].isTabGroup()) {
                    tabList[index++] = list[i2];
                }
                ++i2;
            }
        }
        return tabList;
    }

    public void layout() {
        this.checkWidget();
        this.layout(true);
    }

    public void layout(boolean changed) {
        this.checkWidget();
        if (this.layout == null) {
            return;
        }
        int count = this.getChildrenCount();
        if (count == 0) {
            return;
        }
        if (count > 1 && this.pswp == 0) {
            Control.beginDeferWindowPos(this, count);
        }
        this.layout.layout(this, changed);
        if (this.pswp != 0) {
            Control.endDeferWindowPos(this);
        }
    }

    Point minimumSize() {
        Control[] children = this._getChildren();
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < children.length) {
            Rectangle rect = children[i].getBounds();
            width = Math.max(width, rect.x + rect.width);
            height = Math.max(height, rect.y + rect.height);
            ++i;
        }
        return new Point(width, height);
    }

    void releaseChildren() {
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (!child.isDisposed()) {
                child.releaseWidget();
                child.releaseHandle();
            }
            ++i;
        }
    }

    void releaseWidget() {
        if (this.pswp != 0) {
            Control.endDeferWindowPos(this);
        }
        this.releaseChildren();
        super.releaseWidget();
        this.layout = null;
        this.tabList = null;
    }

    public boolean setFocus() {
        this.checkWidget();
        if ((this.style & 0x80000) != 0) {
            return false;
        }
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (child.setRadioFocus()) {
                return true;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < children.length) {
            Control child = children[i2];
            if (child.setFocus()) {
                return true;
            }
            ++i2;
        }
        return super.setFocus();
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
        this.layout = layout;
    }

    public void setTabList(Control[] tabList) {
        this.checkWidget();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                Control control = tabList[i];
                if (control == null) {
                    this.error(5);
                }
                if (control.isDisposed()) {
                    this.error(5);
                }
                if (control.parent != this) {
                    this.error(32);
                }
                ++i;
            }
            Control[] newList = new Control[tabList.length];
            System.arraycopy(tabList, 0, newList, 0, tabList.length);
            tabList = newList;
        }
        this.tabList = tabList;
    }

    boolean setTabGroupFocus() {
        if (this.isTabItem()) {
            return this.setTabItemFocus();
        }
        if ((this.style & 0x80000) == 0) {
            boolean takeFocus = true;
            if ((this.state & 0x1000) != 0) {
                boolean bl = takeFocus = this.hooks(1) || this.hooks(2);
            }
            if (takeFocus && this.setTabItemFocus()) {
                return true;
            }
        }
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (child.isTabItem() && child.setRadioFocus()) {
                return true;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < children.length) {
            Control child = children[i2];
            if (child.isTabItem() && child.setTabItemFocus()) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    boolean setTabItemFocus() {
        if ((this.style & 0x80000) == 0) {
            boolean takeFocus = true;
            if ((this.state & 0x1000) != 0) {
                boolean bl = takeFocus = this.hooks(1) || this.hooks(2);
            }
            if (takeFocus) {
                if (!this.isShowing()) {
                    return false;
                }
                if (this.forceFocus()) {
                    return true;
                }
            }
        }
        return super.setTabItemFocus();
    }

    boolean translateMnemonic(char key) {
        if (super.translateMnemonic(key)) {
            return true;
        }
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (child.translateMnemonic(key)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    int widgetStyle() {
        return super.widgetStyle();
    }

    MRESULT WM_CALCVALIDRECTS(int mp1, int mp2) {
        int result = this.callWindowProc(9, mp1, mp2);
        if ((this.state & 0x1000) != 0 && (this.style & 0x100000) == 0 && this.hooks(9)) {
            OS.WinInvalidateRect(this.handle, null, false);
        }
        return new MRESULT(result);
    }

    MRESULT WM_ERASEBACKGROUND(int mp1, int mp2) {
        if ((this.state & 0x1000) != 0) {
            return super.WM_ERASEBACKGROUND(mp1, mp2);
        }
        RECTL rcl = new RECTL();
        OS.objcpy(rcl, mp2);
        this.drawBackground(mp1, rcl);
        return MRESULT.FALSE;
    }

    MRESULT WM_QUERYDLGCODE(int mp1, int mp2) {
        MRESULT result = super.WM_QUERYDLGCODE(mp1, mp2);
        if (result != null) {
            return result;
        }
        if ((this.state & 0x1000) != 0) {
            if ((this.style & 0x80000) != 0) {
                return new MRESULT(8);
            }
            if (this.hooks(1) || this.hooks(2)) {
                int flags = 1024;
                return new MRESULT(flags);
            }
            int count = this.getChildrenCount();
            if (count != 0) {
                return new MRESULT(8);
            }
        }
        return result;
    }

    MRESULT WM_PAINT(int mp1, int mp2) {
        if ((this.state & 0x1000) == 0) {
            return super.WM_PAINT(mp1, mp2);
        }
        GCData data = new GCData();
        if (this.hps == 0) {
            this.hps = this.internal_new_GC(data);
            if (this.hps == 0) {
                SWT.error(2);
            }
            data.doInit = true;
        }
        int[] rgnRects = null;
        boolean isComplex = false;
        boolean exposeRegion = false;
        if ((this.style & 0x200000) != 0) {
            int hrgn = OS.GpiCreateRegion(this.hps, 0, null);
            boolean bl = isComplex = OS.WinQueryUpdateRegion(this.handle, hrgn) == 3;
            if (isComplex) {
                RGNRECT rgnctl = new RGNRECT();
                rgnctl.ircStart = 1;
                rgnctl.ulDirection = 1;
                exposeRegion = OS.GpiQueryRegionRects(this.hps, hrgn, null, rgnctl, null);
                if (exposeRegion) {
                    rgnRects = new int[rgnctl.crcReturned * 4];
                    rgnctl.crc = rgnctl.crcReturned;
                    exposeRegion = OS.GpiQueryRegionRects(this.hps, hrgn, null, rgnctl, rgnRects);
                }
            }
            OS.GpiDestroyRegion(this.hps, hrgn);
        }
        int oldBits = 0;
        oldBits = OS.WinQueryWindowULong(this.handle, -2);
        int newBits = oldBits | 0x10000000 | 0x20000000;
        OS.WinSetWindowULong(this.handle, -2, newBits);
        data.rcl = new RECTL();
        data.hps = this.hps;
        GC gc = GC.pm_new(this, data);
        int height = this.getHeight();
        if ((this.style & 0x100000) == 0 || data.rcl.xRight != data.rcl.xLeft || data.rcl.yTop != data.rcl.yBottom) {
            Event event = new Event();
            event.gc = gc;
            if (isComplex && exposeRegion) {
                RECTL rcl = new RECTL();
                int[] hrgnClip = new int[]{0};
                int nCount = rgnRects.length / 4;
                int i = 0;
                while (i < nCount) {
                    if (i > 0) {
                        OS.GpiSetClipRegion(this.hps, 0, hrgnClip);
                    }
                    rcl.xLeft = rgnRects[i << 2];
                    rcl.yBottom = rgnRects[(i << 2) + 1];
                    rcl.xRight = rgnRects[(i << 2) + 2];
                    rcl.yTop = rgnRects[(i << 2) + 3];
                    this.drawBackground(0, rcl);
                    event.x = rcl.xLeft;
                    event.y = height - rcl.yTop;
                    event.width = rcl.xRight - rcl.xLeft;
                    event.height = rcl.yTop - rcl.yBottom;
                    event.count = nCount - 1 - i;
                    if (hrgnClip[0] != 0) {
                        OS.GpiSetClipRegion(this.hps, hrgnClip[0], hrgnClip);
                    }
                    this.sendEvent(9, event);
                    if (!this.isDisposed()) {
                        ++i;
                        continue;
                    }
                    break;
                }
            } else {
                this.drawBackground(0, data.rcl);
                event.x = data.rcl.xLeft;
                event.y = height - data.rcl.yTop;
                event.width = data.rcl.xRight - data.rcl.xLeft;
                event.height = data.rcl.yTop - data.rcl.yBottom;
                this.sendEvent(9, event);
            }
            event.gc = null;
        }
        gc.dispose();
        if (!this.isDisposed()) {
            OS.WinSetWindowULong(this.handle, -2, oldBits);
        }
        return MRESULT.ZERO;
    }

    MRESULT WM_SIZE(int mp1, int mp2) {
        int count;
        if (this.pswp == 0 && (count = this.getChildrenCount()) > 1) {
            Control.beginDeferWindowPos(this, count);
        }
        if (this.layout != null) {
            this.layout.layout(this, false);
        }
        MRESULT result = super.WM_SIZE(mp1, mp2);
        if (this.isDisposed()) {
            return result;
        }
        if (this.pswp != 0) {
            Control.endDeferWindowPos(this);
        }
        return result;
    }
}

