/* Samba build script for OS/2 and OS/2-based systems
 *                        
 * version history
 * version 0.1.0 from 09.04.2010 Herwig
 *   - first edition
 *
 * version 0.2.2 from 08.09.2009 Herwig
 *   - a lot enhancements
 *
 * version 0.3.0 from 17.08.2010 Silvan
 *   - reodne a lot
 *
 * version 0.3.1 from 20.08.2010 Silvan
 *   - added version.ecs check
 *
 * version 0.3.2 from 08.07.2011 Silvan
 *   - pythonhome may be not set
 *
 * version 0.3.3 from 05.11.2011 Herwig
 *   - add support for libc064
 *
 * version 0.3.4 from 23.11.2011 Herwig
 *   - simplify libc switching
 *
 * version 0.3.5 from 23.11.2011 Herwig 
 *   - brand before configure, in case version.h is missing
 *
 * version 0.3.6 from 06.04.2012 Herwig
 *   - support parallel jobs
 *   - show build time upon completion
 *
 * version 0.3.7 from 23.04.2012 Silvan
 *   - compile and link flags need to be set here [happy birthday Jason]
 *
 * version 0.3.8 from 09.11.2012 Silvan
 *   - eliminated the 2nd brand function
 *
 * version 0.3.9 from 12.11.2012 Silvan
 *   - never use ksh, now using sh
 *
 * version 0.3.10 from 15.11.2012 Silvan
 *   - python also in unixroot
 *
 * version 0.3.11 from 15.11.2012 Herwig
 *   - make libc switching really optional
 *
 * version 0.3.12 from 30.11.2012 Silvan
 *   - added maintained by
 *
 * version 0.3.13 from 15.08.2013 Herwig
 *   - create build_anomalies.log
 *   - codepages to ZIP
 *   - libc065 switching
 *
 * version 1.0.0 from 06.11.2013 Silvan
 *   - conf has to create version.h also
 *   - don't check for env anymore, use sh only
 *
 * version 1.0.1 from 13.01.2014 Silvan
 *   - always brand when svn rev changes
 *
 * version 1.0.2 from 18.02.2014 Silvan
 *   - create xqs files for exceptq
 *
 * version 1.0.3 from 13.05.2014 Silvan
 *   - adjust python include
 *
 * version 1.0.4 from 11.06.2014 Silvan
 *   - remove the need of a config.site file
 *
 * version 1.0.5 from 13.03.2015 Silvan
 *   - ticket #249 thx Andy Willis
 *
 * version 1.1.0 from 24.03.2016 Silvan
 *   - remove libc switching
 *   - generate configure via autogen.sh
 *   - cups env is not needed anymore, as available as rpm
 *   - python env removed, as available as rpm
 *   - added lxlite and emxomfstripe
 *   - rename some variables eCS vs OS/2
*/

                                         
/* load the sysfuncs if not already loaded */
if (RxFuncQuery('SysLoadFuncs') = 1) then do
    call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
    call SysLoadFuncs
end

/* init the version string (don't forget to change) */
version      = "1.1.0"
version_date = "24.03.2016"

'@echo off'
parse upper arg cmdline
ok = time('R')

say "Samba for OS/2 and OS/2-based systems build script v"   || version || " from " || version_date

/* No parameter or HELP -> display usage */
if pos("HELP", cmdline) > 0 | cmdline = "" then do
    say
    say "Valid commands are:"
    say "      HELP  - this page"
    say "      CONF  - run configure"
    say "      CLEAN - clean up and recompile everything"
    say "      BRAND - create a branded build"
    say "      MAKE  - just compile changed files"
    say "      CLUT  - build command line utilities only"
    say "      WPI   - create WPI archive"
    say "      ZIP   - create ZIP archive"
    say "      ALL   - do just everything"
    say 
    exit 255
end

/* defaults */
make  = ""
jobs  = "2"  /* number of make jobs to execute at the same time */
brand = "No"
conf  = ""
verstring = 'x.x.x-3.x.x.xxx-OS2-'date('S')  /* for packaging if branding is disabled */
newVersion = "VERSION.OUT"

logFile   = 'build.log'
options   = 'build.options'
scriptfile = 'build_script'

/* Read profile */
say "Reading profile..."
do while lines(options) <> 0
    opt_line = translate(linein(options))
    interpret opt_line
    call charout , opt_line' '
end
say
ok = stream(options,'c','close')

/* Evaluate command line parameters */

build_parms = ""

if pos("MAKE", cmdline) > 0 then do
    make = "MAKE"
    build_parms = build_parms||' 'make
end

if pos("CLEAN", cmdline) > 0 then do
    make = "CLEAN"
    build_parms = build_parms||' 'make
end

if pos("BRAND", cmdline) > 0 then do
    brand = "YES"
    build_parms = build_parms||' BRAND'    
end
if pos("CONF", cmdline) > 0 then do
    conf = "YES"
    build_parms = build_parms||' CONF'    
end

/* test to see, if we need to brand */
call NeedBranding

say "Building with: " || build_parms
say
ok = SysFileTree(".\include\version.h",versionh.,'FO')

if (versionh.0 = 0) | (conf = "YES") | (brand = "YES") then do
    call brand revision
end

/* start working */
if conf = "YES" then do
    address cmd 'SETLOCAL'

/* we need to recreate the script file, so delete it first */
    ok = SysFileDelete(scriptFile);

/* recreate configure first */
    call lineout scriptfile, "autogen.sh --version-file " || newVersion;

/* set the compile, link and pathflags flags */
    call SetCLFlags

/* run configure */
    call lineout scriptfile, "./configure --enable-pie=no --prefix=/samba --disable-shared --with-acl-support"
    ok = stream(scriptFile, 'c', 'close');
    address cmd 'sh ' || scriptfile || ' 2>&1 | tee configure.log'
    address cmd 'ENDLOCAL'
end

if make = "CLEAN" then do
    call XQSPart "del" 
    address cmd "make clean"
end

if make <> "" then do
    address cmd 'make -j 'jobs' 2>&1 | tee 'logFile
    call XQSPart "crt"
end

if pos("ZIP", cmdline) > 0 then do

    zipName = "samba-"translate(verstring, '-',' ')
    say 'Creating "'zipName'.zip"'
    ok = SysFileDelete(zipName'.zip')
    ok = SysFileDelete(zipName'_xqs.zip')

    'cd .\bin'
    'md .\samba'
    'cd .\samba'
    'move ..\*.exe >NUL'
    'move ..\*.dll >NUL'
    'md .\codepage'
    'copy ..\..\..\codepages\*.dat .\codepage\*'
    'cd ..'
    'zip -rpo9 'zipName'.zip .\samba\*.exe .\samba\*.dll .\samba\codepage\*.dat'
    'cd .\samba'
    'move * .. >NUL'
    'del .\codepage\*.dat'
    'rd .\codepage'
    'cd ..'
    'rd .\samba'
    'zip -rpo9 'zipName'_xqs.zip *.xqs'
    'cd ..'
    say 'Created ZIP package'
end

/* Recreate build_anomalies.log */
anomalylog = "build_anomalies.log"
ok = SysFileDelete(anomalylog)
do until lines(logFile) = 0
    buildlogline = linein(logFile)
    select
        when left(buildlogline,11) = "Generating " then iterate
        when left(buildlogline,10) = "Compiling " then iterate
        when left(buildlogline,9)  = "Building " then iterate
        when left(buildlogline,8)  = "Linking " then iterate
        when left(buildlogline,6)  = "Using " then iterate
        when left(buildlogline,6)  = "      " then iterate
        otherwise call lineout anomalylog, buildlogline
    end
end

/* Default exit point */
reqtime = format(time('E'),,0)
reqmin = reqtime%60
reqsec = reqtime//60
say "All done, took "format(reqmin,,0)' min 'format(reqsec,,0)" sec."
ok = stream(logfile,'c','open')
ok = stream(logfile,'c','seek <0')
call lineout logFile, "All done, took "format(reqmin,,0)' min 'format(reqsec,,0)" sec."
ok = stream(logfile,'c','close')
exit 0

brand: procedure expose verstring newVersion
    parse arg revision

    /* OS/2 and OS/2-based systems version file */
    VerFile = "VERSION.OS2"
    maintainedBy = "unknown"

    /* is the file available */
    ok = stream(VerFile, 'c', 'QUERY EXISTS')
    if ok = "" then do
        say "Please create a " || VerFile || " based on VERSION.OS2_"
        exit 0
    end

    /* Samba Version file */
    Version = "VERSION"
    ok = SysFileDelete(newVersion)

    OS2Ver.0 = 0
    I = 0
    do until lines(VerFile) = 0
        I = I + 1
        OS2Ver.I = linein(VerFile)
        if left(OS2Ver.I,28) = "SAMBA_VERSION_VENDOR_SUFFIX=" then do
            parse var OS2Ver.I . '='vendor_suffix
            vendor_suffix = strip(vendor_suffix,,'"')
            parse var vendor_suffix vendor suffix
        end
        if left(OS2Ver.I,14) = "MAINTAINED_BY=" then do
            parse var OS2Ver.I . '='maintainedBy
            maintainedBy = '"Maintained by: ' || strip(maintainedBy,,'"') || '"'
        end
    end
    ok = stream(VerFile, 'c', 'close')
    if Revision <> "" then do
        I = I + 1
        OS2Ver.I = "SAMBA_VERSION_VENDOR_PATCH="revision
    end
    OS2Ver.0 = I

    do until lines(VERSION) = 0
        verline = linein(VERSION)
        if left(Verline,20) = "SAMBA_VERSION_MAJOR=" then do
            parse var verline . '='Major
        end
        if left(Verline,20) = "SAMBA_VERSION_MINOR=" then do
            parse var verline . '='Minor
        end
        if left(Verline,22) = "SAMBA_VERSION_RELEASE=" then do
            parse var verline . '='release
        end
        
        do I = 1 to OS2Ver.0
            parse var OS2Ver.I tag'='strvalue
            parse var verline stag'=' .
            if stag = tag then do
                verline = tag'='strvalue
            end
        end
        if Verline <> "=" then call lineout newVersion, verline
    end
    if maintainedBy <> "" then call lineout newVersion, "MAINTAINED_BY="maintainedBy

    ok = stream(Version,'c','close')
    ok = stream(newVersion,'c','close')
    address cmd "sh ./script/mkversion.sh "newVersion" >NUL"
    verstring = suffix'-'Major'.'minor'.'release'.'revision'-'vendor'-'date('S')
    say 'Samba branded as: '
    say '"'verstring'"'
    say maintainedBy
    say
    return


/**
 * set the compile, link and path flags
 */
SetCLFlags: procedure expose scriptfile

    call lineout scriptfile, "CFLAGS='-O2 -g -march=pentium'";
    call lineout scriptfile, "export CFLAGS";
    call lineout scriptfile, "CXXFLAGS='-O2 -g -march=pentium'";
    call lineout scriptfile, "export CXXFLAGS";
    call lineout scriptfile, "LDFLAGS=' -Zhigh-mem -Zomf -Zargs-wild -Zargs-resp -Zbin-files'";
    call lineout scriptfile, "export LDFLAGS";
    return

/**
 * see if we need to brand again
 */
NeedBranding: procedure expose revision brand build_parms
    svninfo = "svninfo"
    svninfo_tmp = "svninfo_tmp"
    address cmd 'svn info | grep "^Revision:" | sed -e "s/Revision: *//">'svninfo_tmp
    revision = strip(translate(linein(svninfo_tmp)))
    ok = stream(svninfo_tmp,'c','close')
    revision_old = strip(translate(linein(svninfo)))
    ok = stream(svninfo,'c','close')
    if revision_old \= revision then do
        if brand \= "YES" then do
            build_parms = build_parms ||' BRAND'
            brand = "YES"
        end
        ok = SysFileDelete(svninfo)
        'ren ' || svninfo_tmp || ' ' || svninfo
    end
    else do
        ok = SysFileDelete(svninfo_tmp)
    end

    return

/**
 * delete or create the xqs files
 */
XQSPart: procedure
    parse arg what

    binDir = 'bin'
    what = translate(what)

    if what = 'DEL' then do
       say "Delete all xqs files in " || binDir
       ending = '*.xqs'
    end

    if what = 'CRT' then do
       say "Create dbg files for all exe files in " || binDir
       ending = '*.exe'
    end

    ok = SysFileTree(binDir || '\' || ending,files.,"FO")
    do i = 1 to files.0

       if what = 'DEL' then do
          ok = SysFileDelete(files.i)
       end
       if what = 'CRT' then do
          address cmd "emxomfstripe -D " || substr(files.i, 1, length(files.i)-3) || "dbg " || files.i
          address cmd "lxlite /ml1 /mf2 /ydd /yxd /b- " || files.i
       end

    end

    return
