/* Samba build script for eCS (OS/2) */

/* version history */
/* version 0.1.0 from 09.04.2010 Herwig (first edition) */
/* version 0.2.2 from 08.09.2009 Herwig (a lot enhancements) */
/* version 0.3.0 from 17.08.2010 Silvan (redone a lot) */
/* version 0.3.1 from 20.08.2010 Silvan (added version.ecs check) */
/* version 0.3.2 from 08.07.2011 Silvan (pythonhome may be not set) */
/* version 0.3.3 from 05.11.2011 Herwig (add support for libc064) */
/* version 0.3.4 from 23.11.2011 Herwig (simplify libc switching) */
/* version 0.3.5 from 23.11.2011 Herwig (brand before configure, in case
                                         version.h is missing) */
/* version 0.3.6 from 06.04.2012 Herwig (support parallel jobs, show build 
                                         time upon completion) */
/* version 0.3.7 from 23.04.2012 Silvan (compile and link flags need to be
                                         set here [happy birthday Jason]) */
/* version 0.3.8 from 09.11.2012 Silvan (eliminated the 2nd brand function) */
/* version 0.3.9 from 12.11.2012 Silvan (never use ksh, now using sh) */
/* version 0.3.10 from 15.11.2012 Silvan (python also in unixroot) */
/* version 0.3.11 from 15.11.2012 Herwig (make libc switching really optional) */
/* version 0.3.12 from 30.11.2012 Silvan (maintained by) */
/* version 0.3.13 from 15.08.2013 Herwig (create build_anomalies.log, codepages 
                                          to ZIP, libc065 switching) */
                                         
/* load the sysfuncs if not already loaded */
if (RxFuncQuery('SysLoadFuncs') = 1) then
do
    call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs';
    call SysLoadFuncs;
end

/* init the version string (don't forget to change) */
version = "0.3.13"
version_date = "15.08.2013"

'@echo off'
parse upper arg cmdline
ok = time('R')

say "Samba for eCS (OS/2) build script v"   || version || " from " || version_date

/* No parameter or HELP -> display usage */
if pos("HELP", cmdline) > 0 | cmdline = "" then do
    say
    say "Valid commands are:"
    say "      HELP  - this page"
    say "      CONF  - run configure"
    say "      CLEAN - clean up and recompile everything"
    say "      BRAND - create a branded build"
    say "      MAKE  - just compile changed files"
    say "      CLUT  - build command line utilities only"
    say "      WPI   - create WPI archive"
    say "      ZIP   - create ZIP archive"
    say "      ALL   - do just everything"
    say "Deprecated options:"
    say "      065   - link against libc065.dll (default)"
    say "      064   - link against libc064.dll"
    say "      064x  - link against libc064x.dll"
    say "      063   - link against libc063.dll"
    say 
    exit 255
end

if value('MOZENV',,'OS2ENVIRONMENT') = '' then do
   say "Please set GCC environment properly!"
   exit 254
end

logFile   = 'build.log'
options   = 'build.options'
cacheFile = 'build.cache'

/* defaults */
make  = ""
jobs  = "2"  /* number of make jobs to execute at the same time */
brand = "No"
conf  = ""
verstring = 'x.x.x-3.x.x.xxx-eCS-'date('S')  /* for packaging if branding is disabled */

/* Read profile */
say "Reading profile..."
do while lines(options) <> 0
    opt_line = translate(linein(options))
    interpret opt_line
    call charout , opt_line' '
end
say
ok = stream(options,'c','close')

/* Evaluate command line parameters */

build_parms = ""

/* delete the following 8 lines to remove libc switching capability */
select 
    when pos("065", cmdline) > 0 then libc = "065"
    when pos("064", cmdline) > 0 then libc = "064"
    when pos("064X",cmdline) > 0 then libc = "064X"
    when pos("063", cmdline) > 0 then libc = "063"
    otherwise libc = ""
end
if libc <> "" then address cmd "call "libc".cmd"

if pos("MAKE", cmdline) > 0 then do
    make = "MAKE"
    build_parms = build_parms||' 'make
end

if pos("CLEAN", cmdline) > 0 then do
    make = "CLEAN"
    build_parms = build_parms||' 'make
end

if pos("BRAND", cmdline) > 0 then do
    Brand = "YES"
    build_parms = build_parms||' brand'    
end
if pos("CONF", cmdline) > 0 then do
    Conf = "YES"
    build_parms = build_parms||' conf'    
end

say "Building with: " || build_parms
say
ok = SysFileTree(".\include\version.h",versionh.,'FO')

if (versionh.0 = 0 & conf = "YES") | (brand = "YES") then do
    svninfo = ".\svninfo"
    address cmd 'svn status -q -u | grep "^Status against revision:" | sed -e "s/Status against revision: *//">'svninfo
    revision = strip(translate(linein(svninfo)))
    ok = stream(svninfo,'c','close')
    call brand revision
end

/* start working */
if conf = "YES" then do
    address cmd 'SETLOCAL'

/* we need to delete the cache file and redo it afterwards */
    ok = SysFileDelete(cacheFile);

/* add the compile and link flags to the cache file */
    call SetCLFlags

/* is cups env set */
    sEnvVar = EnvGet('CUPS');
    if sEnvVar <> '' then do
        call lineout cacheFile, "ac_cv_path_CUPS_CONFIG='" || sEnvVar || "'";
    end

/* is python env set */
    sEnvVar = EnvGet('PYTHONHOME');
    if sEnvVar <> '' then do
        sPythonVersion = PythonVersion(sEnvVar);
        if sPythonVersion <> '-1' then do
            call lineout cacheFile, "ac_cv_path_PYTHON_CONFIG='" || sEnvVar || "/config/" || sPythonVersion || "'";
            call lineout cacheFile, "ac_cv_path_PYTHON='" || sEnvVar || "'";
        end
    end
    else do
        sEnvVar = EnvGet('UNIXROOT');
        if sEnvVar <> '' then do
            sEnvVar = sEnvVar || '/usr'
            sPythonVersion = PythonVersion(sEnvVar|| '/lib');
            if sPythonVersion <> '-1' then do
                call lineout cacheFile, "ac_cv_path_PYTHON_CONFIG='" || sEnvVar || "/lib/" || sPythonVersion || "'";
                call lineout cacheFile, "ac_cv_path_PYTHON='" || sEnvVar || "/include'";
            end
        end
    end
    ok = stream(cacheFile, 'c', 'close');

/* run configure */
    address cmd 'sh ./configure --enable-pie=no --prefix=/samba --disable-shared --with-acl-support --cache-file=build.cache 2>&1 | tee configure.log'
    address cmd 'ENDLOCAL'
end

if make = "CLEAN" then do
    address cmd "make clean"
end

if make <> "" then do
    address cmd 'make -j 'jobs' 2>&1 | tee 'logFile
end

if pos("ZIP", cmdline) > 0 then do
    say 'Creating "samba-'translate(verstring,'-',' ')'.zip"'
    ok = SysFileDelete('samba-'translate(verstring,'-',' ')'.zip')
    'cd .\bin'
    'md .\samba'
    'cd .\samba'
    'move ..\*.exe >NUL'
    'move ..\*.dll >NUL'
    'md .\codepage'
    'copy ..\..\..\codepages\*.dat .\codepage\*'
    'cd ..'
    'zip -rpo9 samba-'translate(verstring,'-',' ')'.zip .\samba\*.exe .\samba\*.dll .\samba\codepage\*.dat'
    'cd .\samba'
    'move * .. >NUL'
    'del .\codepage\*.dat'
    'rd .\codepage'
    'cd ..'
    'rd .\samba'
    'cd ..'
    say 'Created ZIP package'
end

/* Recreate build_anomalies.log */
ok = SysFileDelete("build_anomalies.log")
do until lines(logFile) = 0
    buildlogline = linein(logFile)
    select
        when left(buildlogline,11) = "Generating " then iterate
        when left(buildlogline,10) = "Compiling " then iterate
        when left(buildlogline,9)  = "Building " then iterate
        when left(buildlogline,8)  = "Linking " then iterate
        when left(buildlogline,6)  = "Using " then iterate
        when left(buildlogline,6)  = "      " then iterate
        otherwise call lineout "build_anomalies.log", buildlogline
    end
end

/* Default exit point */
reqtime = format(time('E'),,0)
reqmin = reqtime%60
reqsec = reqtime//60
say "All done, took "format(reqmin,,0)' min 'format(reqsec,,0)" sec."
call lineout logFile, "All done, took "format(reqmin,,0)' min 'format(reqsec,,0)" sec."
exit 0

brand: procedure expose verstring
    parse arg revision

    /* eComStation Version file */
    VerFile = "VERSION.ECS"
    maintainedBy = "unknown"

    /* is the file available */
    ok = stream(VerFile, 'c', 'QUERY EXISTS')
    if ok = "" then do
        say "Please create a " || VerFile || " based on VERSION.EC_"
        exit 0
    end

    /* Samba Version file */
    Version = "VERSION"
    NewVersion = "VERSION.TMP"

    eCSVer.0 = 0
    I = 0
    do until lines(VerFile) = 0
        I = I + 1
        eCSVer.I = linein(VerFile)
        if left(eCSVer.I,28) = "SAMBA_VERSION_VENDOR_SUFFIX=" then do
            parse var eCSver.I . '='vendor_suffix
            vendor_suffix = strip(vendor_suffix,,'"')
            parse var vendor_suffix vendor suffix
        end
        if left(eCSVer.I,14) = "MAINTAINED_BY=" then do
            parse var eCSver.I . '='maintainedBy
            maintainedBy = 'Maintained by:    "' || strip(maintainedBy,,'"') || '"'
        end
    end
    ok = stream(VerFile, 'c', 'close')
    if Revision <> "" then do
        I = I + 1
        eCSVer.I = "SAMBA_VERSION_VENDOR_PATCH="revision
    end
    eCSVer.0 = I

    do until lines(VERSION) = 0
        verline = linein(VERSION)
        if left(Verline,20) = "SAMBA_VERSION_MAJOR=" then do
            parse var verline . '='Major
        end
        if left(Verline,20) = "SAMBA_VERSION_MINOR=" then do
            parse var verline . '='Minor
        end
        if left(Verline,22) = "SAMBA_VERSION_RELEASE=" then do
            parse var verline . '='release
        end
        
        do I = 1 to eCSVer.0
            parse var eCSVer.I tag'='strvalue
            parse var verline stag'=' .
            if stag = tag then do
                verline = tag'='strvalue
            end
        end
        if Verline <> "=" then call lineout NewVersion, verline
    end
    if maintainedBy <> "" then call lineout NewVersion, "MAINTAINED_BY="maintainedBy

    ok = stream(Version,'c','close')
    ok = stream(NewVersion,'c','close')
    address cmd "ksh ./script/mkversion.sh "NewVersion" >NUL"
    ok = SysFileDelete(NewVersion)
    verstring = suffix'-'Major'.'minor'.'release'.'revision'-'vendor'-'date('S')
    say 'Samba branded as: "'verstring'"'
    say maintainedBy
    say
return


/**
 * Gets the value of sEnvVar.
 */
EnvGet: procedure
    parse arg sEnvVar
    if ((translate(sEnvVar) = 'BEGINLIBPATH') | (translate(sEnvVar) = 'ENDLIBPATH')) then
        return SysQueryExtLibPath(substr(sEnvVar, 1, 1));
return value(sEnvVar,, 'OS2ENVIRONMENT');

/**
 * try to find the pythonversion
 */
PythonVersion: procedure
    parse arg pdir

    ok = SysFileTree(pdir||"\python*.dll",pydll.,"FO")
    rc = -1
    if pydll.0 = 1 then do
        dllpur = filespec("N",pydll.1)
        parse var dllpur 'python' ver '.dll'
        if datatype(ver) <> "NUM" then do
            say "no valid python dll found!"
        end
        else do
            major = left(ver,1)
            minor = substr(ver,2,)
            verstring = "python"||major||"."||minor
            rc = verstring
        end
    end
    else do
        say "no dll found!"
    end
return rc

/**
 * set the compile and link flags
 */
SetCLFlags: procedure expose cacheFile

    call lineout cacheFile, "CFLAGS='-D__EMX__ -DOS2  -D__OS2__ -D__ST_MT_ERRNO__ -O2 -march=pentium -mtune=pentium4'";
    call lineout cacheFile, "CXXFLAGS='-D__EMX__ -DOS2 -D__OS2__ -D__ST_MT_ERRNO__ -O2 -march=pentium -mtune=pentium4'";
    call lineout cacheFile, "LDFLAGS='-Zmap -Zargs-wild -Zbin-files -Zhigh-mem -D__ST_MT_ERRNO__ -s'";
/*  address cmd 'SET AR=emxomfar'
    address cmd 'SET LIBS=-lsocket -lsyslog' */
    return
