#ifndef _SMBWRP_H
#define _SMBWRP_H

#if !defined (O_RDONLY)
#define O_ACCMODE       0x03    /* mask */
#define O_RDONLY        0x00
#define O_WRONLY        0x01
#define O_RDWR          0x02
#define O_NONBLOCK      0x04
#define O_APPEND        0x08
#define O_TEXT          0x10

#define O_BINARY        0x0100
#define O_CREAT         0x0200
#define O_TRUNC         0x0400
#define O_EXCL          0x0800
#define O_SYNC          0x2000
#define O_NOCTTY        0x4000
#define O_SIZE          0x8000
#endif

#if !defined (DENY_NONE)
/* deny modes */
#define DENY_DOS 0
#define DENY_ALL 1
#define DENY_WRITE 2
#define DENY_READ 3
#define DENY_NONE 4
#define DENY_FCB 7
#endif


/* these define the attribute byte as seen by DOS */
#ifndef aRONLY
#define aRONLY (1L<<0)		/* 0x01 */
#define aHIDDEN (1L<<1)		/* 0x02 */
#define aSYSTEM (1L<<2)		/* 0x04 */
#define aVOLID (1L<<3)		/* 0x08 */
#define aDIR (1L<<4)		/* 0x10 */
#define aARCH (1L<<5)		/* 0x20 */
#endif

#pragma pack(1)

#ifdef CLI_BUFFER_SIZE
typedef	struct cli_state cli_state;
#else
typedef	unsigned long cli_state;
#endif

#define CAP_NOPATHINFO2 0x01000000

typedef struct smbwrp_server 
{
	char server_name[256];
	char share_name[256];
	char workgroup[256];
	char username[256];
	char password[256];
	char master[256];
	int ifmastergroup;
	int no_pathinfo2;
} smbwrp_server;

typedef struct smbwrp_file 
{
	int fd;
	unsigned long long offset;
	int openmode;
	int openattr;
	int denymode;
	unsigned long mtime;
	char fullname[261];
	char fname[261];
} smbwrp_file;

typedef struct smbwrp_fileinfo
{
	unsigned long long size;
	unsigned long attr;
	unsigned long ctime;
	unsigned long mtime;
	unsigned long atime;
	int easize;
	char fname[261];
} smbwrp_fileinfo;

typedef struct smbwrp_fileseek
{
	int whence;
	long offset;
	unsigned long result;
} smbwrp_fileseek;


typedef struct filelist_state
{
	unsigned long pipe;
	char * data;
	int datalen;
	int bufferlen;
	void (_System * add_dir_entry)(void * st);
	char mask[261];
	smbwrp_fileinfo finfo;
} filelist_state;

#ifndef INCL_DOS
typedef struct _FSALLOCATE      /* fsalloc */
{
	unsigned long  idFileSystem;
	unsigned long  cSectorUnit;
	unsigned long  cUnit;
	unsigned long  cUnitAvail;
	unsigned short cbSector;
} FSALLOCATE;
#endif


#pragma pack()

int _System smbwrp_getclisize(void);
int _System smbwrp_init(void);
int _System smbwrp_connect(smbwrp_server * srv, cli_state * c);
void _System smbwrp_disconnect(cli_state * cli);
int _System smbwrp_open(cli_state * cli, smbwrp_file * file);
int _System smbwrp_read(cli_state * cli, smbwrp_file * file, void *buf, unsigned long count, unsigned long * result);
int _System smbwrp_write(cli_state * cli, smbwrp_file * file, void *buf, unsigned long count, unsigned long * result);
int _System smbwrp_lseek(cli_state * cli, smbwrp_file * file, int whence, long long offset);
int _System smbwrp_close(cli_state * cli, smbwrp_file * file);
int _System smbwrp_setattr(cli_state * cli, smbwrp_fileinfo *finfo);
int _System smbwrp_getattr(cli_state * cli, smbwrp_fileinfo *finfo);
int _System smbwrp_fgetattr(cli_state * cli, smbwrp_file *file, smbwrp_fileinfo *finfo);
int _System smbwrp_filelist(smbwrp_server *srv, cli_state * cli, filelist_state * state);
int _System smbwrp_rename(cli_state * cli, char *oldname, char *newname);
int _System smbwrp_chdir(cli_state * cli, char *fname);
int _System smbwrp_mkdir(cli_state * cli, char *fname);
int _System smbwrp_rmdir(cli_state * cli, char *fname);
int _System smbwrp_unlink(cli_state * cli, const char *fname);
int _System smbwrp_setfilesize(cli_state * cli, smbwrp_file * file, long long newsize);
int _System smbwrp_setea(cli_state * cli, char *fname, char * name, unsigned char * value, int size);
int _System smbwrp_fsetea(cli_state * cli, smbwrp_file *file, char * name, unsigned char * value, int size);
int _System smbwrp_listea(cli_state * cli, char *fname, void * buffer, unsigned long size);
int _System smbwrp_flistea(cli_state * cli, smbwrp_file *file, void * buffer, unsigned long size);
int _System smbwrp_dskattr(cli_state * cli, FSALLOCATE *pfsa);

#endif /* _SMBWRP_H */
