#define INCL_DOSERRORS
#define INCL_DOS
#include <os2emx.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <sys/types.h>
#include <process.h>
#include <sys/time.h>
#include "smbwrp.h"
#include "smbcd.h"

int debuglevel = 0;
HMTX logmutex = 0;
char *logfile = NULL;

char *timestring(int hires);

int debug_parse_levels(const char *params_str)
{
	return 1;
}

void dbgflush( void )
{
//	if (!logfile) fflush(stdout);
}

int debuglvl(int level)
{
	return (level <= debuglevel) ? 1 : 0;
}

int debugheader(int level, char * file, char * func, int line)
{
	int rc;
	if (level > debuglevel)
	{
		return 0;
	}
	rc = DosRequestMutexSem(logmutex, -1L);
	if (rc)
	{
		return 0;
	}
	rc = 1;
	do
	{
		FILE * f;
		struct timeval tv;
		time_t t;
		char buf[80] = {0};
		if (logfile)
		{
			f = fopen(logfile, "a");
			if (!f)
			{
				rc = 0;
				break;
			}
		}
		else
		{
			f = stdout;
		}
		gettimeofday(&tv, NULL);
		t = time(NULL);
//		strftime(buf,sizeof(buf)-1,"%Y/%m/%d %H:%M:%S", localtime((time_t *)&tv.tv_sec));
		strftime(buf,sizeof(buf)-1,"%Y/%m/%d %H:%M:%S", localtime(&t));
		fprintf(f, "%s.%d: %d %d: %s:%s(%d) :", buf, tv.tv_usec / 10000, level, _gettid(), file, func, line);
		if (logfile)
		{
			fclose(f);
		}
	}
	while (0);
	DosReleaseMutexSem(logmutex);
	return rc;
}

int debugmessage(char * fmt, ...)
{
	int rc;
	rc = DosRequestMutexSem(logmutex, -1L);
	if (rc)
	{
		return 0;
	}
	do
	{
		FILE * f;
		va_list args;
		if (logfile)
		{
			f = fopen(logfile, "a");
			if (!f)
			{
				break;
			}
		}
		else
		{
			f = stdout;
		}
		va_start(args, fmt);
		vfprintf(f, fmt, args);
		va_end(args);
		if (logfile)
		{
			fclose(f);
		}
	}
	while (0);
	DosReleaseMutexSem(logmutex);
	return 0;
}

void debuglocal(int level, char * fmt, ...)
{
	int rc;
	if (level > debuglevel)
	{
		return;
	}
	rc = DosRequestMutexSem(logmutex, -1L);
	if (rc)
	{
		return;
	}
	do
	{
		FILE * f;
		struct timeval tv;
		char buf[80] = {0};
		va_list args;
		if (logfile)
		{
			f = fopen(logfile, "a");
			if (!f)
			{
				break;
			}
		}
		else
		{
			f = stdout;
		}
		gettimeofday(&tv, NULL);
		strftime(buf,sizeof(buf)-1,"%Y/%m/%d %H:%M:%S", localtime((time_t *)&tv.tv_sec));
		fprintf(f, "%s.%d: %d %d: ", buf, tv.tv_usec / 10000, level, _gettid());
		va_start(args, fmt);
		vfprintf(f, fmt, args);
		va_end(args);
		if (logfile)
		{
			fclose(f);
		}
	}
	while (0);
	DosReleaseMutexSem(logmutex);
}

// map errno errors to API errors
int maperror(int rc)
{
	switch (rc)
	{
		case 0 : return NO_ERROR ; /* NO_ERROR */
		case 1 : return ERROR_ACCESS_DENIED ; /* EPERM -  Operation not permitted               */
		case 2 : return ERROR_FILE_NOT_FOUND ; /* ENOENT -  No such file or directory             */
		case 3 : return ERROR_PID_MISMATCH ; /* ESRCH -  No such process                       */
		case 4 : return ERROR_INTERRUPT ; /* EINTR -  Interrupted system call               */
		case 5 : return ERROR_READ_FAULT ; /* EIO -  I/O error                             */
		case 6 : return ERROR_BAD_UNIT ; /* ENXIO -  No such device or address             */
		case 7 : return ERROR_INVALID_DATA ; /* E2BIG -  Arguments or environment too big      */
		case 8 : return ERROR_BAD_EXE_FORMAT ; /* ENOEXEC -  Invalid executable file format        */
		case 9 : return ERROR_INVALID_HANDLE ; /* EBADF -  Bad file number                       */
		case 10 : return ERROR_NO_CHILD_PROCESS ; /* ECHILD -  No child processes                    */
		case 11 : return ERROR_BUSY ; /* EAGAIN -  Resource temporarily unavailable      */
		case 12 : return ERROR_NOT_ENOUGH_MEMORY ; /* ENOMEM -  Not enough memory                     */
		case 13 : return ERROR_ACCESS_DENIED ; /* EACCES -  Permission denied                     */
		case 14 : return ERROR_INVALID_ADDRESS ; /* EFAULT -  Bad address                           */
		case 15 : return ERROR_NOT_LOCKED ; /* ENOLCK -  No locks available                    */
		case 16 : return ERROR_BUSY ; /* EBUSY -  Resource busy                         */
		case 17 : return ERROR_FILE_EXISTS ; /* EEXIST -  File exists                           */
		case 18 : return ERROR_NOT_SAME_DEVICE ; /* EXDEV -  Cross-device link                     */
		case 19 : return ERROR_REM_NOT_LIST ; /* ENODEV -  No such device                        */
		case 20 : return ERROR_PATH_NOT_FOUND ; /* ENOTDIR -  Not a directory                       */
		case 21 : return ERROR_DIRECTORY ; /* EISDIR -  Is a directory                        */
		case 22 : return ERROR_INVALID_PARAMETER ; /* EINVAL -  Invalid argument                      */
		case 23 : return ERROR_TOO_MANY_OPEN_FILES ; /* ENFILE -  Too many open files in system         */
		case 24 : return ERROR_TOO_MANY_OPENS ; /* EMFILE -  Too many open files                   */
		case 25 : return ERROR_MOD_NOT_FOUND ; /* ENOTTY -  Inappropriate ioctl                   */
		case 26 : return ERROR_LOCK_VIOLATION ; /* EDEADLK -  Resource deadlock avoided             */
		case 27 : return ERROR_TRANSFER_TOO_LONG ; /* EFBIG -  File too large                        */
		case 28 : return ERROR_DISK_FULL ; /* ENOSPC -  Disk full                             */
		case 29 : return ERROR_SEEK ; /* ESPIPE -  Invalid seek                          */
		case 30 : return ERROR_WRITE_PROTECT ; /* EROFS -  Read-only file system                 */
		case 31 : return ERROR_TOO_MANY_OPEN_FILES ; /* EMLINK -  Too many links                        */
		case 32 : return ERROR_BROKEN_PIPE ; /* EPIPE -  Broken pipe                           */
		case 33 : return ERROR_INVALID_LEVEL ; /* EDOM -  Domain error                          */
		case 34 : return ERROR_FILENAME_EXCED_RANGE ; /* ERANGE -  Result too large                      */
		case 35 : return ERROR_DIR_NOT_EMPTY ; /* ENOTEMPTY -  Directory not empty                   */
		case 36 : return ERROR_BUSY_DRIVE ; /* EINPROGRESS -  Operation now in progress             */
		case 37 : return ERROR_INVALID_FUNCTION ; /* ENOSYS -  Function not implemented              */
		case 38 : return ERROR_FILENAME_EXCED_RANGE ; /* ENAMETOOLONG -  File name too long                    */
		case 39 : return ERROR_KBD_FOCUS_REQUIRED ; /* EDESTADDRREQ -  Destination address required          */
		case 40 : return ERROR_TRANSFER_TOO_LONG ; /* EMSGSIZE -  Message too long                      */
		case 48 : return ERROR_NETWORK_BUSY ; /* EADDRINUSE -  Address already in use                */
		case 49 : return ERROR_INFO_NOT_AVAIL ; /* EADDRNOTAVAIL -  Can't assigned requested address      */
		case 50 : return ERROR_NETWORK_ACCESS_DENIED ; /* ENETDOWN -  Network is down                       */
		case 51 : return ERROR_NETWORK_ACCESS_DENIED ; /* ENETUNREACH -  Network is unreachable                */
		case 52 : return ERROR_NETWORK_ACCESS_DENIED ; /* ENETRESET -  Network dropped connection on reset   */
		case 53 : return ERROR_NETWORK_ACCESS_DENIED ; /* ECONNABORTED -  Software caused connection abort      */
		case 54 : return ERROR_NETWORK_ACCESS_DENIED ; /* ECONNRESET -  Connection reset by peer              */
		case 55 : return ERROR_BUFFER_OVERFLOW ; /* ENOBUFS -  No buffer space available             */
		case 56 : return ERROR_PIPE_BUSY ; /* EISCONN -  Socket is already connected           */
		case 57 : return ERROR_PIPE_NOT_CONNECTED ; /* ENOTCONN -  Socket is not connected               */
		case 58 : return ERROR_ALREADY_SHUTDOWN ; /* ESHUTDOWN -  Can't send after socket shutdown      */
		case 60 : return ERROR_TIMEOUT ; /* ETIMEDOUT -  Connection timed out                  */
		case 61 : return ERROR_NETWORK_ACCESS_DENIED ; /* ECONNREFUSED -  Connection refused                    */
		case 63 : return ERROR_INVALID_BLOCK ; /* ENOTSOCK -  Socket operation on non-socket        */
		case 64 : return ERROR_BAD_FORMAT ; /* EHOSTDOWN -  Host is down                          */
		case 65 : return ERROR_BAD_NETPATH ; /* EHOSTUNREACH -  No route to host                      */
		case 66 : return ERROR_BUSY_DRIVE ; /* EALREADY -  Operation already in progress         */
	}
	return rc + 40000;
}

char * getlastslash(char * path)
{
	char * p;
	if (!path)
	{
		return NULL;
	}
	for (p = path + strlen(path) - 1; p >= path; p--)
	{
		if (*p == '\\' || *p == '/')
		{
			return p;
		}
	}
	return NULL;
}

void _System add_dir_entry(void * st)
{
	int rc;
	filelist_state * state = (filelist_state *)st;
	if (!state || !*(state->finfo.fname))
	{
		return;
	}
	if (!state->data)
	{
		debuglocal(0,"Malformed filelist_state!\n");
		return;
	}
	if (state->bufferlen < state->datalen + sizeof(state->finfo))
	{	
		// send this portion of buffer to client
		smb_request req = {0};
		smb_response resp = {0};
		unsigned long action;
		resp.length = state->datalen;
		resp.rc = ERROR_MORE_DATA;
		rc = DosWrite(state->pipe, &resp, sizeof(resp), &action);
		if (rc || action < sizeof(resp))
		{
			debuglocal(1,"Failed to write to pipe in add_dir_entry %d: %d %d\n", state->pipe, rc, action);
		}
		else
		{
			rc = DosRead(state->pipe, &req, sizeof(req), &action);
			if (rc || action < sizeof(req))
			{
				debuglocal(0,"Failed to read from pipe in add_dir_entry %d: %d %d\n", state->pipe, rc, action);
				return;
			}
		}
		state->datalen = 0;
	}
	memcpy(state->data + state->datalen, &state->finfo, sizeof(state->finfo));
	state->datalen += sizeof(state->finfo);
}

// rc = 0 - continue, rc = 1 - quit with response
int processrequest(HPIPE pipe, cli_state * cli, unsigned long * reconnect, smbwrp_server * srv, smb_request *req, smb_response *res)
{
	int rc = 0;
	int callrc = 0;
	char * data;
	if (!pipe || !cli || !reconnect || !srv || !req || !req->param || req->paramlen > req->length || !res)
	{
		debuglocal(0,"invalid structures\n");	
		return ERROR_INVALID_PARAMETER;
	}
	data = req->param + req->paramlen;
//	memset(res, 0, sizeof(*res));
	debuglocal(1,"Client request %d paramlen %d len %d, reconnect %d. State %08x\n",  req->request, req->paramlen, req->length, *reconnect, cli);
	if (*reconnect == 2)
	{
		debuglocal(1,"Reconnecting to last server requested\n");
		res->rc = smbwrp_connect(srv, cli);
		if (res->rc)
		{
			debuglocal(1,"Client reconnect resprc %d\n",  res->rc);
			return NO_ERROR;
		}
		*reconnect = 1;
	}
	switch (req->request)
	{
		case SMBREQ_INIT :
		{
			res->value = sizeof(smbwrp_server) << 16 | getpid();
		} break;
		case SMBREQ_INITCOMPLETE :
		{
			callrc = DosGetSharedMem(req->param, PAG_READ | PAG_WRITE);
			if (callrc)
			{
				debuglocal(0,"Cant get sharedmem of %x : %d\n", req->param, callrc);
				res->rc = callrc;
				rc = 1;
				break;
			}
		} break;
		case SMBREQ_CONNECT :
		{
			if (req->paramlen < sizeof(smbwrp_server))
			{
				debuglocal(0,"Not enough data in request %d of %d\n", req->paramlen, sizeof(smbwrp_server));
				res->rc = ERROR_INVALID_PARAMETER;
				break;
			}
			res->rc = smbwrp_connect((smbwrp_server *)req->param, cli);
			if (!res->rc)
			{
				memcpy(srv, req->param, sizeof(smbwrp_server));
				*reconnect = 1;
			}
		} break;
		case SMBREQ_DISCONNECT :
		{
			smbwrp_disconnect(cli);
		} break;
		case SMBREQ_OPEN :
		{
			if (req->paramlen < sizeof(smbwrp_file))
			{
				debuglocal(0,"Not enough data in request %d of %d\n", req->paramlen, sizeof(smbwrp_file));
				res->rc = ERROR_INVALID_PARAMETER;
				break;
			}
			callrc = smbwrp_open(cli, (smbwrp_file *)req->param);
			res->rc = maperror(callrc);
		} break;
		case SMBREQ_CLOSE :
		{
			if (req->paramlen < sizeof(smbwrp_file))
			{
				debuglocal(0,"Not enough data in request %d of %d\n", req->paramlen, sizeof(smbwrp_file));
				res->rc = ERROR_INVALID_PARAMETER;
				break;
			}
			callrc = smbwrp_close(cli, (smbwrp_file *)req->param);
			res->rc = maperror(callrc);
		} break;
		case SMBREQ_READ :
		{
			if (req->paramlen < sizeof(smbwrp_file))
			{
				debuglocal(0,"Not enough data in request %d of %d\n", req->paramlen, sizeof(smbwrp_file));
				res->rc = ERROR_INVALID_PARAMETER;
				break;
			}
			callrc = smbwrp_read(cli, (smbwrp_file *)req->param,
						data, req->length - req->paramlen, (unsigned long *)&res->value);
			res->rc = maperror(callrc);
		} break;
		case SMBREQ_WRITE :
		{
			if (req->paramlen < sizeof(smbwrp_file))
			{
				debuglocal(0,"Not enough data in request %d of %d\n", req->paramlen, sizeof(smbwrp_file));
				res->rc = ERROR_INVALID_PARAMETER;
				break;
			}
			callrc = smbwrp_write(cli, (smbwrp_file *)req->param,
						data, req->length - req->paramlen, (unsigned long *)&res->value);
			res->rc = maperror(callrc);
		} break;
		case SMBREQ_LSEEK :
		{
			if (req->paramlen < sizeof(smbwrp_file) + sizeof(int) + sizeof(long long))
			{
				debuglocal(0,"Not enough data in request %d of %d\n", req->paramlen, sizeof(smbwrp_file) + sizeof(int) + sizeof(long long));
				res->rc = ERROR_INVALID_PARAMETER;
				break;
			}
			callrc = smbwrp_lseek(cli, 
						(smbwrp_file *)req->param,
						*(int *)(req->param + sizeof(smbwrp_file)),
						*(long long *)(req->param + sizeof(smbwrp_file) + sizeof(int)));
			res->rc = maperror(callrc);
		} break;
		case SMBREQ_SETINFO :
		{
			if (req->paramlen < sizeof(smbwrp_fileinfo))
			{
				debuglocal(0,"Not enough data in request %d of %d\n", req->paramlen, sizeof(smbwrp_fileinfo));
				res->rc = ERROR_INVALID_PARAMETER;
				break;
			}
			callrc = smbwrp_setattr(cli, (smbwrp_fileinfo *)req->param);
			res->rc = maperror(callrc);
		} break;
		case SMBREQ_GETINFO :
		{
			if (req->length < sizeof(smbwrp_fileinfo))
			{
				debuglocal(0,"Not enough data in request %d of %d\n", req->length, sizeof(smbwrp_fileinfo));
				res->rc = ERROR_INVALID_PARAMETER;
				break;
			}
			callrc = smbwrp_getattr(cli, (smbwrp_fileinfo *)req->param);
			res->rc = maperror(callrc);
		} break;
		case SMBREQ_FGETINFO :
		{
			if (req->length < sizeof(smbwrp_file) + sizeof(smbwrp_fileinfo))
			{
				debuglocal(0,"Not enough data in request %d of %d\n", req->length, sizeof(smbwrp_file) + sizeof(smbwrp_fileinfo));
				res->rc = ERROR_INVALID_PARAMETER;
				break;
			}
			callrc = smbwrp_fgetattr(cli, 
						(smbwrp_file *)req->param,
						(smbwrp_fileinfo *)(req->param + sizeof(smbwrp_file)));
			res->rc = maperror(callrc);
		} break;
		case SMBREQ_FILELIST :
		{
			filelist_state state;
			char * p;
			if (req->paramlen < sizeof(smbwrp_server) + (CCHMAXPATH + 1))
			{
				debuglocal(0,"Not enough data in request %d of %d\n", req->paramlen, sizeof(smbwrp_server) + (CCHMAXPATH + 1));
				res->rc = ERROR_INVALID_PARAMETER;
				break;
			}
			state.pipe = pipe;
			state.bufferlen = req->length - req->paramlen;
			if (state.bufferlen < sizeof(state))
			{
				debuglocal(0,"Not enough buffer to hold data %d\n", state.bufferlen);
				res->rc = ERROR_BUFFER_OVERFLOW;
				break;
			}
			strncpy(state.mask, req->param + sizeof(smbwrp_server), sizeof(state.mask) - 2);
			p = getlastslash(state.mask);
			if (p)
			{
				*(p + 1) = '*';
				*(p + 2) = 0;
			} 
			else
			{
				strcpy(state.mask, "\\*");
			}
			state.data = data;
			state.datalen = 0;
			state.add_dir_entry = add_dir_entry;
			callrc = smbwrp_filelist((smbwrp_server *)req->param, cli, &state);
			res->rc = maperror(callrc);
			res->length = state.datalen;
		} break;
		case SMBREQ_RENAME :
		{
			if (req->paramlen < 2 * (CCHMAXPATH + 1))
			{
				debuglocal(0,"Not enough data in request %d of %d\n", req->paramlen, 2 * (CCHMAXPATH + 1));
				res->rc = ERROR_INVALID_PARAMETER;
				break;
			}
			callrc = smbwrp_rename(cli, req->param,
						req->param + (CCHMAXPATH + 1));
			res->rc = maperror(callrc);
		} break;
		case SMBREQ_UNLINK :
		{
			if (req->paramlen < CCHMAXPATH + 1)
			{
				debuglocal(0,"Not enough data in request %d of %d\n", req->paramlen, CCHMAXPATH + 1);
				res->rc = ERROR_INVALID_PARAMETER;
				break;
			}
			callrc = smbwrp_unlink(cli, req->param);
			res->rc = maperror(callrc);
		} break;
		case SMBREQ_MKDIR :
		{
			if (req->paramlen < CCHMAXPATH + 1)
			{
				debuglocal(0,"Not enough data in request %d of %d\n", req->paramlen, CCHMAXPATH + 1);
				res->rc = ERROR_INVALID_PARAMETER;
				break;
			}
			callrc = smbwrp_mkdir(cli, req->param);
			res->rc = maperror(callrc);
		} break;
		case SMBREQ_RMDIR :
		{
			if (req->paramlen < CCHMAXPATH + 1)
			{
				debuglocal(0,"Not enough data in request %d of %d\n", req->paramlen, CCHMAXPATH + 1);
				res->rc = ERROR_INVALID_PARAMETER;
				break;
			}
			callrc = smbwrp_rmdir(cli, req->param);
			res->rc = maperror(callrc);
		} break;
		case SMBREQ_CHDIR :
		{
			if (req->paramlen < CCHMAXPATH + 1)
			{
				debuglocal(0,"Not enough data in request %d of %d\n", req->paramlen, CCHMAXPATH + 1);
				res->rc = ERROR_INVALID_PARAMETER;
				break;
			}
			callrc = smbwrp_chdir(cli, req->param);
			res->rc = maperror(callrc);
		} break;
		case SMBREQ_NEWSIZE :
		{
			if (req->paramlen < sizeof(smbwrp_file) + sizeof(off_t))
			{
				debuglocal(0,"Not enough data in request %d of %d\n", req->length, sizeof(smbwrp_file) + sizeof(off_t));
				res->rc = ERROR_INVALID_PARAMETER;
				break;
			}
			callrc = smbwrp_setfilesize(cli, 
						(smbwrp_file *)req->param,
						*(off_t *)(req->param + sizeof(smbwrp_file)));
			res->rc = maperror(callrc);
		} break;
		case SMBREQ_SETEA :
		{
			// got FEA there
			FEALIST * pfealist;
			FEA * pfea;
			unsigned long done = sizeof(long);
			if (req->paramlen <  CCHMAXPATH + 1 + sizeof(FEALIST))
			{
				debuglocal(0,"Not enough data in request %d of %d\n", req->paramlen, CCHMAXPATH + 1 + sizeof(FEALIST));
				res->rc = ERROR_INVALID_PARAMETER;
				break;
			}
			pfealist = (FEALIST *)(req->param + CCHMAXPATH + 1);
			if (req->paramlen < CCHMAXPATH + 1 + pfealist->cbList)
			{
				debuglocal(0,"Not enough data in request %d of %d\n", req->paramlen, CCHMAXPATH + 1 + pfealist->cbList);
				res->rc = ERROR_INVALID_PARAMETER;
				break;
			}
			pfea = pfealist->list;
			while (done < pfealist->cbList)
			{
				callrc = smbwrp_setea(cli, req->param, (char *)(pfea + 1), pfea->cbValue ? (char *)(pfea + 1) + pfea->cbName + 1: NULL, pfea->cbValue);
				if (callrc)
				{
					break;
				}
				pfea = (FEA *)((char *)(pfea + 1) + pfea->cbName + 1 + pfea->cbValue);
				done += sizeof(FEA) + pfea->cbName + 1 + pfea->cbValue;
			}
			res->rc = maperror(callrc);
		} break;
		case SMBREQ_FSETEA :
		{
			// got FEA there
			FEALIST * pfealist;
			FEA * pfea;
			unsigned long done = sizeof(long);
			if (req->paramlen <  sizeof(smbwrp_file) + sizeof(FEALIST))
			{
				debuglocal(0,"Not enough data in request %d of %d\n", req->paramlen, sizeof(smbwrp_file) + sizeof(FEALIST));
				res->rc = ERROR_INVALID_PARAMETER;
				break;
			}
			pfealist = (FEALIST *)(req->param + sizeof(smbwrp_file));
			if (req->paramlen < sizeof(smbwrp_file) + pfealist->cbList)
			{
				debuglocal(0,"Not enough data in request %d of %d\n", req->paramlen, sizeof(smbwrp_file) + pfealist->cbList);
				res->rc = ERROR_INVALID_PARAMETER;
				break;
			}
			pfea = pfealist->list;
			while (done < pfealist->cbList)
			{
				callrc = smbwrp_fsetea(cli, (smbwrp_file *)req->param, (char *)(pfea + 1), pfea->cbValue ? (char *)(pfea + 1) + pfea->cbName + 1: NULL, pfea->cbValue);
				if (callrc)
				{
					break;
				}
				pfea = (FEA *)((char *)(pfea + 1) + pfea->cbName + 1 + pfea->cbValue);
				done += sizeof(FEA) + pfea->cbName + 1 + pfea->cbValue;
			}
			res->rc = maperror(callrc);
		} break;
		case SMBREQ_LISTEA :
		{
			FEALIST * pfealist;
			if (req->paramlen <  CCHMAXPATH + 1)
			{
				debuglocal(0,"Not enough data in request %d of %d\n", req->paramlen, CCHMAXPATH + 1);
				res->rc = ERROR_INVALID_PARAMETER;
				break;
			}
			pfealist = (FEALIST *)data;
			callrc = smbwrp_listea(cli, req->param, data, req->length);
			res->rc = maperror(callrc);
			if (!res->rc && pfealist->cbList > req->length)
			{
				res->rc = ERROR_BUFFER_OVERFLOW;
			}
		} break;
		case SMBREQ_FLISTEA :
		{
			FEALIST * pfealist;
			if (req->paramlen <  sizeof(smbwrp_file))
			{
				debuglocal(0,"Not enough data in request %d of %d\n", req->paramlen, sizeof(smbwrp_file));
				res->rc = ERROR_INVALID_PARAMETER;
				break;
			}
			pfealist = (FEALIST *)data;
			callrc = smbwrp_flistea(cli, (smbwrp_file *)req->param, data, req->length);
			res->rc = maperror(callrc);
			if (!res->rc && pfealist->cbList > req->length)
			{
				res->rc = ERROR_BUFFER_OVERFLOW;
			}
		} break;
		case SMBREQ_DSKATTR :
		{
			if (req->paramlen <  sizeof(FSALLOCATE))
			{
				debuglocal(0,"Not enough data in request %d of %d\n", req->paramlen, sizeof(FSALLOCATE));
				res->rc = ERROR_INVALID_PARAMETER;
				break;
			}
			callrc = smbwrp_dskattr(cli, (FSALLOCATE*)req->param);
			res->rc = maperror(callrc);
			res->length = callrc ? 0 : req->length;
		} break;
		default :
		{
			debuglocal(0,"Unknown request %d\n", req->request);
			// rc = ERROR_INVALID_FUNCTION; ??
			res->rc = ERROR_INVALID_FUNCTION;
		}
	}
	debuglocal(1,"Client request %d rc %d resprc %d resplength %d\n",  req->request, rc, res->rc, res->length);
	if (res->rc == ERROR_PIPE_NOT_CONNECTED && *reconnect == 1)
	{
		debuglocal(1,"Setting reconnect flag\n");
		*reconnect = 2;
	}
	return rc;
}

void clientthread(void * arg)
{
	HPIPE pipe;
	int rc;
	smbwrp_server srv = {0};
	smb_request req = {0};
	smb_response resp = {0};
	unsigned long reconnect = 0;
	unsigned long action;
	cli_state * cli;

	if (!arg)
	{
		debuglocal(0,"Passed null pipe pointer\n");
		return;
	}
	pipe = (HPIPE)arg;
	rc = DosAllocMem((PPVOID)&cli, smbwrp_getclisize(), PAG_COMMIT | PAG_READ | PAG_WRITE | OBJ_ANY);
	if (rc)
	{
		rc = DosAllocMem((PPVOID)&cli, smbwrp_getclisize(), PAG_COMMIT | PAG_READ | PAG_WRITE);
	}
	cli = (cli_state *)calloc(smbwrp_getclisize(), 1);
	if (rc || !cli)
	{
		debuglocal(0,"Not enough memory to initialize client structure\n");
		DosClose(pipe);
		return;
	}
	memset(cli, 0, smbwrp_getclisize());
	debuglocal(0,"opening client pipe %d\n", pipe);
	for (;;)
	{
		rc = DosRead(pipe, &req, sizeof(req), &action);
		if (rc || action < sizeof(req))
		{
			debuglocal(0,"Failed to read from pipe %d: %d %d\n", pipe, rc, action);
			break;
		}
		// rc = 0 - continue, rc = 1 - quit with response
		memset(&resp, 0, sizeof(resp));
		rc = processrequest(pipe, cli, &reconnect, &srv, &req, &resp);
		if (rc < 2)
		{
			rc = DosWrite(pipe, &resp, sizeof(resp), &action);
			if (rc || action < sizeof(resp))
			{
				debuglocal(0,"Failed to write to pipe %d: %d %d\n", pipe, rc, action);
			}
		}
		if (rc)
		{
			debuglocal(0,"shutdown client %d with rc %d\n", pipe, rc);
			break;
		}
	}
	debuglocal(0,"closing client pipe %d\n", pipe);
	DosDisConnectNPipe(pipe);
	DosClose(pipe);
	memset(cli, 0, smbwrp_getclisize());
	DosFreeMem(cli);
}

void help(void)
{
	printf("Usage: smbcd [-d/--debug <debuglevel>] [-q/--quiet] [-l/--logfile <logfile>]\n");
}

int main(int argc, char ** argv)
{
	int rc = 0, quiet = 0;
	HPIPE pipe, newpipe;
	unsigned long action;
	for (argc--, argv++; argc > 0; argc--, argv++)
	{
	 	if (strcmp(argv[0], "-d") == 0 || strcmp(argv[0], "--debug") == 0)
		{
			if (argc < 2)
			{
				rc = 1;
				printf("Parameter missing after <%s>", argv[0]);
				break;
			}
			debuglevel = atoi(argv[1]);
			if (debuglevel <= 0 || debuglevel > 10)
			{
				rc = 1;
				printf("Wrong value <%s> for parameter <%s>", argv[1], argv[0]);
				break;
			}
			if (debuglevel == 10) 
			{
				// smbcd crashed on dump_msg used to dump messages on level 10
				debuglevel--;
			}
			argc --;
			argv ++;
		} else
	 	if (strcmp(argv[0], "-l") == 0 || strcmp(argv[0], "--logfile") == 0)
		{
			FILE * test;
			if (argc < 2)
			{
				rc = 1;
				printf("Parameter missing after <%s>", argv[0]);
				break;
			}
			logfile = argv[1];
			test = fopen(argv[1], "a");
			if (test == NULL)
			{
				rc = 1;
				printf("Cant open log file <%s>\n", logfile);
				break;
			}
			fclose(test);
			argc --;
			argv ++;
		} else
	 	if (strcmp(argv[0], "-q") == 0 || strcmp(argv[0], "--quiet") == 0)
		{
			quiet = 1;
		} else
		{
			printf("Unknown parameter <%s>\n", argv[0]);
			rc = 1;
			break;
		}
	}
	if (rc)
	{
		help();
		return 1;
	}
	if (quiet)
	{
		debuglevel = -10;
	}
	rc = DosCreateMutexSem(NULL, &logmutex, 0, 0);
	if (rc)
	{
		if (!quiet) printf("DosCreateMutexSem %d\n", rc);
		return 1;
	}
	rc = smbwrp_init();
	if (rc)
	{
		debuglocal(0,"Init failed with rc %d\n", rc);
		return 1;
	}
	rc = DosOpen(PIPENAME, &pipe, &action, 0, 0, OPEN_ACTION_OPEN_IF_EXISTS | OPEN_ACTION_FAIL_IF_NEW, OPEN_SHARE_DENYNONE | OPEN_ACCESS_READWRITE, NULL);
	if (rc == NO_ERROR)
	{
		debuglocal(0,"Pipe %s already exists. May be duplicate smbcd is running\n", PIPENAME);
		DosClose(pipe);
		return 1;		
	}

	rc = DosCreateNPipe(PIPENAME, &pipe, NP_ACCESS_DUPLEX,
				NP_WAIT | NP_TYPE_MESSAGE | NP_READMODE_MESSAGE | SMBCD_MAX_THREADS,
				600, 600, 1000);
	if (rc)
	{
		debuglocal(0,"Cant create named pipe %d\n", rc);
		return 1;
	}

	debuglocal(1,"Entering main loop. My pid is %d. My mutex is %08x. My debuglevel is %d. Client state size %d\n", getpid(), logmutex, debuglevel, smbwrp_getclisize());

	for (;;)
	{
		do
		{
			rc = DosConnectNPipe(pipe);
		} while (rc == ERROR_INTERRUPT);

		if (!rc)
		{
			debuglocal(1,"New client connected %d to pipe %d\n", rc, pipe);
			int tid = _beginthread(clientthread, NULL, 655360, (void *)pipe);
			if (tid < 0)
			{
				debuglocal(0,"Failed to create client thread\n");
				rc = 0xFFFF;
			}
		}

		if (rc)
		{
			debuglocal(0,"Client failed to connect %d\n", rc);
			DosDisConnectNPipe(pipe);
			DosClose(pipe);
		}
		
		rc = DosCreateNPipe(PIPENAME, &pipe, NP_ACCESS_DUPLEX,
				NP_WAIT | NP_TYPE_MESSAGE | NP_READMODE_MESSAGE | SMBCD_MAX_THREADS,
				600, 600, 1000);
		if (rc)
		{
			debuglocal(0,"Cant create new named pipe %d\n", rc);
			break;
		}
	}

	DosDisConnectNPipe(pipe);
	DosClose(pipe);
	DosCloseMutexSem(logmutex);
	return 0;
}
