#ifndef _MY_DEBUG_
#define _MY_DEBUG_ 1

#ifdef DEBUG

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <time.h>

void log(const char *fmt, ...)
{  
	FILE * logfile = NULL;
	va_list args;
	time_t t = time(NULL);
	char timebuf[80] = {0};
	strftime(timebuf,sizeof(timebuf)-1,"%Y/%m/%d %H:%M:%S", localtime(&t));
	logfile = fopen("e:\\smblog","a");
	if (logfile == NULL)
	{
		DosBeep(400,400);
	}
	else
	{
		fprintf(logfile, "%s: ", timebuf);
		va_start(args, fmt);
		vfprintf(logfile, fmt, args);    
		va_end(args);
		fclose(logfile);
	}
}

#else

#define log;

#endif

#endif /* _MY_DEBUG_ */