#define INCL_LONGLONG
#define INCL_DOS
#define INCL_DOSPROCESS
#define INCL_DOSPROFILE
#define INCL_DOSMISC
#define INCL_DOSMODULEMGR
//_SMB_H
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <types.h>
#include <InnoTekLIBC/backend.h>
#define PRINTF_ATTRIBUTE(a1, a2) __attribute__ ((format (__printf__, a1, a2)))
#include "local.h"
#include "xfile.h"
#include "pstring.h"
#include "debug.h"

APIRET (APIENTRY * xDosPerfSysCall)(ULONG ulCommand, ULONG ulParm1, ULONG ulParm2, ULONG ulParm3) = NULL;
APIRET (APIENTRY * xDosQuerySysState)(ULONG func, ULONG arg1, ULONG pid, ULONG _res_, PVOID buf, ULONG bufsz) = NULL;
HMODULE doscalls = 0;

int os2_init(void)
{
	HMODULE dllhandle;
	int rc = 0;
	char failname[CCHMAXPATH+1];
	if (doscalls == 0) 
	{
		rc = DosLoadModule(failname, sizeof(failname), "DOSCALL1", &doscalls);
		if (rc)
		{
			DEBUG(0,("Cant load DOSCALL1: %s (%d)\n", failname, rc));
			return rc;
		}
		rc = DosQueryProcAddr(doscalls, 976, NULL, (PFN *)&xDosPerfSysCall);
		if (rc)
		{
			DEBUG(0,("Cant load xDosPerfSysCall (%d)\n", rc));
			xDosPerfSysCall = NULL;
		}
		rc = DosQueryProcAddr(doscalls, 368, NULL, (PFN *)&xDosQuerySysState);
		if (rc)
		{
			DEBUG(0,("Cant load xDosQuerySysState (%d)\n", rc));
			xDosQuerySysState = NULL;
		}
	}
	return 0;
}

int os2_ftruncate(int fd, off_t size)
{
	// We call there __libc_Back_ioFileSizeSet directly instead of 
        // ftruncate to force it not to zero expanding files to optimize
        // samba performance when copying files
	int rc = __libc_Back_ioFileSizeSet(fd, size, 0);
	if (rc < 0)
	{
		errno = -rc;
		return -1;
	}
	return 0;
}

#define   CMD_KI_RDCNT    (0x63)

typedef struct _CPUUTIL {
    ULONG ulTimeLow;            /* Low 32 bits of time stamp      */
    ULONG ulTimeHigh;           /* High 32 bits of time stamp     */
    ULONG ulIdleLow;            /* Low 32 bits of idle time       */
    ULONG ulIdleHigh;           /* High 32 bits of idle time      */
    ULONG ulBusyLow;            /* Low 32 bits of busy time       */
    ULONG ulBusyHigh;           /* High 32 bits of busy time      */
    ULONG ulIntrLow;            /* Low 32 bits of interrupt time  */
    ULONG ulIntrHigh;           /* High 32 bits of interrupt time */
} CPUUTIL;

// very simple random data gatherer derived from openssl
void os2_randget(char * buffer, int length)
{
	QWORD qwTime;
	ULONG SysVars[QSV_FOREGROUND_PROCESS];
	int done = 0;

	if (!buffer || length <= 0)
	{
		return;
	}

	DosTmrQueryTime(&qwTime);
	memcpy(buffer, &qwTime, sizeof(qwTime) > length ? length : sizeof(qwTime));
	done += sizeof(qwTime);
	if (done >= length)
	{
		return;
	}

	if (xDosPerfSysCall) 
	{
		CPUUTIL util;
		if (xDosPerfSysCall(CMD_KI_RDCNT, (ULONG)&util, 0, 0) == 0) 
		{
			memcpy(buffer + done, &util, sizeof(util) > length - done ? length - done : sizeof(util));
			done += sizeof(util);
			if (done >= length)
			{
				return;
			}
		}
	}

#if 0
	if (xDosQuerySysState) 
	{
		char *tmp = (char *)malloc(256 * 1024);
		if (tmp)
		{
			if (xDosQuerySysState(0x1F, 0, 0, 0, tmp, 256 * 1024) == 0)
			{
				memcpy(buffer + done, tmp, 256 * 1024 > length - done ? length - done : 256 * 1024);
				done += 256 * 1024;
			}
			free(tmp);
		}
	}
	if (done >= length)
	{
		return;
	}
#endif

	DosQuerySysInfo(1, QSV_FOREGROUND_PROCESS, SysVars, sizeof(SysVars));
	memcpy(buffer + done, SysVars, sizeof(SysVars) > length - done ? length - done : sizeof(SysVars));
}

#include <InnoTekLIBC/tcpip.h>
#undef close
int debug_close(char * file, char * function, int line, int h )
{
	int os2socket = -1;
	PLIBCSOCKETFH   pFHSocket = __libc_TcpipFH(h);	
	if (pFHSocket) os2socket = pFHSocket->iSocket;
	DEBUG(0,("close(%d (%d)) on %s:%s(%d)\n", h, os2socket, file, function, line));
	return close(h);
}
