#include "nversion.h"

:userdoc.

.nameit symbol=os text='eCS (OS/2)'
.nameit symbol=nd text='NetDrive for &os.'
.nameit symbol=ndcp text='NetDrive for &os. Control Panel'
.nameit symbol=mp text='mount point'
.nameit symbol=ressmb text='Samba Resource Properties'
.nameit symbol=usage text='Usage'
.nameit symbol=build text='Samba Client Plugin for &os. version <$NDPSMB_VERSION> build <$NDPSMB_BUILD>'

:title.NetDrive for &os. Control Panel Help

:docprof toc=123456.
.******************************************************
:h1.Introduction
:p.
Samba is a SMB/CIFS protocols file and print sharing server/client suite originaly
made for the UNIX world to cooperate with corresponding Windows and &os. servers or
clients. &os. has a native implementation of SMB/CIFS server/client set - IBM LAN
Manager and IBM Peer. These products haven&csq.t been updated for a long time and
have some compatibility problems with modern Windows SMB/CIFS implementations.
:p.
This package is the &os. port of Samba client made as the plugin for&colon.
:ul.
:li.&nd. - a well known virtual file system for &os.
:li.EVFS - the eComStation Virtual Filesystem for SMB
:eul.:p.
&os. Samba client provides seamless access to SMB/CIFS file shares over your network using TCP/IP as the
underlying transport protocol.
:p.
The &os. Samba client consists of one module&colon.
:ul.
:li.ndpsmb.dll - the NetDrive plugin itself
:eul.:p.
Releases prior to version 1.5.0 had a second module which is now deprecated&colon.
:ul.
:li.smbcd.exe  - the Samba client daemon, which actually processes the requests from ndpsmb.dll
:eul.
.******************************************************
:h1.License
:p.
Samba is freely available under the GNU General Public License. You can get
the full sourcecode from our SVN repository, please refer to the Samba for &os. Homepage for details about downloading the source.
:p.
The NetDrive plugin for &os. is also available with full sourcecode.
:p.
So if you are using our plugin we kindly ask you to support netlabs.org.
Please refer to the Samba for &os. Homepage to learn how you can do
that!
:h2 res=003.Links
:p.
:ul.
:li.Samba for &os. Homepage (http&colon.&slr.&slr.samba.netlabs.org)
:li.NetDrive Homepage (http&colon.&slr.&slr.www.blueprintsoftwareworks.com&slr.netdrive)
:li.Samba Homepage (http&colon.&slr.&slr.www.samba.org)
:eul.
.*******************************************************
:h1 res=1000 group=2 x=left y=top width=100% height=100% scroll=both.&ressmb.
:i1 id=ressmb.&ressmb.
:ul.
:li.:link reftype=hd res=100.&ressmb.:elink.
:li.:link reftype=hd res=101.&usage.:elink.
:eul.
:h2 res=100.&ressmb.
:p.
The parameters of a SMB/CIFS FS resource are&colon.
:parml.
:pt.Workgroup
:pd.The name of workgroup to connect to.

:pt.Server
:pd.The name or IP address of server to connect to.

:pt.Share
:pd.The name of server resource (share) to connect to.

:pt.User
:pd.The name of user to login under.

:pt.Password
:pd.The password of selected user.

:pt.Master
:pd.the name of 'master' server or workgroup, used to get the list of workgroups when the concrete workgroup and server not specified.

:pt.Mastertype
:pd.0 if 'master' is the name of master server, 1 if 'master' is the name of master workgroup.

:pt.EA Support
:pd.1 to support eCS (OS/2) Extended Attributes, 0 to not support it.

:pt.Cache timeout
:pd.The time in seconds for which the cache is valid. If the time is over the client rereads the directory again. For a directory with many
files it may be better to increase the timeout (rule of thumb: per 500-800 files 10 seconds). Default: 10 seconds

:pt.Cache listings
:pd.The amount of directories the cache should hold. Be aware the higher the value the more memory is used. Default: 32 listings

:eparml.
.******************************************************
:h2 res=101.&usage.
:p.
To mount the exact server&csq.s share one need to specify both &csq.server&csq. and
&csq.share&csq. parameters, the other parameters are optional. The root path of
server&csq.s share will be mounted to the mounting path.
:p.
If one want to access all server shares, then only the &csq.server&csq., not the &csq.share&csq.
parameter, should be specified,the other parameters are optional. The list of
server shares will be mounted to the mounting path.
:p.
If one want to access all servers within the workgroup, then only the &csq.workgroup&csq.,
not the &csq.server&csq. parameter, should be specified, the other parameters are
optional. The list of servers within the specified workgroup will be mounted to
the mounting path.
:p.
If one want to access all available workgroups within one master browser
within the network, then only the &csq.master&csq., not the &csq.workgroup&csq. nor the &csq.server&csq. parameter,
should be specified, the other parameters are optional. The list of workgroups
will be mounted to the mounting path. The &csq.master&csq. workgroup can be any known
workgroup in the net. The &csq.master&csq. server should be the master browser for
workgroup[s].
:p.
By default the &csq.guest&csq. user with blank password is used to access selected
resources. If you get access denied errors, try to specify another user and
password combination.

.******************************************************
:h1.Version
:p.
&build.
:h1.Debugging
:p.
To produce a logfile please add an empty file called ndpsmb.dbg into the root drive.
:p.
The logfile is placed to your LOGFILES env path, if available. If the LOGFILES env is missing
the logfile is placed into the &nd. directory. The logfile is called log.ndpsmb for the &nd. part and
log.smbd for the Samba part.

.******************************************************
:h1.History
:p.History of the Samba client for &nd.
:ul.
:li.:link reftype=hd res=011.Version 1.0:elink.
:li.:link reftype=hd res=012.Version 1.5:elink.
:li.:link reftype=hd res=013.Version 2.0:elink.
:li.:link reftype=hd res=014.Version 2.1:elink.
:eul.
:h2 res=011.Version 1.0
:p.
:ul.
:li.beta3
:ul.
:li.changelog created
:li.fixed a bug with several network interfaces on one system
:li.fixed a bug with broken cmd.exe builtin commands
:li.fixed a bug with wrong dates of new and modified files
:li.fixed a bunch of other bugs which are too small to remember ;)
:li.smbcd.exe compiled against old tcp/ip stack interface
:eul.
:li.beta4
:ul.
:li.fixed errors on write to eCs shares
:li.more fixes for wrong dates of files
:eul.
:li.beta5
:ul.
:li.added file locking
:li.added 64bit file IO (when working with NDFS 2.3+)
:li.moved to 3.0.9 samba code.
:eul.
:li.beta6
:ul.
:li.fixed set attribute bug introduced in beta 5
:li.implemented setnewfilesize function. It may work not on all CIFS servers.
:li.added automatic smbcd.exe starting if not started when connecting to CIFS share
:li.added 'logfile' and 'loglevel' options to ndpsmb
:eul.
:li.beta7
:ul.
:li.moved to libc06b4.dll libc.
:eul.
:li.beta8
:ul.
:li.moved back to libc custom build. 
:li.added EA support
:li.a bunch of bugs fixed
:eul.
:li.beta9
:ul.
:li.added EA support for DosOpen which was forgotten in beta8
:eul.
:li.beta10
:ul.
:li.caching of EA size after file find request
:li.moved to libc06b5.dll libc
:eul.
:li.beta11
:ul.
:li.moved to libc06r1.dll libc
:eul.
:li.beta12
:ul.
:li.NdpRsrcQueryFSAllocate rewritten
:li.moved to libc06.dll from GA2 release
:eul.
:li.beta13 (the lucky one)
:ul.
:li.moved to libc061.dll from CSD1 release
:eul.
:li.beta14
:ul.
:li.moved to libc custom build
:eul.
:li.GA
:ul.
:li.changelog was not updated
:eul.
:eul.
:h2 res=012.Version 1.5   
:ul.
:li.alpha1
:ul.
:li.smbdc.exe was implemented within ndpsmb.dll
:li.a lot of other changes
:eul.
:li.beta1
:ul.
:li.logging feature rewritten
:li.fixed free disk space
:li.added more return codes in the mount part (for evfsgui)
:eul.
:li.beta2
:ul.
:li.update to Samba 3.0.35 client code
:eul.   
:li.beta3
:ul.
:li.update to Samba 3.0.36 client code
:li.codepage fix for system running non IBM-850 codepages (Ticket #100)
:eul.
:li.beta4
:ul.
:li.update to Samba 3.0.37 client code
:li.codepage fix for Ticket #68
:eul.   
:li.1.5.0 GA
:ul.
:li.Fix memory leak in EA code
:li.Ticket #111
:li.Remove unused MEMLEN, LOGFILE and LOGLEVEL token:p.
(Compatibility warning: These tokens must also be removed from older *.ndc *.evp and volumes.cfg files in order to restore connections with the new plugin properly)
:li.added logging feature for samba messages
:eul.
:li.1.5.1
:ul.
:li.Fix crash on quadcore machines
:eul.
:li.1.5.2
:ul.
:li.Fix help files
:eul.
:li.1.5.3
:ul.
:li.Fix timestamp problem
:eul.
:eul.
:h2 res=013.Version 2.0   
:ul.
:li.2.0.0
:ul.
:li.added dir caching
:eul.
:li.beta2
:ul.
:li.read problem of small files fixed
:li.delete cache of changed files
:li.SIGPIPE crash fixed 
:eul.
:li.beta3
:ul.
:li.changed instpl.cmd to work correct with nls
:li.added the possibility to adjust cache timeout and depth via GUI
:li.adjustments to helpfile and readme
:eul.
:li.beta4
:ul.
:li.possible SIGPIPE crashes redone (thanks to Vitali)
:li.touch did not delete the cache
:eul.
:eul.
:h2 res=014.Version 2.1   
:ul.
:li.2.1.0 alpha1
:ul.
:li.moved to samba 3.3 source base
:li.new merge of 2.0 code and 1.6 code
:eul.
:eul.
.******************************************************
:h1.Credit
:ul.
:li.Paul Smedley (aka Smedles)
:li.Yuri Dario (aka Paperino)
:li.Herwig Bauernfeind (aka HerwigB)
:li.Silvan Scherrer (aka diver)
:li.Alex Taylor (aka AlexT)
:li.Nikolay Kolosov (aka nickk)
:li.Vitali Pelenyov (aka sunlover)
:li.and all we missed 
:eul.
.******************************************************

:euserdoc.
