/* Samba build script for eCS (OS/2) */

/* version history */
/* version 0.1.0 from 09.04.2010 Herwig (first edition) */
/* version 0.2.2 from 08.09.2009 Herwig (a lot enhancements) */
/* version 0.3.0 from 17.08.2010 Silvan (redone a lot) */
/* version 0.3.1 from 20.08.2010 Silvan (added version.ecs check) */

/* load the sysfuncs if not already loaded */
if (RxFuncQuery('SysLoadFuncs') = 1) then
do
    call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs';
    call SysLoadFuncs;
end

/* init the version string (don't forget to change) */
version = "0.3.1"
version_date = "20.08.2010"


'@echo off'
parse upper arg cmdline

say "Samba for eCS (OS/2) build script v"   || version || " from " || version_date


/* No parameter or HELP -> display usage */
if pos("HELP", cmdline) > 0 | cmdline = "" then do
    say
    say "Valid commands are:"
    say "      HELP  - this page"
    say "      063   - link against libc063.dll"
    say "      064x  - link against libc064x.dll"
    say "      CONF  - run configure"
    say "      CLEAN - clean up and recompile everything"
    say "      BRAND - create a branded build"
    say "      MAKE  - just compile changed files"
    say "      CLUT  - build command line utilities only"
    say "      WPI   - create WPI archive"
    say "      ZIP   - create ZIP archive"
    say "      ALL   - do just everything"
    say 
    exit 255
end

if value('MOZENV',,'OS2ENVIRONMENT') = '' then do
   say "Please set GCC environment properly!"
   exit 254
end

options = 'build.options'
cacheFile = 'build.cache'

/* defaults */
make  = ""
libc  = "064x"
brand = "No"
conf  = ""
verstring = 'x.x.x-3.x.x.xxx-eCS-'date('S')  /* for packaging if branding is disabled */

/* Read profile */
say "Reading profile..."
do while lines(options) <> 0
    opt_line = translate(linein(options))
    interpret opt_line
    call charout , opt_line' '
end
say
ok = stream(options,'c','close')

/* Evaluate command line parameters */

build_parms = ""

if pos("MAKE", cmdline) > 0 then do
    make = "MAKE"
    build_parms = build_parms||' 'make
end

if pos("CLEAN", cmdline) > 0 then do
    make = "CLEAN"
    build_parms = build_parms||' 'make
end
if pos("064X", cmdline) > 0 then do
    libc = "064X"
    build_parms = build_parms||' 'libc    
end
if pos("063", cmdline) > 0 then do
    libc = "063"
    build_parms = build_parms||' 'libc    
end
if pos("BRAND", cmdline) > 0 then do
    Brand = "YES"
    build_parms = build_parms||' brand'    
end
if pos("CONF", cmdline) > 0 then do
    Conf = "YES"
    build_parms = build_parms||' conf'    
end

/* start working */
if libc = "063" then do
    address cmd "call 063.cmd"
end
else do
    address cmd "call 064x.cmd"
end

if conf = "YES" then do
    address cmd 'SETLOCAL'
/*    address cmd 'SET CFLAGS=-g -Zomf -O1 -march=pentium -mtune=pentium4'
    address cmd 'SET CXXFLAGS=-g -Zomf -O1 -march=pentium -mtune=pentium4'
    address cmd 'SET LDFLAGS=-s -Zsym -Zmap -Zbin-files -Zomf -Zexe -Zargs-wild -Zargs-resp'
    address cmd 'SET AR=emxomfar'
    address cmd 'SET LIBS=-lsocket -lsyslog' */
    /* disabled options:
         --enable-developer --enable-socket-wrapper
     */

/* we need to delete the cache file and redo it afterwards */
    ok = SysFileDelete(cacheFile);

/* is cups env set */
        sEnvVar = EnvGet('CUPS');
    if sEnvVar <> '' then do
    call lineout cacheFile, "ac_cv_path_CUPS_CONFIG='" || sEnvVar || "'";
    end

/* is python env set */
        sEnvVar = EnvGet('PYTHONHOME');
    if sEnvVar <> '' then do
    sPythonVersion = PythonVersion(sEnvVar);
    end
    if sPythonVersion <> '-1' then do
    call lineout cacheFile, "ac_cv_path_PYTHON_CONFIG='" || sEnvVar || "/config/" || sPythonVersion || "'";
    call lineout cacheFile, "ac_cv_path_PYTHON='" || sEnvVar || "'";
    end

    ok = stream(cacheFile, 'c', 'close');

/* run configure */
    address cmd 'ksh ./configure --enable-pie=no --prefix=/samba --disable-shared --with-acl-support --cache-file=build.cache 2>&1 | tee configure.log'
    address cmd 'ENDLOCAL'
end

if make = "CLEAN" then do
    address cmd "make clean"
end
       
if brand = "YES" then do
    svninfo = ".\svninfo"
    address cmd 'svn status -q -u | grep "^Status against revision:" | sed -e "s/Status against revision: *//">'svninfo
    revision = strip(translate(linein(svninfo)))
    ok = stream(svninfo,'c','close')
    call brand revision
end

if make <> "" then do
    say build_parms
    address cmd 'make 2>&1 | tee build.log'
end    

if pos("ZIP", cmdline) > 0 then do
    say 'Creating "samba-'translate(verstring,'-',' ')'.zip"'
    ok = SysFileDelete('samba-'translate(verstring,'-',' ')'.zip')
    'cd .\bin'
    'md .\samba'
    'cd .\samba'
    'move ..\*.exe >NUL'
    'move ..\*.dll >NUL'
    'cd ..'
    'zip -rpo9 samba-'translate(verstring,'-',' ')'.zip .\samba\*.exe .\samba\*.dll'
    'cd .\samba'
    'move * .. >NUL'
    'cd ..'
    'rd .\samba'
    say 'Created ZIP package'
end
/* Default exit point */
say "All done."
exit 0

brand: procedure expose verstring
    parse arg revision

    /* eComStation Version file */
    VerFile = "VERSION.ECS"

    /* is the file available */
    ok = stream(VerFile, 'c', 'QUERY EXISTS')
    if ok = "" then do
        say "Please create a " || VerFile || " based on VERSION.EC_"
        exit 0
    end

    /* Samba Version file */
    Version = "VERSION"
    NewVersion = "VERSION.TMP"

    eCSVer.0 = 0
    I = 0
    do until lines(VerFile) = 0
        I = I + 1
        eCSVer.I = linein(VerFile)
        if left(eCSVer.I,28) = "SAMBA_VERSION_VENDOR_SUFFIX=" then do
            parse var eCSver.I . '='vendor_suffix
            vendor_suffix = strip(vendor_suffix,,'"')
            parse var vendor_suffix vendor suffix
        end
    end
    ok = stream(VerFile, 'c', 'close')
    if Revision <> "" then do
        I = I + 1
        eCSVer.I = "SAMBA_VERSION_VENDOR_PATCH="revision
    end
    eCSVer.0 = I

    do until lines(VERSION) = 0
        verline = linein(VERSION)
        if left(Verline,20) = "SAMBA_VERSION_MAJOR=" then do
            parse var verline . '='Major
        end
        if left(Verline,20) = "SAMBA_VERSION_MINOR=" then do
            parse var verline . '='Minor
        end
        if left(Verline,22) = "SAMBA_VERSION_RELEASE=" then do
            parse var verline . '='release
        end
        
        do I = 1 to eCSVer.0
            parse var eCSVer.I tag'='strvalue
            parse var verline stag'=' .
            if stag = tag then do
                verline = tag'='strvalue
            end
        end
        if Verline <> "=" then call lineout NewVersion, verline
    end

    ok = stream(Version,'c','close')
    ok = stream(NewVersion,'c','close')
    address cmd "ksh ./script/mkversion.sh "NewVersion" >NUL"
    ok = SysFileDelete(NewVersion)
    verstring = suffix'-'Major'.'minor'.'release'.'revision'-'vendor'-'date('S')
    say "Samba "verstring
return


/**
 * Gets the value of sEnvVar.
 */
EnvGet: procedure
    parse arg sEnvVar
    if ((translate(sEnvVar) = 'BEGINLIBPATH') | (translate(sEnvVar) = 'ENDLIBPATH')) then
        return SysQueryExtLibPath(substr(sEnvVar, 1, 1));
return value(sEnvVar,, 'OS2ENVIRONMENT');

/**
 * try to find the pythonversion
 */
PythonVersion: procedure
    parse arg pdir

    ok = SysFileTree(pdir||"\python*.dll",pydll.,"FO")
    rc = -1
    if pydll.0 = 1 then do
        dllpur = filespec("N",pydll.1)
        parse var dllpur 'python' ver '.dll'
        if datatype(ver) <> "NUM" then do
            say "no valid python dll found!"
        end
        else do
            major = left(ver,1)
            minor = substr(ver,2,)
            verstring = "python"||major||"."||minor
            rc = verstring
        end
    end
    else do
        say "no dll found!"
    end
return rc
