/*:VRX         Main
*/
/* Samba Status Monitor for OS/2 
Copyright (C) 2007-2017 Herwig Bauernfeind for bww bitwise works GmbH.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end; else do
        call VROptions 'ImplicitNames'
        call VROptions 'NoEchoQuit'
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary:
    __vrlsWait = abbrev( 'WAIT', translate(arg(2)), 1 )
    if __vrlsWait then do
        call VRFlush
    end
    __vrlsHWnd = VRLoad( VRWindow(), VRWindowPath(), arg(1) )
    if __vrlsHWnd = '' then signal __vrlsDone
    if __vrlsWait \= 1 then signal __vrlsDone
    call VRSet __vrlsHWnd, 'WindowMode', 'Modal' 
    __vrlsTmp = __vrlsWindows.0
    if( DataType(__vrlsTmp) \= 'NUM' ) then do
        __vrlsTmp = 1
    end
    else do
        __vrlsTmp = __vrlsTmp + 1
    end
    __vrlsWindows.__vrlsTmp = VRWindow( __vrlsHWnd )
    __vrlsWindows.0 = __vrlsTmp
    do while( VRIsValidObject( VRWindow() ) = 1 )
        __vrlsEvent = VREvent()
        interpret __vrlsEvent
    end
    __vrlsTmp = __vrlsWindows.0
    __vrlsWindows.0 = __vrlsTmp - 1
    call VRWindow __vrlsWindows.__vrlsTmp 
    __vrlsHWnd = ''
__vrlsDone:
return __vrlsHWnd

/*:VRX         __VXREXX____APPENDS__
*/
__VXREXX____APPENDS__:
/*
#append ..\shared\inittempdir.vrs
#append ..\shared\sambainit.vrs
#append ..\shared\nlv.vrs
#append ..\shared\smbtree.vrs
#append ..\shared\browse.VRS
#append ..\shared\usercredmem.vrs
#append ..\shared\rxrpclib.vrs
*/
return

/*:VRX         _ChkTDB
*/
_ChkTDB: 

ok = SysFileTree(etc'\samba\lock\*.TDB',tdb.,'FO')
say etc'\samba\lock\*.TDB  'tdb.0

error = 0
ok = VRMethod("CN_CHKTDB", "RemoveRecord", "ALL")

RecHandleArray.0 = 0
ok = VRSet("CN_CHKTDB", "Painting", 0)

do I = 1 to tdb.0
    RecHandleArray.I = VRMethod("CN_CHKTDB", "Addrecord")
end
ok = VRSet("CN_CHKTDB", "Painting", 1)

/* ok = VRSet("CN_CHKTDB", "Painting", 0) */

do I = 1 to tdb.0
    RecHandle = RecHandleArray.I
    TDBFile =left(filespec('N',tdb.I), 22)
    TDBSize = stream(tdb.I,'c','query size')
    ok = VRMethod("CN_CHKTDB", "SetFieldData", RecHandle, ChkTDBFilesFH, TDBFile, ChkTDBIconFH, "$50", ChkTDBSizeFH, TDBSize||" Bytes" )
    address cmd '@tdbtool 'tdb.I' check 2>'tdb.I'.err 1>'tdb.I'.out'
    ok = file2stem(tdb.I'.out',"out.")
    out = out.ok
    say out
    if pos('integrity is OK',out) > 0 then do /* integrity is ok */
        ok = SysFileDelete(tdb.I'.err')
        ok = SysFileDelete(tdb.I'.out')
        out = left(out,length(out)-1)
        TDBRecords = substr(out, pos("and has", out) + 7,)
        ok = VRMethod("CN_CHKTDB", "SetFieldData", RecHandle, ChkTDBStatusFH, TDBRecords )

        address cmd '@tdbbackup -s.bak 'tdb.I' 2>NUL 1>NUL'
    end
    else do /* tdb error */
        ok = VRMethod("CN_CHKTDB", "SetFieldData", RecHandle, ChkTDBIconFH, "$51" )
        error = 1
        count = 0
        out = ""
        do while lines(tdb.I'.err') > 0 & count < 5
            errline = linein(tdb.I'.err')
            select
                /* skip unnecessary lines of log */
                when pos("bww ",errline) > 0 then iterate
                when pos("fcntl",errline) > 0 then iterate
                otherwise do
                    out = out||errline'. '
                    count = count + 1
                end
            end
        end
        ok = VRMethod("CN_CHKTDB", "SetFieldData", RecHandle, ChkTDBStatusFH, out )
        ok = VRSet("CN_CHKTDB", "Painting", 1)
        ok = VRSet("CN_CHKTDB", "Painting", 0)

        ok = stream(tdb.I'.err','c','close')
    end

/*
    call charout , left(filespec('N',tdb.I), 22)
    address cmd '@tdbtool 'tdb.I' check 2>'tdb.I'.err 1>'tdb.I'.out'
    out = linein(tdb.I'.out')
    ok = stream(tdb.I'.out','c','close')
    say out
    if pos('integrity is OK',out) = 0 then do
        call beep 880, 20
        address cmd '@tdbbackup -s.bak -v 'tdb.I' 2>NUL 1>NUL'
        error = 1
        count = 0
        do while lines(tdb.I'.err') > 0 & count < 5
            errline = linein(tdb.I'.err')
            select
                /* skip unnecessary lines of log */
                when pos("bww ",errline) > 0 then iterate
                when pos("fcntl",errline) > 0 then iterate
                otherwise do
                    say right(copies(' ',22)'Cause: 'errline'!',min(length(errline)+22,79))
                    count = count + 1
                end
            end
        end
        ok = stream(tdb.I'.err','c','close')
    end
    else do
        ok = SysFileDelete(tdb.I'.err')
        ok = SysFileDelete(tdb.I'.out')
        address cmd '@tdbbackup -s.bak 'tdb.I' 2>NUL 1>NUL'
    end */
end

ok = VRSet("CN_CHKTDB", "Painting", 1)

return

/*:VRX         _ColumnShow
*/
_ColumnShow: 
    userdata = VRGet(VRInfo("Object"),"Userdata")
    parse var userdata Container '|' fieldh '|' VisStatus
say userdata
    ok = VRMethod(Container,"SetFieldAttr", fieldh, "Visible", \VisStatus )
return

/*:VRX         _ColumnsMenu
*/
_ColumnsMenu: 
    Container = arg(1)
    ok = VRMethod(Container, "GetFieldList", "Fields." )

    do I = 1 to 14
        R2I = right("0"||I,2)
        if I <= fields.0 then do
/*          say "Columns_"||R2I' 'VRMethod(Container, "GetFieldAttr", fields.I, "Title" ) */
            ok = VRset("Columns_"||R2I, "Visible", 1)
            ok = VRset("Columns_"||R2I, "Caption", VRMethod(Container, "GetFieldAttr", fields.I, "Title" ))
            ok = VRset("Columns_"||R2I, "Checked", VRMethod(Container, "GetFieldAttr", fields.I, "Visible" ))
            ok = VRset("Columns_"||R2I, "Userdata", Container'|'fields.I'|'VRMethod(Container, "GetFieldAttr", fields.I, "Visible" ))
        end
        else ok = VRset("Columns_"||R2I, "Visible", 0)
    end
    ok = VRMethod( "Columns", "Popup", , , "", "" )    
return

/*:VRX         _ContainerInit
*/
_ContainerInit: 
    say '_ContainerInit() started.'

    /* Users */
    UIconH     = VRMethod( "CN_Users", "AddField", "Icon",   NLVGetMessage(148) )
    UsernameFH = VRMethod( "CN_Users", "AddField", "String", NLVGetMessage(131) )
    GroupFH    = VRMethod( "CN_Users", "AddField", "String", NLVGetMessage(132) )
    UMachineFH = VRMethod( "CN_Users", "AddField", "String", NLVGetMessage(133) )
    UIPAdrFH   = VRMethod( "CN_Users", "AddField", "String", NLVGetMessage(147) )
    UPIDFH     = VRMethod( "CN_Users", "AddField", "String", NLVGetMessage(130) )  

    /* Files */
    FIconH     = VRMethod( "CN_Files", "AddField", "Icon",   NLVGetMessage(148) )
    FileFH     = VRMethod( "CN_Files", "AddField", "String", NLVGetMessage(134) )
    FUserFH    = VRMethod( "CN_Files", "AddField", "String", NLVGetMessage(131) )
    FPIDFH     = VRMethod( "CN_Files", "AddField", "String", NLVGetMessage(130) )
    DenyModeFH = VRMethod( "CN_Files", "AddField", "String", NLVGetMessage(135) )
    TimeFH     = VRMethod( "CN_Files", "AddField", "String", NLVGetMessage(136) )
    DateFH     = VRMethod( "CN_Files", "AddField", "String", NLVGetMessage(149) )
    AccessFH   = VRMethod( "CN_Files", "AddField", "String", NLVGetMessage(137) )
    RWFH       = VRMethod( "CN_Files", "AddField", "String", NLVGetMessage(138) )
    OplockFH   = VRMethod( "CN_Files", "AddField", "String", NLVGetMessage(139) )
    UIDFH      = VRMethod( "CN_Files", "AddField", "String", NLVGetMessage(140) )
    SharePathFH= VRMethod( "CN_Files", "AddField", "String", NLVGetMessage(141) )
    NameFH     = VRMethod( "CN_Files", "AddField", "String", NLVGetMessage(142) )

    /* Service */
    SIconH     = VRMethod( "CN_Service", "AddField", "Icon",   NLVGetMessage(148) )
    SPIDFH     = VRMethod( "CN_Service", "AddField", "String", NLVGetMessage(130) )
    ServiceFH  = VRMethod( "CN_Service", "AddField", "String", NLVGetMessage(143) )
    SMachineFH = VRMethod( "CN_Service", "AddField", "String", NLVGetMessage(133) )
    ConnectedFH= VRMethod( "CN_Service", "AddField", "String", NLVGetMessage(144) )

    /* Daemons */
    DaemonFH   = VRMethod( "CN_Daemons", "AddField", "String", NLVGetMessage(145) )
    DStatusFH  = VRMethod( "CN_Daemons", "AddField", "String", NLVGetMessage(146) )
    DPidsFH    = VRMethod( "CN_Daemons", "AddField", "String", NLVGetMessage(130) )

    smbdHandle = VRMethod("CN_Daemons", "Addrecord",, ,NLVGetMessage(77),"$41") /* smbd.exe */
    nmbdHandle = VRMethod("CN_Daemons", "Addrecord", ,,NLVGetMessage(78),"$41") /* nmbd.exe */
    winbHandle = VRMethod("CN_Daemons", "Addrecord",, ,NLVGetMessage(79),"$41") /* winbindd.exe */

    ok = VRMethod("CN_Daemons", "SetFieldData", smbdHandle, DaemonFH, NLVGetMessage(77)) /* smbd.exe */
    ok = VRMethod("CN_Daemons", "SetFieldData", nmbdHandle, DaemonFH, NLVGetMessage(78)) /* nmbd.exe */
    ok = VRMethod("CN_Daemons", "SetFieldData", winbHandle, DaemonFH, NLVGetMessage(79)) /* winbindd.exe */
    ok = (stream(samba.!bin'\winbindd.exe','c','query exists') <> "")
    ok = VRMethod("CN_Daemons", "SetRecordAttr", winbHandle, "Visible", ok)
    ok = VRMethod("CN_Daemons", "SetRecordAttr","All", "Collapsed", 0 )


    /* SMBTree */
    WorkgroupFH = VRMethod( "CN_SMBTREE", "AddField", "String", NLVGetMessage(150)  )
    NBFH        = VRMethod( "CN_SMBTREE", "AddField", "String", "NetBIOS name" )
    IpFH        = VRMethod( "CN_SMBTREE", "AddField", "String",  NLVGetMessage(147)  )
    MBFH        = VRMethod( "CN_SMBTREE", "AddField", "String", "DMB/LMB" )    
    OSFH        = VRMethod( "CN_SMBTREE", "AddField", "String", "OS" )
 /* VersionFH   = VRMethod( "CN_SmbTree", "AddField", "String", "Version" ) */
    CommentFH   = VRMethod( "CN_SMBTREE", "AddField", "String", NLVGetMessage(151) )
    MacFH       = VRMethod( "CN_SMBTREE", "AddField", "String", "MAC" )

    ok = VRMethod("CN_SMBTREE","SetfieldAttr",IPFH,       "ReadOnly", 1)
    ok = VRMethod("CN_SMBTREE","SetfieldAttr",NBFH,       "ReadOnly", 1)
    ok = VRMethod("CN_SMBTREE","SetfieldAttr",MBFH,       "ReadOnly", 1)
    ok = VRMethod("CN_SMBTREE","SetfieldAttr",WorkGroupFH,"ReadOnly", 1)
    ok = VRMethod("CN_SMBTREE","SetfieldAttr",OSFH,       "ReadOnly", 1)
    ok = VRMethod("CN_SMBTREE","SetfieldAttr",MacFH,      "ReadOnly", 1)

    /* ChkTdb */
    ChkTDBFilesFH = VRMethod( "CN_CHKTDB", "AddField", "String", NLVGetMessage(134) )
    ChkTDBIconFH  = VRMethod( "CN_CHKTDB", "AddField", "Icon",   NLVGetMessage(146) )
    ChkTDBSizeFH  = VRMethod( "CN_CHKTDB", "AddField", "String", NLVGetMessage(152) )
    ChkTDBStatusFH= VRMethod( "CN_CHKTDB", "AddField", "String", NLVGetMessage(151) )

    ok = VRMethod( "CN_CHKTDB", "SetfieldAttr", ChkTDBIconFH,   "Justification","Center", "ReadOnly", 1)
    ok = VRMethod( "CN_CHKTDB", "SetfieldAttr", ChkTDBSizeFH,   "Justification","Right",  "ReadOnly", 1)
    ok = VRMethod( "CN_CHKTDB", "SetfieldAttr", ChkTDBStatusFH, "Justification","Right",  "ReadOnly", 1)

    say '_ContainerInit() done.'
return
/*:VRX         _ContainerSort
*/
_ContainerSort: 
    ok = VRMethod( "LB_SortFields", "GetSelectedList", "SortFields." ) 
    if Fields.0 = 0 then return
    idx = SortFields.1
    ok = VRset( Container, "DetailSort", Fields.idx )
    ok = VRSet( Container, "Sort", SortOrder )
    ok = VRMethod( Container, "SortRecords" ) 
return

/*:VRX         _ContextMenuSelectedSet
*/
_ContextMenuSelectedSet: 
    ok = VRSet("ContextMenu_Tree_Login",       "Visible", 0)
    ok = VRSet("ContextMenu_Tree_ACLS",        "Visible", 0)
    ok = VRSet("ContextMenu_Tree_SendMsg",     "Visible", 0)
    ok = VRSet("ContextMenu_Tree_Logoff",      "Visible", 0)
    ok = VRSet("ContextMenu_Tree_Sep1",        "Visible", 0)
    ok = VRSet("ContextMenu_Tree_MiniIcons",   "Visible", 0)
    ok = VRSet("ContextMenu_Tree_Tree",        "Visible", 1)
    ok = VRSet("ContextMenu_Tree_Details",     "Visible", 1)
    ok = VRSet("ContextMenu_Tree_Icons",       "Visible", 1)
    ok = VRSet("ContextMenu_Tree_Sort",        "Visible", 0) /* FIXME: Crashes */
    say '  SMBObj.udatatype = "'SMBObj.udatatype'"'
    select
        when SMBObj.udatatype = "WORKGROUP" then do
            ok = VRSet("ContextMenu_Tree_MiniIcons",   "Visible", 1)
        end
        when SMBObj.udatatype = "SERVER" then do
            ok = VRSet("ContextMenu_Tree_Login",       "Visible", 1)
            ok = VRSet("ContextMenu_Tree_SendMsg",     "Visible", 1)
            ok = VRSet("ContextMenu_Tree_Logoff",      "Visible", 1)
            ok = VRSet("ContextMenu_Tree_Sep1",        "Visible", 1)
            ok = VRSet("ContextMenu_Tree_MiniIcons",   "Visible", 1)
        end
        when SMBObj.udatatype = "DISK" then do
            ok = VRSet("ContextMenu_Tree_ACLS",        "Visible", 1)
            ok = VRSet("ContextMenu_Tree_Sep1",        "Visible", 1)
            ok = VRSet("ContextMenu_Tree_MiniIcons",   "Visible", 1)
        end
        when SMBObj.udatatype = "PRINTER" then do
            ok = VRSet("ContextMenu_Tree_MiniIcons",   "Visible", 1)
        end
        when SMBObj.udatatype = "DIRECTORY" then do
            ok = VRSet("ContextMenu_Tree_ACLS",        "Visible", 1)
            ok = VRSet("ContextMenu_Tree_Sep1",        "Visible", 1)
        end
        when SMBObj.udatatype = "FILE" then do
            ok = VRSet("ContextMenu_Tree_ACLS",        "Visible", 1)
            ok = VRSet("ContextMenu_Tree_Sep1",        "Visible", 1)
        end
        otherwise do /* No other value known - default */
            ok = VRSet("ContextMenu_Tree_Tree",        "Visible", 1)
            ok = VRSet("ContextMenu_Tree_Details",     "Visible", 1)
            ok = VRSet("ContextMenu_Tree_Icons",       "Visible", 1)
            ok = VRSet("ContextMenu_Tree_Sort",        "Visible", 1)
        end
    end
return

/*:VRX         _CreateSmbStarter
*/
_CreateSmbStarter: 
ok = SysFileDelete(samba.!bin'\smbstarter.cmd')
call lineout samba.!bin'\smbstarter.cmd', '/* REXX */'
call lineout samba.!bin'\smbstarter.cmd', 'signal on failure name CLEANUP'
call lineout samba.!bin'\smbstarter.cmd', 'signal on halt name CLEANUP'
call lineout samba.!bin'\smbstarter.cmd', 'signal on syntax name CLEANUP'
call lineout samba.!bin'\smbstarter.cmd', 'say "Samba Server Starter"'
call lineout samba.!bin'\smbstarter.cmd', 'address cmd "@echo off"'
call lineout samba.!bin'\smbstarter.cmd', 'home:'
call lineout samba.!bin'\smbstarter.cmd', 'select' 
call lineout samba.!bin'\smbstarter.cmd', 'when VRFileExists("smbstart") then do'
call lineout samba.!bin'\smbstarter.cmd', 'say "Start"'
call lineout samba.!bin'\smbstarter.cmd', 'address cmd "call 'samba.!bin'\smb.cmd start"'
call lineout samba.!bin'\smbstarter.cmd', 'ok = SysFileDelete("smbstart")'
call lineout samba.!bin'\smbstarter.cmd', 'end'
call lineout samba.!bin'\smbstarter.cmd', 'when VRFileExists("smbstop") then do'
call lineout samba.!bin'\smbstarter.cmd', 'say "Stop"'
call lineout samba.!bin'\smbstarter.cmd', 'address cmd "call 'samba.!bin'\smb.cmd stop"'
call lineout samba.!bin'\smbstarter.cmd', 'ok = SysFileDelete("smbstop")'
call lineout samba.!bin'\smbstarter.cmd', 'end' 
call lineout samba.!bin'\smbstarter.cmd', 'when VRFileExists("restart") then do' 
call lineout samba.!bin'\smbstarter.cmd', 'say "Restart"'
call lineout samba.!bin'\smbstarter.cmd', 'address cmd "call 'samba.!bin'\smb.cmd restart"'
call lineout samba.!bin'\smbstarter.cmd', 'ok = SysFileDelete("restart")'
call lineout samba.!bin'\smbstarter.cmd', 'end' 
call lineout samba.!bin'\smbstarter.cmd', 'when VRFileExists("reload") then do' 
call lineout samba.!bin'\smbstarter.cmd', 'say "Reload"'
call lineout samba.!bin'\smbstarter.cmd', 'address cmd "call 'samba.!bin'\smb.cmd reload"'
call lineout samba.!bin'\smbstarter.cmd', 'ok = SysFileDelete("reload")'
call lineout samba.!bin'\smbstarter.cmd', 'end' 
call lineout samba.!bin'\smbstarter.cmd', 'when VRFileExists("quit") then do' 
call lineout samba.!bin'\smbstarter.cmd', 'say "Quit"'
call lineout samba.!bin'\smbstarter.cmd', 'ok = SysFileDelete("quit")'
call lineout samba.!bin'\smbstarter.cmd', 'signal cleanup'
call lineout samba.!bin'\smbstarter.cmd', 'end' 
call lineout samba.!bin'\smbstarter.cmd', 'otherwise nop'
call lineout samba.!bin'\smbstarter.cmd', 'end'
call lineout samba.!bin'\smbstarter.cmd', 'ok = SysSleep(1)'
call lineout samba.!bin'\smbstarter.cmd', 'signal home'
call lineout samba.!bin'\smbstarter.cmd', 'cleanup:'
call lineout samba.!bin'\smbstarter.cmd', 'say "Aborting..."'
call lineout samba.!bin'\smbstarter.cmd', 'exit'
ok = stream(samba.!bin'\smbstarter.cmd','c','close')

Setup = 'NOPRINT=YES;DEFAULTVIEW=RUNNING;'||,
        'EXENAME='samba.!bin'\smbstarter.cmd;'||,
        'STARTUPDIR='samba.!bin';'||,
        'TITLE=;'||,
        'PROGTYPE=WINDOWABLEVIO;'||,
        'MINIMIZED=YES;'||,
        'VISIBLE=NO;'||,
        'NOAUTOCLOSE=NO;'||,
        'OBJECTID=<smbstarter>'

rc = SysCreateObject('WPProgram', 'SMBSTARTER', '<WP_NOWHERE>', Setup, 'UPDATE' )
If rc <> 1 Then Say ' > failed to create SMBSTARTER Object'
else ok = SysOpenObject('<smbstarter>', 'DEFAULT', 1) 


return

/*:VRX         _GuessIcon
*/
_GuessIcon: procedure
    text = arg(1)
    select /* Printer guessing */
        when pos('LJ',text)      > 0 then res = '#65:PMWP.DLL'
        when pos('LASER',text)   > 0 then res = '#65:PMWP.DLL'
        when pos('EPSON',text)   > 0 then res = '#65:PMWP.DLL'
        when pos('PRINT',text)   > 0 then res = '#65:PMWP.DLL'
        when pos('PRT',text)     > 0 then res = '#65:PMWP.DLL'
        when pos('CANON',text)   > 0 then res = '#65:PMWP.DLL'
        when pos('MINOLTA',text) > 0 then res = '#65:PMWP.DLL'
        when pos('FAX',text)     > 0 then res = '#65:PMWP.DLL'
        when pos('LEXMARK',text) > 0 then res = '#65:PMWP.DLL'
        when pos('IPC$',text)    > 0 then res = '#59:PMWP.DLL'
        otherwise res = "#34:PMWP.DLL"
    end
return res

/*:VRX         _GUIInit
*/
_GUIInit: 
    IF options.!debug == 1 then say time()' _GUIInit() started'

    if datatype(Top) = 'NUM' then do
        ok = VRset("Main","Top",Top)
        ok = VRset("Main","Left",Left)
        ok = VRset("Main","Width",Width)
        ok = VRset("Main","Height",Height)
    end

    ok = VRSet("Main",        "Font", Font.!Main)
    ok = VRSet("DT_StatusBar","Font", Font.!Status)
    ok = VRSet("SW_Users",    "Font", Font.!Users)
    ok = VRSet("SW_Files",    "Font", Font.!Files)
    ok = VRSet("SW_Service",  "Font", Font.!Service)
    ok = VRSet("SW_Daemons",  "Font", Font.!Daemons)
    ok = VRSet("SW_SMBTree",  "Font", Font.!SMBTree)
    ok = VRSet("SW_Settings", "Font", Font.!Settings)

    ok = VRSet("CN_Users",    "Font", Font.!Users)
    ok = VRSet("CN_Files",    "Font", Font.!Files)
    ok = VRSet("CN_Service",  "Font", Font.!Service)
    ok = VRSet("CN_Daemons",  "Font", Font.!Daemons)
    ok = VRSet("CN_SMBTREE",  "Font", Font.!SMBTree)

    CALL NLVSetText 'DT_Refresh',      'Caption',  25
    CALL NLVSetText 'DT_RefreshMin',   'Caption',  25
    CALL NLVSetText 'DT_Intervall',    'Caption',  26
    ok = VRSet("DT_IntervallMin",      "Caption", NLVGetMessage(26)' 'NLVGetMessage(28))
    CALL NLVSetText 'CB_NoMsgBox',     'Caption',  27
    CALL NLVSetText 'CB_WPSSTARTSTOP', 'Caption',  29
    CALL NLVSetText 'CB_DetectZombies','Caption',  30

    CALL NLVSetText 'ContextMenu_Daemons_Sort',   'Caption', 35 
    CALL NLVSetText 'ContextMenu_Daemons_Ping',   'Caption', 32
    CALL NLVSetText 'ContextMenu_Daemons_Details','Caption', 118
    CALL NLVSetText 'ContextMenu_Daemons_Tree',   'Caption', 120

    CALL NLVSetText 'ContextMenu_Files_Sort',     'Caption', 35 

    CALL NLVSetText 'ContextMenu_Service_Sort',   'Caption', 35 
    CALL NLVSetText 'ContextMenu_Service_CloseSHare', 'Caption', 70

    CALL NLVSetText 'ContextMenu_Users_SendMsg', 'Caption', 80
    CALL NLVSetText 'ContextMenu_Users_Sort',    'Caption', 35   

    CALL NLVSetText 'ContextMenu_Tree_SendMsg',  'Caption', 80
    CALL NLVSetText 'ContextMenu_Tree_Sort',     'Caption', 35   
    CALL NLVSetText 'ContextMenu_Tree_Tree',     'Caption', 120
    CALL NLVSetText 'ContextMenu_Tree_Details',  'Caption', 118

    Buttonwidth = VRMethod( "Screen", "PixelsToTwips", 32 )

    ok = VRSet("SPIN_Intervall",   "Value", Intervall)
    ok = VRSet("SPIN_IntervallMin","Value", IntervallMin)
    ok = VRSet("TM_Refresh","Delay", Intervall * 1000)
    
    ok = VRSet("ICB_START",  "Enabled", VRFileExists(samba.!smbcmd))
    ok = VRSet("ICB_REstart","Enabled", VRFileExists(samba.!smbcmd))
    ok = VRSet("ICB_REload", "Enabled", VRFileExists(samba.!smbcmd))

    ok = VRSet("CN_Daemons",      "View", DaemonView)
    ok = VRSet("CN_SMBTREE",      "View", TreeView)
    ok = VRSet("CB_NoMsgBox",     "Set",  NoMsgBox)
    ok = VRSet("CB_WPSStartStop", "Set",  WPSStartStop)
    ok = VRSet("CB_DetectZombies","Set",  DetectZombies)

    call _INILayoutRead "CN_Users"
    call _INILayoutRead "CN_Files"
    call _INILayoutRead "CN_Service"
    call _INILayoutRead "CN_Daemons"
    call _INILayoutRead "CN_SMBTREE"

    ok = VRset("CN_DAEMONS", "MiniIcons", \advanced.!bigicons)
    ok = VRset("CN_SMBTREE", "MiniIcons", \advanced.!bigicons)
    ok = VRset("ContextMenu_Tree_MiniIcons",  "Checked", \advanced.!bigicons)
    ok = VRset("ContextMenu_Daemons_MiniIcons",  "Checked", \advanced.!bigicons)
    ok = VRSet("CB_Debug","set",options.!Debug)

    if _ChkTempFreeSpace() < 262144 then do
        Msg.Type = "W"
        Msg.Text = NLVGetMessage(116, TempDir)
        call _ShowMsg
    end

    /* Common margin around controls */
    margin = ((VRGet("Main", "InteriorLeft") / 3) * 2) + 2

    /* Statusbar */
    ok = VRSet("DT_STATUSBAR","Caption", " "||VRGet("Main", "HintText"))

    call Main_Resize

    
    ok = VRSet("Main", "Visible", 1)
    IF options.!debug == 1 then say time()' _GUIInit() done'
return

/*:VRX         _INILayoutRead
*/
_INILayoutRead: 
    Container = arg(1)
    ok = VRMethod(Container, "GetFieldList", "Fields." )
    Layout = VRGetIni( "Layout", Container,  OurINI )
    if Layout = "" then return
    do I = 1 to Fields.0
        ok = VRMethod(Container, "SetFieldAttr", fields.I,"Visible", substr(Layout,I,1))
    end
return

/*:VRX         _INILayoutWrite
*/
_INILayoutWrite: 
    Container = arg(1)
    ok = VRMethod(Container, "GetFieldList", "Fields." )
    Layout = "" 
    do I = 1 to fields.0
        Layout = Layout||VRMethod(Container, "GetFieldAttr", fields.I, "Visible" )        
    end
    ok = VRSetIni( "Layout", Container , Layout, OurINI, 'NoClose' ) 
return

/*:VRX         _INIRead
*/
_INIRead: 
    IF options.!debug == 1 then say time()' _INIRead() started'

    OurINI = strip(VRParseFileName(VRget("Application","Program"),'DP')'\SMBSTATUS.INI',,'\')
    ok = SysFileTree(OurINI, INIFound.,'FO')
    if INIFound.0 = 1 then OurINI = VRParseFileName(INIFound.1,'DPNE')
    IF options.!debug == 1 then say '  OurINI='OurINI

    Top   = VRGetIni( "Pos", "Top",    OurINI , 'NoClose')
    Left  = VRGetIni( "Pos", "Left",   OurINI , 'NoClose')
    Width = VRGetIni( "Pos", "Width",  OurINI , 'NoClose')
    Height= VRGetIni( "Pos", "Height", OurINI , 'NoClose')

    Font.!Users   = VRGetIni( "Fonts", "SW_USERS",    OurINI , 'NoClose' )
    Font.!Files   = VRGetIni( "Fonts", "SW_FILES",    OurINI , 'NoClose' )
    Font.!Service = VRGetIni( "Fonts", "SW_SERVICE",  OurINI , 'NoClose' )
    Font.!Daemons = VRGetIni( "Fonts", "SW_DAEMONS",  OurINI , 'NoClose' )
    Font.!SMBTree = VRGetIni( "Fonts", "SW_SMBTREE",  OurINI , 'NoClose' )
    Font.!Settings= VRGetIni( "Fonts", "SW_SETTINGS", OurINI , 'NoClose' )
    Font.!Main    = VRGetIni( "Fonts", "Main",        OurINI , 'NoClose' )
    Font.!Status  = VRGetIni( "Fonts", "Statusfont",  OurINI , 'NoClose' )

    if Font.!Users    = "" then Font.!Users    = "9.WarpSans"
    if Font.!Files    = "" then Font.!Files    = "9.WarpSans"
    if Font.!Service  = "" then Font.!Service  = "9.WarpSans"
    if Font.!Daemons  = "" then Font.!Daemons  = "9.WarpSans"
    if Font.!SMBTree  = "" then Font.!SMBTree  = "9.WarpSans"
    if Font.!Settings = "" then Font.!Settings = "9.WarpSans"
    if Font.!Main     = "" then Font.!Main     = "9.WarpSans"
    if Font.!Status   = "" then Font.!Status   = "9.WarpSans"

    Intervall = VRGetIni( "Settings", "Intervall", OurINI,'NoClose')
    if Intervall = "" then Intervall = 60

    IntervallMin = VRGetIni( "Settings", "IntervallMin", OurINI,'NoClose')
    if IntervallMin = "" then IntervallMin = 180

    CurrentPageNr = VRGetIni( "Settings", "CurrentPageNr", OurINI,'NoClose')
    if CurrentPageNr = "" then CurrentPageNr = 4

    DaemonView = VRGetIni( "Settings", "DaemonView", OurINI,'NoClose')
    if DaemonView = "" then DaemonView = "IconTree"

    TreeView = VRGetIni( "Settings", "TreeView", OurINI,'NoClose')
    if TreeView = "" then TreeView = "IconTree"

    NoMsgBox = VRGetIni( "Settings", "NoMsgBox", OurINI,'NoClose')
    if NoMsgBox = "" then NoMsgBox = 1

    WPSStartStop = VRGetIni( "Settings", "WPSStartStop", OurINI,'NoClose')
    if WPSStartStop = "" then WPSStartStop = 1

    DetectZombies = VRGetIni( "Settings", "DetectZombies", OurINI,'NoClose')
    if DetectZombies = "" then DetectZombies = 0

    options.!debug = VRGetIni( "Options", "Debug", OurINI)
    if options.!debug = "" then options.!debug = 0

    if options.!Debug then ok = VRRedirectStdIO("ON")
                      else ok = VRRedirectStdIO("OFF")
    options.!storecreds = VRGetIni('Settings', 'StoreCreds', OurINI, 'NoClose')
say "options.!storecreds = "options.!storecreds
    IF options.!storecreds == '' then options.!storecreds = 1
say "options.!storecreds = "options.!storecreds
    IF _ucChkObj() = 0 then options.!storecreds = 0
say "options.!storecreds = "options.!storecreds


    advanced.!bigicons = VRGetIni( "Settings", "BigIcons", OurINI)
    if advanced.!bigicons = "" then advanced.!bigicons = 1

    advanced.!smbconfchanged = 0

    /* For Browse page */
    FirstRun = 1
    /* For Users page in case connections.tdb is not initialised */
    IgnoreSmbNoInit = 1

    /* For Refresh tree display code */
    RefreshMode =""

    call _BrowseIconsInit

    smbdpidhandle.0 = 0
    nmbdpidhandle.0 = 0
    winbpidhandle.0 = 0

    prevsmbdct = 0
    prevnmbdct = 0
    prevwinbct = 0

    smbdoutput = TempDir'smbd.out'
    IF options.!debug == 1 then say time()' _INIRead() done'
return

/*:VRX         _INIWrite
*/
_INIWrite: 
    IF options.!debug == 1 then say time()' _INIWrite() started'
    ok = VRSetIni( "Pos", "Top",          VRGet("Main","Top"),         OurINI, 'NoClose' )
    ok = VRSetIni( "Pos", "Left",         VRGet("Main","Left"),        OurINI, 'NoClose' )
    ok = VRSetIni( "Pos", "Width",        VRGet("Main","Width"),       OurINI, 'NoClose' )    
    ok = VRSetIni( "Pos", "Height",       VRGet("Main","Height"),      OurINI, 'NoClose' ) 

    ok = VRSetIni( "Settings", "Intervall",    VRGet("SPIN_Intervall","Value"),OurINI,'NoClose')
    ok = VRSetIni( "Settings", "IntervallMin", VRGet("SPIN_IntervallMin","Value"),OurINI,'NoClose')
    ok = VRSetIni( "Settings", "CurrentPageNr",CurrentPageNr,                  OurINI,'NoClose')
    ok = VRSetIni( "Settings", "DaemonView",   VRGet("CN_Daemons","View"),     OurINI,'NoClose')
    ok = VRSetIni( "Settings", "TreeView",     VRGet("CN_SMBTREE","View"),     OurINI,'NoClose')
    ok = VRSetIni( "Settings", "NoMsgBox",     NoMsgBox,                       OurINI,'NoClose')
    ok = VRSetIni( "Settings", "WPSStartStop", WPSStartStop,                   OurINI,'NoClose')
    ok = VRSetIni( "Settings", "BigIcons",     \VRGet("CN_SMBTREE", "MiniIcons"),OurINI,'NoClose')
    ok = VRSetIni( "Settings", "DetectZombies",DetectZombies,                  OurINI,'NoClose')
    call VRSetIni 'Settings', 'StoreCreds',    options.!storecreds  ,          OurINI, 'NoClose'

    ok = VRSetIni( "Options",  "Debug",    options.!debug,             OurINI, 'NoClose' )     

    call _INILayoutWrite "CN_Users"
    call _INILayoutWrite "CN_Files"
    call _INILayoutWrite "CN_Service"
    call _INILayoutWrite "CN_Daemons"
    call _INILayoutWrite "CN_SMBTREE"

    if VRGet("CN_USERS",   "Font") <> "<default>" then ok = VRSet("SW_USERS",  "Font", VRGet("CN_USERS",  "Font"))
    if VRGet("CN_FILES",   "Font") <> "<default>" then ok = VRSet("SW_FILES",  "Font", VRGet("CN_FILES",  "Font"))
    if VRGet("CN_SERVICE", "Font") <> "<default>" then ok = VRSet("SW_SERVICE","Font", VRGet("CN_SERVICE","Font"))
    if VRGet("CN_DAEMONS", "Font") <> "<default>" then ok = VRSet("SW_DAEMONS","Font", VRGet("CN_DAEMONS","Font"))
    if VRGet("CN_SMBTREE", "Font") <> "<default>" then ok = VRSet("SW_SMBTREE","Font", VRGet("CN_SMBTREE","Font"))
      
    ok = VRSetIni( "Fonts", "SW_USERS",   VRGet("SW_USERS",   "Font"), OurINI, 'NoClose' )
    ok = VRSetIni( "Fonts", "SW_FILES",   VRGet("SW_FILES",   "Font"), OurINI, 'NoClose' )
    ok = VRSetIni( "Fonts", "SW_SERVICE", VRGet("SW_SERVICE", "Font"), OurINI, 'NoClose' )
    ok = VRSetIni( "Fonts", "SW_DAEMONS", VRGet("SW_DAEMONS", "Font"), OurINI, 'NoClose' )
    ok = VRSetIni( "Fonts", "SW_SMBTREE", VRGet("SW_SMBTREE", "Font"), OurINI, 'NoClose' )
    ok = VRSetIni( "Fonts", "SW_SETTINGS",VRGet("SW_SETTINGS","Font"), OurINI, 'NoClose' )
    ok = VRSetIni( "Fonts", "Statusfont", VRGet("DT_StatusBar","Font"),OurINI, 'NoClose' )
    ok = VRSetIni( "Fonts", "Main",       VRGet("Main","Font"),        OurINI )
    IF options.!debug == 1 then say time()' _INIWrite() done'
return

/*:VRX         _LoadotherFuncs
*/
_LoadotherFuncs: 
    IF options.!debug == 1 then say time()' _LoadotherFuncs() started'
    SIGNAL ON SYNTAX NAME DLLMissing

    call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
    call SysLoadFuncs

    call RxFuncAdd 'PRLoadFuncs',  'PR1UTIL', 'PRLoadFuncs'
    call PRLoadFuncs

    call rxfuncadd 'IniLoadFuncs', 'REXXINI', 'IniLoadFuncs'
    call IniLoadFuncs

    call RxFuncAdd 'RxDate', 'RexxDate', 'RxDate'

    SIGNAL OFF SYNTAX
    IF options.!debug == 1 then say time()' _LoadotherFuncs() done'
return

DLLMissing:
    Fatal = 1
    call VRMessage 'Main', 'REXX function library 'strip(translate(word(sourceline(SIGL-1),4),'  ',"',"))'.DLL is missing!', "EVFSGUI fatal error", "E"
signal Quit
/*:VRX         _MsgYesNo
*/
_MsgYesNo: 
    say "_MsgYesNo() started"
    buttons.0 = 2
    buttons.1 = NLVGetMessage(6)
    buttons.2 = NLVGetMessage(7)
    default = 2
    buttons.default = NLVGetMessage(7)
    esc = 2
    buttons.esc = NLVGetMessage(7)
    RC = VRMessage( VRWindow(), Msg.Text, Msg.Title,"Q","buttons.",default, esc )
    say "_MsgYesNo() done, answer "RC
return RC

/*:VRX         _NLVSetup
*/
_NLVSetup: 
    settings.!messages = 1  /* language files exist(s) */
    settings.!helpfile = 0 /* helpfiles do not exist  */
    settings.!nlv8dot3 = 0  /* NLV may have long filenames  */
    call NLVSetup

    Msg.Title = NLVGetMessage(1)
    ok = VRSet("Main","helpFile", settings.!helpfile)

    /* Setup the tabbed dialogue */
    w = VRLoad( "TDL_1", VRWindowPath(), "SW_DAEMONS" )
    ok = VRMethod( "TDL_1", "InsertPage", w,"+ "NLVGetMessage(18)" ") 
    w = VRLoad( "TDL_1", VRWindowPath(), "SW_SMBTREE" )
    ok = VRMethod( "TDL_1", "InsertPage", w,"+ "NLVGetMessage(19)" ") 
    w = VRLoad( "TDL_1", VRWindowPath(), "SW_USERS" )
    ok = VRMethod( "TDL_1", "InsertPage", w,"+ "NLVGetMessage(15)" ") 
    w = VRLoad( "TDL_1", VRWindowPath(), "SW_FILES" )
    ok = VRMethod( "TDL_1", "InsertPage", w,"+ "NLVGetMessage(16)" ") 
    w = VRLoad( "TDL_1", VRWindowPath(), "SW_SERVICE" )
    ok = VRMethod( "TDL_1", "InsertPage", w,"+ "NLVGetMessage(17)" ") 
    w = VRLoad( "TDL_1", VRWindowPath(), "SW_CHKTDB" )
    ok = VRMethod( "TDL_1", "InsertPage", w,"+ "NLVGetMessage(22)" ") 
    w = VRLoad( "TDL_1", VRWindowPath(), "SW_SETTINGS" )
    ok = VRMethod( "TDL_1", "InsertPage", w,"+ "NLVGetMessage(24)" ") 

    CALL NLVSetText 'ICB_Refresh',  'Caption', 11
    CALL NLVSetText 'ICB_Apply',    'Caption', 10
    CALL NLVSetText 'ICB_About',    'Caption', 14
    CALL NLVSetText 'ICB_EXIT',     'Caption', 12

    CALL NLVSetText 'ICB_Refresh',  'Hinttext', 51
/*  CALL NLVSetText 'ICB_APPLY',    'Hinttext', FIXME */
    CALL NLVSetText 'ICB_ABOUT',    'Hinttext', 53
    CALL NLVSetText 'ICB_EXIT',     'Hinttext', 54

    CALL VRMethod 'TT_Main', 'Register', 'ICB_REFRESH', NLVGetMessage(51)
    CALL VRMethod 'TT_Main', 'Register', 'ICB_APPLY',   NLVGetMessage(52) /* FIXME */
    CALL VRMethod 'TT_Main', 'Register', 'ICB_ABOUT',   NLVGetMessage(53)
    CALL VRMethod 'TT_Main', 'Register', 'ICB_EXIT',    NLVGetMessage(54)
return

/*:VRX         _Refresh
*/
_Refresh: 
    IF options.!debug == 1 then say time()' _Refresh() started'
    ok = VRSet("TM_refresh","Enabled", 0)
    SmbNoInit = 0

    refreshoutput = TempDir'refresh.out'
    refresherr    = TempDir'refresh.err'

    say '  'samba.!smbd' -V --debuglevel=0 2>'refresherr' 1>'refreshoutput
    address cmd samba.!smbd' -V --debuglevel=0 2>'refresherr' 1>'refreshoutput

    do while lines(refreshoutput) > 0
        Hdr = linein(refreshoutput)
        if pos("Version ",Hdr) > 0 then leave
    end

    SambaVer = "Samba "||strip(Hdr)
    say '  smbd.exe:  "'SambaVer'"'
    ok = stream(refreshoutput,'c','close')

    say     '  'samba.!smbstatusexe' smbd 'DebugLevel' 2>'refresherr' 1>'refreshoutput
    address cmd samba.!smbstatusexe' smbd 'DebugLevel' 2>'refresherr' 1>'refreshoutput

    do while lines(refreshoutput) > 0
        Hdr = linein(refreshoutput)
        if pos("Samba version",Hdr) > 0 then leave
    end

    SambaStVer = strip(Hdr) /* we can detect version mismatches here */
    say '  smbstatus: "'SambaStVer'"'

    select
        when pos('not initialised',SambaStVer) > 0 then do
            SambaVer = SambaVer||" (Init)"
            SmbNoInit = 1
        end
        when translate(SambaStVer) <> translate(SambaVer) then SambaVer = SambaVer||" (Hybrid)"
        otherwise nop
    end

    Ok = VRSet("Main", "Caption", SambaVer' - 'NLVGetMessage(146))

    /* Active User */
    Hdr1 = linein(refreshoutput)
/* say '  1:'hdr1 */
    Hdr2 = linein(refreshoutput)
/* say '  2:'hdr2 */
    Zeile = linein(refreshoutput)
    say '    'Zeile
    if SmbNoInit then do
        call lineout samba.!msg, SambaStVer
        call lineout samba.!msg, Hdr1
        call lineout samba.!msg, Hdr2
        call lineout samba.!msg, Zeile
        ok = stream(samba.!msg,'c','close')
        if IgnoreSmbNoInit then do
            call _SambaShowMsg
            IgnoreSmbNoInit = 0
        end
    end

    say '  SmbNoInit = 'SmbNoInit

    /* Active users */
    ok = VRSet("CN_Users","Painting", 0)
    ok = VRMethod("CN_Users", "RemoveRecord", "ALL")
    Username.0 = 0
    IP.0 = 0
    Group.0 = 0
    I = 0
    if \SmbNoInit then do
        do while Zeile <> ''
            parse var Zeile UPID Username Group Machine IP
            I = I + 1
            UPID.I = UPID
            Username.I = Username
            Group.I = Group
            IP = strip(IP)
            parse var IP '('IP.I')'
            RecHandle = VRMethod("CN_Users", "Addrecord")
            ok = VRMethod("CN_Users", "SetFieldData", RecHandle, UIconH, "$44", UPIDFH, UPID, UsernameFH, Username, GroupFH, Group, UMachineFH, Machine, UIPAdrFH, IP.I)
            Zeile = linein(refreshoutput)
        end   
    end
    Username.0 = I
    Group.0 = I
    UPID.0 = I
    ok = VRSet("CN_Users","Painting", 1)

    /* Active Services */
    Hdr = linein(refreshoutput)
    Hdr = linein(refreshoutput)
    I = 0
    Zeile = linein(refreshoutput)
    ok = VRSet("CN_Service","Painting", 0)
    ok = VRMethod("CN_Service", "RemoveRecord", "ALL")
    do while Zeile <> ''
        parse var Zeile Service SPId Machine Connected
        I = I + 1
        SPid.I = SPid
        Machine.I = Machine
        Service.I = Service
        Icon = _GuessIcon(Service.I)

        Connected = strip(Connected)
        T. = ""
        parse var Connected T.WDay T.Month T.DoM T.TimeoD T.Year
        Connected = T.TimeoD', 'T.WDay' 'T.DoM' 'T.Month' 'T.Year

        RecHandle = VRMethod("CN_Service", "Addrecord")
        ok = VRMethod("CN_Service", "SetFieldData", RecHandle, SIconH, Icon, ServiceFH, Service, SPIDFH, SPID, SMachineFH, Machine, ConnectedFH, Connected)
        Zeile = linein(refreshoutput)
    end   
    SPid.0    = I
    Machine.0 = I
    Service.0 = I

    ok = VRSet("CN_Service","Painting", 1)

    /* Open files */
    Hdr = linein(refreshoutput)
    Hdr = linein(refreshoutput)
    Hdr = linein(refreshoutput)

    Zeile = linein(refreshoutput)
    ok = VRSet("CN_Files","Painting", 0)
    ok = VRMethod("CN_Files", "RemoveRecord", "ALL")
    File.0 = 0
    FPID.0 = 0
    do while Zeile <> ''
        parse var Zeile FPid Uid DenyMode Access RW Oplock Sharepath Rest
        TimeDate = right(rest,25)

say 'Refreshcrash "'Rest'"'
say 'Refreshcrash "'max(length(Rest)-25)'"'

        Name = strip(left(Rest,max(length(Rest)-25,1)))
        I = I + 1
        sharepath = strip(translate(left(sharepath,1))||translate(substr(SharePath,2),'\','/'),'T','\')
        Username = UID
        do J = 1 to UPID.0
            if FPID = UPID.J then do
                Username = Username.J
                leave
            end
        end
        File = SharePath||'\'||translate(Name,'\','/')
        File.I = File
        FPID.I = FPID
        TimeDate = strip(TimeDate)
        say Timedate
        T. = ""
        parse var TimeDate T.WDay T.Month T.DoM T.TimeoD T.Year
        FileTime = T.TimeoD
        FileDate = T.WDay' 'T.DoM' 'T.Month' 'T.Year
        RecHandle = VRMethod("CN_Files", "Addrecord")
        ok = VRMethod("CN_Files", "SetFieldData", RecHandle, FPidFH, FPid, FileFH, File, FUserFH, Username, UidFH, Uid, DenyModeFH, DenyMode,  AccessFH, Access, RWFH, RW)
        ok = VRMethod("CN_Files", "SetFieldData", RecHandle, FIconH, "$45", TimeFH, FileTime, DateFH, FileDate, OplockFH, Oplock, SharePathFH, Sharepath, NameFH, Name)
        Zeile = linein(refreshoutput)
    end   
    File.0 = I
    FPID.0 = I

    ok = stream(refreshoutput, 'c','close')
    ok = SysFileDelete(refreshoutput)
    ok = stream(refresherr, 'c','close')
    ok = SysFileDelete(refreshouterr)
    if VRFileExists( samba.!bin"\smbsched.cmd" ) then do
        address cmd samba.!bin"\smbsched.cmd"
    end

    call _RefreshDaemons
    ok = VRSet("CN_Files","Painting", 1)
    if VRGet("Main", "WindowState") = "Minimized" then do
        ok = VRSet("TM_Refresh","Delay", IntervallMin * 1000)    
    end
    else do
        ok = VRSet("TM_Refresh","Delay", Intervall * 1000)
    end
    ok = VRSet("TM_refresh","Enabled", 1)

    IF options.!debug == 1 then say time()' _Refresh() done'
return
/*:VRX         _RefreshDaemons
*/
_RefreshDaemons: 
    IF options.!debug == 1 then say time()' _RefreshDaemons() started'
    ok = VRSet("TM_RefreshDaemons","Delay",3000)

    ok = VRSet("CN_Daemons","Painting", 0 )
    call VRSet VRWindow(), 'Pointer', 'Wait' 

    do I = 1 to smbdpidhandle.0
        ok = VRMethod("CN_Daemons", "RemoveRecord", smbdpidhandle.I ) 
    end

    do I = 1 to nmbdpidhandle.0
        ok = VRMethod("CN_Daemons", "RemoveRecord", nmbdpidhandle.I ) 
    end

    do I = 1 to winbpidhandle.0
        ok = VRMethod("CN_Daemons", "RemoveRecord", winbpidhandle.I ) 
    end

    Running = _SambaRunning()

    call VRSet VRWindow(), 'Pointer', '<default>'   

    smbdpids = pids.!smbd
    nmbdpids = pids.!nmbd
    winbpids = pids.!nmbd

    smbdRunning = running.!smbd
    nmbdRunning = running.!nmbd
    winbRunning = running.!winb

    if smbdRunning then do
        ok = VRMethod("CN_Daemons", "SetFieldData", smbdHandle, DStatusFH, NLVGetMessage(40), DPidsFH, smbdpids)
        ok = VRMethod("CN_Daemons", "SetRecordAttr", smbdHandle, "Icon", "$46")
        smbdpidhandle.0 = words(smbdpids)
        if options.!debug = 1 then do
            if smbdpidhandle.0 > prevsmbdct then do
                prevsmbdct = smbdpidhandle.0
                call beep 880*1, 10
                call beep 880*2, 10
                call beep 880*4, 10
            end
            if smbdpidhandle.0 < prevsmbdct then do
                prevsmbdct = smbdpidhandle.0
                call beep 880*4, 10
                call beep 880*2, 10
                call beep 880*1, 10
            end
        end

        do I = 1 to words(smbdpids)
            Username = ""
            do J = 1 to UPID.0
                if UPID.J = word(smbdpids,I) then do
                    Username = ' 'Username.J
                    leave
                end
            end
            smbdpidhandle.I = VRMethod( "CN_Daemons", "AddRecord", smbdhandle, , NLVGetMessage(130)' 'word(smbdpids,I)' ('d2x(word(smbdpids,I))'x)', "$48")
            /* we ping all smbd.exe except the first one */
            if DetectZombies = 1 & I > 1 then do
                ok = VRSet("Main", 'Pointer', 'Wait' )
                address cmd samba.!smbcontrolexe' 'word(smbdpids,I)' ping --timeout=2 --debuglevel=0 2>'samba.!error' 1>'samba.!msg
                ok = VRSet("Main", 'Pointer', '<default>' )
                response = linein(samba.!msg)
                ok = stream(samba.!msg,'c','close')
                if pos('PONG', response) = 0 then do /* we have a zombie */
                    ok = VRMethod( "CN_Daemons", "SetRecordAttr", smbdpidhandle.I,"Icon", "$49")
                    say "  Found Zombie "word(smbdpids,I)
                end
            end
            if Username <> "" then do
                smbdpidhandle.I.user = VRMethod( "CN_Daemons", "AddRecord", smbdpidhandle.I, , Username, "$44")
                do J = 1 to FPID.0
                    if FPID.J = word(smbdpids,I) then do
                        dummyHandle = VRMethod( "CN_Daemons", "AddRecord", smbdpidhandle.I.user, , File.J, "$45")
                    end
                end
            end
        end
    end
    else do
        ok = VRMethod("CN_Daemons", "SetFieldData", smbdHandle, DStatusFH, NLVGetMessage(41), DPidsFH, "")
        ok = VRMethod("CN_Daemons", "SetRecordAttr", smbdHandle, "Icon", "$47")
        if options.!debug = 1 then do
            if prevsmbdct > 0 then do
                prevsmbdct = 0
                call beep 880*4, 10
                call beep 880*2, 10
                call beep 880*1, 10
            end
        end
    end

    if nmbdRunning then do
        ok = VRMethod("CN_Daemons", "SetFieldData", nmbdHandle, DStatusFH, NLVGetMessage(40), DPidsFH, nmbdpids)
        ok = VRMethod("CN_Daemons", "SetRecordAttr", nmbdHandle, "Icon", "$46") 
        nmbdpidhandle.0 = words(nmbdpids)
        do I = 1 to words(nmbdpids)
            nmbdpidhandle.I = VRMethod( "CN_Daemons", "AddRecord", nmbdhandle, , NLVGetMessage(130)' 'word(nmbdpids,I)' ('d2x(word(nmbdpids,I))'x)', "$48")
        end
    end
    else do
        ok = VRMethod("CN_Daemons", "SetFieldData", nmbdHandle, DStatusFH, NLVGetMessage(41), DPidsFH, "")
        ok = VRMethod("CN_Daemons", "SetRecordAttr", nmbdHandle, "Icon", "$47") 
    end

    if winbRunning then do
        ok = VRMethod("CN_Daemons", "SetFieldData", winbHandle, DStatusFH, NLVGetMessage(40), DPidsFH, winbpids)
        ok = VRMethod("CN_Daemons", "SetRecordAttr", winbHandle, "Icon", "$46") 
        winbpidhandle.0 = words(winbpids)
        do I = 1 to words(winbpids)
            winbpidhandle.I = VRMethod( "CN_Daemons", "AddRecord", winbhandle, , NLVGetMessage(130)' 'word(winbpids,I)' ('d2x(word(winbpids,I))'x)', "$48")
        end
    end
    else do
        ok = VRMethod("CN_Daemons", "SetFieldData", winbHandle, DStatusFH, NLVGetMessage(41), DPidsFH, "")
        ok = VRMethod("CN_Daemons", "SetRecordAttr", winbHandle, "Icon", "$47") 
    end

    if \(smbdrunning|nmbdrunning|winbrunning) then do
        ok = VRSet("ICB_START",  "Enabled", 1)
        ok = VRSet("ICB_STOP",   "Enabled", 0)
        ok = VRSet("ICB_REStart","Enabled", 0)
        ok = VRSet("ICB_RELoad", "Enabled", 0)
    end
    else do
        ok = VRSet("ICB_START",  "Enabled", 0)
        ok = VRSet("ICB_STOP",   "Enabled", 1)
        ok = VRSet("ICB_REStart","Enabled", 1)
        ok = VRSet("ICB_RELoad", "Enabled", 1)
    end

    ok = (stream(samba.!bin'\winbindd.exe','c','query exists') <> "")
    ok = VRMethod("CN_Daemons", "SetRecordAttr", winbHandle, "Visible", ok)
    ok = VRSet("CN_Daemons","Painting", 1 )
    if Running then call _SambaUptime

    IF options.!debug == 1 then say time()' _RefreshDaemons() done'
return

/* 
_pids: procedure
    pongfile = arg(1)
    pids = ''
    do until lines(pongfile) = 0
        pongline = linein(pongfile)
        if word(Pongline,1) = 'PONG' then do
            parse var pongline pong from tpid pid
            pids = pids||pid', '
        end
        else pids = pids||pongline
    end 
    pids = strip(strip(pids),,',')
    ok = stream(pongfile,'c','close')
    ok = SysFileDelete(pongfile)
return pids
 */

/*  pingout = 'ping.out'
    '@smbcontrol -t 2 smbd ping -d 0 1>'pingout
    if rc = 0 then smbdRunning = 1
    ok = VRMethod("CN_Daemons", "SetFieldData", smbdHandle, DPidsFH, _pids(pingout))

    '@smbcontrol -t 2 nmbd ping -d 0 1>'pingout
    if rc = 0 then nmbdRunning = 1
    ok = VRMethod("CN_Daemons", "SetFieldData", nmbdHandle, DPidsFH, _pids(pingout))

    '@smbcontrol -t 1 winbindd ping -d 0 1>'pingout
    if rc = 0 then winbRunning = 1
    ok = VRMethod("CN_Daemons", "SetFieldData", winbHandle, DPidsFH, _pids(pingout))

    ok = SysFileDelete(PingOut)
*/
/*:VRX         _RefreshDaemonsDelay
*/
_RefreshDaemonsDelay: 
    IF options.!debug == 1 then say time()' _RefreshDaemonsDelay() started'
    IF options.!debug == 1 then say "  Old intervall = "VRGet("TM_RefreshDaemons","Delay")
    ok = VRSet("TM_RefreshDaemons","Delay",   60000)
    IF options.!debug == 1 then say "  New Intervall = "VRGet("TM_RefreshDaemons","Delay")
    IF options.!debug == 1 then say time()' _RefreshDaemonsDelay() done'
return

/*:VRX         _SambaFindPIDfile
*/
_SambaFindPIDfile: 
    IF options.!debug == 1 then say time()' _SambaFindPIDfile() started'

    ok = SysFileTree(ETC'\samba\pid\nmbd*pid',nmbdpid.,'FO')
    if nmbdpid.0 = 1 
        then nmbdpidfile = nmbdpid.1; 
        else nmbdpidfile = ""

    IF options.!debug == 1 then say "  nmbdpidfile = "nmbdpidfile

    IF options.!debug == 1 then say time()' _SambaFindPIDfile() done'
return

/*:VRX         _SambaShowError
*/
_SambaShowError: procedure expose samba. settings. options.
    I = 0
    do while lines(samba.!error) <> 0
        I = I + 1
        smberr.I = linein(samba.!error)
    end
    ok = stream(Samba.!error,"c","close")
    smberr.0 = I
    Buttons.1 = "OK" /* NLVGetMessage(2) */
    Buttons.0 = 1
    id = VRMessageStem( VRWindow(), "smberr.", VRGet("Main", "Caption") , "Error", "Buttons.", buttons.1, buttons.1 )
    ok = SysFileDelete(Samba.!error)    
return

/*:VRX         _SambaShowMsg
*/
_SambaShowMsg: procedure expose samba. settings. options.
    say "SambaShowMsg started"
    skipWords = arg(1)
    skip.0 = words(skipWords)
    do J = 1 to skip.0
        skip.J = translate(word(skipWords,J))
    end
    I = 0
    do while lines(samba.!msg) <> 0
        msgline = linein(samba.!msg)
        SkipIt = 0
        do J = 1 to skip.0
            if pos(skip.J,translate(msgline)) > 0 then do
                skipit = 1
                leave
            end
        end
        if \SkipIt then do
            I = I + 1
            smbmsg.I = strip(MsgLine)
        end
    end
    ok = stream(Samba.!msg,"c","close")
    say "  stream close "Samba.!msg" = "ok
    smbmsg.0 = I
    if smbmsg.0 > 0 then do
        Buttons.1 = "OK" /* NLVGetMessage(2) */
        Buttons.0 = 1
        id = VRMessageStem( VRWindow(), "smbmsg.", VRGet("Main", "Caption") , "I", "Buttons.", buttons.1, buttons.1 )
    end
    ok = SysFileDelete(Samba.!msg) 
    say "  Delete "Samba.!msg" = "ok
    say "SambaShowMsg done"
return
/*:VRX         _SambaUptime
*/
_SambaUptime: 
    IF options.!debug == 1 then say time()' _SambaUptime() started'
    call _SambaFindPIDfile
    if nmbdpidfile = "" then do
        ok = VRset("CN_Daemons", "Caption", NLVGetMessage(42)||" "||NLVGetMessage(41))
        return
    end

    StartTime = SysGetFileDateTime(nmbdpidfile)
    if StartTime = -1 then return

    NowTime   = substr(date('S'),1,4)'-'substr(date('S'),5,2)'-'substr(date('S'),7,2)' 'time()

 /* StartTime = "2007-12-31 00:00:00"
    NowTime   = "2008-03-05 08:59:50" */

    IF options.!debug == 1 then do
        say "  Start Time ='"StartTime"'"
        say "  Now   Time ='"NowTime"'"
    end

    doM.0 = 12 
    doM.1 = 31; doM.2 = 28; doM.3 = 31; doM.4 = 30; doM.5 = 31; doM.6 = 30;
    doM.7 = 31; doM.8 = 31; doM.9 = 30; doM.10= 31; doM.11= 30; doM.12= 31 

    parse var StartTime sY'-'sM'-'sD' 'sH':'sMi':'sS
    parse var NowTime nY'-'nM'-'nD' 'nH':'nMi':'nS

    if nY//4 = 0 & nY//400 <> 0 then doM.2 = 29

    /* say doM.2 */

    uY =nY-sY
    uM =nM-sM
    uD =nD-sD
    uH =nH-sH
    uMi=nMi-sMi
    uS =nS-sS



    if uS < 0 then do; uMi= uMi- 1; uS = uS + 60; end
    if uMi< 0 then do; uH = uH - 1; uMi= uMi+ 60; end
    if uH < 0 then do; uD = uD - 1; uH = uH + 24; end
    if uD < 0 then do; 
        /* uM = uM - 1; */
        if uM < 0 then uMx = uM + 12; else uMx = uM
        uD = uD + doM.uMx - 1; 
    end
    if uM < 0 then do; uY = uY - 1; uM = uM + 12; end

    /* say uY uM uD uH uMi uS */

    UpTimeStr = ' 'NlvGetMessage(43)':'
    if uY <> 0 then UpTimeStr = UpTimeStr' 'uY' 'NlvGetMessage(44)
    if uM <> 0 then UpTimeStr = UpTimeStr' 'uM' 'NlvGetMessage(45)
    if uD <> 0 then UpTimeStr = UpTimeStr' 'uD' 'NlvGetMessage(46)
    if uH <> 0 then UpTimeStr = UpTimeStr' 'uH' 'NlvGetMessage(47)
    if uMi<> 0 then UpTimeStr = UpTimeStr' 'uMi' 'NlvGetMessage(48)
    if uS <> 0 | UpTimeStr = ' 'NlvGetMessage(43)':' then UpTimeStr = UpTimeStr' 'uS' 'NlvGetMessage(49)

    loggingfreespace = word(sysdriveinfo(left(samba.!logdir,2)),2)%1024%1024
    ok = VRSet("DT_FREESPACE", "Caption", loggingfreespace' MB')
    ok = VRset("CN_Daemons", "Caption", UpTimeStr)

    select
        when loggingfreespace <  50 then ok = VRDeleteFile(samba.!logdir'\log.*')
        when loggingfreespace < 100 then ok = VRset("CN_Daemons","BackColor","Red")
        when loggingfreespace < 200 then ok = VRset("CN_Daemons","BackColor","Yellow")
        otherwise ok = VRset("CN_Daemons","BackColor","SystemWindow")       
    end

    IF options.!debug == 1 then say time()' _SambaUptime() done'
return

/*:VRX         _SendMsg
*/
_SendMsg: 
    Buttons.1 = NLVGetMessage( 2 )
    Buttons.2 = NLVGetMessage( 3 )
    Buttons.0 = 2
    Message  = "Blurp!"
    id = VRPrompt( VRWindow(), NLVGetMessage( 85 , CurMachine), "Message", NLVGetMessage( 80 ), "Buttons.", buttons.1, buttons.2 )

    MsgFile = SysTempFileName(TempDir'\smbmsg.'??? )
    call lineout MsgFile, Message
    ok = stream(MsgFile,'c','close')
say Message
    address cmd samba.!smbclientexe' --message='CurMachine' 'DebugLevel' <'MsgFile' 2>&1>'samba.!msg
    /* if rc <> 0 then call _SambaShowError; else */
    call _SambaShowMsg
    ok = SysFileDelete(MsgFile)
return

/*:VRX         _ShowMsg
*/
_ShowMsg: 
    Buttons.1 = NLVGetMessage(2)
    Buttons.0 = 1
    id = VRMessage( VRWindow(), Msg.Text, Msg.Title, Msg.Type, "Buttons.", buttons.1, buttons.1 )
return

/*:VRX         _SmbConfCreateShadowCopy
*/
_SmbConfCreateShadowCopy:
    if options.!debug == 1 then say time()' _SmbConfCreateShadowCopy started'
    /* we create a complete version of smb.conf in temporary directory for reading purposes */
    /* as we can only determine a default value from this complete version of the file */
    /* however it is not desirable to always have a complete copy normally */
    ok = SysFileDelete(samba.!shadowsmbconf)
    if dataype(log_Level) <> "NUM" then log_level = 2
    say     '  'samba.!testparmexe' -v -s -d='log_level' 1>'samba.!shadowsmbconf' 2>'TempDir'testparm.stderr'
    address cmd samba.!testparmexe' -v -s -d='log_level' 1>'samba.!shadowsmbconf' 2>'TempDir'testparm.stderr'
    if options.!debug == 1 then say time()' _SmbConfCreateShadowCopy done'
return

/*:VRX         _UserCredUpdate
*/
_UserCredUpdate:
    if options.!debug == 1 then say time()' _UserCredUpdate started'
    credentials.!username = VRGet("EF_USER1","Value")
    credentials.!password = VRGet("EF_PASSWORD1","Value")

    if pos("4OS2", value("COMSPEC",,"OS2ENVIRONMENT")) = 1 | pos(left(credentials.!password,1),'01234567890') > 0
        then UserCred = '--user='Credentials.!username'%%'Credentials.!password
        else UserCred = '--user='Credentials.!username'%'Credentials.!password

    if options.!storecreds = 1 & \(UserCred   = 'USERCRED'   | UserCred = '' | UserCred = '--user=%' | UserCred = '--user=%%' | UserCred = '-N') then do
        ok = _ucSetUc()
/*      ok = VRSet("Pict_PWINMEM","PicturePath","#36") */
        if options.!debug == 1 then call beep 2400, 10
    end
    else do
        if options.!debug == 1 then call beep 200, 20
/*      ok = VRSet("Pict_PWINMEM","PicturePath","#37") */
    end
    if options.!debug == 1 then say time()' _UserCredUpdate done'
return
/*:VRX         About_Close
*/
About_Close: 
    call About_Fini
return

/*:VRX         About_Create
*/
About_Create: 
    call About_Init
    ok = VRSet("About","Caption", NLVGetMessage(20))
    ok = VRSet("PB_AboutOK1","Caption", NLVGetMessage(2))
    SambaTeam.0 = 11
    SambaTeam.1 = 'Silvan Scherrer'
    SambaTeam.2 = 'Herwig Bauernfeind'
    SambaTeam.3 = 'Dmitrij Kuminov'
    SambaTeam.4 = 'Vitali Pelenyov'
    SambaTeam.5 = 'Paul Smedley'
    SambaTeam.6 = 'Yuri Dario'
    SambaTeam.7 = 'Alex Taylor'
    SambaTeam.8 = 'Nikolay Kolosov'
    SambaTeam.9 = 'All the Samba people'
    SambaTeam.10= 'All the ArcaNoae people'
    SambaTeam.11= 'All the netlabs people'
    ok = VRSet("About","Font", VRGet("SW_SETTINGS","Font"))
    ok = VRMethod("LB_SambaTeam","AddStringList", "SambaTeam." )
    ok = VRSet("DT_SambaTeam","Caption", NLVGetMessage(21))
    ok = VRSet("MLE_Version","Value", NLVGetMessage(1)||'0D0A'x||VRGet("Main", "Hinttext")||'0D0A'x||'0D0A'x||SambaVer)
return

/*:VRX         About_Fini
*/
About_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         About_Init
*/
About_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         Activate
*/
Activate: 
    parse arg Nr
    /* call PushbackAll */
    CurrentPageNr = Nr
    /* ok = VRSet("PB_"Nr,"Font","9.WarpSans Bold") */
/*  ok = VRSet("TAB_"Nr,"Top", TabTop-8)
    ok = VRSet("TAB_"Nr,"Left",TabWidth*(Nr-1)+PageLeft)
    ok = VRSet("TAB_"Nr,"PicturePath", "#1"||Nr||";#1"||Nr)
    ok = VRset("DT_PageName", "Caption", VRGet("TAB_"Nr, "UserData"))
    ok = VRSet("Page_"Nr,"Visible", 1)
    select 
        when Nr = 1 then ok = VRSet("IPB_paper","PicturePath","#4;#4")
        when Nr = Pages then ok = VRSet("IPB_paper","PicturePath","#6;#6")
        otherwise ok = VRSet("IPB_paper","PicturePath","#5;#5")
    end */
return

/*:VRX         CN_CHKTDB_ContextMenu
*/
CN_CHKTDB_ContextMenu: 
    if VRInfo("Top") < 400 & VRGet("CN_Files", "View") = "Detail" then call _ColumnsMenu "CN_Files"
    else do
        RH = VRInfo("Record")
        OH = VRInfo("Object")
        if RH <> "" then do
            ok = VRMethod( "Contextmenu_Files", "Popup", , , "", "PositionOnItem" )
        end
    end
return

/*:VRX         CN_Daemons_Click
*/
CN_Daemons_Click:
    IF options.!debug == 1 then say time()' CN_Daemons_Click() started' 
    NowClickedRecord = VRInfo("Record")
    say "  NowRecord  = '"NowClickedRecord"'"
    say "  LastRecord = '"LastClickedRecord"'"
    if NowClickedRecord <> LastClickedRecord then call _RefreshDaemonsDelay
    LastClickedRecord = NowClickedRecord
    IF options.!debug == 1 then say time()' CN_Daemons_Click() done' 
return

/*:VRX         CN_Daemons_ContextMenu
*/
CN_Daemons_ContextMenu: 
    IF options.!debug == 1 THEN SAY time()' CN_Daemons_ContextMenu() started'
    if VRInfo("Top") < 400 & VRGet("CN_Daemons", "View") = "Detail" then do
        say "  Going for column modification..."
        call _ColumnsMenu "CN_Daemons"
    end
    else do
        say "  Going for context menu, record = '"VRInfo("Record")"'"

        call _RefreshDaemonsDelay
        DRH = VRInfo("Record")
        DaemonName = ""

        OH = VRInfo("Object")
        ok = VRset("ContextMenu_Daemons_Details",   "Visible", 1 )
        ok = VRset("ContextMenu_Daemons_Tree",      "Visible", 1 )
        ok = VRset("MItem_9",                       "Visible", 1 )
        ok = VRset("ContextMenu_Daemons_Sort",      "Visible", 1 )
        ok = VRset("ContextMenu_Daemons_MiniIcons", "Visible", 1 )
        ok = VRset("MItem_13",                      "Visible", 1 )
        ok = VRset("ContextMenu_Daemons_Ping",      "Visible", 1 )
        ok = VRset("ContextMenu_Daemons_KillPID",   "Visible", 1 )
        ok = VRset("ContextMenu_Daemons_Start",     "Visible", 1 )
        ok = VRset("ContextMenu_Daemons_Shutdown",  "Visible", 1 )

        if DRH <> "" then do
            DaemonName = VRMethod("CN_Daemons", "GetRecordAttr", DRH, "Caption")
            ok = VRset("ContextMenu_Daemons_Ping","Visible", 1 )
        end

        select
            when Words(DaemonName) = 3 & pos("PID ",DaemonName) > 0 then do /* a child process with PID in name */
                DaemonName = word(DaemonName,2)
                ok = VRSet("ContextMenu_Daemons_KillPID", "Caption", NLVGetMessage( 38, DaemonName))
                ok = VRset("ContextMenu_Daemons_Start", "Visible", 0 )
            end
            when Words(DaemonName) = 1 & (pos("mbd.exe",Daemonname) > 0 | pos("winbindd.exe",Daemonname) > 0) then do /* on root process */
                parse var DaemonName DaemonName'.exe'
                if strip(VRMethod("CN_Daemons", "GetFieldData", DRH, DPidsFH)) <> "" then do
                    ok = VRSet("ContextMenu_Daemons_Shutdown",  "Caption", NLVGetMessage( 33, DaemonName))
                    ok = VRset("ContextMenu_Daemons_KillPID",   "Visible", 0 )
                    ok = VRset("ContextMenu_Daemons_Start",     "Visible", 0 )
                end
            end
            when pos("\", DaemonName) > 0 then do /* we are on a file */
                ok = VRset("MItem_13",                      "Visible", 0 )
                ok = VRset("ContextMenu_Daemons_Ping",      "Visible", 0 )
                ok = VRset("ContextMenu_Daemons_KillPID",   "Visible", 0 )
                ok = VRset("ContextMenu_Daemons_Start",     "Visible", 0 )
                ok = VRset("ContextMenu_Daemons_Shutdown",  "Visible", 0 )
            end
            otherwise do /* we are on a user */
                ok = VRset("MItem_13",                      "Visible", 0 )
                ok = VRset("ContextMenu_Daemons_Ping",      "Visible", 0 )
                ok = VRset("ContextMenu_Daemons_KillPID",   "Visible", 0 )
                ok = VRset("ContextMenu_Daemons_Start",     "Visible", 0 )
                ok = VRset("ContextMenu_Daemons_Shutdown",  "Visible", 0 )
            end
        end
        say '  Daemon is "'DaemonName'"'
        say '  DaemonView = "'DaemonView'"'
        if VRGet("CN_Daemons","View") = "Detail" then do
            ok = VRSet("ContextMenu_Daemons_Details", "Enabled", 0)
            ok = VRSet("ContextMenu_Daemons_Tree", "Enabled", 1)
        end
        else do
            ok = VRSet("ContextMenu_Daemons_Details", "Enabled", 1)
            ok = VRSet("ContextMenu_Daemons_Tree", "Enabled", 0)
        end
        DaemonView = VRGet("CN_Daemons","View")

        ok = VRMethod( "ContextMenu_Daemons", "Popup", , , "", "" )
    end
    IF options.!debug == 1 THEN SAY time()' CN_Daemons_ContextMenu() done'
return

/*:VRX         CN_Files_ContextMenu
*/
CN_Files_ContextMenu: 
    if VRInfo("Top") < 400 & VRGet("CN_Files", "View") = "Detail" then call _ColumnsMenu "CN_Files"
    else do
        RH = VRInfo("Record")
        OH = VRInfo("Object")
        if RH <> "" then do
            ok = VRMethod( "Contextmenu_Files", "Popup", , , "", "PositionOnItem" )
        end
    end
return

/*:VRX         CN_Service_ContextMenu
*/
CN_Service_ContextMenu: 
    if VRInfo("Top") < 400 & VRGet("CN_Service", "View") = "Detail" then call _ColumnsMenu "CN_Service"
    else do
    ok = VRSet("TM_refresh","Enabled", 0)
        SRH = VRInfo("Record")
        OH = VRInfo("Object")
        if SRH <> "" then do
            Service = VRMethod("CN_Service", "GetFieldData", SRH, ServiceFH)
            say '  Service is "'Service'"'
            ok = VRMethod( "ContextMenu_Service", "Popup", , , "", "" )
        end
    end
return

/*:VRX         CN_SMBTREE_Click
*/
CN_SMBTREE_Click: 
    rh = VRInfo('Record')
    if VRMethod( 'CN_SMBTREE', "ValidateRecord", rh) <> 1 then return
    userdata = VRMethod('CN_SMBTREE', 'GetRecordAttr', rh, 'UserData')
    parse var userdata . '|' userdata
    ok = VRset("Main","StatusText", userdata)
 

return

/*:VRX         CN_SMBTREE_ContextMenu
*/
CN_SMBTREE_ContextMenu: 
    if options.!debug == 1 then say time()' CN_SMBTREE_ContextMenu started'
    if VRInfo("Top") < 400 & VRGet("CN_SMBTREE", "View") = "Detail" then call _ColumnsMenu "CN_SMBTREE"
    else do
        call _dropdeprecated
        RH = VRInfo("Record")
        if RH <> "" then do
            call _GetSmbObjectProperties RH
            call _ContextMenuSelectedSet
            if SMBobj.udatatype <> "WORKGROUP" then do
                BrowsePath = _browsebuildpath(SMBObj.rh)
                parse var browsepath '\\'machine'\'sharename '\' browsepath
            end

            /* call _BrowseResetObject(SmbObj.rh) */

            CurMachine = SMBObj.Resname
            ok = VRMethod( "Contextmenu_Tree", "Popup", , , "", "PositionOnItem" )
        end
        else do
            say "nix '"RH"'"
            drop SMBObj. /* it is invalid */
            call _ContextMenuSelectedSet
        end
    end
    if options.!debug == 1 then say time()' CN_SMBTREE_ContextMenu done'
return

/*:VRX         CN_SMBTREE_DoubleClick
*/
CN_SMBTREE_DoubleClick:
    if options.!debug == 1 then say time()' CN_SMBTREE_DoubleClick started'

    call _dropdeprecated
    call _GetSmbObjectProperties VRInfo('Record')

/*  if options.!debug == 1 then say time()' CN_SMBTREE_DoubleClick done'
return */
    /* Enable last 2 lines for 2.0.x (to disable on the fly browsing) */

    if options.!debug == 1 then say '  Browsing "'SMBObj.udatatype'"'

    If SMBObj.udatatype = "DIRECTORY" then do
        BrowsePath = _browsebuildpath(SMBObj.rh)

        call _BrowseResetObject(SmbObj.rh)

        parse var browsepath '\\'machine'\'sharename '\' browsepath
        browsepath = browsepath'\*'

        call _BrowseDirectory
    end

    If SMBObj.udatatype = "FILE" then do
        BrowsePath = _browsebuildpath(SMBObj.rh)
        call _BrowseResetObject(SmbObj.rh)

        parse var browsepath '\\'machine'\'sharename '\' browsepath

        OpenOk = _browseobjectopen(machine,sharename,browsepath)

        if \OpenOK then do
            say "  Not connected - trying to connect"
            ok = VRMethod( "CN_SMBTREE", "SetRecordAttr", sharerh, "Selected", 1)
            OpenOk = 0
            if VRIsValidObject("PB_SMBTREE_CONNECT") then do
                call PB_SMBTREE_CONNECT_Click
                ok = VRMethod( "CN_SMBTREE", "SetRecordAttr", SMBObj.rh, "Selected", 1)
                OpenOk = _browseobjectopen(machine,sharename,browsepath)
            end
            if \OpenOk then do
                Msg.Text = "Not connected - cannot open - aborting!"
                Msg.Type = "E"
                call _ShowMsg
            end
        end
    end

    if SMBObj.udatatype = "DISK" then do
        machine  = VRMethod("CN_SMBTREE","GetRecordAttr",SMBObj.parentrh,"Caption")
        parse var machine machine '0D0A'x .
        machine = strip(machine)

        call _BrowseResetObject(SmbObj.rh)

        sharename = SMBObj.resname
        BrowsePath = ""

        call _BrowseDirectory
    end
    if options.!debug == 1 then say time()' CN_SMBTREE_DoubleClick done'
return
/*:VRX         CN_Users_ContextMenu
*/
CN_Users_ContextMenu: 
    if VRInfo("Top") < 400 & VRGet("CN_users", "View") = "Detail" then call _ColumnsMenu "CN_users"
    else do
        RH = VRInfo("Record")
        OH = VRInfo("Object")
        if RH <> "" then do
            CurMachine = VRMethod( "CN_users", "GetFieldData", RH, UMachineFH )
            ok = VRMethod( "Contextmenu_Users", "Popup", , , "", "PositionOnItem" )
        end
    end
return

/*:VRX         Columns_01_Click
*/
Columns_01_Click: 
    call _ColumnShow
return

/*:VRX         Columns_02_Click
*/
Columns_02_Click: 
    call _ColumnShow
return

/*:VRX         Columns_03_Click
*/
Columns_03_Click: 
    call _ColumnShow
return

/*:VRX         Columns_04_Click
*/
Columns_04_Click: 
    call _ColumnShow
return

/*:VRX         Columns_05_Click
*/
Columns_05_Click: 
    call _ColumnShow
return

/*:VRX         Columns_06_Click
*/
Columns_06_Click: 
    call _ColumnShow
return

/*:VRX         Columns_07_Click
*/
Columns_07_Click: 
    call _ColumnShow
return

/*:VRX         Columns_08_Click
*/
Columns_08_Click: 
    call _ColumnShow
return

/*:VRX         Columns_09_Click
*/
Columns_09_Click: 
    call _ColumnShow
return

/*:VRX         Columns_10_Click
*/
Columns_10_Click: 
    call _ColumnShow
return

/*:VRX         Columns_11_Click
*/
Columns_11_Click: 
    call _ColumnShow
return

/*:VRX         Columns_12_Click
*/
Columns_12_Click: 
    call _ColumnShow
return

/*:VRX         Columns_13_Click
*/
Columns_13_Click: 
    call _ColumnShow
return

/*:VRX         Columns_14_Click
*/
Columns_14_Click: 
    call _ColumnShow
return

/*:VRX         ContextMenu_Daemons_Details_Click
*/
ContextMenu_Daemons_Details_Click: 
    IF options.!debug == 1 THEN SAY time()' ContextMenu_Daemons_Tree_Click() started'
    ok = VRset("CN_Daemons","View","Detail")
    ok = VRset("ContextMenu_Daemons_Tree","Enabled",1)
    ok = VRset("ContextMenu_Daemons_Details","Enabled",0)
    ok = VRSet("TM_refresh","Enabled", 1)
    IF options.!debug == 1 THEN SAY time()' ContextMenu_Daemons_Tree_Click() done'
return

/*:VRX         ContextMenu_Daemons_KillPID_Click
*/
ContextMenu_Daemons_KillPID_Click: 
    Msg.Text = NLVGetMessage(39, DaemonName)
    Msg.Type = 'Q'
    if _MsgYesNo() = 1 then do
        ok = PRKillProcess("1",DaemonName )
        if ok = 0 then say ", success!"; else say ", error "ok

/*      say 'kill -9 'DaemonName
        address cmd 'kill -9 'DaemonName */
    end
    ok = VRSet("TM_Refresh","Enabled", 1)
return

/*:VRX         ContextMenu_Daemons_MiniIcons_Click
*/
ContextMenu_Daemons_MiniIcons_Click: 
    advanced.!bigicons = \advanced.!bigicons
    ok = VRset("CN_DAEMONS", "MiniIcons", \advanced.!bigicons)
    ok = VRset("CN_SMBTREE", "MiniIcons", \advanced.!bigicons)
    ok = VRset("ContextMenu_Tree_MiniIcons",  "Checked", \advanced.!bigicons)
    ok = VRset("ContextMenu_Daemons_MiniIcons",  "Checked", \advanced.!bigicons)
return

/*:VRX         ContextMenu_Daemons_Ping_Click
*/
ContextMenu_Daemons_Ping_Click: 
    ok = VRSet("Main", 'Pointer', 'Wait' )
    address cmd samba.!smbcontrolexe' 'DaemonName' ping --timeout=3 --debuglevel=0 2>'samba.!error' 1>'samba.!msg
    call _SambaShowMsg "section table registered"

    ok = VRSet("Main", 'Pointer', '<default>' )
    ok = VRSet("TM_refresh","Enabled", 1)
return

/*:VRX         ContextMenu_Daemons_Shutdown_Click
*/
ContextMenu_Daemons_Shutdown_Click: 
    Msg.Text = NLVGetMessage(34, DaemonName)
    Msg.Type = 'Q'
    if _MsgYesNo() = 1 then do
        address cmd samba.!smbcontrolexe' 'DaemonName' shutdown 2>'samba.!error' 1>'samba.!msg
        call _SambaShowMsg "section table registered tdb"
    end
    ok = VRSet("TM_Refresh","Enabled", 1)
return

/*:VRX         ContextMenu_Daemons_Sort_Click
*/
ContextMenu_Daemons_Sort_Click: 
    window = VRLoadSecondary( "SW_SORT", "W" )
return

/*:VRX         ContextMenu_Daemons_Start_Click
*/
ContextMenu_Daemons_Start_Click: 
    Msg.Text = NLVGetMessage(37, DaemonName)
    Msg.Type = 'Q'
    if _MsgYesNo() = 1 then do
        say samba.!smbcmd' start 'DaemonName
        address cmd samba.!smbcmd' start 'DaemonName
    end
    ok = VRSet("TM_Refresh","Enabled", 1)
return

/*:VRX         ContextMenu_Daemons_Tree_Click
*/
ContextMenu_Daemons_Tree_Click: 
    IF options.!debug == 1 THEN SAY time()' ContextMenu_Daemons_Tree_Click() started'
    ok = VRset("CN_Daemons","View","IconTree")
    ok = VRset("ContextMenu_Daemons_Tree","Enabled",0)
    ok = VRset("ContextMenu_Daemons_Details","Enabled",1)
    ok = VRSet("TM_refresh","Enabled", 1)
    IF options.!debug == 1 THEN SAY time()' ContextMenu_Daemons_Tree_Click() done'
return

/*:VRX         ContextMenu_Files_Sort_Click
*/
ContextMenu_Files_Sort_Click: 
    window = VRLoadSecondary( "SW_SORT", "W" )
return

/*:VRX         ContextMenu_Service_CloseShare_Click
*/
ContextMenu_Service_CloseShare_Click: 
    Msg.Text = NLVGetMessage(75, Service)
    Msg.Type = 'Q'
    if _MsgYesNo() = 1 then do
        address cmd samba.!smbcontrolexe' smbd close-share 'Service' --debuglevel=0' /* ' 2>'samba.!error' 1>'samba.!msg */
        /* No usable output from Samba here ! */
        /* call _SambaShowMsg */
        Msg.Text = NLVGetMessage(76, Service)
        Msg.Type = 'I'
        call _ShowMsg
    end
    ok = VRSet("TM_refresh","Enabled", 1)
return

/*:VRX         ContextMenu_Service_Sort_Click
*/
ContextMenu_Service_Sort_Click: 
    window = VRLoadSecondary( "SW_SORT", "W" )
return

/*:VRX         ContextMenu_Tree_ACLS_Click
*/
ContextMenu_Tree_ACLS_Click: 
    if options.!debug == 1 then say '  List ACLS for  "'SMBObj.udatatype'"'
    window = VRLoadSecondary( "SW_ACLS", "W" )
return

/*:VRX         ContextMenu_Tree_Details_Click
*/
ContextMenu_Tree_Details_Click: 
    ok = VRset("CN_SMBTREE","View","Detail")
    ok = VRset("ContextMenu_Tree_Tree","Enabled",1)
    ok = VRset("ContextMenu_Tree_Details","Enabled",0)
    ok = VRset("ContextMenu_Tree_Icons","Enabled",1)
    ok = VRset("TM_Throbber", "Enabled", 1)
    ok = VRset("Pict_Throbber", "Visible", 0)
    call _RefreshTree
return

/*:VRX         ContextMenu_Tree_Icons_Click
*/
ContextMenu_Tree_Icons_Click: 
    ok = VRset("CN_SMBTREE","View","Icon")
    ok = VRset("ContextMenu_Tree_Icons","Enabled",0)
    ok = VRset("ContextMenu_Tree_Tree","Enabled",1)
    ok = VRset("ContextMenu_Tree_Details","Enabled",1)
    ok = VRset("TM_Throbber", "Enabled", 1)
    ok = VRset("Pict_Throbber", "Visible", 1)
    call _RefreshTree
return

/*:VRX         ContextMenu_Tree_LOGIN_Click
*/
ContextMenu_Tree_LOGIN_Click: 
    window = VRLoadSecondary( "SW_LOGIN", "W" )

    /* call _UserCredUpdate */

return

/*:VRX         ContextMenu_Tree_LOGOFF_Click
*/
ContextMenu_Tree_LOGOFF_Click: 
    UserCred = '-N'
return

/*:VRX         ContextMenu_Tree_MiniIcons_Click
*/
ContextMenu_Tree_MiniIcons_Click: 
    advanced.!bigicons = \advanced.!bigicons
    ok = VRset("CN_DAEMONS", "MiniIcons", \advanced.!bigicons)
    ok = VRset("CN_SMBTREE", "MiniIcons", \advanced.!bigicons)
    ok = VRset("ContextMenu_Tree_MiniIcons",  "Checked", \advanced.!bigicons)
    ok = VRset("ContextMenu_Daemons_MiniIcons",  "Checked", \advanced.!bigicons)
return

/*:VRX         ContextMenu_Tree_SendMsg_Click
*/
ContextMenu_Tree_SendMsg_Click: 
    call _SendMsg 
return

/*:VRX         ContextMenu_Tree_Sort_Click
*/
ContextMenu_Tree_Sort_Click: 
    window = VRLoadSecondary( "SW_SORT", "W" )
return

/*:VRX         ContextMenu_Tree_Tree_Click
*/
ContextMenu_Tree_Tree_Click: 
    ok = VRset("CN_SMBTREE","View","IconTree")
    ok = VRset("ContextMenu_Tree_Tree","Enabled",0)
    ok = VRset("ContextMenu_Tree_Details","Enabled",1)
    ok = VRset("ContextMenu_Tree_Icons","Enabled",1)
    ok = VRset("TM_Throbber", "Enabled", 1)
    ok = VRset("Pict_Throbber", "Visible", 1)
    call _RefreshTree
return

/*:VRX         ContextMenu_Users_SendMsg_Click
*/
ContextMenu_Users_SendMsg_Click: 
    call _SendMsg 
return

/*:VRX         ContextMenu_Users_Sort_Click
*/
ContextMenu_Users_Sort_Click: 
    window = VRLoadSecondary( "SW_SORT", "W" )
return

/*:VRX         DT_STATUSBAR_ContextMenu
*/
DT_STATUSBAR_ContextMenu: 
    ok = VRSet("DT_STATUSBAR","Caption", VRGet("Main", "HintText"))
return

/*:VRX         EF_log_file_Change
*/
EF_log_file_Change: 
    advanced.!smbconfchanged = 1 
return

/*:VRX         Fini
*/
Fini:
    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         GetBootDrive
*/
GetBootDrive: 
/* Use SysBootDrive if possible */
If Rxfuncadd('SysBootDrive', 'RexxUtil', 'SysBootDrive') Then
   Return Left(Value('RUNWORKPLACE',,'OS2ENVIRONMENT'),2)
Else
   Return SysBootDrive()


/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         ICB_ABOUT_Click
*/
ICB_ABOUT_Click: 
    window = VRLoadSecondary( "About", "W" )
return

/*:VRX         ICB_APPLY_Click
*/
ICB_APPLY_Click: 
    IF options.!debug == 1 then say time()' PB_Apply_Click() started' 
    options.!Debug = VRGet("CB_Debug","set")
    if options.!Debug then ok = VRREdirectStdIO("ON")
                      else ok = VRREdirectStdIO("OFF")
    Intervall = VRGet("SPIN_Intervall","Value")
    ok = VRSet("TM_Refresh","Delay", Intervall * 1000)
    IntervallMin = VRGet("SPIN_IntervallMin","Value")

    NoMsgBox = VRGet("CB_NoMsgBox","set")
    say 'NoMsgBox = "'NoMsgBox'"'

    WPSStartStop = VRGet("CB_WPSStartStop","set")
    say 'WPSStartStop = "'WPSStartStop'"'

    DetectZombies = VRGet("CB_DetectZombies","set")
    say 'DetectZombies = "'DetectZombies'"'

    options.!storecreds = VRGet("CB_STORECREDS","Set")
    say "options.!storecreds = "options.!storecreds

    if advanced.!smbconfchanged = 1 then do
        log_level    = VRGet("SPIN_log_level","Value")
        log_file     = VRGet("EF_log_file","Value")
        max_protocol = VRGet("SPIN_max_protocol","Value")

        handle = IniOpen('global', samba.!smbconf)

        ok = IniSet('log level',    log_level,    handle)
        ok = IniSet('log file',     log_file,     handle)
        ok = IniSet('max protocol', max_protocol, handle)

        ok = IniSave(handle)
        ok = IniClose(handle)
        advanced.!smbconfchanged = 0
    end
    IF options.!debug == 1 then say time()' PB_Apply_Click() done' 
return

/*:VRX         ICB_EXIT_Click
*/
ICB_EXIT_Click: 
    say 'start ICB_EXIT_Click'
    Call Quit
    say 'done ICB_EXIT_Click'
return

/*:VRX         ICB_LOGIN_CANCEL_Click
*/
ICB_LOGIN_CANCEL_Click: 
/*  ok = VRSet("EF_USER","Value",VRGet("EF_USER1","Value"))
    ok = VRSet("EF_PASSWORD","Value",VRGet("EF_PASSWORD1","Value")) */
    options.!storecreds = VRGet("CB_STORECREDS1","Set")
    credentials.!entered = 1
    p_server = SMBObj.resname
    if p_server <> "" then do
        ok = _rpcqueryuser(p_server, VRGet("EF_USER1","Value"), VRGet("EF_PASSWORD1","Value"), VRGet("EF_USER1","Value"))

        if word(ok,1) = "1" then do
            call _StatusBarWrapper NLVGetMessage(107, rpc.queryuser.FULL_NAME)
            say 'rpc.queryuser.DIR_DRIVE    = "'rpc.queryuser.DIR_DRIVE'"'
            say 'rpc.queryuser.LOGON_SCRIPT = "'rpc.queryuser.LOGON_SCRIPT'"'
            call _UserCredUpdate
        end
        else do
            call _StatusBarWrapper VRGet("EF_USER1","Value")" \\"p_server": "rpc.queryuser.LOGONSTATUS
        end
    end

    call SW_LOGIN_Close
return

/*:VRX         ICB_LOGIN_OK_Click
*/
ICB_LOGIN_OK_Click: 
/*  ok = VRSet("EF_USER","Value",VRGet("EF_USER1","Value"))
    ok = VRSet("EF_PASSWORD","Value",VRGet("EF_PASSWORD1","Value")) */
    options.!storecreds = VRGet("CB_STORECREDS1","Set")
    credentials.!entered = 1
    p_server = SMBObj.resname
    if p_server <> "" then do
        ok = _rpcqueryuser(p_server, VRGet("EF_USER1","Value"), VRGet("EF_PASSWORD1","Value"), VRGet("EF_USER1","Value"))

        if word(ok,1) = "1" then do
            call _StatusBarWrapper NLVGetMessage(107, rpc.queryuser.FULL_NAME)
            say 'rpc.queryuser.DIR_DRIVE    = "'rpc.queryuser.DIR_DRIVE'"'
            say 'rpc.queryuser.LOGON_SCRIPT = "'rpc.queryuser.LOGON_SCRIPT'"'
            call _UserCredUpdate
        end
        else do
            call _StatusBarWrapper VRGet("EF_USER1","Value")" \\"p_server": "rpc.queryuser.LOGONSTATUS
        end
    end

    call SW_LOGIN_Close
return

/*:VRX         ICB_REFRESH_Click
*/
ICB_REFRESH_Click: 
    IF options.!debug == 1 then say time()' ICB_REFRESH_Click() started' 
    ok = SysSleep(0.3)

    say "  CurrentPageNr = "CurrentPageNr
    select
        when CurrentPageNr = 2 then do
            ok = VRset("Pict_Throbber", "Visible", 1)
            ok = VRset("TM_Throbber", "Enabled", 1)
            call _RefreshTree
        end
        when CurrentPageNr = 6 then do
            call _ChkTDB
        end
        otherwise call _Refresh
    end
    IF options.!debug == 1 then say time()' ICB_REFRESH_Click() done' 
return

/*:VRX         ICB_RELOAD_Click
*/
ICB_RELOAD_Click: 
    call VRSet VRWindow(), 'Pointer', 'Wait' 
    if WPSStartStop then do
        ok = SysOpenObject('<smb_reload>', 'DEFAULT', 1) 
    end
    else do
        call lineout samba.!bin"\smbstart", "reload"
        ok = stream(samba.!bin"\reload","c","close")
    end
    ok = VRSet("TM_Refresh","Delay", 2000)
    call VRSet VRWindow(), 'Pointer', '<default>' 
return

/*:VRX         ICB_RESTART_Click
*/
ICB_RESTART_Click: 
    call VRSet VRWindow(), 'Pointer', 'Wait' 
    if WPSStartStop then do
        ok = SysOpenObject('<smb_restart>', 'DEFAULT', 1) 
    end
    else do
        call lineout samba.!bin"\restart", "restart"
        ok = stream(samba.!bin"\restart","c","close")
    end
    ok = VRSet("TM_Refresh","Delay", 2000)
    call VRSet VRWindow(), 'Pointer', '<default>' 
return

/*:VRX         ICB_START_Click
*/
ICB_START_Click: 
    say "IPB_Start_Click started"
    call VRSet VRWindow(), 'Pointer', 'Wait' 
    if WPSStartStop then do
        ok = SysOpenObject('<smb_start>', 'DEFAULT', 1) 
    end
    else do
        call lineout samba.!bin"\smbstart", "smbstart"
        ok = stream(samba.!bin"\smbstart","c","close")
    end
    ok = VRSet("TM_Refresh","Delay", 2000)
    call VRSet VRWindow(), 'Pointer', '<default>' 
    say "IPB_Start_Click done"
return

/*:VRX         ICB_STOP_Click
*/
ICB_STOP_Click: 
    say "IPB_Stop_Click started"
    call VRSet VRWindow(), 'Pointer', 'Wait' 
    if WPSStartStop then do
        ok = SysOpenObject('<smb_stop>', 'DEFAULT', 1) 
    end
    else do
        call lineout samba.!bin"\smbstop", "smbstop"
        ok = stream(samba.!bin"\smbstop","c","close")
    end
    ok = VRSet("TM_Refresh","Delay", 2000)
    call VRSet VRWindow(), 'Pointer', '<default>' 
    say "IPB_Stop_Click done"
return

/*:VRX         Init
*/
Init:
window = VRWindow()
call VRMethod window, "CenterWindow"
call VRSet window, "Visible", 0
call VRMethod window, "Activate"
drop window
return

/*:VRX         LB_SortFields_Click
*/
LB_SortFields_Click: 
    call _ContainerSort
return

/*:VRX         Main_Activate
*/
Main_Activate: 
    call TM_Refresh_Trigger
    ok = VRset("TM_Refresh", "Enabled", 1)
return

/*:VRX         Main_Close
*/
Main_Close:
    call Quit
return

/*:VRX         Main_Create
*/
Main_Create:
    options.!debug    = 0
    if options.!debug == 1 then do
        ok = VRRedirectStdIO("ON")
        say time()' Main_Create started'
    end
    else ok = VRRedirectStdIO("OFF")
 
    call _LoadOtherFuncs
    call _InitTempDir

    call _IniRead
    call _NLVSetup

    call _SambaInit
    if \WPSStartStop then call _CreateSmbStarter
    if _SambaRunning() then call _SambaFindPIDfile
    call _ContainerInit
    call _GUIInit
   
    ok = VRMethod("ICB_Refresh","SetFocus")

    if options.!debug == 1 then say time()' Main_Create done'
return
/*:VRX         Main_Deactivate
*/
Main_Deactivate: 
    ok = VRset("TM_Refresh", "Enabled", 0)
return

/*:VRX         Main_Resize
*/
Main_Resize: 
    IF options.!debug == 1 THEN SAY time()' Main_Resize started'
    ok = VRSet("Main","Painting", 0)

 /* Basic measurements */
    main_iwidth  = VRGet("Main","InteriorWidth")                /* Width of window client-area */
    main_iheight = VRGet("Main","InteriorHeight")               /* Height of window client-area */

    /* if main_iheight < 5500 then ok = VRSet("Main","Height",6200) */
    sbar_height  = margin * 8                                          /* Height of status-bar */
    marginx2     = margin * 2                                   /* Common margin around controls */
    marginx4     = margin * 4

    pbtn_width   = 1200
    pbtn_dist    = 80 + pbtn_width
    pbtn_nr      = 4
    pbtn_pos     = max((main_iwidth - pbtn_Dist * pbtn_Nr)%2, 0)+ margin
    pbtn_height  = 460                                          /* Height of the panels' internal button areas */


    pane_height  = main_iheight- sbar_height - pbtn_height - margin * 7                   /* Height of notebook  */
    pane_width   = main_iwidth - marginx2              /* Width of the notebook panel */

    /* Tabbed Dialog */
    ok = VRset("TDL_1", "Top",    marginx2    )
    ok = VRset("TDL_1", "Left",   margin      )
    ok = VRset("TDL_1", "Width",  pane_width  )
    ok = VRset("TDL_1", "Height", pane_height )

    /* Statusbar */
    ok = VRSet("GB_STATUSBAR", "Left",  margin )
    ok = VRSet("GB_STATUSBAR", "Top",   main_iheight - sbar_height - margin )
    ok = VRSet("GB_STATUSBAR", "Height",sbar_height )
    ok = VRSet("GB_STATUSBAR", "Width", pane_width  )

    ok = VRSet("DT_STATUSBAR", "Top",   12 )
    ok = VRSet("DT_STATUSBAR", "Left",  12 )
    ok = VRSet("DT_STATUSBAR", "Height",sbar_height- 24)
    ok = VRSet("DT_STATUSBAR", "Width", pane_width - 24)

    ok = VRSet("ICB_REFRESH","top", pane_height + marginx4 )
    ok = VRSet("ICB_EXIT",   "top", pane_height + marginx4 )
    ok = VRSet("ICB_Apply",  "top", pane_height + marginx4 )
    ok = VRSet("ICB_About",  "top", pane_height + marginx4 )

    ok = VRSet("ICB_REFRESH","Width", pbtn_width )
    ok = VRSet("ICB_EXIT",   "Width", pbtn_width )
    ok = VRSet("ICB_Apply",  "Width", pbtn_width )
    ok = VRSet("ICB_About",  "Width", pbtn_width )

    ok = VRSet("ICB_REFRESH","Height", pbtn_Height )
    ok = VRSet("ICB_EXIT",   "Height", pbtn_Height )
    ok = VRSet("ICB_Apply",  "Height", pbtn_Height )
    ok = VRSet("ICB_About",  "Height", pbtn_Height )


    ok = VRSet("ICB_REFRESH","left",pbtn_pos + pbtn_dist * (pbtn_nr - 4))
    ok = VRSet("ICB_Apply",  "left",pbtn_pos + pbtn_dist * (pbtn_nr - 3))
    ok = VRSet("ICB_About",  "left",pbtn_pos + pbtn_dist * (pbtn_nr - 2))
    ok = VRSet("ICB_EXIT",   "left",pbtn_pos + pbtn_dist * (pbtn_nr - 1))

    ok = VRset("GB_CHKTDB","Top",    margin  )
    ok = VRset("GB_CHKTDB","Left",   marginx2)
    ok = VRset("GB_CHKTDB","Width",  pane_width - 760)
    ok = VRset("GB_CHKTDB","Height", pane_height- 1020)
    ok = VRset("CN_CHKTDB","Top",    margin)
    ok = VRset("CN_CHKTDB","Left",   margin)
    ok = VRset("CN_CHKTDB","Width",  pane_width - 760 - marginx2 )
    ok = VRset("CN_CHKTDB","Height", pane_height- 1020- marginx2 )

    ok = VRset("GB_USERS","Top",    margin  )
    ok = VRset("GB_USERS","Left",   marginx2)
    ok = VRset("GB_USERS","Width",  pane_width - 760)
    ok = VRset("GB_USERS","Height", pane_height- 1020)
    ok = VRset("CN_USERS","Top",    margin)
    ok = VRset("CN_USERS","Left",   margin)
    ok = VRset("CN_USERS","Width",  pane_width - 760 - marginx2 )
    ok = VRset("CN_USERS","Height", pane_height- 1020- marginx2 )

    ok = VRset("GB_FILES","Top",    margin  )
    ok = VRset("GB_FILES","Left",   marginx2)
    ok = VRset("GB_FILES","Width",  pane_width - 760)
    ok = VRset("GB_FILES","Height", pane_height- 1020)
    ok = VRset("CN_FILES","Top",    margin)
    ok = VRset("CN_FILES","Left",   margin)
    ok = VRset("CN_FILES","Width",  pane_width - 760 - marginx2 )
    ok = VRset("CN_FILES","Height", pane_height- 1020- marginx2 )

    ok = VRset("GB_SERVICE","Top",    margin  )
    ok = VRset("GB_SERVICE","Left",   marginx2)
    ok = VRset("GB_SERVICE","Width",  pane_width - 760)
    ok = VRset("GB_SERVICE","Height", pane_height- 1020)
    ok = VRset("CN_SERVICE","Top",    margin)
    ok = VRset("CN_SERVICE","Left",   margin)
    ok = VRset("CN_SERVICE","Width",  pane_width - 760 - marginx2 )
    ok = VRset("CN_SERVICE","Height", pane_height- 1020- marginx2 )

    ok = VRset("GB_DAEMONS","Top",    margin  )
    ok = VRset("GB_DAEMONS","Left",   marginx2)
    ok = VRset("GB_DAEMONS","Width",  pane_width -  760)
    ok = VRset("GB_DAEMONS","Height", pane_height- 1020)
    ok = VRset("CN_DAEMONS","Top",    margin)
    ok = VRset("CN_DAEMONS","Left",   margin)
    ok = VRset("CN_DAEMONS","Width",  pane_width -  760 - margin*4 - pbtn_width)
    ok = VRset("CN_DAEMONS","Height", pane_height- 1020 - marginx2 )

    ok = VRSet("ICB_START",  "Top",    pbtn_height*2 - marginx2)
    ok = VRSet("ICB_STOP",   "Top",    pbtn_height*3 - marginx2)
    ok = VRSet("ICB_Restart","Top",    pbtn_height*4 - marginx2)
    ok = VRSet("ICB_REload", "Top",    pbtn_height*5 - marginx2) 

    ok = VRSet("ICB_START",  "Left",   pane_width -  760 - marginx2 - pbtn_width)
    ok = VRSet("ICB_STOP",   "Left",   pane_width -  760 - marginx2 - pbtn_width)
    ok = VRSet("ICB_Restart","Left",   pane_width -  760 - marginx2 - pbtn_width)
    ok = VRSet("ICB_REload", "Left",   pane_width -  760 - marginx2 - pbtn_width)

    ok = VRSet("ICB_START",  "Width",    pbtn_width)
    ok = VRSet("ICB_STOP",   "Width",    pbtn_width)
    ok = VRSet("ICB_Restart","Width",    pbtn_width)
    ok = VRSet("ICB_Reload",  "Width",    pbtn_width) 

    ok = VRSet("ICB_START",  "Height",    pbtn_Height)
    ok = VRSet("ICB_STOP",   "Height",    pbtn_Height)
    ok = VRSet("ICB_Restart","Height",    pbtn_Height)
    ok = VRSet("ICB_Reload", "Height",    pbtn_Height) 


    ok = VRset("GB_SMBTREE","Top",    margin  )
    ok = VRset("GB_SMBTREE","Left",   marginx2)
    ok = VRset("GB_SMBTREE","Width",  pane_width - 760)
    ok = VRset("GB_SMBTREE","Height", pane_height- 1020)
    ok = VRset("CN_SMBTREE","Top",    margin)
    ok = VRset("CN_SMBTREE","Left",   margin)
    ok = VRset("CN_SMBTREE","Width",  pane_width - 760 - marginx2 )
    ok = VRset("CN_SMBTREE","Height", pane_height- 1020- marginx2 )

    ok = VRset("PICT_THROBBER", "Top",  VRGet("CN_SMBTREE","Height") % 2 - 100 )
    ok = VRset("PICT_THROBBER", "Left", VRGet("CN_SMBTREE","Width")  % 2 - 200 )

    ok = VRset("GB_SETTINGS","Top",    margin  )
    ok = VRset("GB_SETTINGS","Left",   marginx2)
    ok = VRset("GB_SETTINGS","Width",  pane_width - 760)
    ok = VRset("GB_SETTINGS","Height", pane_height- 1020- marginx2)


    /* check and empty event queue, trash spurious resize events */
    EventString = ''
    TrashedResize = 0
    do until EventString = 'nop'
        EventString = VREvent('N')
        if EventString <> 'nop' then do
            if EventString = 'CALL Main_Resize' then TrashedResize = 1
                                                else interpret eventString
        end
    end 
    if TrashedResize then CALL Main_Resize
    ok = VRSet("Main", "Painting", 1)

    IF options.!debug == 1 THEN SAY time()' Main_Resize done'
return

/*:VRX         Page1_Create
*/
Page1_Create: 

Return

/*:VRX         Page1_Init
*/
Page1_Init: 
    call _ContainerInit
return

/*:VRX         Page2_Create
*/
Page2_create:

Return
/*:VRX         Page2_init
*/
Page2_init: 

return

/*:VRX         Page3_Create
*/
Page3_create:

Return
/*:VRX         Page3_Init
*/
Page3_Init: 

return

/*:VRX         Page4_Create
*/
Page4_Create: 

Return
/*:VRX         Page4_init
*/
Page4_init: 

return

/*:VRX         Page5_Create
*/
Page5_Create: 

return

/*:VRX         Page5_Init
*/
Page5_Init: 

return

/*:VRX         Paper_Init
*/
Paper_Init: 
    ok = VRSet("IPB_Paper","Width" ,VRMethod( "Screen", "PixelsToTwips", 32 ))
    ok = VRSet("IPB_Paper","Height",VRMethod( "Screen", "PixelsToTwips", 32 ))
    ok = VRset("IPB_Paper","Left",VRget("GB_Main2","width")-420)
return

/*:VRX         PB_AboutOK1_Click
*/
PB_AboutOK1_Click: 
    call About_Close
return

/*:VRX         PB_AboutOK_Click
*/
PB_AboutOK_Click: 
    call About_Close
return

/*:VRX         PB_ACLS_OK_Click
*/
PB_ACLS_OK_Click: 
    call SW_ACLS_close
return

/*:VRX         PB_DELLOGS_Click
*/
PB_DELLOGS_Click: 
    call VRSet VRWindow(), 'Pointer', 'Wait' 
say VRGet("EF_LOG_FILE","Value")
say translate(VRGet("EF_LOG_FILE","Value"),'\','/')
    samba.!logdir = VRParseFileName(translate(VRGet("EF_LOG_FILE","Value"),'\','/'),"DP")
say samba.!logdir

    loggingfreespace = word(sysdriveinfo(left(samba.!logdir,2)),2)%1024%1024
    ok = VRSet("DT_FREESPACE", "Caption", loggingfreespace' MB') 


    ok = SysFileTree(samba.!logdir'\log.*', logs.,'FO')
    do I = 1 to logs.0
        ok = VRMethod( "CN_Daemons", "GetRecordList", "All", "handle." ) 
        KeepLog = 0
        do J = 1 to handle.0
            CurPID = VRMethod("CN_Daemons", "GetFieldData", handle.J, DPidsFH)
            if pos(CurPID,logs.I) > 0 then KeepLog = 1
        end
        if KeepLog = 0 then do
            say "Delete "logs.I
            ok = SysFileDelete(logs.I)
        end
    end

    loggingfreespace = word(sysdriveinfo(left(samba.!logdir,2)),2)%1024%1024
    ok = VRSet("DT_FREESPACE", "Caption", loggingfreespace' MB')    

    call VRSet VRWindow(), 'Pointer', '<default>'
return

/*:VRX         PB_Help_Click
*/
PB_Help_Click: 
    ok = VRMethod("Main", "InvokeHelp" ) 
return

/*:VRX         PB_Sort_Cancel_Click
*/
PB_Sort_Cancel_Click: 
    ok = VRset( Container, "DetailSort", Old.SortField )
    ok = VRSet( Container, "Sort", Old.SortOrder )
    ok = VRMethod( Container, "SortRecords" ) 
    drop Old.
    call SW_SORT_Close
return

/*:VRX         PB_Sort_OK_Click
*/
PB_Sort_OK_Click: 
    drop Old.
    call SW_SORT_Close
return

/*:VRX         PushbackAll
*/
PushbackAll: 
    Pages = 6
    /* Tab distance from top */
    TabTop = 20
    TabWidth = VRMethod( "Screen", "PixelsToTwips", 78 )
    TabHeight= VRMethod( "Screen", "PixelsToTwips", 24 )

    /* Page Position */
    PageLeft = 120
    PageTop = PageLeft + TabTop + 330

    /* Page size */
    PageHeight = 3000
    PageWidth = 3000
    call beep 880, 20
/*  ok = VRset("DT_PageName", "Caption", "")
    ok = VRSet("GB_Main","Left", 0)
    ok = VRSet("GB_Main","Top", TabTop+230)
    do I = 1 to Pages
        ok = VRSet("TAB_"I,"Top", TabTop)
        ok = VRSet("TAB_"I,"PicturePath","#2"||I||";#2"||I)
        ok = VRSet("TAB_"I,"Left",TabWidth*(I-1)+PageLeft)
        ok = VRSet("TAB_"I,"Width",TabWidth)
        ok = VRSet("TAB_"I,"Height",TabHeight)
        ok = VRSet("Page_"I,"Height", max(PageHeight,VRget("GB_Main2","Height")-600))
        ok = VRSet("Page_"I,"Width", max(PageWidth,VRget("GB_Main2","Width")-450))
        ok = VRSet("Page_"I,"Left", PageLeft)
        ok = VRSet("Page_"I,"Top", PageTop)
        ok = VRSet("Page_"I,"Visible", 0)
        ok = VRSet("Page_"I,"BackColor", "<default>")
    end */
return

/*:VRX         Quit
*/
Quit:
    call VRSet VRWindow(), 'Pointer', 'Wait' 
    call _IniWrite
    ok = VRRedirectStdIO("OFF")
    call _SambaFinish

    ok = SysFileDelete(smbdoutput)

    call lineout samba.!bin"\quit", "quit"
    ok = stream(samba.!bin"\quit","c","close")
    ok = SysSleep(1)
    ok = SysDestroyObject('<smbstarter>') 
    ok = SysFileDelete(samba.!bin'\smbstarter.cmd')
    ok = SysFileDelete(samba.!bin'\quit')
    call VRSet VRWindow(), 'Pointer', '<default>'

    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         RB_ACLS_NUMERIC_Click
*/
RB_ACLS_NUMERIC_Click: 
    aclsnumeric = '--numeric'
    ok = VRSet("DT_REV_CONT","Caption","")
    ok = VRMethod("CN_ACLS","RemoveRecord","ALL")
    ok = VRMethod("CN_ACLS","SetFieldAttr", ACL.userFH, "Visible", 0 )
    call _ACLSBrowse
return

/*:VRX         RB_ACLS_TEXT_Click
*/
RB_ACLS_TEXT_Click: 
    aclsnumeric = ''
    ok = VRSet("DT_REV_CONT","Caption","")
    ok = VRMethod("CN_ACLS","RemoveRecord","ALL")
    ok = VRMethod("CN_ACLS","SetFieldAttr", ACL.userFH, "Visible", 1 )
    call _ACLSBrowse
return

/*:VRX         RB_Sort_Ascending_Click
*/
RB_Sort_Ascending_Click: 
    SortOrder = "Ascending"
    call _ContainerSort
return

/*:VRX         RB_Sort_Descending_Click
*/
RB_Sort_Descending_Click: 
    SortOrder = "Descending"
    call _ContainerSort
return

/*:VRX         RB_Sort_None_Click
*/
RB_Sort_None_Click: 
    SortOrder = "None"
    call _ContainerSort
return

/*:VRX         SPIN_Intervall_Change
*/
SPIN_Intervall_Change: 
return

/*:VRX         SPIN_IntervallMin_Change
*/
SPIN_IntervallMin_Change: 
return

/*:VRX         SPIN_log_level_Change
*/
SPIN_log_level_Change: 
    advanced.!smbconfchanged = 1 
return

/*:VRX         SPIN_max_protocol_Change
*/
SPIN_max_protocol_Change: 
    advanced.!smbconfchanged = 1 
return

/*:VRX         SW_ACLS_Close
*/
SW_ACLS_Close: 
    call SW_ACLS_Fini
return

/*:VRX         SW_ACLS_Create
*/
SW_ACLS_Create: 
    call SW_ACLS_Init
    ACL.typeFH   = VRMethod( "CN_ACLS", "AddField", "String", "Type" )
    ACL.groupFH  = VRMethod( "CN_ACLS", "AddField", "String", "Group" )
    ACL.userFH   = VRMethod( "CN_ACLS", "AddField", "String", "User" )
    ACL.ADFH     = VRMethod( "CN_ACLS", "AddField", "String", "A/D" )
    ACL.flagsFH  = VRMethod( "CN_ACLS", "AddField", "String", "Flags" )
    ACL.accessFH = VRMethod( "CN_ACLS", "AddField", "String", "Access" )
    ok = VRMethod( "CN_ACLS", "RemoveRecord", "ALL")
    aclsnumeric = ''
    call _ACLSBrowse
return
/*:VRX         SW_ACLS_Fini
*/
SW_ACLS_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         SW_ACLS_Init
*/
SW_ACLS_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         SW_CHKTDB_Close
*/
SW_CHKTDB_Close: 
    call SW_CHKTDB_Fini
return

/*:VRX         SW_CHKTDB_Create
*/
SW_CHKTDB_Create: 
    call SW_CHKTDB_Init
return

/*:VRX         SW_CHKTDB_Fini
*/
SW_CHKTDB_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         SW_CHKTDB_Init
*/
SW_CHKTDB_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         SW_DAEMONS_Close
*/
SW_DAEMONS_Close: 
    call SW_DAEMONS_Fini
return

/*:VRX         SW_DAEMONS_Create
*/
SW_DAEMONS_Create: 
    call SW_DAEMONS_Init

    CALL NLVSetText 'CN_DAEMONS',     'Caption', 65
    
    CALL VRMethod 'TT_Main', 'Register', 'ICB_START',   NLVGetMessage(61)
    CALL VRMethod 'TT_Main', 'Register', 'ICB_STOP',    NLVGetMessage(62)
    CALL VRMethod 'TT_Main', 'Register', 'ICB_RESTART', NLVGetMessage(63)
    CALL VRMethod 'TT_Main', 'Register', 'ICB_RELOAD',  NLVGetMessage(64)
    CALL VRMethod 'TT_DAEMONS', 'Register', 'CN_DAEMONS',  NLVGetMessage(66)
return

/*:VRX         SW_DAEMONS_Fini
*/
SW_DAEMONS_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         SW_DAEMONS_Init
*/
SW_DAEMONS_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         SW_FILES_Close
*/
SW_FILES_Close: 
    call SW_FILES_Fini
return

/*:VRX         SW_FILES_Create
*/
SW_FILES_Create: 
    call SW_FILES_Init
    CALL VRMethod 'TT_FILES', 'Register', 'CN_FILES',  NLVGetMessage(68)
return

/*:VRX         SW_FILES_Fini
*/
SW_FILES_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         SW_FILES_Init
*/
SW_FILES_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "TDL" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         SW_LOGIN_Close
*/
SW_LOGIN_Close: 
    call SW_LOGIN_Fini
return

/*:VRX         SW_LOGIN_Create
*/
SW_LOGIN_Create: 
    call SW_LOGIN_Init
/*  ok = VRSet("SW_LOGIN","Caption",NLVGetMessage(136)' 'strip(p_workgroup' \\'p_server'\'p_share,'T','\')) */
    CALL NLVSetText 'DT_USER1',       "Caption", 131
    CALL NLVSetText 'DT_PASSWORD1',   "Caption", 23
/*  CALL NLVSetText 'CB_STORECREDS1', "Caption", 135 */
    CALL NLVSetText 'ICB_LOGIN_OK',    "Caption", 2
    CALL NLVSetText 'ICB_LOGIN_CANCEL',"Caption", 3

    if VRIsValidObject(SMBObj.rh) then do
        select
            when pos("PDC",VRMethod("CN_smbtree", "GetFieldData", SMBObj.rh, MBFH)) > 0 then LoginIcon = "#63:PMWP.DLL" /* icons.!pdc */
            when SMBObj.udatatype = "WORKGROUP" then LoginIcon = SMBObj.Icon
            when SMBObj.udatatype = "SERVER"    then LoginIcon = SMBObj.Icon
            when SMBObj.udatatype = "DISK"      then do
                if pos("PDC",VRMethod("CN_smbtree", "GetFieldData", SMBObj.parentrh, MBFH)) > 0
                    then LoginIcon = "#63:PMWP.DLL" /* icons.!pdc */
                    else LoginIcon = "#35:PMWP.DLL" /* icons.!pdc */
            end
            otherwise LoginIcon = "#35:PMWP.DLL" /* icons.!machine_awake */
        end
        say loginicon
        ok = VRSet("Pict_Login","PicturePath", LoginIcon)
    end
/*  ok = VRSet("EF_USER1","Value",VRGet("EF_USER","Value"))
    ok = VRSet("EF_PASSWORD1","Value",VRGet("EF_PASSWORD","Value")) */
say options.!storecreds
    ok = VRSet("CB_STORECREDS1","Set",options.!storecreds)
return

/*:VRX         SW_LOGIN_Fini
*/
SW_LOGIN_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         SW_LOGIN_Init
*/
SW_LOGIN_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         SW_SERVICE_Close
*/
SW_SERVICE_Close: 
    call SW_SERVICE_Fini
return

/*:VRX         SW_SERVICE_Create
*/
SW_SERVICE_Create: 
    call SW_SERVICE_Init
    CALL VRMethod 'TT_SERVICE', 'Register', 'CN_SERVICE',  NLVGetMessage(69)
return

/*:VRX         SW_SERVICE_Fini
*/
SW_SERVICE_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         SW_SERVICE_Init
*/
SW_SERVICE_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "TDL" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         SW_SETTINGS_Close
*/
SW_SETTINGS_Close: 
    call SW_SETTINGS_Fini
return

/*:VRX         SW_SETTINGS_Create
*/
SW_SETTINGS_Create: 
    call SW_SETTINGS_Init

    call SW_SETTINGS_Init_Content

say VRGet("EF_LOG_FILE","Value")
say translate(VRGet("EF_LOG_FILE","Value"),'\','/')
    samba.!logdir = VRParseFileName(translate(VRGet("EF_LOG_FILE","Value"),'\','/'),"DP")
say samba.!logdir
    CALL VRMethod 'TT_SETTINGS', 'Register', 'DT_FREESPACE', samba.!logdir' blums'
return

/*:VRX         SW_SETTINGS_Fini
*/
SW_SETTINGS_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         SW_SETTINGS_Init
*/
SW_SETTINGS_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "TDL" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         SW_SETTINGS_Init_Content
*/
SW_SETTINGS_Init_Content: 
    
    log_level    = IniGet('log level',    'global', samba.!smbconf)
    log_file     = IniGet('log file',     'global', samba.!smbconf)
    max_protocol = IniGet('max_protocol', 'global', samba.!smbconf)

    if log_level = "" then log_level = 2
    if max_protocol = "" then max_protocol = "NT1"

    ok = VRSet("SPIN_LOG_LEVEL","Value",log_level)
    ok = VRSet("EF_LOG_FILE","Value",log_file)
return

/*:VRX         SW_SMBTREE_Close
*/
SW_SMBTREE_Close: 
    call SW_SMBTREE_Fini
return

/*:VRX         SW_SMBTREE_Create
*/
SW_SMBTREE_Create: 
    call SW_SMBTREE_Init
return

/*:VRX         SW_SMBTREE_Fini
*/
SW_SMBTREE_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         SW_SMBTREE_Init
*/
SW_SMBTREE_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "TDL" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         SW_SMBTREE_Init_Content
*/
SW_SMBTREE_Init_Content: 
    ok = VRset("Pict_Throbber", "Visible", 1)
    ok = VRset("TM_Throbber", "Enabled", 1)
    call _RefreshTree
return

/*:VRX         SW_SORT_Close
*/
SW_SORT_Close: 
    call SW_SORT_Fini
return

/*:VRX         SW_SORT_Create
*/
SW_SORT_Create: 
    call SW_SORT_Init

    CALL NLVSetText 'SW_SORT',              'Caption', 35
    CALL NLVSetText 'PB_Sort_OK',           'Caption', 2
    CALL NLVSetText 'PB_Sort_Cancel',       'Caption', 3

    CALL NLVSetText 'RB_Sort_Ascending',    'Caption', 90
    CALL NLVSetText 'RB_Sort_Descending',   'Caption', 91
    CALL NLVSetText 'RB_Sort_None',         'Caption', 92

    Container = OH
say OH
say Container
    ok = VRMethod(Container, "GetFieldList", "Fields." )

    SortOrder = "None"

    do I = 1 to Fields.0
        ok = VRMethod("LB_SortFields","AddString", VRMethod(Container, "GetFieldAttr", fields.I, "Title" ))
    end    
    Old.SortField = VRGet( Container, "DetailSort" )
    Old.SortOrder = VRGet( Container, "Sort" )
say Old.SortField
say Old.SortOrder
return

/*:VRX         SW_SORT_Fini
*/
SW_SORT_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         SW_SORT_Init
*/
SW_SORT_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         SW_USERS_Close
*/
SW_USERS_Close: 
    call SW_USERS_Fini
return

/*:VRX         SW_USERS_Create
*/
SW_USERS_Create: 
    call SW_USERS_Init
    CALL VRMethod 'TT_USERS', 'Register', 'CN_USERS',  NLVGetMessage(67)
return

/*:VRX         SW_USERS_Fini
*/
SW_USERS_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         SW_USERS_Init
*/
SW_USERS_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         TDL_1_PageSelected
*/
TDL_1_PageSelected: 
    page =  VRInfo("Page")
    CurrentPageNr = page
    ok = VRSet("TM_RefreshDaemons","Enabled", 0)
    ok = VRSet("DT_STATUSBAR","Caption", VRGet("Main", "HintText"))
    ok = VRSet("CN_DAEMONS","Visible", 0)
    ok = VRSet("CN_SMBTREE","Visible", 0)
    ok = VRSet("CN_USERS",  "Visible", 0)
    ok = VRSet("CN_FILES",  "Visible", 0)
    ok = VRSet("CN_SERVICE","Visible", 0)
    ok = VRSet("CN_CHKTDB", "Visible", 0)
    ok = VRSet("GB_SETTINGS","Visible", 0)

    select 
        when page = 1 then do /* daemons */
            ok = VRSet("CN_DAEMONS","Visible", 1)
            ok = VRSet("Main","WindowIcon","$46")
            ok = VRSet("TM_RefreshDaemons","Enabled", 1)
            ok = VRSet("TM_RefreshDaemons","Delay",   3000)
        end
        when page = 2 then do /* smbtree */
            ok = VRSet("CN_SMBTREE","Visible", 1)
            ok = VRSet("Main","WindowIcon","$1")
            ok = VRMethod( "CN_SMBTREE", "GetRecordList", "All", "handle." ) 
            /* if the page is empty, populate it */
            if handle.0 = 0 then call ICB_REFRESH_Click
        end
        when page = 3 then do /* Users */
            ok = VRSet("CN_USERS","Visible", 1)
            ok = VRSet("Main","WindowIcon","$44")
        end
        when page = 4 then do /* files */
            ok = VRSet("CN_FILES",  "Visible", 1)
            ok = VRSet("Main","WindowIcon","$1")
        end
        when page = 5 then do /* service */
            ok = VRSet("CN_SERVICE","Visible", 1)
            ok = VRSet("Main","WindowIcon","$52")
        end
        when page = 6 then do /* chkTDB */
            ok = VRSet("CN_CHKTDB", "Visible", 1)
            ok = VRSet("Main","WindowIcon","$53")
            say "ChkTDB"
            call _ChkTDB
        end
        when page = 7 then do /* Settings */
            ok = VRSet("GB_SETTINGS","Visible", 1)
            ok = VRSet("Main","WindowIcon","$53")
            call SW_SETTINGS_Init_Content
        end
        otherwise nop
    end
return

/*:VRX         TM_Refresh_Trigger
*/
TM_Refresh_Trigger: 
/*  call beep 1200, 20 */
    ok = VRSet("TM_Refresh","Delay", Intervall * 1000)
    call _Refresh
return

/*:VRX         TM_RefreshDaemons_Trigger
*/
TM_RefreshDaemons_Trigger: 
    ok = VRSet("TM_RefreshDaemons","Delay", 3000)
    call _RefreshDaemons
    call _AddSharesDisplay
return

/*:VRX         TM_RefreshTreeDisplay_Trigger
*/
TM_RefreshTreeDisplay_Trigger: 
    select 
        when RefreshMode = "TREE" then do
            call _RefreshTreeDisplay
        end
        when RefreshMode = "SHARE" then do
            call _AddSharesDisplay    
        end
        otherwise say "RefreshMode = "RefreshMode
    end
return

/*:VRX         TM_STATUSBAR_Trigger
*/
TM_STATUSBAR_Trigger: 
    call _StatusBarReset
return

/*:VRX         TM_Throbber_Trigger
*/
TM_Throbber_Trigger: 
    pIdx = VRGet("Pict_Throbber","PicturePath")
    parse var pIdx '#' pidx
    pidx = pidx + 1
    if pidx = 122 then pidx = 111
    ok = VRSet("Pict_Throbber","PicturePath","#"pidx)
return

