<?PHP

/* RDFInt.php - RDF Interfaces for PHP
 * Copyright 2011 netlabs.org
 * Author: Christian Langanke, Adrian Gschwend
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// ------ configure ARC2 - mandantory
define( 'ARC2', getenv( 'PHP_LIBROOT_ARC2'));

// ----- configure fDebug - optional
// define locations of required external libraries
define( 'fDebug', getenv( 'PHP_LIBROOT_FDEBUG'));
if (fDebug !== '') {

  // define base name of sample in fDebug
  define( 'SAMPLE_NAME', 'RDFInt Sample');

  // activate debug output of the library classes
  // if not set, only the sample code itself generates debug messages
  define( 'RDFA_DEBUGOUTPUT_CLASSES', true);

  // activate debug output for specific RDFaLIB classes in samples and unittests
  define( 'RDFA_DEBUGOUTPUT_READER', true);
  define( 'RDFA_DEBUGOUTPUT_PROJECTION', true);
  define( 'RDFA_DEBUGOUTPUT_SPARQLENDPOINT', true);
  define( 'RDFA_DEBUGOUTPUT_SPARQLQUERY', true);
}

// define location of rdfint
// TODO - replace with autoload code
define( 'RDFINT', getenv( 'PHP_LIBROOT_RDFINT'));
require_once( RDFINT.'/rdfa.php');

?>
