<?PHP

/* RDFInt.php - RDF Interfaces for PHP
 * Copyright 2011 netlabs.org
 * Author: Christian Langanke, Adrian Gschwend
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

$fdebug = \fDebug::getInstance();
If (isset( $_SERVER["SERVER_NAME"]))
  $fdebug->setSession( $_SERVER["SERVER_NAME"]);
else {
  $unittest_name = str_replace( '_', ' ', basename( getcwd()));
  $fdebug->setSession( 'localhost', SAMPLE_NAME . ' ' . $unittest_name);
}
$fdebug->openSocket( '127.0.0.1');
$fdebug->sendSource( '<?xml version="1.0" ?><emptysource/>');

// if fDebug implementation already supports filtering,
// filter out log messages of the library classes, as configured
if (method_exists( $fdebug, 'setContextFilter')) {
  if (!RDFA_DEBUGOUTPUT_READER)         $fdebug->setContextFilter( 'RDFA_READER');
  if (!RDFA_DEBUGOUTPUT_PROJECTION)     $fdebug->setContextFilter( 'RDFA_PROJECTION');
  if (!RDFA_DEBUGOUTPUT_SPARQLENDPOINT) $fdebug->setContextFilter( 'RDFA_SPARQLENDPOINT');
  if (!RDFA_DEBUGOUTPUT_SPARQLQUERY)    $fdebug->setContextFilter( 'RDFA_SPARQLQUERY');
}
?>