Option Explicit

'  RDFInt.php - RDF Interfaces for PHP
'  Copyright 2011 netlabs.org
'  Author: Christian Langanke, Adrian Gschwend
'
'  Licensed under the Apache License, Version 2.0 (the "License");
'  you may not use this file except in compliance with the License.
'  You may obtain a copy of the License at
'
'      http://www.apache.org/licenses/LICENSE-2.0
'
'  Unless required by applicable law or agreed to in writing, software
'  distributed under the License is distributed on an "AS IS" BASIS,
'  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
'  See the License for the specific language governing permissions and
'  limitations under the License.

Const CONST_REGVAL_PREFBROWSER_FILETYPE = "HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Explorer\FileExts\.html\UserChoice\Progid"
Const CONST_REGSUBVALL_FILETYPE_COMMAND = "shell\open\command\"

Dim rc : rc = Main
WScript.Quit rc

'===============================================================
Function Main( )
  Main = 0

  Dim oFSO : Set oFSO = CreateObject("Scripting.FileSystemObject")
  Dim oWshShell : Set oWshShell = Wscript.CreateObject("Wscript.Shell")

  ' get name of configfile from 1st parm
  If (WScript.Arguments.Count = 0) Then
    WScript.Echo "Error: no config file specified!"
    Main = 87
    Exit Function
  End If
  Dim strIndexFile : strIndexFile = oFSO.GetAbsolutePathName( WScript.Arguments(0))
  If (Not oFSO.FileExists( strIndexFile)) Then
    WScript.Echo "Error: file not found: " & strCfgFile
    Main = 2
    Exit Function
  End If

  ' get command for default browser
  Dim strUrl : strUrl = "file:///" & Replace( strIndexFile, "\", "/")
  Dim strFileType : strFileType = oWshShell.RegRead( CONST_REGVAL_PREFBROWSER_FILETYPE)
  Dim strExec : strExec = oWshShell.RegRead( "HKEY_CLASSES_ROOT\" & strFileType & "\" & CONST_REGSUBVALL_FILETYPE_COMMAND)
  If (InStr( strExec, "%1") > 0) Then
    strExec = Replace( strExec, "%1", strUrl)
  Else
    strExec = strExec & " """ & strUrl & """"
  End If

  ' launch browser with file
  oWshShell.Run strExec

End Function
'===============================================================
