<?php

/* RDFInt.php - RDF Interfaces for PHP
 * Copyright 2011 netlabs.org
 * Author: Christian Langanke, Adrian Gschwend
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

namespace rdfa;

/**
 *  \class  SparqlQuery
 *  \brief  This class implements a class for executing SPARQL queries agains an endpoint
 *          by the Data::parse method.
 *  \author Christian Langanke
 *  \author Adrian Gschwend
 *  \date   2011
 */

class SparqlQuery {

  /**
   * Version of the class
   */
  const version = '1.0.0';
  /**
   * Name of the fDebug context
   */
  const debugcontext = 'RDFA_SPARQLQUERY';

  private $debugger;
  private $endpoint;
  private $statement;

  // ---------------------------------------

  /**
   * Creates a SPARQL qery class instance.
   *
   * \param endpoint     instance of SparqlEndpoint holding the endpoint configuration
   * \param statement    SPARQL CONSTRUCT query statement to execute.
   *
   * Note: to effectively execute the query, invoke the method
   * - rdfa::SparqlQuery::run()
   */
  public function __construct( $endpoint, $statement) {

    // setup debugger
    $this->debugger = \fDebug::getInstance();

    // check for required class
    if ((!is_object( $endpoint)) ||
        ('\\' . get_class(  $endpoint) != '\\rdfa\\SparqlEndpoint'))
      throw new \Exception( get_class().'::__construct: Parameter $endpoint is not object of class \rdfa\SparqlEndpoint.');

    // check for statement, may not be empty
    if (strlen( $statement) < 1)
      throw new \Exception( get_class().'::__construct: Parameter $statement is empty.');

    // initialize instance vars
    $this->endpoint  = $endpoint;
    $this->statement = $statement;

    $debugmessage = "Creating SPARQL query object\n" . 
                    "SPARQL query statement: \n" .
                    $this->getStatement();
    $this->debugger->sendMessage( $debugmessage, self::debugcontext);

  } // public function __construct

  // ---------------------------------------

  /**
   * Gets the SPARQL query statementof the object.
   */

  public function getStatement() {
    return $this->statement;
  }

  // ---------------------------------------

  /**
   * Runs the SPARQL query of the object.
   *
   * Returns indexed RDF data.
   */

  public function run() {
    $store = \ARC2::getRemoteStore( $this->endpoint->getConfigurationValues());

    $debugmessage = "Executing SPARQL query\n" .
                    "SPARQL query statement: \n" .
                    $this->getStatement();
    $this->debugger->sendMessage( $debugmessage, self::debugcontext);
    return $store->query( $this->statement, 'raw');
  }

} // class SparqlEndpoint

?>