<?php

/* RDFInt.php - RDF Interfaces for PHP
 * Copyright 2011 netlabs.org
 * Author: Christian Langanke, Adrian Gschwend
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

namespace rdfa;

/**
 *  \class  SparqlEndpoint
 *  \brief  This class implements the configuration class for SPARQL endpoints, used
 *          for creation of rdfa::SparqlQuery objects.
 *  \author Christian Langanke
 *  \author Adrian Gschwend
 *  \date   2011
 */

class SparqlEndpoint {

  /**
   * Version of the class
   */
  const version = '1.0.0';
  /**
   * Name of the fDebug context
   */
  const debugcontext = 'RDFA_SPARQLENDPOINT';

  private $debugger;
  private $aconfig;

  // ---------------------------------------

  /**
   * Creates an endpoint configuration class instance.
   */
  public function __construct( $aconfig) {

    // setup debugger
    $this->debugger = \fDebug::getInstance();

    // initialize instance vars
    $this->aconfig = array();
    
    // store inital configuration
    if (is_array( $aconfig)) {
      $this->aconfig = $aconfig;
      $debugmessage = "Creating endpoint configuration\n";
      foreach ($aconfig as $name => $value) {
        $debugmessage .= "$name=$value\n";
      }
      $this->debugger->sendMessage( $debugmessage, self::debugcontext);
    } else {
      $debugmessage = "Missing configuration parameters provided for endpoint configuration!";
      $this->debugger->sendWarning( $debugmessage, self::debugcontext);
    }

  } // public function __construct

  // ---------------------------------------

  /**
   * Sets an endpoint configuration values
   */
  public function setConfigurationValue( $name, $value) {
    $this->debugger->sendMessage( "Send endpoint configuration value $name=$value", self::debugcontext);
    $this->aconfig[ $name] = $value;
    return;
  }

  // ---------------------------------------

  /**
   * Gets an endpoint configuration values
   */
  public function getConfigurationValue( $name) {
    if (!isset( $this->aconfig[ $name]))
      return false;
    else
      return $this->aconfig[ $name];
  }

  // ---------------------------------------

  /**
   * Queries the list of all endpoint configuration values
   */
  public function getConfigurationValues( ) {
    return $this->aconfig;
  }

} // class SparqlEndpoint

?>