#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>

#ifdef __OS2__

#include <io.h>

#define INCL_DOSFILEMGR
#include <os2.h>

void doDosQueryHType(HFILE hfile)
{
    ULONG type, attr;
    APIRET arc = DosQueryHType(hfile, &type, &attr);
    if (arc == 0)
        printf("DosQueryHType(%ld) type %lx attr %lx\r\n", hfile, type, attr);
    else
        printf("DosQueryHType(%ld) rc %ld\r\n", hfile, arc);
}

#endif

int main(int argc, char *argv[])
{
    int         n;
    FILE        *fp;
    char        buffer[4096];

#ifdef __OS2__
    _fsetmode(stdin, "b");
    _fsetmode(stdout, "b");
    _fsetmode(stderr, "b");
#endif

#if 0
	printf("isatty(stdin) %d\r\n", isatty(fileno(stdin)));
	printf("isatty(stdout) %d\r\n", isatty(fileno(stdout)));
	printf("isatty(stderr) %d\r\n", isatty(fileno(stderr)));

#ifdef __OS2__
    doDosQueryHType((HFILE)0);
    doDosQueryHType((HFILE)1);
    doDosQueryHType((HFILE)2);
#endif
#endif    

    if( argc > 2 )
    {
        switch( atoi( argv[1] ) )
        {
        case 0:
            if( (fp = fopen(argv[2], "wb" )) != NULL )
            {
                while( (n = fread(buffer, 1, sizeof(buffer), stdin)) > 0 )
                {
                    fwrite(buffer, 1, n, fp);
                }

                fclose( fp );
            }

            return 0;

        case 1:
            if( (fp = fopen(argv[2], "rb" )) != NULL )
            {
                while( (n = fread(buffer, 1, sizeof(buffer), fp)) > 0 )
                {
                    fwrite(buffer, 1, n, stdout);
                }

                fclose( fp );
            }

            return 0;

        case 2:
            if( (fp = fopen(argv[2], "rb" )) != NULL )
            {
                while( (n = fread(buffer, 1, sizeof(buffer), fp)) > 0 )
                {
                    fwrite(buffer, 1, n, stderr);
                }

                fclose( fp );
            }

            return 0;
        }
    }
    else if (argc == 2)
    {
        switch (atoi (argv[1]))
        {
        case 3:
            while ((n = fread (buffer, 1, sizeof (buffer), stdin)) > 0)
            {
                fwrite (buffer, 1, n, stdout);
            }

            return 0;

        case 4:
            while (!feof (stdin) && !ferror (stdin))
            {
                n = fread (buffer, 1, sizeof (buffer), stdin);
                fwrite (buffer, 1, n, stdout);
            }

            return 0;
        }
    }

    return -1;
}
