/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Qt Software Information (qt-info@nokia.com)
**
** Copyright (C) 2009 netlabs.org. OS/2 parts.
**
** This file is part of the QtGui module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial Usage
** Licensees holding valid Qt Commercial licenses may use this file in
** accordance with the Qt Commercial License Agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Nokia.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain
** additional rights. These rights are described in the Nokia Qt LGPL
** Exception version 1.0, included in the file LGPL_EXCEPTION.txt in this
** package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
** $QT_END_LICENSE$
**
****************************************************************************/

#include "qt_os2.h"

#include "qapplication.h"
#include "qapplication_p.h"

#include "qwidget.h"
#include "qpointer.h"
#include "qcolormap.h"
#include "qpixmapcache.h"

#include "qset.h"

#include "qwidget_p.h"
#include "qkeymapper_p.h"
#include "qcursor_p.h"

QT_BEGIN_NAMESPACE

/*****************************************************************************
  Internal variables and functions
 *****************************************************************************/

static HWND	 curWin		= 0;		// current window
static HPS	 displayPS	= 0;		// display presentation space

static bool replayPopupMouseEvent = false; // replay handling when popups close

// ignore the next release event if return from a modal widget
static bool ignoreNextMouseReleaseEvent = false;

#if defined(QT_DEBUG)
static bool appNoGrab = false; // mouse/keyboard grabbing
#endif

static bool app_do_modal = false; // modal mode
extern QWidgetList *qt_modal_stack;
extern QDesktopWidget *qt_desktopWidget;
static QPointer<QWidget> popupButtonFocus;
static bool	qt_try_modal(QWidget *, QMSG *, int& ret);

static QWidget *qt_button_down = 0; // widget got last button-down

static HWND autoCaptureWnd = NULLHANDLE;
static void setAutoCapture(HWND); // automatic capture
static void releaseAutoCapture();

static void unregWinClasses();

extern QCursor *qt_grab_cursor();

extern "C" MRESULT EXPENTRY QtWndProc(HWND, ULONG, MPARAM, MPARAM);

class QETWidget : public QWidget                // event translator widget
{
public:
    QWExtra    *xtra() { return d_func()->extraData(); }
    QTLWExtra  *topData() { return d_func()->topData(); }
// @todo later
//  QTLWExtra  *maybeTopData() { return d_func()->maybeTopData(); }
//  void syncBackingStore(const QRegion &rgn) { d_func()->syncBackingStore(rgn); }
//  void syncBackingStore() { d_func()->syncBackingStore(); }
//  QWidgetData *dataPtr() { return data; }
//  QWidgetPrivate *dptr() { return d_func(); }
//  QRect frameStrut() const { return d_func()->frameStrut(); }
//  bool        winEvent(QMSG *m, long *r) { return QWidget::winEvent(m, r); }
//  void        markFrameStrutDirty() { data->fstrut_dirty = 1; }
//  bool        translateMouseEvent(const MSG &msg);
//  bool        translateWheelEvent(const MSG &msg);
//  bool        translatePaintEvent(const MSG &msg);
//  bool        translateConfigEvent(const MSG &msg);
//  bool        translateCloseEvent(const MSG &msg);
//  void        repolishStyle(QStyle &style);
//  inline void showChildren(bool spontaneous) { d_func()->showChildren(spontaneous); }
//  inline void hideChildren(bool spontaneous) { d_func()->hideChildren(spontaneous); }
//  inline uint testWindowState(uint teststate){ return dataPtr()->window_state & teststate; }
//  inline void forceUpdate() {
//      QTLWExtra *tlwExtra = window()->d_func()->maybeTopData();
//      if (tlwExtra && tlwExtra->backingStore)
//          tlwExtra->backingStore->markDirty(rect(), this, true, true);
//  }
};

static void qt_set_pm_resources()
{
    // @todo later: take colors, fonts, etc. from the system theme
};

/*****************************************************************************
  qt_init() - initializes Qt for PM
 *****************************************************************************/

void qt_init(QApplicationPrivate *priv, int)
{

    int argc = priv->argc;
    char **argv = priv->argv;
    int i, j;

    // Get command line params

    j = argc ? 1 : 0;
    for (i=1; i<argc; i++) {
        if (argv[i] && *argv[i] != '-') {
            argv[j++] = argv[i];
            continue;
        }
#if defined(QT_DEBUG)
        if (qstrcmp(argv[i], "-nograb") == 0)
            appNoGrab = !appNoGrab;
        else
#endif // QT_DEBUG
            argv[j++] = argv[i];
    }
    if(j < priv->argc) {
        priv->argv[j] = 0;
        priv->argc = j;
    }

    // initialize key mapper
    QKeyMapper::changeKeyboard();

    QColormap::initialize();
    QFont::initialize();
#ifndef QT_NO_CURSOR
    QCursorData::initialize();
#endif
    qApp->setObjectName(priv->appName());

    // default font
    QApplicationPrivate::setSystemFont(
        QFont(QLatin1String("System Proportional"), 10));

    // QFont::locale_init();  ### Uncomment when it does something on OS/2

    if (QApplication::desktopSettingsAware())
        qt_set_pm_resources();
}

/*****************************************************************************
  qt_cleanup() - cleans up when the application is finished
 *****************************************************************************/

void qt_cleanup()
{
    unregWinClasses();
    QPixmapCache::clear();

#ifndef QT_NO_CURSOR
    QCursorData::cleanup();
#endif
    QFont::cleanup();
    QColormap::cleanup();

    if (displayPS) {
        WinReleasePS(displayPS);
        displayPS = 0;
    }
}

/*****************************************************************************
  Platform specific global and internal functions
 *****************************************************************************/

Q_GUI_EXPORT HPS qt_display_dc()
{
    Q_ASSERT(qApp && qApp->thread() == QThread::currentThread());
    if (!displayPS)
        displayPS = WinGetScreenPS(HWND_DESKTOP);
    return displayPS;
}

// application no-grab option
bool qt_nograb()
{
#if defined(QT_DEBUG)
    return appNoGrab;
#else
    return false;
#endif
}

typedef QSet<QString> WinClassNameHash;
Q_GLOBAL_STATIC(WinClassNameHash, winclassNames)

// register window class
const QString qt_reg_winclass(QWidget *w)
{
    int flags = w->windowFlags();
    int type = flags & Qt::WindowType_Mask;

    QString cname;
    ULONG style = 0;

    if (type == Qt::Window) {
        // this class is for frame window clients when WC_FRAME is used.
        cname = QLatin1String("QWindow");
        style |= CS_MOVENOTIFY;
    } else if (type == Qt::Popup || type == Qt::Tool || type == Qt::ToolTip) {
        cname = QLatin1String("QPopup");
        // @todo do we really want SAVEBITS here?
        style |= CS_SAVEBITS;
    } else {
        cname = QLatin1String("QWidget");
    }

    if (winclassNames()->contains(cname)) // already registered in our list
        return cname;

    // QT_EXTRAWINDATASIZE is defined in qwindowdefs_pm.h
    WinRegisterClass(0, cname.toLatin1(), QtWndProc, style, QT_EXTRAWINDATASIZE);

    winclassNames()->insert(cname);
    return cname;
}

static void unregWinClasses()
{
    // there is no need to unregister private window classes -- it is done
    // automatically upon process termination.
    winclassNames()->clear();
}

/*****************************************************************************
  Safe configuration (move,resize,setGeometry) mechanism to avoid
  recursion when processing messages.
 *****************************************************************************/

/*****************************************************************************
    GUI event dispatcher
 *****************************************************************************/

/*****************************************************************************
  Platform specific QApplication members
 *****************************************************************************/

void QApplicationPrivate::initializeWidgetPaletteHash()
{
}

QString QApplicationPrivate::appName() const
{
    return QCoreApplicationPrivate::appName();
}

/*****************************************************************************
  QApplication cursor stack
 *****************************************************************************/

/*****************************************************************************
  Routines to find a Qt widget from a screen position
 *****************************************************************************/

/*****************************************************************************
  Main event loop
 *****************************************************************************/

/*****************************************************************************
  Modal widgets; We have implemented our own modal widget mechanism
  to get total control.
  A modal widget without a parent becomes application-modal.
  A modal widget with a parent becomes modal to its parent and grandparents..

  QApplicationPrivate::enterModal()
        Enters modal state
        Arguments:
            QWidget *widget        A modal widget

  QApplicationPrivate::leaveModal()
        Leaves modal state for a widget
        Arguments:
            QWidget *widget        A modal widget
 *****************************************************************************/

/*****************************************************************************
  Popup widget mechanism

  openPopup()
        Adds a widget to the list of popup widgets
        Arguments:
            QWidget *widget        The popup widget to be added

  closePopup()
        Removes a widget from the list of popup widgets
        Arguments:
            QWidget *widget        The popup widget to be removed
 *****************************************************************************/

/*****************************************************************************
  Event translation; translates PM events to Qt events
 *****************************************************************************/

QT_END_NAMESPACE
