isEmpty(DEPTH):error("DEPTH is not set before including common.pri!")

DESTDIR = $$OUT_PWD/$$DEPTH/.

!build_pass: {
    debug_and_release {
        debug-run.target = debug-run
        debug-run.commands = $(MAKE) -f $(MAKEFILE).Debug run
        release-run.target = release-run
        release-run.commands = $(MAKE) -f $(MAKEFILE).Release run
        QMAKE_EXTRA_TARGETS += debug-run release-run
	
        debug-dbg.target = debug-dbg
        debug-dbg.commands = $(MAKE) -f $(MAKEFILE).Debug dbg
        release-dbg.target = release-dbg
        release-dbg.commands = $(MAKE) -f $(MAKEFILE).Release dbg
        QMAKE_EXTRA_TARGETS += debug-dbg release-dbg
    }
} else {
	isEmpty(RUN_SHELL):RUN_SHELL = $(RUN_SHELL)
	isEmpty(RUN_ARGS):RUN_ARGS = $(RUN_ARGS)
	
	run.target = run
	run.commands = $$RUN_SHELL $(DESTDIR_TARGET) $$RUN_ARGS
	run.depends = $(DESTDIR_TARGET) 
	QMAKE_EXTRA_TARGETS += run
	
	os2:isEmpty(RUN_DEBUG):RUN_DEBUG = idbug
	win:isEmpty(RUN_DEBUG):RUN_DEBUG = windbg
	unix:isEmpty(RUN_DEBUG):RUN_DEBUG = gdb
	
	dbg.target = dbg
	dbg.commands = $$RUN_SHELL $$RUN_DEBUG $(DESTDIR_TARGET) $$RUN_ARGS
	dbg.depends = $(DESTDIR_TARGET) 
	QMAKE_EXTRA_TARGETS += dbg
}

# All kinds of builds should have the console if possible
win32 {
	CONFIG(release, debug|release):CONFIG(qt):contains(QT, gui) {
		CONFIG -= console
		CONFIG *= windows
	} else {
		CONFIG -= windows
		CONFIG *= console
	}	
}
os2 {
    CONFIG -= windows
    CONFIG *= console
}	
