
/*
 *@@sourcefile xsystray.h:
 *      Extended system tray widget for XCenter/eCenter.
 *
 *      Public API.
 *
 *      This file contains the public API to the Extended system tray widget.
 *      This API is used by applications to add and remove icons from the
 *      special notification area on the desktop provided by the Extended
 *      system tray widget.
 *
 *      Refer to the "API" file for more details about the public API.
 *
 *      Copyright (C) 2009 Dmitry A. Kuminov
 *
 *      This file is part of the Extended system tray widget source package.
 *      Extended system tray widget is free software; you can redistribute it
 *      and/or modify it under the terms of the GNU General Public License as
 *      published by the Free Software Foundation, in version 2 as it comes in
 *      the "COPYING" file of the Extended system tray widget distribution. This
 *      program is distributed in the hope that it will be useful, but WITHOUT
 *      ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *      FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 *      more details.
 */

#ifndef XSYSTRAY_API_HEADER_INCLUDED
#define XSYSTRAY_API_HEADER_INCLUDED

#if __cplusplus
extern "C" {
#endif

#ifdef XSTAPI_IMPL
#define XSTAPI __declspec(dllexport) EXPENTRY
#else
#define XSTAPI EXPENTRY
#endif

// notification code constants for the notification messages sent by the system
// tray (refer to xstAddSysTrayIcon() for details)
#define XST_IN_MOUSE    0x0001
#define XST_IN_CONTEXT  0x0002
#define XST_IN_WHEEL    0x0003

// structure for XST_IN_MOUSE
typedef struct
{
    ULONG  ulMouseMsg;
           // mouse message (one of WM_BUTTONxyyy)
    POINTS ptsPointerPos;
           // global pointer position at the time of the mouse event
    USHORT fsHitTestRes;
           // hit-test result (see WM_BUTTONxyyy description in PM)
    USHORT fsFlags;
           // keyboard control codes (see WM_BUTTONxyyy description in PM)

} XSTMOUSEMSG, *PXSTMOUSEMSG;

// structure for XST_IN_CONTEXT
typedef struct
{
    POINTS ptsPointerPos;
           // global pointer position at the time of the mouse event
    USHORT fPointer;
           // input device flag (see WM_CONTEXTMENU description in PM)

} XSTCONTEXTMSG, *PXSTCONTEXTMSG;

// structure for XST_IN_WHEEL
typedef struct
{
    ULONG  ulWheelMsg;
           // mouse message (one of WM_HSCROLL or WM_VSCROLL)
    POINTS ptsPointerPos;
           // global pointer position at the time of the mouse event
    USHORT usCmd;
           // command (see WM_HSCROLL/WM_VSCROLL description in PM)

} XSTWHEELMSG, *PXSTWHEELMSG;

BOOL XSTAPI xstQuerySysTrayVersion(PULONG pulMajor, PULONG pulMinor,
                                   PULONG pulRevision);
                                    
BOOL XSTAPI xstAddSysTrayIcon(HWND hwnd, USHORT usId, HPOINTER hIcon,
                              PCSZ pcszToolTip, ULONG ulMsgId, ULONG ulFlags);
                               
BOOL XSTAPI xstReplaceSysTrayIcon(HWND hwnd, USHORT usId, HPOINTER hIcon);

BOOL XSTAPI xstRemoveSysTrayIcon(HWND hwnd, USHORT usId);

BOOL XSTAPI xstSetSysTrayIconToolTip(HWND hwnd, USHORT usId, PCSZ pcszToolTip);

BOOL XSTAPI xstShowSysTrayIconBalloon(HWND hwnd, USHORT usId, PCSZ pcszTitle,
                                      PCSZ pcszText, ULONG ulFlags,
                                      ULONG ulTimeout);

BOOL XSTAPI xstHideSysTrayIconBalloon(HWND hwnd, USHORT usId);

BOOL XSTAPI xstQuerySysTrayIconRect(HWND hwnd, USHORT usId, PRECTL prclRect);

ULONG XSTAPI xstGetSysTrayCreatedMsgId();

ULONG XSTAPI xstGetSysTrayMaxTextLen();

#if __cplusplus
}
#endif

#endif // XSYSTRAY_API_HEADER_INCLUDED

