#include <QDebug>

#include <QtGui>

#define myDefFlagEx(var,fl,varstr,flstr) if (var & fl) { \
    if (!varstr.isEmpty()) varstr += "|"; varstr += flstr; \
} else do {} while(0)

#define myDefFlag(var,fl,varstr) myDefFlagEx(var,fl,varstr,#fl)
#define myDefFlagCut(var,fl,varstr,pos) myDefFlagEx(var,fl,varstr,#fl + pos)

#define PRINT_EXPR(e) qWarning() << #e << e

QDebug operator<<(QDebug dbg, Qt::WindowStates st)
{
    QByteArray name;
    myDefFlagEx(st, Qt::WindowMinimized, name, "Min");
    myDefFlagEx(st, Qt::WindowMaximized, name, "Max");
    myDefFlagEx(st, Qt::WindowFullScreen, name, "Full");
    myDefFlagEx(st, Qt::WindowActive, name, "Act");
    if (name.isEmpty()) name = "None";
    dbg.nospace() << "WindowState(" << name.constData() << ")";
    return dbg.space();
}

QDebug operator<<(QDebug dbg, Qt::FocusReason r)
{
    QByteArray name;
    if (r == Qt::MouseFocusReason) name = "Mouse";
    if (r == Qt::TabFocusReason) name = "Tab";
    if (r == Qt::BacktabFocusReason) name = "Backtab";
    if (r == Qt::ActiveWindowFocusReason) name = "ActWin";
    if (r == Qt::PopupFocusReason) name = "Popup";
    if (r == Qt::ShortcutFocusReason) name = "Shortcut";
    if (r == Qt::MenuBarFocusReason) name = "MenuBar";
    if (r == Qt::OtherFocusReason) name = "Other";
    dbg.nospace() << "FocusReason(" << name.constData() << ")";
    return dbg.space();
}

////////////////////////////////////////////////////////////////////////////////

class MyChild : public QWidget
{
    Q_OBJECT

public:

    MyChild(QWidget *aParent) : QWidget(aParent), mPressed(0)
    {
        setFocusPolicy(Qt::StrongFocus);

        resize(64, 32);
    }

    void paintEvent(QPaintEvent *aE)
    {
        qDebug() << this << __FUNCTION__
                 << ": " << aE->rect() << "focus" << hasFocus();

        QPainter p(this);
        p.setRenderHint(QPainter::Antialiasing);

        if (hasFocus())
            p.fillRect(aE->rect(), mPressed % 2 ? Qt::red : Qt::green);
        else
            p.fillRect(aE->rect(), Qt::gray);
    }

    void mousePressEvent(QMouseEvent *aE)
    {
        Q_UNUSED(aE);
        ++mPressed;
        update();
    }

    void mouseReleaseEvent(QMouseEvent *aE)
    {
        Q_UNUSED(aE);
        ++mPressed;
        update();
    }

    void focusInEvent(QFocusEvent *aE)
    {
        qDebug() << this << __FUNCTION__ << ": reason" << aE->reason();
        QWidget::focusInEvent(aE);
    }

    void focusOutEvent(QFocusEvent *aE)
    {
        qDebug() << this << __FUNCTION__ << ": reason" << aE->reason();
        QWidget::focusOutEvent(aE);
    }

private:

    int mPressed;
};

////////////////////////////////////////////////////////////////////////////////

class MyButton : public QPushButton
{
public:

    MyButton(QWidget *aParent) : QPushButton(aParent)
    {
        QMenu *menu = new QMenu(aParent);
        menu->addAction(QLatin1String("Action &1"));
        menu->addAction(QLatin1String("Action &2"));
        setMenu(menu);
    }

#if 0
    void focusInEvent(QFocusEvent *aE)
    {
        qDebug() << this << __FUNCTION__ << ":" << text()
                 << "reason" << aE->reason()
                 << "focus" << qApp->focusWidget();

        QPushButton::focusInEvent(aE);
    }

    void focusOutEvent(QFocusEvent *aE)
    {
        qDebug() << this << __FUNCTION__ << ":" << text()
                 << "reason" << aE->reason()
                 << "focus" << qApp->focusWidget();
        QPushButton::focusOutEvent(aE);
    }
#endif
};


////////////////////////////////////////////////////////////////////////////////

class MyCombo : public QComboBox
{
public:

    MyCombo(QWidget *aParent) : QComboBox(aParent) {}

#if 0
    void focusInEvent(QFocusEvent *aE)
    {
        qDebug() << this << __FUNCTION__ << ":" << currentText()
                 << "reason" << aE->reason()
                 << "focus" << qApp->focusWidget();
        QComboBox::focusInEvent(aE);
    }

    void focusOutEvent(QFocusEvent *aE)
    {
        qDebug() << this << __FUNCTION__ << ":" << currentText()
                 << "reason" << aE->reason()
                 << "focus" << qApp->focusWidget();
        QComboBox::focusOutEvent(aE);
    }
#endif

#if 0
    void resizeEvent(QResizeEvent *aE)
    {
        qDebug() << __FUNCTION__ << ":"  << currentText() << "g" << geometry() << "fg" << frameGeometry()
                 << "sz" << aE->size() << "old" << aE->oldSize();
    }

    void moveEvent(QMoveEvent *aE)
    {
        qDebug() << __FUNCTION__ << ":" << currentText() << " g" << geometry() << "fg" << frameGeometry()
                 << "pos" << aE->pos() << "old" << aE->oldPos();
    }
#endif

#if 0
    virtual void enterEvent(QEvent *event)
    {
        qDebug() << __FUNCTION__ << ":" << currentText();
    }

    virtual void leaveEvent(QEvent *event)
    {
        qDebug() << __FUNCTION__ << ":" << currentText();
    }
#endif

#if 0
    void mousePressEvent(QMouseEvent *aE)
    {
        qDebug() << __FUNCTION__ << ": btn" << aE->button()
                 << "btns" << qDebugFmtHex(aE->buttons())
                 << "mods" << qDebugFmtHex(aE->modifiers())
                 << "gpos" << aE->globalPos() << "pos" << aE->pos();
        QComboBox::mousePressEvent(aE);
    }

    void mouseReleaseEvent(QMouseEvent *aE)
    {
        qDebug() << __FUNCTION__ << ": btn" << aE->button()
                 << "btns" << qDebugFmtHex(aE->buttons())
                 << "mods" << qDebugFmtHex(aE->modifiers())
                 << "gpos" << aE->globalPos() << "pos" << aE->pos();
        QComboBox::mouseReleaseEvent(aE);
    }

    void contextMenuEvent(QContextMenuEvent *aE)
    {
        QMenu menu;
        menu.addAction(QLatin1String("Action &1"));
        menu.addAction(QLatin1String("Action &2"));
        menu.exec(aE->globalPos());
        winId();
    }
#endif
};

////////////////////////////////////////////////////////////////////////////////

class MyWidget : public QWidget
{
public:

    MyWidget() : mPressed(0)
    {
#if 0
        MyButton *btn1 = new MyButton(this);
        btn1->setText(QLatin1String("&Hello (also Ctrl+H)"));
        btn1->setObjectName("Hello");
        btn1->move(20, 20);

        connect(new QShortcut(QKeySequence(Qt::CTRL + Qt::Key_H), btn1),
                SIGNAL(activated()), btn1, SLOT(animateClick()));

        MyButton *btn2 = new MyButton(this);
        btn2->setText(QString::fromUtf16((const ushort *)L"&\u041f\u0440\u0438\u0432\u0435\u0442 (also Ctrl+\u041f)"));
        btn2->setObjectName(QString::fromUtf16((const ushort *)L"\u041f\u0440\u0438\u0432\u0435\u0442"));
        btn2->move(20, 60);

        connect(new QShortcut(QKeySequence(Qt::CTRL + 0x041F), btn2),
                SIGNAL(activated()), btn2, SLOT(animateClick()));

//      QComboBox *cb1 = new MyCombo(this);
//      cb1->addItem(QLatin1String("Test 1"));
//      cb1->addItem(QLatin1String("Test 2"));

//      QComboBox *cb2 = new MyCombo(this);
//      cb2->addItem(QLatin1String("Test 3"));
//      cb2->addItem(QLatin1String("Test 4"));

        QVBoxLayout *mainLayout = new QVBoxLayout();
        mainLayout->addWidget(btn1);
        mainLayout->addWidget(btn2);
//      mainLayout->addWidget(cb1);
//      mainLayout->addWidget(cb2);

        setLayout(mainLayout);
#endif

#if 0
        QMenuBar *mb = new QMenuBar(this);

        QMenu *menu = new QMenu(mb);
        menu->setTitle ("Menu &1");
        menu->addAction(QLatin1String("Action &1"));
        menu->addAction(QLatin1String("Action &2"));
        mb->addMenu(menu);

        menu = new QMenu(mb);
        menu->setTitle ("Menu &2");
        menu->addAction(QLatin1String("Action &1"));
        menu->addAction(QLatin1String("Action &2"));
        mb->addMenu(menu);

        menu = new QMenu(mb);
        menu->setTitle ("Menu &3");
        menu->addAction(QLatin1String("Action &1"));
        menu->addAction(QLatin1String("Action &2"));
        mb->addMenu(menu);
#endif

#if 0
        new MyChild(this);
#endif

    };

#if 0
    void closeEvent(QCloseEvent *aE)
    {
        QMessageBox::warning(this, QLatin1String("Close"),
                             QLatin1String("Somebody asked us to terminate"));
        aE->accept();
    }
#endif

#if 0
    void paintEvent(QPaintEvent *aE)
    {
        qDebug() << __FUNCTION__ <<": " << aE->rect();

        QPainter p(this);
#if 0
        // simple QPainter test

        p.setRenderHint(QPainter::Antialiasing);

        p.fillRect(0, 0, 20, 20, mPressed % 2 ? Qt::red : Qt::green);

        p.setPen(Qt::black);
        p.drawEllipse(10, 10, 10, 10);

        //p.setFont(QFont("Arial", 12));
        p.drawText(10, 30, QLatin1String("ABC"));
#endif
#if 0
        // simple QClipboard image test

        const QMimeData *data = QApplication::clipboard()->mimeData();
        if (data && data->hasImage()){
            QImage img = qvariant_cast<QImage>(data->imageData());
            p.drawImage(0, 0, img);
        }
#endif
    }
#endif

#if 0
    void resizeEvent(QResizeEvent *aE)
    {
        qDebug() << __FUNCTION__ << ": g" << geometry() << "fg" << frameGeometry()
                 << "sz" << aE->size() << "old" << aE->oldSize();
    }

    void moveEvent(QMoveEvent *aE)
    {
        qDebug() << __FUNCTION__ << ": g" << geometry() << "fg" << frameGeometry()
                 << "pos" << aE->pos() << "old" << aE->oldPos();
    }
#endif

#if 0
    void focusInEvent(QFocusEvent *aE)
    {
        qDebug() << this << __FUNCTION__ << ": reason" << aE->reason();
        QWidget::focusInEvent(aE);
    }

    void focusOutEvent(QFocusEvent *aE)
    {
        qDebug() << this << __FUNCTION__ << ": reason" << aE->reason();
        QWidget::focusOutEvent(aE);
    }
#endif

#if 0
    void changeEvent(QEvent *aE)
    {
        switch (aE->type()) {
        case QEvent::WindowStateChange: {
            QWindowStateChangeEvent *e2 = (QWindowStateChangeEvent *)aE;
            qDebug().nospace() << __FUNCTION__ << ": QWindowStateChangeEvent(" <<
                e2->oldState() << "->" << windowState() << ")";
            break;
        }
        default:
            break;
        }
    }
#endif

#if 0
    void keyPressEvent(QKeyEvent *aE)
    {
        qDebug() << __FUNCTION__ << ": cnt" << aE->count()
                 << "rep" << aE->isAutoRepeat()
                 << "key" << qDebugFmtHex(aE->key())
                 << "mods" << qDebugFmtHex(aE->modifiers())
                 << "text" << aE->text()
                 << qDebugFmtHex((aE->text().isEmpty() ? 0 :
                                  aE->text()[0].unicode()));
    }

    void keyReleaseEvent(QKeyEvent *aE)
    {
        qDebug() << __FUNCTION__ << ": cnt" << aE->count()
                 << "rep" << aE->isAutoRepeat()
                 << "key" << qDebugFmtHex(aE->key())
                 << "mods" << qDebugFmtHex(aE->modifiers())
                 << "text" << aE->text()
                 << qDebugFmtHex((aE->text().isEmpty() ? 0 :
                                  aE->text()[0].unicode()));
    }
#endif

#if 0
    // QCursor shape test
    void mousePressEvent(QMouseEvent *aE)
    {
        static int shape = 0;
        if (aE->button() == Qt::LeftButton)
            ++shape;
        else
            --shape;
        shape = (Qt::LastCursor + 1 + shape) % (Qt::LastCursor + 1);
        setCursor(QCursor((Qt::CursorShape)shape));
    }
#endif

#if 0
    void mousePressEvent(QMouseEvent *aE)
    {
        qDebug() << __FUNCTION__ << ": btn" << aE->button()
                 << "btns" << qDebugFmtHex(aE->buttons())
                 << "mods" << qDebugFmtHex(aE->modifiers())
                 << "gpos" << aE->globalPos() << "pos" << aE->pos();

        ++mPressed;
        update();
    }

    void mouseReleaseEvent(QMouseEvent *aE)
    {
        qDebug() << __FUNCTION__ << ": btn" << aE->button()
                 << "btns" << qDebugFmtHex(aE->buttons())
                 << "mods" << qDebugFmtHex(aE->modifiers())
                 << "gpos" << aE->globalPos() << "pos" << aE->pos();
    }

    void mouseMoveEvent(QMouseEvent *aE)
    {
        qDebug() << __FUNCTION__ << ": btn" << aE->button()
                 << "btns" << qDebugFmtHex(aE->buttons())
                 << "mods" << qDebugFmtHex(aE->modifiers())
                 << "gpos" << aE->globalPos() << "pos" << aE->pos();
    }
#endif

#if 0
    virtual void enterEvent(QEvent *event)
    {
        qDebug() << __FUNCTION__ << ":";
    }

    virtual void leaveEvent(QEvent *event)
    {
        qDebug() << __FUNCTION__ << ":";
    }
#endif

#if 0
    void contextMenuEvent(QContextMenuEvent *aE)
    {
        QMenu menu;
        menu.addAction(QLatin1String("Action &1"));
        menu.addAction(QLatin1String("Action &2"));
        menu.exec(aE->globalPos());
    }
#endif

#if 0
    void timerEvent(QTimerEvent *aE)
    {
        qDebug() << __FUNCTION__ << ": id" << aE->timerId();
    }
#endif

    bool event(QEvent *aE)
    {
        switch (aE->type())
        {
#if 0
        case QEvent::Enter:
            qDebug() << this << "Enter";
            break;
        case QEvent::Leave:
            qDebug() << this << "Leave";
            break;
        case QEvent::NonClientAreaMouseMove:
        case QEvent::NonClientAreaMouseButtonPress:
        case QEvent::NonClientAreaMouseButtonRelease:
        case QEvent::NonClientAreaMouseButtonDblClick: {
            QMouseEvent *me = static_cast<QMouseEvent*>(aE);
            qDebug() << this << aE->type() << ": btn" << me->button()
                     << "btns" << qDebugFmtHex(me->buttons())
                     << "mods" << qDebugFmtHex(me->modifiers())
                     << "gpos" << me->globalPos() << "pos" << me->pos();
            break;
        }
#endif
        default:
            break;
        }

        return QWidget::event(aE);
    }

private:

    int mPressed;
};

void testCodec(const char *title, const QString &sample, QTextCodec *codec)
{
    // test console output

    printf("%s : Unicode (source) : ", title);
    foreach (QChar ch, sample)
        printf("%hX ", ch.unicode());
    printf("\n");

    QByteArray eightbit = codec->fromUnicode(sample);
    printf("%s : 8-bit (as is)    : %s\n", title, eightbit.data());

    QString sample2 = codec->toUnicode(eightbit);
    printf("%s : Unicode (result) : ", title);
    foreach (QChar ch, sample2)
        printf("%hX ", ch.unicode());
    printf("\n");

    if (sample != sample2)
        qWarning() << "Source and resulting Unicode differ!";

    qWarning() << "";

    // test GUI output (both window title and window text)

    QString combined = QString("%1 : %2").arg(QLatin1String(title), sample);
    QMessageBox mbox;
    mbox.setWindowTitle(combined);
    mbox.setText(combined);
    mbox.exec();
}

int main(int argc, char **argv)
{
#if 1
    ////////////////////////////////////////////////////////////////////////////
    // Text mode

    QCoreApplication app(argc, argv);

#if 1
    //--------------------------------------------------------------------------
    // Simple QProcess test
    QProcess cmd;
    QStringList params;
    params << "/c" << "ver";
    cmd.start("cmd", params, QIODevice::ReadOnly);
    cmd.waitForStarted();
    cmd.waitForFinished();
    PRINT_EXPR(cmd.readAll());
#endif

#if 0
    //--------------------------------------------------------------------------
    // QFileInfo test
    PRINT_EXPR(QFileInfo(QLatin1String("../../qt4/src/corelib/global/qt_windows.h")).isExecutable());
    PRINT_EXPR(QFileInfo(QLatin1String("../../qt4/src/corelib/global/qt_os2.h")).isExecutable());
    PRINT_EXPR(QFileInfo(QLatin1String("../../qt4/configure.cmd")).isExecutable());
    PRINT_EXPR(QFileInfo(QLatin1String("../../qt4/configure.exe")).isExecutable());
    PRINT_EXPR(QFileInfo(QLatin1String("../../qt4/bin/qmake.exe")).isExecutable());
    PRINT_EXPR(QFileInfo(QLatin1String("../../qt4/bin/QtCore4.dll")).isExecutable());
    PRINT_EXPR(QFileInfo(QLatin1String("../../qt4/bin")).isExecutable());
#endif

#if 0
    //--------------------------------------------------------------------------
    // QTextStream test

    QFile file("widget.cpp");
    file.open(QIODevice::ReadOnly);
    QTextStream text(&file);
    QString str = text.readAll();
    file.close();
    qWarning() << "Read" << str.length() << "chars from widget.cpp";
#endif

#if 0
    //--------------------------------------------------------------------------
    // absolute/relative path test
    qWarning() << "1" << QDir(QLatin1String("C:\\OS2")).absoluteFilePath(QLatin1String("../aaa"));
    qWarning() << "1" << QDir(QLatin1String("C:\\OS2")).absoluteFilePath(QLatin1String("aaa"));
    qWarning() << "1" << QDir(QLatin1String("C:\\OS2")).absoluteFilePath(QLatin1String("/aaa"));
    qWarning() << "1" << QDir(QLatin1String("C:\\OS2")).absoluteFilePath(QLatin1String("\\aaa"));
    qWarning() << "1" << QDir(QLatin1String("C:\\OS2")).absoluteFilePath(QLatin1String("D:\\aaa"));
    qWarning() << "1" << QDir(QLatin1String("C:\\OS2")).absoluteFilePath(QLatin1String("D:aaa"));

    qWarning() << "2" << QDir(QLatin1String(".")).absoluteFilePath(QLatin1String("../aaa"));
    qWarning() << "2" << QDir(QLatin1String(".")).absoluteFilePath(QLatin1String("aaa"));
    qWarning() << "2" << QDir(QLatin1String(".")).absoluteFilePath(QLatin1String("/aaa"));
    qWarning() << "2" << QDir(QLatin1String(".")).absoluteFilePath(QLatin1String("\\aaa"));
    qWarning() << "2" << QDir(QLatin1String(".")).absoluteFilePath(QLatin1String("D:\\aaa"));
    qWarning() << "2" << QDir(QLatin1String(".")).absoluteFilePath(QLatin1String("D:aaa"));

    qWarning() << "3" << QDir(QLatin1String("D:bbb")).absoluteFilePath(QLatin1String("../aaa"));
    qWarning() << "3" << QDir(QLatin1String("D:bbb")).absoluteFilePath(QLatin1String("aaa"));
    qWarning() << "3" << QDir(QLatin1String("D:bbb")).absoluteFilePath(QLatin1String("/aaa"));
    qWarning() << "3" << QDir(QLatin1String("D:bbb")).absoluteFilePath(QLatin1String("\\aaa"));
    qWarning() << "3" << QDir(QLatin1String("D:bbb")).absoluteFilePath(QLatin1String("D:\\aaa"));
    qWarning() << "3" << QDir(QLatin1String("D:bbb")).absoluteFilePath(QLatin1String("D:aaa"));

    qWarning() << "4" << QDir(QLatin1String("E:bbb")).absoluteFilePath(QLatin1String("D:aaa"));
    qWarning() << "4" << QDir(QLatin1String("E:bbb")).absoluteFilePath(QLatin1String("bbb"));
    qWarning() << "4" << QDir(QLatin1String("C:bbb")).absoluteFilePath(QLatin1String("bbb"));
#endif

#if 0
    //--------------------------------------------------------------------------
    // QDir::mkdir/mkpath test
    PRINT_EXPR(QDir().mkdir("some_dir"));
    PRINT_EXPR(QFile::exists("some_dir"));
    PRINT_EXPR(QDir().rmdir("some_dir"));

    PRINT_EXPR(QDir().mkdir("some_dir/subdir"));
    PRINT_EXPR(QFile::exists("some_dir/subdir"));
    PRINT_EXPR(QDir().rmdir("some_dir/subdir"));

    PRINT_EXPR(QDir().mkpath("some_dir/subdir"));
    PRINT_EXPR(QFile::exists("some_dir/subdir"));
    PRINT_EXPR(QDir().rmpath("some_dir/subdir"));

    PRINT_EXPR(QDir("C:/").mkpath("some_dir/subdir"));
    PRINT_EXPR(QFile::exists("C:/some_dir/subdir"));
    PRINT_EXPR(QDir("C:/").rmpath("some_dir/subdir"));

    PRINT_EXPR(QDir("C:/").mkdir("/aaa"));
    PRINT_EXPR(QFile::exists("C:/aaa"));
    PRINT_EXPR(QDir("C:/").rmdir("/aaa"));
#endif

#if 0
    //--------------------------------------------------------------------------
    // QLibraryInfo test
    qWarning() << "QLibraryInfo::buildKey :" << QLibraryInfo::buildKey();
    qWarning() << "QLibraryInfo::licensedProducts :" << QLibraryInfo::licensedProducts();
    qWarning() << "QLibraryInfo::licensee :" << QLibraryInfo::licensee();
    #define PRINT_LOC(L) qWarning() << #L << ":" << QLibraryInfo::location(L)
    PRINT_LOC(QLibraryInfo::PrefixPath);
    PRINT_LOC(QLibraryInfo::DocumentationPath);
    PRINT_LOC(QLibraryInfo::HeadersPath);
    PRINT_LOC(QLibraryInfo::LibrariesPath);
    PRINT_LOC(QLibraryInfo::BinariesPath);
    PRINT_LOC(QLibraryInfo::PluginsPath);
    PRINT_LOC(QLibraryInfo::DataPath);
    PRINT_LOC(QLibraryInfo::TranslationsPath);
    PRINT_LOC(QLibraryInfo::SettingsPath);
    PRINT_LOC(QLibraryInfo::DemosPath);
    PRINT_LOC(QLibraryInfo::ExamplesPath);
    #undef PRINT_LOC
#endif

#if 0
    //--------------------------------------------------------------------------
    // QSettings test

    QSettings sysOrgSet(QSettings::IniFormat, QSettings::SystemScope,
                        QLatin1String("MySoft"));
    QSettings sysAppSet(QSettings::IniFormat, QSettings::SystemScope,
                        QLatin1String("MySoft"), QLatin1String("MyApp"));
    QSettings userOrgSet(QSettings::IniFormat, QSettings::UserScope,
                         QLatin1String("MySoft"));
    QSettings userAppSet(QSettings::IniFormat, QSettings::UserScope,
                         QLatin1String("MySoft"), QLatin1String("MyApp"));

    QList<QSettings *> sets;
    sets << &sysOrgSet << &sysAppSet << &userOrgSet << &userAppSet;

    foreach (QSettings *set, sets) {
        set->setValue("Time", QDateTime::currentDateTime());
    }

    qWarning() << "Modified Time key in MySoft/MyApp (system & user)";
#endif

#else
    ////////////////////////////////////////////////////////////////////////////
    // GUI

    QApplication app(argc, argv);
    app.setQuitOnLastWindowClosed(true);

#if 0
    //--------------------------------------------------------------------------
    // locale test

    QLocale locale = QLocale::system();

    qWarning() << "Library paths    :" << QApplication::libraryPaths();
    qWarning() << "";
    qWarning() << "Available codecs :\n" << QTextCodec::availableCodecs();
    qWarning() << "";
    qWarning() << "Codec for locale :" << QTextCodec::codecForLocale()->name();
    qWarning() << "         Aliases :" << QTextCodec::codecForLocale()->aliases();
    qWarning() << "";
    qWarning() << "Country for locale  :" << QLocale::countryToString(locale.country())
                                          << "[" << locale.country() << "]";
    qWarning() << "Language for locale :" << QLocale::languageToString(locale.language())
                                          << "[" << locale.language() << "]";
    qWarning() << "";

    testCodec("First 3 months",
              QString("%1, %2, %3").arg(locale.standaloneMonthName(1),
                                        locale.standaloneMonthName(2),
                                        locale.standaloneMonthName(3)),
              QTextCodec::codecForLocale());
    return 0;
#endif

#if 0
    QRect r = QApplication::desktop()->availableGeometry();
    MyWidget widget;
    widget.resize(100, 100);
    widget.move(r.width() - 200, r.height() - 200);

    widget.show();
#endif

#if 0
    //--------------------------------------------------------------------------
    // QDesktopServices test
    {
        for (int i = 0; i <= 10; ++i) {
            qWarning() << "StandardLocation" << i
                       << QDesktopServices::
                storageLocation((QDesktopServices::StandardLocation)i);
        }

        PRINT_EXPR(QDesktopServices::openUrl(QUrl::fromLocalFile(QDir::currentPath())));
        PRINT_EXPR(QDesktopServices::openUrl(QUrl("file:///C:/OS2/BITMAP/OCEAN.BMP")));
        PRINT_EXPR(QDesktopServices::openUrl(QUrl("mailto:user@example.com")));
        PRINT_EXPR(QDesktopServices::openUrl(QUrl("http://www.ru")));
    }
#endif

#if 0
    //--------------------------------------------------------------------------
    // QFontDialog test
    {
        int appFont1, appFont2;

        PRINT_EXPR((appFont1 = QFontDatabase::addApplicationFont(
            QLatin1String("fonts/Earthqua.ttf"))));

        QByteArray fontData;
        QFile fontFile(QLatin1String("fonts/NATIONFD.TTF"));
        if (fontFile.open(QIODevice::ReadOnly)) {
            fontData = fontFile.readAll();
            fontFile.close();
        }
        PRINT_EXPR((appFont2 = QFontDatabase::addApplicationFontFromData(fontData)));

        PRINT_EXPR(QFontDatabase::applicationFontFamilies(appFont1));
        PRINT_EXPR(QFontDatabase::applicationFontFamilies(appFont2));

        QFontDialog fntDlg;
        fntDlg.exec();

        PRINT_EXPR(QFontDatabase::removeApplicationFont(appFont1));
        PRINT_EXPR(QFontDatabase::applicationFontFamilies(appFont1));

        fntDlg.exec();

        {
            QFont font("MyCoolFont");
            QFontInfo info(font);
            qDebug() << info.family();
        }
    }
#endif

#if 0
    //--------------------------------------------------------------------------
    // QFileDialog test
    {
        QFileDialog dlg;

        dlg.setFileMode(QFileDialog::ExistingFile);
        //dlg.setFilter(QDir::Dirs | QDir::Files | QDir::Drives);
        dlg.setNameFilter("*.exe");
        dlg.selectFile("mplayer.exe");
        dlg.exec();

        //PRINT_EXPR(QFileDialog::getOpenFileName());
    }
#endif

#if 0
    QSound snd2("C:/MMOS2/SOUNDS/DESKTOP/dsk_shut.wav");
    snd2.setLoops(2);
    snd2.play();

    QSound snd1("C:/MMOS2/SOUNDS/DESKTOP/dsk_strt.wav");
    snd1.setLoops(3);
    snd1.play();
#endif

#if 0
    widget.startTimer(1000);
    widget.startTimer(2000);
    widget.startTimer(4000);
#endif

#if 0
    qDebug() << "------------- before min" << widget.geometry() << widget.frameGeometry();
    widget.showMinimized();
    qDebug() << "------------- after min" << widget.geometry() << widget.frameGeometry();
    widget.move(100, 100);
    qDebug() << "------------- after move" << widget.geometry() << widget.frameGeometry();
    widget.showNormal();
    qDebug() << "------------- after norm" << widget.geometry() << widget.frameGeometry();
    widget.showFullScreen();
    qDebug() << "------------- after full" << widget.geometry() << widget.frameGeometry();
#endif

    bool haveVisibleTops = false;
    foreach(QWidget *top, app.topLevelWidgets()) {
        if (top->isVisible()) {
            haveVisibleTops = true;
            break;
        }
    }

    if (haveVisibleTops)
        return app.exec();

    return 0;
#endif
}

#include "widget.moc"
