/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Qt Software Information (qt-info@nokia.com)
**
** Copyright (C) 2009 netlabs.org. OS/2 parts.
**
** This file is part of the QtGui module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial Usage
** Licensees holding valid Qt Commercial licenses may use this file in
** accordance with the Qt Commercial License Agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Nokia.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain
** additional rights. These rights are described in the Nokia Qt LGPL
** Exception version 1.0, included in the file LGPL_EXCEPTION.txt in this
** package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
** $QT_END_LICENSE$
**
****************************************************************************/

#include "qapplication.h"

#include "qapplication_p.h"
#include "qevent.h"
#include "qpainter.h"
#include "qwidget.h"
#include "qbuffer.h"
#include "qdatastream.h"
#include "qcursor.h"
#include "qdesktopwidget.h"
#include "qdnd_p.h"
#include "qdebug.h"

#include "qt_os2.h"

#define QDND_DEBUG // in pair with qmime_pm.cpp

#ifdef QDND_DEBUG
#   define DEBUG(a) qDebug a
#else
#   define DEBUG(a) do {} while(0)
#endif

QT_BEGIN_NAMESPACE

#if !defined(QT_NO_DRAGANDDROP) && !defined(QT_NO_CLIPBOARD)

/** \internal
 *  Data for QDragEnterEvent/QDragMoveEvent/QPMDropEvent.
 */
class QPMDragData
{
public:
    QPMDragData();
    ~QPMDragData();

    void initialize( DRAGINFO *di );
    void reset( bool isAccepted, bool isActAccepted );
    void reset() { reset( FALSE, FALSE ); }

    void setDropped( bool d ) { dropped = d; }
    bool isDropped() const { return dropped; }

    DRAGINFO *info() const { return di; }

    bool hasFormat_sys(const QString &mimeType);
    QStringList formats_sys();
    QVariant retrieveData_sys(const QString &mimeType, QVariant::Type type);

private:

    void initWorkers();

    bool initialized : 1;
    bool dropped : 1;
    bool gotWorkers : 1;

    DRAGINFO *di;
    // @todo later
//  QPtrList<QPMMime::DropWorker> workers;
};

QPMDragData::QPMDragData()
    : initialized(false), dropped(false)
    , gotWorkers(false), di(NULL)
{
    QDragManager *manager = QDragManager::self();
    Q_ASSERT(!manager->dropData->d);
    manager->dropData->d = this;
}

QPMDragData::~QPMDragData()
{
    reset();

    QDragManager *manager = QDragManager::self();
    Q_ASSERT(manager->dropData->d == this);
    manager->dropData->d = 0;
}

void QPMDragData::initialize(DRAGINFO *info)
{
    Q_ASSERT(info);
    if (initialized || !info)
        return;

    initialized = true;
    di = info;
}

void QPMDragData::initWorkers()
{
    Q_ASSERT(initialized);
    if (!initialized || gotWorkers)
        return;

    gotWorkers = true;

    // @todo later
#if 0
    // go through all convertors and collect DropWorkers to use
    QPtrList<QPMMime> mimes = QPMMime::all();
    for ( QPMMime *mime = mimes.first(); mime; mime = mimes.next() ) {
        QPMMime::DropWorker *wrk = mime->dropWorkerFor( di );
        if ( wrk ) {
            if ( wrk->isExclusive() ) {
                // ignore all other workers if some of them identified itself
                // as exclusive
                workers.clear();
                workers.append( wrk );
                break;
            }
            // ensure there are no duplicates
            if ( !workers.containsRef( wrk ) )
                workers.append( wrk );
        }
    }

    DEBUG(() << "QPMDragData:" << workers.count() << "drop workers for DRAGINFO" << di);

    // init all workers
    for ( QPMMime::DropWorker *w = workers.first(); w; w = workers.next() ) {
        w->nfo = di;
        w->init();
    }
#endif
}

void QPMDragData::reset(bool isAccepted, bool isActAccepted)
{
    if (!initialized)
        return;

    // @todo later
#if 0
    // cleanup all workers
    for ( QPMMime::DropWorker *w = workers.first(); w; w = workers.next() ) {
        w->cleanup( isAccepted, isActAccepted );
        w->nfo = NULL;
    }

    workers.clear();
#endif
    di = NULL;
    initialized = dropped = gotWorkers = FALSE;
}

bool QPMDragData::hasFormat_sys(const QString &mimeType)
{
    return false;
}

QStringList QPMDragData::formats_sys()
{
    return QStringList();
}

QVariant QPMDragData::retrieveData_sys(const QString &mimeType,
                                       QVariant::Type type)
{
    QVariant result;

    // we may only do data transfer after DM_DROP is sent. Return shortly.
    if (!isDropped())
        return result;

    return result;
}

// @todo later
#if 0
class QPMDropEvent : public QDropEvent
{
public:
    QPMDropEvent( const QPoint &pos, QPMDragData *data )
        : QDropEvent( pos ) { d = data; }

    inline bool isTrulyAccepted() const { return accpt; }
    inline bool isActionTrulyAccepted() const { return accptact; }
};

class QPMDragEnterEvent : public QDragEnterEvent
{
public:
    QPMDragEnterEvent( const QPoint &pos, QPMDragData *data )
        : QDragEnterEvent( pos ) { d = data; }

    inline bool isTrulyAccepted() const { return accpt; }
    inline bool isActionTrulyAccepted() const { return accptact; }
};

class QPMDragMoveEvent : public QDragMoveEvent
{
public:
    QPMDragMoveEvent( const QPoint &pos, QPMDragData *data )
        : QDragMoveEvent( pos ) { d = data; }

    inline bool isTrulyAccepted() const { return accpt; }
    inline bool isActionTrulyAccepted() const { return accptact; }
};

bool QDropEvent::provides( const char* mimeType ) const
{
    QPMDragData *data = static_cast<QPMDragData *> (d);
    Q_ASSERT( data );
    if ( !data )
        return FALSE;

    return data->provides( mimeType );
}

const char *QDropEvent::format( int fn ) const
{
    QPMDragData *data = static_cast<QPMDragData *> (d);
    Q_ASSERT( data );
    if ( !data )
        return NULL;

    return data->format( fn );
}

QByteArray QDropEvent::encodedData( const char *format ) const
{
    QByteArray array;

    QPMDragData *data = static_cast<QPMDragData *> (d);
    Q_ASSERT( data );

    if ( !data || !data->isDropped() ) {
        // This is a QDragEnterEvent/QDragMoveEvent subclass; we cannot provide
        // any MIME contents yet because it's impossible to do data transfers
        // before DM_DROP is sent. Return shortly.
        return array;
    }

    array = data->encodedData( format );
    return array;
}
#endif

/*!
 *  \internal
 *  Direct manipulation (Drag & Drop) event handler
 */
MRESULT qt_dispatchDragAndDrop(QWidget *widget, const QMSG &qmsg)
{
    static HWND lastDragOverHwnd = 0; // last target window
    static USHORT lastDragOverOp = 0; // last DM_DRAGOVER operation
    static USHORT lastRealOp = 0; // last real op (never DO_DEFAULT or DO_UNKNOWN)
    static USHORT defaultOp = 0; // default op for DO_DEFAULT or DO_UNKNOWN

    static USHORT supportedOps = 0; // operations supported by all items
    static bool sourceAllowsOp = FALSE; // does source allow requested operation

    static bool lastAccept = FALSE; // last reply from the target
    static bool lastAcceptAction = FALSE; // last action reply from the target

    static QPMDragData dragData;

    Q_ASSERT(widget);

    BOOL ok = FALSE;

    switch( qmsg.msg ) {
        case DM_DRAGOVER: {
            bool first = lastDragOverHwnd != qmsg.hwnd;
            if (first) {
                // the first DM_DRAGOVER message
                lastDragOverHwnd = qmsg.hwnd;
                lastAccept = lastAcceptAction = FALSE;
                supportedOps = DO_COPYABLE | DO_MOVEABLE | DO_LINKABLE;
                // ensure drag data is reset (just in case of a wrong msg flow...)
                dragData.reset();
            }

            Q_ASSERT(first || widget->acceptDrops());
            if (!widget->acceptDrops()) {
                if (!first) {
                    // Odin32 apps are dramatically bogus, they continue to send
                    // DM_DRAGOVER even if we reply DOR_NEVERDROP. Simulate
                    // DM_DRAGLEAVE
                    lastDragOverHwnd = 0;
                    dragData.reset();
                }
                return MRFROM2SHORT(DOR_NEVERDROP, 0);
            }

            DRAGINFO *info = (DRAGINFO *)qmsg.mp1;
            ok = DrgAccessDraginfo(info);
            Q_ASSERT(ok && info);
            if (!ok || !info)
                return MRFROM2SHORT(DOR_NEVERDROP, 0);

            USHORT dropReply = DOR_DROP;

            if (first) {
                // determine the set of operations supported by *all* items
                // (this implies that DRAGITEM::fsSupportedOps is a bit field)
                ULONG itemCount = DrgQueryDragitemCount(info);
                for (ULONG i = 0; i < itemCount; ++ i) {
                    PDRAGITEM item = DrgQueryDragitemPtr(info, i);
                    Q_ASSERT(item);
                    if (!item) {
                        dropReply = DOR_NEVERDROP;
                        break;
                    }
                    supportedOps &= item->fsSupportedOps;
                }
                if (dropReply != DOR_NEVERDROP) {
                    Q_ASSERT(itemCount);
                    if (!itemCount || !supportedOps) {
                        // items don't have even a single common operation...
                        dropReply = DOR_NEVERDROP;
                    } else {
                        // determine the default operation
                        // (in order MOVE, COPY, LINK, for compatibility with Win32)
                        if      (supportedOps & DO_MOVEABLE) defaultOp = DO_MOVE;
                        else if (supportedOps & DO_COPYABLE) defaultOp = DO_COPY;
                        else if (supportedOps & DO_LINKABLE) defaultOp = DO_LINK;
                        else Q_ASSERT(false); // should never happen
                    }
                }
            }

            if (dropReply != DOR_NEVERDROP) {

                if (first || lastDragOverOp != info->usOperation) {
                    // the current drop operation was changed by a modifier key
                    lastDragOverOp = info->usOperation;
                    lastRealOp = info->usOperation;
                    if (lastRealOp == DO_DEFAULT || lastRealOp == DO_UNKNOWN) {
                        // the default operation is requested
                        lastRealOp = defaultOp;
                    }
                    sourceAllowsOp =
                        ((supportedOps & DO_MOVEABLE) && lastRealOp == DO_MOVE) ||
                        ((supportedOps & DO_COPYABLE) && lastRealOp == DO_COPY) ||
                        ((supportedOps & DO_LINKABLE) && lastRealOp == DO_LINK);
                }

                // Note that if sourceAllowsOp = false here, we have to deliver
                // events anyway (stealing them from Qt would be confusing), but
                // we will silently ignore any accept commands and always reject
                // the drop. Other platforms seem to do the same.

                // convert the operation to an Action
                Qt::DropAction action = Qt::CopyAction;
                if      (lastRealOp == DO_COPY) action = Qt::CopyAction;
                else if (lastRealOp == DO_MOVE) action = Qt::MoveAction;
                else if (lastRealOp == DO_LINK) action = Qt::LinkAction;
                else Q_ASSERT(false); // should never happen

                // flip y coordinate
                QPoint pnt(info->xDrop, info->yDrop);
                pnt.setY(QApplication::desktop()->height() - (pnt.y() + 1));
                pnt = widget->mapFromGlobal(pnt);

                // initialize drag data used in QPMDrag.../QPMDrop... events
                if (first)
                    dragData.initialize(info);

                // @todo later
#if 0
                QDropEvent *de = NULL;
                QPMDragEnterEvent *dee = NULL;
                QPMDragMoveEvent *dme = NULL;

                if (first)
                    de = dee = new QPMDragEnterEvent(pnt, &dragData);
                else
                    de = dme = new QPMDragMoveEvent(pnt, &dragData);

                de->setAction(action);
                de->accept(lastAccept);
                de->acceptAction(lastAcceptAction);

                QApplication::sendEvent(widget, de);

                // if not allowed or not accepted, always reply DOR_NODROP
                // to have DM_DRAGOVER delivered to us again in any case

                dropReply = sourceAllowsOp && de->isAccepted() ?
                            DOR_DROP : DOR_NODROP;

                lastAccept = dee ? dee->isTrulyAccepted() :
                                   dme->isTrulyAccepted();
                lastAcceptAction = dee ? dee->isActionTrulyAccepted() :
                                         dme->isActionTrulyAccepted();
                delete de;
#endif
            }

            DrgFreeDraginfo(info);

            return MRFROM2SHORT(dropReply, lastRealOp);
        }
        case DM_DRAGLEAVE: {
            // Odin32 apps produce incorrect message flow, ignore
            Q_ASSERT(lastDragOverHwnd != 0);
            if (lastDragOverHwnd == 0)
                return 0;

            lastDragOverHwnd = 0;
            dragData.reset();

            if (!widget->acceptDrops())
                return 0;

            QDragLeaveEvent de;
            QApplication::sendEvent(widget, &de);
            return 0;
        }
        case DM_DROP: {
            // Odin32 apps produce incorrect message flow, ignore
            Q_ASSERT(lastDragOverHwnd != 0);
            if (lastDragOverHwnd == 0)
                return 0;

            // Odin32 apps send DM_DROP even if we replied DOR_NEVERDROP or
            // DOR_NODROP, simulate DM_DRAGLEAVE
            Q_ASSERT(lastAccept || lastAcceptAction);
            if (!lastAccept && !lastAcceptAction) {
                WinSendMsg(qmsg.hwnd, DM_DRAGLEAVE, 0, 0);
                return 0;
            }

            lastDragOverHwnd = 0;

            Q_ASSERT(widget->acceptDrops());
            if (!widget->acceptDrops())
                return 0;

            DRAGINFO *info = (DRAGINFO *)qmsg.mp1;
            ok = DrgAccessDraginfo(info);
            Q_ASSERT(ok && info);
            if (!ok || !info)
                return MRFROM2SHORT(DOR_NEVERDROP, 0);

            Q_ASSERT(lastRealOp == info->usOperation);

            // convert the operation to an Action
            Qt::DropAction action = Qt::CopyAction;
            if      (lastRealOp == DO_COPY ) action = Qt::CopyAction;
            else if (lastRealOp == DO_MOVE ) action = Qt::MoveAction;
            else if (lastRealOp == DO_LINK ) action = Qt::LinkAction;
            else Q_ASSERT(false); // should never happen

            // flip y coordinate
            QPoint pnt(info->xDrop, info->yDrop);
            pnt.setY(QApplication::desktop()->height() - (pnt.y() + 1));

            dragData.setDropped(true);

            // @todo later
#if 0
            QPMDropEvent de(widget->mapFromGlobal(pnt), &dragData);
            de.setAction(action);
            de.accept(lastAccept);
            de.acceptAction(lastAcceptAction);

            QApplication::sendEvent(widget, &de);

            dragData.reset(de.isTrulyAccepted(), de.isActionTrulyAccepted());

            // If the target has accepted the particular Drop action (using
            // acceptProposedAction() rather than just accept()), it means that
            // it will perform the necessary operation on its own (for example,
            // will delete the source if the accepted action is Move). In this
            // case, we always send DMFL_TARGETFAIL to the source to prevent it
            // from doing the same on its side.

            ULONG targetReply =
                de.isTrulyAccepted() && !de.isActionTrulyAccepted() ?
                DMFL_TARGETSUCCESSFUL : DMFL_TARGETFAIL;
#else
            ULONG targetReply = DMFL_TARGETFAIL;
#endif

            // send DM_ENDCONVERSATION for every item
            ULONG itemCount = DrgQueryDragitemCount(info);
            for (ULONG i = 0; i < itemCount; ++ i) {
                PDRAGITEM item = DrgQueryDragitemPtr(info, i);
                Q_ASSERT(item);
                if (!item)
                    continue;
                // it is possible that this item required DM_RENDERPREPARE but
                // returned FALSE in reply to it (so hwndItem may be NULL)
                if (!item->hwndItem)
                    continue;
                DrgSendTransferMsg(item->hwndItem, DM_ENDCONVERSATION,
                                   MPFROMLONG(item->ulItemID),
                                   MPFROMLONG(targetReply));
            }

            DrgDeleteDraginfoStrHandles(info);
            DrgFreeDraginfo(info);

            return 0;
        }
        default:
            break;
    }

    return WinDefWindowProc(qmsg.hwnd, qmsg.msg, qmsg.mp1, qmsg.mp2);
}

//---------------------------------------------------------------------
//                    QDropData
//---------------------------------------------------------------------

bool QDropData::hasFormat_sys(const QString &mimeType) const
{
    Q_ASSERT(d);
    if (d)
        return d->hasFormat_sys(mimeType);
    return false;
}

QStringList QDropData::formats_sys() const
{
    QStringList fmts;
    Q_ASSERT(d);
    if (d)
        fmts = d->formats_sys();
    return fmts;
}

QVariant QDropData::retrieveData_sys(const QString &mimeType, QVariant::Type type) const
{
    QVariant result;
    Q_ASSERT(d);
    if (d)
        result = d->retrieveData_sys(mimeType, type);
    return result;
}

Qt::DropAction QDragManager::drag(QDrag *o)

{
    DEBUG(() << "QDragManager::drag");

    // @todo implement
    return Qt::IgnoreAction;
}

void QDragManager::cancel(bool /* deleteSource */)
{
    // @todo implement
}

void QDragManager::updatePixmap()
{
    // not used in PM implementation
}

bool QDragManager::eventFilter(QObject *, QEvent *)
{
    // not used in PM implementation
    return false;
}

void QDragManager::timerEvent(QTimerEvent*)
{
    // not used in PM implementation
}

void QDragManager::move(const QPoint &)
{
    // not used in PM implementation
}

void QDragManager::drop()
{
    // not used in PM implementation
}

QT_END_NAMESPACE

#endif // QT_NO_DRAGANDDROP
