/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Qt Software Information (qt-info@nokia.com)
**
** Copyright (C) 2009 netlabs.org. OS/2 parts.
**
** This file is part of the QtGui module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial Usage
** Licensees holding valid Qt Commercial licenses may use this file in
** accordance with the Qt Commercial License Agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Nokia.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain
** additional rights. These rights are described in the Nokia Qt LGPL
** Exception version 1.0, included in the file LGPL_EXCEPTION.txt in this
** package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
** $QT_END_LICENSE$
**
****************************************************************************/

#include "qclipboard.h"

#ifndef QT_NO_CLIPBOARD

#include "qapplication.h"
#include "qapplication_p.h"
#include "qeventloop.h"
#include "qwidget.h"
#include "qevent.h"
#include "qmime.h"
#include "qt_os2.h"
#include "qdnd_p.h"

QT_BEGIN_NAMESPACE

////////////////////////////////////////////////////////////////////////////////

class QClipboardWatcher : public QInternalMimeData
{
public:
    QClipboardWatcher() {}

    bool hasFormat_sys(const QString &mimetype) const;
    QStringList formats_sys() const;
    QVariant retrieveData_sys(const QString &mimetype, QVariant::Type preferredType) const;
};

bool QClipboardWatcher::hasFormat_sys(const QString &mime) const
{
    bool ok = false;
    if (WinOpenClipbrd(NULLHANDLE)) {
        ULONG cf = 0;
        while ((cf = WinEnumClipbrdFmts(NULLHANDLE, cf))) {
//          if (QPMMime::converterToMime(mime, cf)) {
//              ok = true;
//              break;
//          }
        }
        WinCloseClipbrd(NULLHANDLE);
    }
#ifndef QT_NO_DEBUG
    else
        qWarning("QClipboardWatcher: WinOpenClipbrd failed with %lX",
                 WinGetLastError(NULLHANDLE));
#endif
    return ok;
}

QStringList QClipboardWatcher::formats_sys() const
{
    QStringList fmts;
    if (WinOpenClipbrd(NULLHANDLE)) {
//      fmts = QPMMime::allMimesForFormats();
        WinCloseClipbrd(NULLHANDLE);
    }
#ifndef QT_NO_DEBUG
    else
        qWarning("QClipboardWatcher: WinOpenClipbrd failed with %lX",
                 WinGetLastError(NULLHANDLE));
#endif
    return fmts;
}

QVariant QClipboardWatcher::retrieveData_sys(const QString &mime,
                                             QVariant::Type type) const
{
    QStringList fmts;
    if (WinOpenClipbrd(NULLHANDLE)) {
        // @todo enumerate all formats and select the best converter
//      QPMMime *converter = QPMMime::converterToMime(mime, cf);
//      if (converter)
//          result = converter->convertToMime(mime, cf, type);
        WinCloseClipbrd(NULLHANDLE);
    }
#ifndef QT_NO_DEBUG
    else
        qWarning("QClipboardWatcher: WinOpenClipbrd failed with %lX",
                 WinGetLastError(NULLHANDLE));
#endif
    return fmts;
}

////////////////////////////////////////////////////////////////////////////////

class QClipboardData
{
public:
    QClipboardData();
    ~QClipboardData();

    // @todo ...

private:
};

QClipboardData::QClipboardData()
{
}

QClipboardData::~QClipboardData()
{
}

static QClipboardData *ptrClipboardData = 0;

static QClipboardData *clipboardData()
{
    if (ptrClipboardData == 0) {
        ptrClipboardData = new QClipboardData;
        // @todo ...
    }
    return ptrClipboardData;
}

static void cleanupClipboardData()
{
    delete ptrClipboardData;
    ptrClipboardData = 0;
}

////////////////////////////////////////////////////////////////////////////////

QClipboard::~QClipboard()
{
    cleanupClipboardData();
}

void QClipboard::setMimeData(QMimeData *src, Mode mode)
{
    // @todo implement
}

void QClipboard::clear(Mode mode)
{
    // @todo implement
}

bool QClipboard::event(QEvent *e)
{
    // @todo implement
    return false;
}

void QClipboard::connectNotify(const char *signal)
{
    // @todo implement
}

const QMimeData *QClipboard::mimeData(Mode mode) const
{
    // @todo implement
    return 0;
}

bool QClipboard::supportsMode(Mode mode) const
{
    return (mode == Clipboard);
}

bool QClipboard::ownsMode(Mode mode) const
{
    // @todo implement
    return false;
}

void QClipboard::ownerDestroyed()
{
}

QT_END_NAMESPACE

#endif // QT_NO_CLIPBOARD
