/*
 * Extended system tray widget for XCenter/eCenter
 *
 * Public API
 *
 * Made by netlabs.org
 *
 * Author: Dmitry A. Kuminov
 *
 * This software is public domain.
 *
 * WITHOUT ANY WARRANTY..., AT YOUR OWN RISC... ETC.
 *
 */

#ifndef XSYSTRAY_API_HEADER_INCLUDED
#define XSYSTRAY_API_HEADER_INCLUDED

#if __cplusplus
extern "C" {
#endif

// notification code constants for the notification messages sent by the system
// tray (refer to xstAddSysTrayIcon() for details)
#define XST_IN_MOUSE    0x0001
#define XST_IN_CONTEXT  0x0002
#define XST_IN_WHEEL    0x0003

// structure for XST_IN_MOUSE
typedef struct
{
    ULONG  ulMouseMsg;
           // mouse message (one of WM_BUTTONxyyy)
    POINTS ptsPointerPos;
           // global pointer position at the time of the mouse event
    USHORT fsHitTestRes;
           // hit-test result (see WM_BUTTONxyyy description in PM)
    USHORT fsFlags;
           // keyboard control codes (see WM_BUTTONxyyy description in PM)

} XSTMOUSEMSG, *PXSTMOUSEMSG;

// structure for XST_IN_CONTEXT
typedef struct
{
    POINTS ptsPointerPos;
           // global pointer position at the time of the mouse event
    USHORT fPointer;
           // input device flag (see WM_CONTEXTMENU description in PM)

} XSTCONTEXTMSG, *PXSTCONTEXTMSG;

// structure for XST_IN_WHEEL
typedef struct
{
    ULONG  ulWheelMsg;
           // mouse message (one of WM_HSCROLL or WM_VSCROLL)
    POINTS ptsPointerPos;
           // global pointer position at the time of the mouse event
    USHORT usCmd;
           // command (see WM_HSCROLL/WM_VSCROLL description in PM)

} XSTWHEELMSG, *PXSTWHEELMSG;

BOOL xstQuerySysTrayVersion(PULONG pulMajor, PULONG pulMinor, PULONG pulRevision);
BOOL xstAddSysTrayIcon(HWND hwnd, USHORT usId, HPOINTER hIcon, ULONG ulMsgId,
                       ULONG ulFlags);
BOOL xstRemoveSysTrayIcon(HWND hwnd, USHORT usId);
BOOL xstSetSysTrayIconToolTip(HWND hwnd, USHORT usId, PSZ pszText);
BOOL xstShowSysTrayIconBalloon(HWND hwnd, USHORT usId, PSZ pszTitle, PSZ pszText,
                               ULONG ulFlags, ULONG ulTimeout);
BOOL xstHideSysTrayIconBalloon(HWND hwnd, USHORT usId);

BOOL xstQuerySysTrayIconRect(HWND hwnd, USHORT usId, PRECTL prclRect);

ULONG xstGetSysTrayCreatedMsgId();

ULONG xstGetSysTrayMaxTextLen();

#if __cplusplus
}
#endif

#endif // XSYSTRAY_API_HEADER_INCLUDED

