/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Qt Software Information (qt-info@nokia.com)
**
** Copyright (C) 2009 netlabs.org. OS/2 parts.
**
** This file is part of the QtGui module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial Usage
** Licensees holding valid Qt Commercial licenses may use this file in
** accordance with the Qt Commercial License Agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Nokia.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain
** additional rights. These rights are described in the Nokia Qt LGPL
** Exception version 1.0, included in the file LGPL_EXCEPTION.txt in this
** package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
** $QT_END_LICENSE$
**
****************************************************************************/

#include "qpixmap.h"
#include "qpixmap_raster_p.h"

#include "qicon.h"
#include "qbitmap.h"
#include "qpainter.h"

#include "qt_os2.h"

QT_BEGIN_NAMESPACE

HPS qt_alloc_mem_ps(int w, int h, HPS compat = 0)
{
    HDC hdcCompat = NULLHANDLE;
    if (compat)
        hdcCompat = GpiQueryDevice(compat);

    static const PSZ hdcData[4] = { "Display", NULL, NULL, NULL };
    HDC hdc = DevOpenDC(0, OD_MEMORY, "*", 4, (PDEVOPENDATA) hdcData, hdcCompat);
    if (!hdc) {
        qWarning( "alloc_mem_dc: DevOpenDC failed with %08lX!", WinGetLastError(0));
        return NULLHANDLE;
    }
    SIZEL size = { w, h };
    HPS hps = GpiCreatePS(0, hdc, &size, PU_PELS | GPIA_ASSOC | GPIT_MICRO);
    if (hps == NULLHANDLE) {
        qWarning("alloc_mem_dc: GpiCreatePS failed wit %08lX!", WinGetLastError(0));
        return NULLHANDLE;
    }
    // @todo later
//  if (QColor::hPal()) {
//      GpiSelectPalette(hps, QColor::hPal());
//  } else {
        // direct RGB mode
        GpiCreateLogColorTable(hps, 0, LCOLF_RGB, 0, 0, NULL);
//  }
    return hps;
}

void qt_free_mem_ps(HPS hps)
{
    HDC hdc = GpiQueryDevice(hps);
    GpiAssociate(hps, NULLHANDLE);
    GpiDestroyPS(hps);
    DevCloseDC(hdc);
}

/*!
    Creates a \c HBITMAP equivalent to the QPixmap. Returns the \c HBITMAP
    handle.

    If \a mask is not NULL, the mask mode is turned. In this mode, the bitmap
    mask is also created from the QPixmap's mask and returned in the given
    variable. This bitmap mask will contain two vertically adjacent sections,
    the first of which is the AND mask and the second one is the XOR mask
    (according to WinCreatePointer() specification). Also, in mask mode, the
    HBITMAP returned for the pixmap itself will be prepared for masking (with
    transparent pixels made black). This mode is useful for creating system
    icons and pointers (\sa toPmHPOINTER()).

    Note that if the pixmap does neither have a maks nor the alpha channel but
    \a mask is not NULL, a NULLHANDLE value will be stored there.

    It is the caller's responsibility to free both returned \c HBITMAP handes
    after use.

    \warning This function is only available on OS/2.
*/
HBITMAP QPixmap::toPmHBITMAP(HBITMAP *mask) const
{
    if (data->classId() != QPixmapData::RasterClass) {
        QPixmapData *data = new QRasterPixmapData(depth() == 1 ?
                                                  QPixmapData::BitmapType : QPixmapData::PixmapType);
        data->fromImage(toImage(), Qt::AutoColor);
        return QPixmap(data).toPmHBITMAP(mask);
    }

    QRasterPixmapData* d = static_cast<QRasterPixmapData*>(data);
    int w = d->image.width();
    int h = d->image.height();

    HPS hps = qt_alloc_mem_ps(w, h * 2);
    if (hps == NULLHANDLE)
        return NULLHANDLE;

    HBITMAP hbm = NULLHANDLE;
    HBITMAP hbmMask = NULLHANDLE;

    QImage image = d->image.convertToFormat(QImage::Format_ARGB32).mirrored();

    // bitmap header + 2 palette entries (for the mask)
    char bmi[sizeof(BITMAPINFOHEADER2) + 4 * 2];
    memset(bmi, 0, sizeof(bmi));
    BITMAPINFOHEADER2 &bmh = *(PBITMAPINFOHEADER2)bmi;
    bmh.cbFix = sizeof(BITMAPINFOHEADER2);
    PULONG pal = (PULONG)(bmi + sizeof(BITMAPINFOHEADER2));

    // create the normal bitmap from the pixmap data
    bmh.cx = w;
    bmh.cy = h;
    bmh.cPlanes = 1;
    bmh.cBitCount = 32;
    hbm = GpiCreateBitmap(hps, &bmh, CBM_INIT, (PBYTE)(const uchar *)image.bits(),
                          (PBITMAPINFO2)&bmi);

    if (mask && hasAlpha()) {
        // get the mask. We prefer QImage::createAlphaMask() over QPixmap::mask()
        // since the former will dither while the latter will convert any
        // non-zero alpha value to an opaque pixel
#if 1
        QImage mask = image.createAlphaMask().convertToFormat(QImage::Format_Mono);

        // note: for some strange reason, createAlphaMask() (as opposed to
        // mask().toImage()) returns an image already flipped top to bottom,
        // so take it into account

        // create the AND mask
        mask.invertPixels();
        // add the XOR mask (and leave it zeroed)
        mask = mask.copy(0, -h, w, h * 2);

#else
        QImage mask = this->mask().toImage().convertToFormat(QImage::Format_Mono);

        // create the AND mask
        mask.invertPixels();
        // add the XOR mask (and leave it zeroed)
        mask = mask.copy(0, 0, w, h * 2);
        // flip the bitmap top to bottom for PM
        mask = mask.mirrored(false, true);
#endif

        // create the mask bitmap
        bmh.cbFix = sizeof(BITMAPINFOHEADER2);
        bmh.cx = w;
        bmh.cy = h * 2;
        bmh.cPlanes = 1;
        bmh.cBitCount = 1;
        bmh.cclrUsed = 2;
        pal[0] = 0;
        pal[1] = 0x00FFFFFF;
        hbmMask = GpiCreateBitmap(hps, &bmh, CBM_INIT,
                                  (PBYTE)(const uchar *)mask.bits(),
                                  (PBITMAPINFO2)&bmi);

        // prepare the bitmap for masking by setting transparent pixels to black
        GpiSetBitmap(hps, hbm);

        POINTL ptls[] = {
            { 0, 0 }, { w - 1, h - 1 },     // dst: inclusive-inclusive
            { 0, h }, { w, h * 2 },             // src: inclusive-exclusive
        };
        ptls[0].y -= h;
        ptls[1].y -= h;
        enum { AllImageAttrs = IBB_COLOR | IBB_BACK_COLOR |
                               IBB_MIX_MODE | IBB_BACK_MIX_MODE };
        IMAGEBUNDLE ib = { CLR_TRUE, CLR_FALSE, FM_OVERPAINT, BM_OVERPAINT };
        GpiSetAttrs(hps, PRIM_IMAGE, AllImageAttrs, 0, (PBUNDLE)&ib);
        GpiDrawBits(hps, (PBYTE)(const uchar *)mask.bits(), (PBITMAPINFO2)&bmi,
                    4, ptls, ROP_SRCAND, BBO_IGNORE);
    }

    qt_free_mem_ps(hps);

    if (mask)
        *mask = hbmMask;

    return hbm;
}

/*!
    Creates a \c HPOINTER from the given QIcon. Returns the \c HPOINTER handle.

    If \a isPointer is \c true, an icon size closest to the system pointer size
    is chosen, otherwise to the system icon size. \a hotX and \a hotY define the
    hot spot.

    It is the caller's responsibility to free the \c HPOINTER data
    after use.

    \warning This function is only available on OS/2.
*/
// static
HPOINTER QPixmap::toPmHPOINTER(const QIcon &icon, bool isPointer,
                               int hotX, int hotY)
{
    if (icon.isNull())
        return NULLHANDLE;

    // get the system icon size
    int w = WinQuerySysValue(HWND_DESKTOP, isPointer ? SV_CXPOINTER : SV_CXICON);
    int h = WinQuerySysValue(HWND_DESKTOP, isPointer ? SV_CYPOINTER : SV_CYICON);
    int w2 = w / 2;
    int h2 = h / 2;

    // obtain the closest (but never larger) icon sizes we have
    QSize size = icon.actualSize(QSize(w, h));
    QSize sizeMini = icon.actualSize(QSize(w2, h2));

    QPixmap pm = icon.pixmap(size);
    QPixmap pmMini = icon.pixmap(sizeMini);
    if (pm.isNull() && pmMini.isNull())
        return NULLHANDLE;

    // if we got smaller pixmaps then center them inside the system sized rect
    // instead of letting WinCreatePointerIndirect() scale them (this covers a
    // usual case when we got 32 and 16 px pixmaps on a 120 DPI system where the
    // icon size is 40 and 20 px respectively): scaling such small images looks
    // really ugly.
    if (!pm.isNull() && (pm.width() < w || pm.height() < h)) {
        Q_ASSERT(pm.width() <= w && pm.height() <= h);
        QPixmap pmNew(w, h);
        pmNew.fill(Qt::transparent);
        QPainter painter(&pmNew);
        painter.drawPixmap((w - pm.width()) / 2, (h - pm.height()) / 2, pm);
        pm = pmNew;
    }
    if (!pmMini.isNull() && (pmMini.width() < w2 || pmMini.height() < h2)) {
        Q_ASSERT(pmMini.width() <= w2 && pmMini.height() <= h2);
        QPixmap pmNew(w2, h2);
        pmNew.fill(Qt::transparent);
        QPainter painter(&pmNew);
        painter.drawPixmap((w2 - pmMini.width()) / 2, (h2 - pmMini.height()) / 2, pmMini);
        pmMini = pmNew;
    }

    if (pm.isNull()) {
        // if we only have the mini icon, use it as a normal one;
        // WinCreatePointerIndirect() will figure that and not scale it
        pm = pmMini;
        pmMini = QPixmap();
    }

    POINTERINFO info;
    info.fPointer = isPointer;
    info.xHotspot = hotX;
    info.yHotspot = hotY;
    info.hbmColor = pm.toPmHBITMAP(&info.hbmPointer);
    if (!pmMini.isNull()) {
        info.hbmMiniColor = pmMini.toPmHBITMAP(&info.hbmMiniPointer);
    } else {
        info.hbmMiniPointer = NULLHANDLE;
        info.hbmMiniColor = NULLHANDLE;
    }

    HPOINTER hIcon = WinCreatePointerIndirect(HWND_DESKTOP, &info);

    GpiDeleteBitmap(info.hbmPointer);
    GpiDeleteBitmap(info.hbmColor);
    GpiDeleteBitmap(info.hbmMiniPointer);
    GpiDeleteBitmap(info.hbmMiniColor);

    return hIcon;
}

QPixmap QPixmap::grabWindow(WId winId, int x, int y, int w, int h )
{
    // @todo implement
    return QPixmap();
}

QT_END_NAMESPACE
