/*
 * Extended system tray widget for XCenter/eCenter
 *
 * Internal declarations
 *
 * Made by netlabs.org
 *
 * Author: Dmitry A. Kuminov
 *
 * This software is public domain.
 *
 * WITHOUT ANY WARRANTY..., AT YOUR OWN RISC... ETC.
 *
 */

#ifndef XSYSTRAY_HEADER_INCLUDED
#define XSYSTRAY_HEADER_INCLUDED

#define XSYSTRAY_VERSION_MAJOR 0
#define XSYSTRAY_VERSION_MINOR 1
#define XSYSTRAY_VERSION_REVISION 0

#define WNDCLASS_WIDGET_XSYSTRAY_SERVER "XWPCenterExtendedSysTrayServer"

#define WNDCLASS_WIDGET_XSYSTRAY        "XWPCenterExtendedSysTray"
#define INTCLASS_WIDGET_XSYSTRAY        "ExtendedSysTray"
#define HUMANSTR_WIDGET_XSYSTRAY        "Extended system tray"

#define WM_XST_CONTROL  (WM_USER + 0)

typedef enum
{
    SYSTRAYCMD_GETVERSION,
    SYSTRAYCMD_ADDICON,
    SYSTRAYCMD_REMOVEICON,
    SYSTRAYCMD_SETTOOLTIP,
    SYSTRAYCMD_SHOWBALLOON,
    SYSTRAYCMD_HIDEBALLOON,
} SYSTRAYCMD;

// NOTE: the idea is to fit SYSTRAYCTLDATA into a page (4K) since this is the
// smallest piece DosAllocSharedMem() allocates anyway.
typedef struct
{
    SYSTRAYCMD  ulCommand;
                // command to execute, must always be set
    HWND        hwndSender;
                // sender window, a must for SYSTRAYCMD_ADDICON, REMOVEICON,
                // SETTOOLTIP, SHOWBALLOON, HIDEBALLOON
    union
    {
        struct
        {
            ULONG ulMajor;
            ULONG ulMinor;
            ULONG ulRevision;
        } version;
          // used by SYSTRAYCMD_GETVERSION

        struct
        {
            ULONG       ulId;
            HPOINTER    hIcon;
            ULONG       ulMsgId;
        } icon;
          // used by SYSTRAYCMD_ADDICON, SYSTRAYCMD_REMOVEICON

        struct
        {
            ULONG   ulId;
            CHAR    szText[4000]; // occupy as much of 4K page as we can
        } tooltip;

    } u;

    BOOL    bAcknowledged : 1;
            // set to true by the recipient if it processes the message

} SYSTRAYCTLDATA, *PSYSTRAYCTLDATA;

#endif // XSYSTRAY_HEADER_INCLUDED


