/*
 * Extended system tray widget for XCenter/eCenter
 *
 * Public API
 *
 * Made by netlabs.org
 *
 * Author: Dmitry A. Kuminov
 *
 * This software is public domain.
 *
 * WITHOUT ANY WARRANTY..., AT YOUR OWN RISC... ETC.
 *
 */

#ifndef XSYSTRAY_API_HEADER_INCLUDED
#define XSYSTRAY_API_HEADER_INCLUDED

#if __cplusplus
extern "C" {
#endif

// notification code constants for WM_XST_NOTIFY, refer to xstAddSysTrayIcon()
#define XST_IN_MOUSE    0x0001

// structure for XST_IN_MOUSE
typedef struct
{
    ULONG  ulMouseMsg;
    POINTS ptsPointerPos;
    USHORT fsHitTestRes;
    USHORT fsFlags;

} XSTMOUSEMSG, *PXSTMOUSEMSG;

BOOL xstQuerySysTrayVersion(PULONG pulMajor, PULONG pulMinor, PULONG pulRevision);
BOOL xstAddSysTrayIcon(HWND hwnd, ULONG ulId, HPOINTER hIcon, ULONG ulMsgId,
                       ULONG ulFlags);
BOOL xstRemoveSysTrayIcon(HWND hwnd, ULONG ulId);
BOOL xstSetSysTrayIconToolTip(HWND hwnd, ULONG ulId, PSZ pszText);
BOOL xstShowSysTrayIconBalloon(HWND hwnd, ULONG ulId, PSZ pszTitle, PSZ pszText,
                               ULONG ulFlags, ULONG ulTimeout);
BOOL xstHideSysTrayIconBalloon(HWND hwnd, ULONG ulId);

BOOL xstQuerySysTrayIconRect(HWND hwnd, ULONG ulId, PRECTL prclRect);

ULONG xstGetSysTrayCreatedMsgId();

ULONG xstGetSysTrayMaxTextLen();

#if __cplusplus
}
#endif

#endif // XSYSTRAY_API_HEADER_INCLUDED

