#include <QDebug>

#include <QtGui>

#ifndef Q_WS_PM

// For printing non-quoted QString's with QDebug)
struct QDbgStr: public QString
{
    inline QDbgStr(const QString &str) : QString(str) {}
};

// Prints a non-quoted QString
inline QDebug operator<<(QDebug dbg, const QDbgStr &str)
{ dbg << str.toUtf8().constData(); return dbg; }

QDbgStr qWidgetName(QWidget *w)
{
    if (w)
        return QString()
            .sprintf("%s.%s", w->metaObject()->className(),
                     w->objectName().isEmpty() ? "<noname>" :
                     w->objectName().toUtf8().constData());
    return QString(QLatin1String("<no-widget>"));
}

#endif

#define myDefFlagEx(var,fl,varstr,flstr) if (var & fl) { \
    if (!varstr.isEmpty()) varstr += QLatin1String("|"); varstr += QLatin1String(flstr); \
} else do {} while(0)

#define myDefFlag(var,fl,varstr) myDefFlagEx(var,fl,varstr,#fl)
#define myDefFlagCut(var,fl,varstr,pos) myDefFlagEx(var,fl,varstr,#fl + pos)


QDebug operator<<(QDebug dbg, Qt::WindowStates st)
{
    QString name;
    myDefFlagEx(st, Qt::WindowMinimized, name, "Min");
    myDefFlagEx(st, Qt::WindowMaximized, name, "Max");
    myDefFlagEx(st, Qt::WindowFullScreen, name, "Full");
    myDefFlagEx(st, Qt::WindowActive, name, "Act");
    if (name.isEmpty()) name = QLatin1String("None");
    dbg.nospace() << "WindowState(" << QDbgStr(name) << ")";
    return dbg.space();
}

QDebug operator<<(QDebug dbg, Qt::FocusReason r)
{
    QString name;
    if (r == Qt::MouseFocusReason) name = "Mouse";
    if (r == Qt::TabFocusReason) name = "Tab";
    if (r == Qt::BacktabFocusReason) name = "Backtab";
    if (r == Qt::ActiveWindowFocusReason) name = "ActWin";
    if (r == Qt::PopupFocusReason) name = "Popup";
    if (r == Qt::ShortcutFocusReason) name = "Shortcut";
    if (r == Qt::MenuBarFocusReason) name = "MenuBar";
    if (r == Qt::OtherFocusReason) name = "Other";
    dbg.nospace() << "FocusReason(" << QDbgStr(name) << ")";
    return dbg.space();
}

class MyButton : public QPushButton
{
public:

    MyButton(QWidget *aParent) : QPushButton(aParent) {}

    void focusInEvent(QFocusEvent *aE)
    {
#if 0
        qDebug() << __FUNCTION__ << ":" << text() << "reason" << aE->reason()
                 << "focus" << (qApp->focusWidget() ?
                    qWidgetName(qApp->focusWidget()) : QDbgStr(QLatin1String("<none>")));
#endif
    }

    void focusOutEvent(QFocusEvent *aE)
    {
#if 0
        qDebug() << __FUNCTION__ << ":" << text() << "reason" << aE->reason()
                 << "focus" << (qApp->focusWidget() ?
                    qWidgetName(qApp->focusWidget()) : QDbgStr(QLatin1String("<none>")));
#endif
    }
};

class MyCombo : public QComboBox
{
public:

    MyCombo(QWidget *aParent) : QComboBox(aParent) {}

    void focusInEvent(QFocusEvent *aE)
    {
        update();
#if 0
        qDebug() << __FUNCTION__ << ":" << currentText() << "reason" << aE->reason()
                 << "focus" << (qApp->focusWidget() ?
                    qWidgetName(qApp->focusWidget()) : QDbgStr(QLatin1String("<none>")));
#endif
    }

    void focusOutEvent(QFocusEvent *aE)
    {
        update();
#if 0
        qDebug() << __FUNCTION__ << ":" << currentText() << "reason" << aE->reason()
                 << "focus" << (qApp->focusWidget() ?
                    qWidgetName(qApp->focusWidget()) : QDbgStr(QLatin1String("<none>")));
#endif
    }

#if 0
    void resizeEvent(QResizeEvent *aE)
    {
        qDebug() << __FUNCTION__ << ":"  << currentText() << "g" << geometry() << "fg" << frameGeometry()
                 << "sz" << aE->size() << "old" << aE->oldSize();
    }

    void moveEvent(QMoveEvent *aE)
    {
        qDebug() << __FUNCTION__ << ":" << currentText() << " g" << geometry() << "fg" << frameGeometry()
                 << "pos" << aE->pos() << "old" << aE->oldPos();
    }
#endif

#if 0
    virtual void enterEvent(QEvent *event)
    {
        qDebug() << __FUNCTION__ << ":" << currentText();
    }

    virtual void leaveEvent(QEvent *event)
    {
        qDebug() << __FUNCTION__ << ":" << currentText();
    }
#endif

#if 0
    void mousePressEvent(QMouseEvent *aE)
    {
        qDebug() << __FUNCTION__ << ": btn" << aE->button()
                 << QDbgStr(QString().sprintf("btns %08X mods %08X",
                                              (int) aE->buttons(), (int) aE->modifiers()))
                 << "gpos" << aE->globalPos() << "pos" << aE->pos();
        QComboBox::mousePressEvent(aE);
    }

    void mouseReleaseEvent(QMouseEvent *aE)
    {
        qDebug() << __FUNCTION__ << ": btn" << aE->button()
                 << QDbgStr(QString().sprintf("btns %08X mods %08X",
                                              (int) aE->buttons(), (int) aE->modifiers()))
                 << "gpos" << aE->globalPos() << "pos" << aE->pos();
        QComboBox::mouseReleaseEvent(aE);
    }

    void contextMenuEvent(QContextMenuEvent *aE)
    {
        QMenu menu;
        menu.addAction(QLatin1String("Action &1"));
        menu.addAction(QLatin1String("Action &2"));
        menu.exec(aE->globalPos());
        winId();
    }
#endif
};

class MyWidget : public QWidget
{
public:

    MyWidget()
    {
        //setFocusPolicy(Qt::StrongFocus);

//      MyButton *btn1 = new MyButton(this);
//      btn1->setText(QLatin1String("Hello 1"));
//      btn1->setObjectName("Hello 1");
//      btn1->move(20, 20);
//      MyButton *btn2 = new MyButton(this);
//      btn2->setText(QLatin1String("Hello 2"));
//      btn2->setObjectName("Hello 2");
//      btn2->move(20, 60);

        QComboBox *cb1 = new MyCombo(this);
        cb1->addItem(QLatin1String("Test 1"));
        cb1->addItem(QLatin1String("Test 2"));

//      QComboBox *cb2 = new MyCombo(this);
//      cb2->addItem(QLatin1String("Test 3"));
//      cb2->addItem(QLatin1String("Test 4"));

        QVBoxLayout *mainLayout = new QVBoxLayout();
//      mainLayout->addWidget(btn1);
//      mainLayout->addWidget(btn2);
        mainLayout->addWidget(cb1);
//      mainLayout->addWidget(cb2);

        setLayout(mainLayout);
    };

#if 0
    void paintEvent(QPaintEvent *aE)
    {
        qDebug() << __FUNCTION__ <<": " << aE->rect();

        QPainter p(this);
        p.setRenderHint(QPainter::Antialiasing);

        p.fillRect(0, 0, 20, 20, Qt::green);

        p.setPen(Qt::black);
        p.drawEllipse(10, 10, 10, 10);

        //p.setFont(QFont("Arial", 12));
        p.drawText(10, 30, QLatin1String("ABC"));
    }
#endif

#if 0
    void resizeEvent(QResizeEvent *aE)
    {
        qDebug() << __FUNCTION__ << ": g" << geometry() << "fg" << frameGeometry()
                 << "sz" << aE->size() << "old" << aE->oldSize();
    }

    void moveEvent(QMoveEvent *aE)
    {
        qDebug() << __FUNCTION__ << ": g" << geometry() << "fg" << frameGeometry()
                 << "pos" << aE->pos() << "old" << aE->oldPos();
    }
#endif

#if 0
    void focusInEvent(QFocusEvent *aE)
    {
        qDebug() << __FUNCTION__ << ": reason" << aE->reason();
    }

    void focusOutEvent(QFocusEvent *aE)
    {
        qDebug() << __FUNCTION__ << ": reason" << aE->reason();
    }
#endif

#if 0
    void changeEvent(QEvent *aE)
    {
        switch (aE->type()) {
        case QEvent::WindowStateChange: {
            QWindowStateChangeEvent *e2 = (QWindowStateChangeEvent *)aE;
            qDebug().nospace() << __FUNCTION__ << ": QWindowStateChangeEvent(" <<
                e2->oldState() << "->" << windowState() << ")";
            break;
        }
        default:
            break;
        }
    }
#endif

#if 0
    void keyPressEvent(QKeyEvent *aE)
    {
        qDebug() << __FUNCTION__ << "  : cnt" << aE->count()
                 << "rep" << aE->isAutoRepeat()
                 << QDbgStr(QString().sprintf("key %08X mods %08X", aE->key(), (int) aE->modifiers()))
                 << "text" << aE->text()
                 << QDbgStr(aE->text().isEmpty() ? QString() :
                            QString().sprintf("(%04X)", aE->text()[0].unicode()));
    }

    void keyReleaseEvent(QKeyEvent *aE)
    {
        qDebug() << __FUNCTION__ << ": cnt" << aE->count()
                 << "rep" << aE->isAutoRepeat()
                 << QDbgStr(QString().sprintf("key %08X mods %08X", aE->key(), (int) aE->modifiers()))
                 << "text" << aE->text()
                 << QDbgStr(aE->text().isEmpty() ? QString() :
                            QString().sprintf("(%04X)", aE->text()[0].unicode()));
    }
#endif

#if 0
    void mouseMoveEvent(QMouseEvent *aE)
    {
        qDebug() << __FUNCTION__ << ": btn" << aE->button()
                 << QDbgStr(QString().sprintf("btns %08X mods %08X",
                                              (int) aE->buttons(), (int) aE->modifiers()))
                 << "gpos" << aE->globalPos() << "pos" << aE->pos();
    }

    void mousePressEvent(QMouseEvent *aE)
    {
        qDebug() << __FUNCTION__ << ": btn" << aE->button()
                 << QDbgStr(QString().sprintf("btns %08X mods %08X",
                                              (int) aE->buttons(), (int) aE->modifiers()))
                 << "gpos" << aE->globalPos() << "pos" << aE->pos();
    }

    void mouseReleaseEvent(QMouseEvent *aE)
    {
        qDebug() << __FUNCTION__ << ": btn" << aE->button()
                 << QDbgStr(QString().sprintf("btns %08X mods %08X",
                                              (int) aE->buttons(), (int) aE->modifiers()))
                 << "gpos" << aE->globalPos() << "pos" << aE->pos();
    }
#endif

#if 0
    virtual void enterEvent(QEvent *event)
    {
        qDebug() << __FUNCTION__ << ":";
    }

    virtual void leaveEvent(QEvent *event)
    {
        qDebug() << __FUNCTION__ << ":";
    }
#endif

#if 0
    void contextMenuEvent(QContextMenuEvent *aE)
    {
        QMenu menu;
        menu.addAction(QLatin1String("Action &1"));
        menu.addAction(QLatin1String("Action &2"));
        menu.exec(aE->globalPos());
    }
#endif

#if 0
    void timerEvent(QTimerEvent *aE)
    {
        qDebug() << __FUNCTION__ << ": id" << aE->timerId();
    }
#endif
};

int main(int argc, char **argv)
{
    QApplication app(argc, argv);

    MyWidget widget;
    widget.resize(100, 100);
    widget.move(500, 500);

    widget.show();
    
#if 1
    {
        QFontDialog fntDlg;
        fntDlg.exec();
        
        {
            QFont font("MyCoolFont");
            QFontInfo info(font);
            qDebug() << info.family();
        }
        {
            QFont font("MyCoolFont2");
            QFontInfo info(font);
            qDebug() << info.family();
        }
    }
#endif

#if 0
    widget.startTimer(1000);
    widget.startTimer(2000);
    widget.startTimer(4000);
#endif

#if 0
    qDebug() << "------------- before min" << widget.geometry() << widget.frameGeometry();
    widget.showMinimized();
    qDebug() << "------------- after min" << widget.geometry() << widget.frameGeometry();
    widget.move(100, 100);
    qDebug() << "------------- after move" << widget.geometry() << widget.frameGeometry();
    widget.showNormal();
    qDebug() << "------------- after norm" << widget.geometry() << widget.frameGeometry();
    widget.showFullScreen();
    qDebug() << "------------- after full" << widget.geometry() << widget.frameGeometry();
#endif

    return app.exec();
}
