/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Qt Software Information (qt-info@nokia.com)
**
** Copyright (C) 2009 netlabs.org. OS/2 parts.
**
** This file is part of the QtGui module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial Usage
** Licensees holding valid Qt Commercial licenses may use this file in
** accordance with the Qt Commercial License Agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Nokia.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain
** additional rights. These rights are described in the Nokia Qt LGPL
** Exception version 1.0, included in the file LGPL_EXCEPTION.txt in this
** package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
** $QT_END_LICENSE$
**
****************************************************************************/

#include <private/qcursor_p.h>
#include <qbitmap.h>
#include <qcursor.h>

#ifndef QT_NO_CURSOR

#include <qimage.h>
#include <qapplication.h>
#include <qdesktopwidget.h>
#include <qt_os2.h>

QT_BEGIN_NAMESPACE

extern QCursorData *qt_cursorTable[Qt::LastCursor + 1]; // qcursor.cpp

/*****************************************************************************
  Internal QCursorData class
 *****************************************************************************/

QCursorData::QCursorData(Qt::CursorShape s)
  : cshape(s), bm(0), bmm(0), hx(0), hy(0), hptr(NULLHANDLE), isSysPtr(false)
{
    ref = 1;
}

QCursorData::~QCursorData()
{
    delete bm;
    delete bmm;
    if (hptr && !isSysPtr)
        WinDestroyPointer(hptr);
}


QCursorData *QCursorData::setBitmap(const QBitmap &bitmap, const QBitmap &mask, int hotX, int hotY)
{
    if (!QCursorData::initialized)
        QCursorData::initialize();
    if (bitmap.depth() != 1 || mask.depth() != 1 || bitmap.size() != mask.size()) {
        qWarning("QCursor: Cannot create bitmap cursor; invalid bitmap(s)");
        QCursorData *c = qt_cursorTable[0];
        c->ref.ref();
        return c;
    }
    QCursorData *d = new QCursorData;
    d->bm  = new QBitmap(bitmap);
    d->bmm = new QBitmap(mask);
    d->hptr = NULLHANDLE;
    d->cshape = Qt::BitmapCursor;
    d->hx = hotX >= 0 ? hotX : bitmap.width()/2;
    d->hy = hotY >= 0 ? hotY : bitmap.height()/2;
    return d;
}

HPOINTER QCursor::handle() const
{
    if (!QCursorData::initialized)
        QCursorData::initialize();
    if (d->hptr == NULLHANDLE)
        d->update();
    return d->hptr;
}

QCursor::QCursor(HPOINTER handle)
{
    d = new QCursorData(Qt::CustomCursor);
    d->hptr = handle;
}

#endif //QT_NO_CURSOR

QPoint QCursor::pos()
{
    POINTL p;
    WinQueryPointerPos(HWND_DESKTOP, &p);
    // flip y coordinate
    p.y = QApplication::desktop()->height() - (p.y + 1);
    return QPoint(p.x, p.y);
}

void QCursor::setPos(int x, int y)
{
    // flip y coordinate
    y = QApplication::desktop()->height() - (y + 1);
    WinSetPointerPos(HWND_DESKTOP, x, y);
}

#ifndef QT_NO_CURSOR

void QCursorData::update()
{
    if (!QCursorData::initialized)
        QCursorData::initialize();
    // @todo we depend on QPixmap vs HBITMAP integration here

    LONG id = 0;
    const uchar *bits = 0;
    const uchar *mask = 0;
    bool isbitmap = false;

    switch (cshape) { // map to OS/2 cursor
    case Qt::ArrowCursor:
    case Qt::UpArrowCursor: // @todo what's this?
    case Qt::CrossCursor: // @todo what's this?
        id = SPTR_ARROW;
	    break;
    case Qt::WaitCursor:
        id = SPTR_WAIT;
	    break;
    case Qt::IBeamCursor:
    	id = SPTR_TEXT;
    	break;
    case Qt::SizeVerCursor:
    	id = SPTR_SIZENS;
    	break;
    case Qt::SizeHorCursor:
    	id = SPTR_SIZEWE;
    	break;
    case Qt::SizeBDiagCursor:
    	id = SPTR_SIZENESW;
    	break;
    case Qt::SizeFDiagCursor:
    	id = SPTR_SIZENWSE;
    	break;
    case Qt::SizeAllCursor:
    	id = SPTR_MOVE;
    	break;
    case Qt::ForbiddenCursor:
    	id = SPTR_ILLEGAL;
    	break;
    default:
        // @temporary
        id = SPTR_ARROW;
        break;
        // @todo later here will be this:
//      qWarning("QCursor::update: Invalid cursor shape %d", cshape);
//      return;
    }


    if ((bits && mask) || isbitmap) {
        // @todo later
        hptr = 0;
        isSysPtr = false;
    } else {
        hptr = WinQuerySysPointer(HWND_DESKTOP, id, FALSE);
        isSysPtr = true;
    }
}

#endif // QT_NO_CURSOR

QT_END_NAMESPACE
