/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Qt Software Information (qt-info@nokia.com)
**
** Copyright (C) 2009 netlabs.org. OS/2 parts.
**
** This file is part of the QtGui module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial Usage
** Licensees holding valid Qt Commercial licenses may use this file in
** accordance with the Qt Commercial License Agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Nokia.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain
** additional rights. These rights are described in the Nokia Qt LGPL
** Exception version 1.0, included in the file LGPL_EXCEPTION.txt in this
** package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef QWINDOWDEFS_PM_H
#define QWINDOWDEFS_PM_H

#include <QtCore/qglobal.h>

QT_BEGIN_HEADER

QT_BEGIN_NAMESPACE

QT_MODULE(Gui)

QT_END_NAMESPACE

// typedefs to avoid inclusion of qt_os2.h in public headers
typedef unsigned long LHANDLE;
typedef LHANDLE HWND;
typedef LHANDLE HPS;
typedef LHANDLE HPOINTER;
typedef LHANDLE HRGN;
typedef struct _QMSG QMSG;
typedef void *MRESULT;

typedef HWND WId;

#define NULLHANDLE ((LHANDLE)0)

// constants to address extra window data
#define QWL_QTCLIPRGN       (QWL_USER)
#define QWL_QTMODAL         (QWL_USER + sizeof(ULONG))
#define QT_EXTRAWINDATASIZE (sizeof(LONG) * 2)

QT_BEGIN_NAMESPACE

class QWidget;

Q_GUI_EXPORT HPS qt_display_ps();

Q_GUI_EXPORT QWidget *qWidgetFromHWND(HWND hwnd);

// For printing non-quoted QString's with QDebug
struct Q_CORE_EXPORT QDbgStr: public QString
{
    inline QDbgStr(const QString &str) : QString(str) {}
};

Q_GUI_EXPORT QDbgStr qWidgetName(QWidget *w);
inline QDbgStr qWidgetName(HWND hwnd)
{ return qWidgetName(qWidgetFromHWND(hwnd)); }

Q_CORE_EXPORT QDbgStr qStrHWND(HWND hwnd);
Q_CORE_EXPORT QDbgStr qStrHPS(HPS hps);
Q_CORE_EXPORT QDbgStr qStrHPOINTER(HPOINTER hptr);
Q_CORE_EXPORT QDbgStr qStrHRGN(HRGN hrgn);

Q_CORE_EXPORT QDbgStr qStrQMSG(const QMSG &qmsg);

// the following declarations require OS/2 types not defined here,
// we don't drag them in but require qt_os2.h to be included before
#if defined(QT_OS2_H)

Q_CORE_EXPORT QDbgStr qStrRECTL(const RECTL &rcl);
Q_CORE_EXPORT QDbgStr qStrSWP(const SWP &swp);

#endif // defined(QT_OS2_H)

// don't drag qdebug.h as well but require it to be included before
#if defined(QDEBUG_H) && !defined(QT_NO_DEBUG_STREAM)

// Prints a non-quoted QString
inline QDebug operator<<(QDebug dbg, const QDbgStr &str)
{ dbg << str.toUtf8().constData(); return dbg; }

#if defined(QT_OS2_H)

inline QDebug operator<<(QDebug dbg, const RECTL &rcl)
{ dbg << qStrRECTL(rcl); return dbg; }

inline QDebug operator<<(QDebug dbg, const SWP &swp)
{ dbg << qStrSWP(swp); return dbg; }

#endif // defined(QT_OS2_H)

#endif // defined(QDEBUG_H) && !defined(QT_NO_DEBUG_STREAM)

QT_END_NAMESPACE

QT_END_HEADER

#endif // QWINDOWDEFS_WIN_H
