#ifdef __OS2__
#include <os2.h>
#endif

#include <QDebug>
#include <QtGui>

class VideoWidget : public QFrame
{
public:

    VideoWidget()
    {
        layout = new QHBoxLayout (this);
        layout->setContentsMargins (0, 0, 0, 0);
        setLayout (layout);
        stable = 0;
        show();
    }

    WId request()
    {
        stable = new QWidget();
        QPalette plt = palette();
        plt.setColor (QPalette::Window, Qt::black);
        stable->setPalette (plt);
        stable->setAutoFillBackground (true);
        stable->setAttribute (Qt::WA_PaintOnScreen, true);

        layout->addWidget (stable);

        WId id = stable->winId();
        qDebug() << "stable id" << qDebugHWND (id);
        return id;
    }

    void release()
    {
        layout->removeWidget (stable);
        stable->deleteLater();
        stable = 0;

        updateGeometry();
    }

    QHBoxLayout *layout;
    QWidget *stable;
};

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:

    MainWindow()
        : id (0), timerId (0)
    {
        /* menus */
        {
            QAction *playAct = new QAction ("&Play", this);
            playAct->setShortcut (QKeySequence("Ctrl+P"));
            playAct->setCheckable (true);
            connect (playAct, SIGNAL (triggered(bool)), SLOT (playTriggered(bool)));

            QAction *playListAct = new QAction ("Play&list", this);
            playListAct->setShortcut (QKeySequence("Ctrl+L"));
            playListAct->setCheckable (true);
            connect (playListAct, SIGNAL (triggered(bool)), SLOT (playListTriggered(bool)));

            QMenu *actionsMenu = menuBar()->addMenu ("&Actions");
            actionsMenu->addAction (playAct);
            actionsMenu->addAction (playListAct);
        }

        /* this mimics VLC behavior */

        QWidget *main = new QWidget();
        setCentralWidget (main);
        QVBoxLayout *mainLayout = new QVBoxLayout (main);
        main->setContentsMargins (0, 0, 0, 0);
        mainLayout->setSpacing (0);
        mainLayout->setMargin (0);

        stackCentralW = new QStackedWidget (main);

        // avoid hiding widgets when tossing the stack (just raise/lower)
        qobject_cast <QStackedLayout *> (stackCentralW->layout())
                ->setStackingMode (QStackedLayout::StackAll);

        bgWidget = new QLabel ("Background");
        stackCentralW->addWidget (bgWidget);

        videoWidget = new VideoWidget();
        stackCentralW->addWidget (videoWidget);

        mainLayout->insertWidget (1, stackCentralW);

        mainLayout->insertWidget (2, new QLabel ("Controls"));
    }

    void timerEvent (QTimerEvent *)
    {
        static int tickCount = 0;
        ++ tickCount;

        if (tickCount == 5)
            resize (800, 600);
#ifdef __OS2__
        if (id)
        {
            qDebug() << "window handle" << qDebugFmtHex (id);
            HWND hwnd = id;
            HPS hps = WinGetPS (hwnd);
            if (hps)
            {
                RECTL rcl;
//                WinQueryWindowRect (hwnd, &rcl);

                rcl.xLeft = 0;
                rcl.yBottom = 0;
                rcl.xRight = videoWidget->size().width();
                rcl.yTop = videoWidget->size().height();

                qDebug() << rcl.xRight << rcl.yTop;

                WinDrawBorder (hps, &rcl, 3, 3, CLR_RED, CLR_DARKGREEN, DB_INTERIOR);

                WinReleasePS (hps);
            }
        }
#endif
    }

public slots:

    void playTriggered (bool checked)
    {
        if (checked)
        {
            stackCentralW->setCurrentWidget (videoWidget);
            id = videoWidget->request();
            timerId = startTimer (1000);
        }
        else
        {
            videoWidget->release();
            id = 0;
            killTimer (timerId);
            timerId = 0;
            stackCentralW->setCurrentWidget (bgWidget);
        }
    }

    void playListTriggered (bool checked)
    {
        if (checked)
        {
            stackCentralW->setCurrentWidget (bgWidget);
        }
        else
        {
            stackCentralW->setCurrentWidget (videoWidget);
        }
    }

public:

    QStackedWidget *stackCentralW;
    QLabel *bgWidget;
    VideoWidget *videoWidget;
    WId id;
    int timerId;
};


int main (int argc, char **argv)
{
    QApplication app (argc, argv);
    MainWindow window;
    window.resize (400, 300);
    window.show();
    return app.exec();
}

#include "embedded.moc"
