/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Qt Software Information (qt-info@nokia.com)
**
** Copyright (C) 2009 netlabs.org. OS/2 parts.
**
** This file is part of the QtGui module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial Usage
** Licensees holding valid Qt Commercial licenses may use this file in
** accordance with the Qt Commercial License Agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Nokia.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain
** additional rights. These rights are described in the Nokia Qt LGPL
** Exception version 1.0, included in the file LGPL_EXCEPTION.txt in this
** package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
** $QT_END_LICENSE$
**
****************************************************************************/

#include "qbitmap.h"
#include "qbuffer.h"
#include "qimage.h"
#include "qpolygon.h"
#include "qregion.h"

QT_BEGIN_NAMESPACE

QRegion::QRegionData QRegion::shared_empty = { Q_BASIC_ATOMIC_INITIALIZER(1) }; // @todo, 0 };

QRegion::QRegion()
    : d(&shared_empty)
{
    d->ref.ref();
}

QRegion::QRegion(const QRect &r, RegionType t)
{
    d = new QRegionData;
    d->ref = 1;
    // @todo implement
}

QRegion::QRegion(const QPolygon &a, Qt::FillRule fillRule)
{
    d = new QRegionData;
    d->ref = 1;
    // @todo implement
}

QRegion::QRegion(const QRegion &r)
{
    d = r.d;
    d->ref.ref();
}

QRegion::QRegion(const QBitmap &bm)
{
    d = new QRegionData;
    d->ref = 1;
    // @todo implement
}

void QRegion::cleanUp(QRegion::QRegionData *x)
{
    delete x;
    // @todo implement
}

QRegion::~QRegion()
{
    if (!d->ref.deref())
        cleanUp(d);
}

QRegion &QRegion::operator=(const QRegion &r)
{
    r.d->ref.ref();
    if (!d->ref.deref())
        cleanUp(d);
    d = r.d;
    return *this;
}


QRegion QRegion::copy() const
{
    // @todo implement
    return QRegion();
}

bool QRegion::isEmpty() const
{
    return (d == &shared_empty || boundingRect().isEmpty());
}


bool QRegion::contains(const QPoint &p) const
{
    // @todo implement
    return false;
}

bool QRegion::contains(const QRect &r) const
{
    // @todo implement
    return false;
}


void QRegion::translate(int dx, int dy)
{
    // @todo implement
}

QRegion QRegion::unite(const QRegion &r) const
{
    // @todo implement
    return QRegion();
}

QRegion QRegion::unite(const QRect &r) const
{
    return unite(QRegion(r));
}

QRegion QRegion::intersect(const QRegion &r) const
{
    // @todo implement
    return QRegion();
}

QRegion QRegion::subtract(const QRegion &r) const
{
    // @todo implement
    return QRegion();
}

QRegion QRegion::eor(const QRegion &r) const
{
    // @todo implement
    return QRegion();
}


QRect QRegion::boundingRect() const
{
    // @todo implement
    return QRect();
}

QVector<QRect> QRegion::rects() const
{
    // @todo implement
    return QVector<QRect>();
}

void QRegion::setRects(const QRect *rects, int num)
{
    *this = QRegion();
    if (!rects || num == 0 || (num == 1 && rects->isEmpty()))
        return;
    for (int i = 0; i < num; ++i)
        *this |= rects[i];
}

int QRegion::numRects() const
{
    // @todo implement
    return 0;
}

bool QRegion::operator==(const QRegion &r) const
{
    // @todo implement
    return false;
}

QRegion& QRegion::operator+=(const QRegion &r)
{
    // @todo implement
    return *this;
}

QRegion& QRegion::operator-=(const QRegion &r)
{
    // @todo implement
    return *this;
}

QRegion& QRegion::operator&=(const QRegion &r)
{
    // @todo implement
    return *this;
}

bool qt_region_strictContains(const QRegion &region, const QRect &rect)
{
    Q_UNUSED(region);
    Q_UNUSED(rect);
    return false;
}

QT_END_NAMESPACE
