/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Qt Software Information (qt-info@nokia.com)
**
** Copyright (C) 2009 netlabs.org. OS/2 parts.
**
** This file is part of the QtGui module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial Usage
** Licensees holding valid Qt Commercial licenses may use this file in
** accordance with the Qt Commercial License Agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Nokia.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain
** additional rights. These rights are described in the Nokia Qt LGPL
** Exception version 1.0, included in the file LGPL_EXCEPTION.txt in this
** package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
** $QT_END_LICENSE$
**
****************************************************************************/

#include "qt_os2.h"

#include "qapplication.h"
#include "qapplication_p.h"

#include "qwidget.h"
#include "qpointer.h"
#include "qcolormap.h"
#include "qpixmapcache.h"

#include "qset.h"

#include "private/qeventdispatcher_pm_p.h"

#include "qwidget_p.h"
#include "qkeymapper_p.h"
#include "qcursor_p.h"

QT_BEGIN_NAMESPACE

/*****************************************************************************
  Internal variables and functions
 *****************************************************************************/

static HWND	 curWin		= 0;		// current window
static HPS	 displayPS	= 0;		// display presentation space

static bool replayPopupMouseEvent = false; // replay handling when popups close

// ignore the next release event if return from a modal widget
static bool ignoreNextMouseReleaseEvent = false;

#if defined(QT_DEBUG)
static bool appNoGrab = false; // mouse/keyboard grabbing
#endif

static bool app_do_modal = false; // modal mode
extern QWidgetList *qt_modal_stack;
extern QDesktopWidget *qt_desktopWidget;
static QPointer<QWidget> popupButtonFocus;
static bool	qt_try_modal(QWidget *, QMSG *, int& ret);

QWidget *qt_button_down = 0; // widget got last button-down
QPointer<QWidget> qt_last_mouse_receiver = 0;

static HWND autoCaptureWnd = NULLHANDLE;
static void setAutoCapture(HWND); // automatic capture
static void releaseAutoCapture();

extern QCursor *qt_grab_cursor();

MRESULT EXPENTRY QtWndProc(HWND, ULONG, MPARAM, MPARAM);

class QETWidget : public QWidget                // event translator widget
{
public:
    QWExtra    *xtra() { return d_func()->extraData(); }
    QTLWExtra  *topData() { return d_func()->topData(); }
// @todo later
//  QTLWExtra  *maybeTopData() { return d_func()->maybeTopData(); }
//  void syncBackingStore(const QRegion &rgn) { d_func()->syncBackingStore(rgn); }
//  void syncBackingStore() { d_func()->syncBackingStore(); }
//  QWidgetData *dataPtr() { return data; }
//  QWidgetPrivate *dptr() { return d_func(); }
//  QRect frameStrut() const { return d_func()->frameStrut(); }
//  bool        winEvent(QMSG *m, long *r) { return QWidget::winEvent(m, r); }
//  void        markFrameStrutDirty() { data->fstrut_dirty = 1; }
//  bool        translateMouseEvent(const MSG &msg);
//  bool        translateWheelEvent(const MSG &msg);
//  bool        translatePaintEvent(const MSG &msg);
//  bool        translateConfigEvent(const MSG &msg);
//  bool        translateCloseEvent(const MSG &msg);
//  void        repolishStyle(QStyle &style);
//  inline void showChildren(bool spontaneous) { d_func()->showChildren(spontaneous); }
//  inline void hideChildren(bool spontaneous) { d_func()->hideChildren(spontaneous); }
//  inline uint testWindowState(uint teststate){ return dataPtr()->window_state & teststate; }
//  inline void forceUpdate() {
//      QTLWExtra *tlwExtra = window()->d_func()->maybeTopData();
//      if (tlwExtra && tlwExtra->backingStore)
//          tlwExtra->backingStore->markDirty(rect(), this, true, true);
//  }
};

static void qt_set_pm_resources()
{
    // @todo later: take colors, fonts, etc. from the system theme
};

/*****************************************************************************
  qt_init() - initializes Qt for PM
 *****************************************************************************/

void qt_init(QApplicationPrivate *priv, int)
{

    int argc = priv->argc;
    char **argv = priv->argv;
    int i, j;

    // Get command line params

    j = argc ? 1 : 0;
    for (i=1; i<argc; i++) {
        if (argv[i] && *argv[i] != '-') {
            argv[j++] = argv[i];
            continue;
        }
#if defined(QT_DEBUG)
        if (qstrcmp(argv[i], "-nograb") == 0)
            appNoGrab = !appNoGrab;
        else
#endif // QT_DEBUG
            argv[j++] = argv[i];
    }
    if(j < priv->argc) {
        priv->argv[j] = 0;
        priv->argc = j;
    }

    // initialize key mapper
    QKeyMapper::changeKeyboard();

    QColormap::initialize();
    QFont::initialize();
#ifndef QT_NO_CURSOR
    QCursorData::initialize();
#endif
    qApp->setObjectName(priv->appName());

    // default font
    QApplicationPrivate::setSystemFont(
        QFont(QLatin1String("System Proportional"), 10));

    // QFont::locale_init();  ### Uncomment when it does something on OS/2

    if (QApplication::desktopSettingsAware())
        qt_set_pm_resources();
}

/*****************************************************************************
  qt_cleanup() - cleans up when the application is finished
 *****************************************************************************/

void qt_cleanup()
{
    QPixmapCache::clear();

#ifndef QT_NO_CURSOR
    QCursorData::cleanup();
#endif
    QFont::cleanup();
    QColormap::cleanup();

    if (displayPS) {
        WinReleasePS(displayPS);
        displayPS = 0;
    }
}

/*****************************************************************************
  Platform specific global and internal functions
 *****************************************************************************/

Q_GUI_EXPORT HPS qt_display_ps()
{
    Q_ASSERT(qApp && qApp->thread() == QThread::currentThread());
    if (!displayPS)
        displayPS = WinGetScreenPS(HWND_DESKTOP);
    return displayPS;
}

// application no-grab option
bool qt_nograb()
{
#if defined(QT_DEBUG)
    return appNoGrab;
#else
    return false;
#endif
}

/*****************************************************************************
  Safe configuration (move,resize,setGeometry) mechanism to avoid
  recursion when processing messages.
 *****************************************************************************/

struct QPMConfigRequest {
    WId         id; // widget to be configured
    int         req; // 0=move, 1=resize, 2=setGeo
    int         x, y, w, h; // request parameters
};

Q_GLOBAL_STATIC(QList<QPMConfigRequest*>, configRequests);

void qPMRequestConfig(WId id, int req, int x, int y, int w, int h)
{
    QPMConfigRequest *r = new QPMConfigRequest;
    r->id = id;
    r->req = req;
    r->x = x;
    r->y = y;
    r->w = w;
    r->h = h;
    configRequests()->append(r);
}

/*****************************************************************************
    GUI event dispatcher
 *****************************************************************************/

class QGuiEventDispatcherPM : public QEventDispatcherPM
{
    Q_DECLARE_PRIVATE(QEventDispatcherPM)
public:
    QGuiEventDispatcherPM(QObject *parent = 0);
    bool processEvents(QEventLoop::ProcessEventsFlags flags);
};

QGuiEventDispatcherPM::QGuiEventDispatcherPM(QObject *parent)
    : QEventDispatcherPM(parent)
{
    // pre-create the message queue early as we'll need it anyway in GUI mode
    createMsgQueue();
}

bool QGuiEventDispatcherPM::processEvents(QEventLoop::ProcessEventsFlags flags)
{
    if (!QEventDispatcherPM::processEvents(flags))
        return false;

    QPMConfigRequest *r;
    for (;;) {
        if (configRequests()->isEmpty())
            break;
        r = configRequests()->takeLast();
        QWidget *w = QWidget::find(r->id);
        QRect rect(r->x, r->y, r->w, r->h);
        int req = r->req;
        delete r;

        if (w) { // widget exists
            if (w->testAttribute(Qt::WA_WState_ConfigPending))
                break; // biting our tail
            if (req == 0)
                w->move(rect.topLeft());
            else if (req == 1)
                w->resize(rect.size());
            else
                w->setGeometry(rect);
        }
    }

    return true;
}

void QApplicationPrivate::createEventDispatcher()
{
    Q_Q(QApplication);
    if (q->type() != QApplication::Tty)
        eventDispatcher = new QGuiEventDispatcherPM(q);
    else
        eventDispatcher = new QEventDispatcherPM(q);
}

/*****************************************************************************
  Platform specific QApplication members
 *****************************************************************************/

void QApplicationPrivate::initializeWidgetPaletteHash()
{
}

QString QApplicationPrivate::appName() const
{
    return QCoreApplicationPrivate::appName();
}

void  QApplication::setCursorFlashTime(int msecs)
{
    // @todo implement
}


int QApplication::cursorFlashTime()
{
    // @todo implement
    return 0;
}

void QApplication::setDoubleClickInterval(int ms)
{
    // @todo implement
}

int QApplication::doubleClickInterval()
{
    // @todo implement
    return 0;
}


void QApplication::setKeyboardInputInterval(int ms)
{
    // @todo implement
}

int QApplication::keyboardInputInterval()
{
    // @todo implement
    return 0;
}

#ifndef QT_NO_WHEELEVENT
void QApplication::setWheelScrollLines(int n)
{
    // @todo implement
}

int QApplication::wheelScrollLines()
{
    // @todo implement
    return 0;
}
#endif //QT_NO_WHEELEVENT

void QApplication::setEffectEnabled(Qt::UIEffect effect, bool enable)
{
    // @todo implement
}

bool QApplication::isEffectEnabled(Qt::UIEffect effect)
{
    // @todo implement
    return false;
}

void QApplication::beep()
{
    // @todo implement
}

void QApplication::alert(QWidget *widget, int duration)
{
    // @todo implement
}

/*****************************************************************************
  QApplication cursor stack
 *****************************************************************************/

#ifndef QT_NO_CURSOR

void QApplication::setOverrideCursor(const QCursor &cursor)
{
    // @todo implement
}

void QApplication::restoreOverrideCursor()
{
    // @todo implement
}

#endif

/*****************************************************************************
  Routines to find a Qt widget from a screen position
 *****************************************************************************/

QWidget *QApplication::topLevelAt(const QPoint &pos)
{
    // @todo implement
    return 0;
}

/*****************************************************************************
  Main event loop
 *****************************************************************************/

// QtWndProc() receives all messages from the main event loop

MRESULT EXPENTRY QtWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    // message handling indicators: if handled is true at the end of message
    // processing, no default window proc is called but rc is returned.
    bool handled = false;
    MRESULT rc = (MRESULT) FALSE;
    QETWidget *widget = 0;
    HWND hwndC = NULLHANDLE;

    do {
        switch(msg) {
        default:
            break;
        }
        if (handled)
            return rc;
    } while(0);

    return WinDefWindowProc(hwnd, msg, mp1, mp2);
}

PFNWP QtOldFrameProc = 0;

MRESULT EXPENTRY QtFrameProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    // message handling indicators: if handled is true at the end of message
    // processing, no default window proc is called but rc is returned.
    bool handled = false;
    MRESULT rc = (MRESULT) FALSE;
    QETWidget *widget = 0;
    HWND hwndC = NULLHANDLE;

    do {
        switch(msg) {
        default:
            break;
        }
        if (handled)
            return rc;
    } while(0);

    return QtOldFrameProc(hwnd, msg, mp1, mp2);
}

/*****************************************************************************
  Modal widgets; We have implemented our own modal widget mechanism
  to get total control.
  A modal widget without a parent becomes application-modal.
  A modal widget with a parent becomes modal to its parent and grandparents..

  QApplicationPrivate::enterModal()
        Enters modal state
        Arguments:
            QWidget *widget        A modal widget

  QApplicationPrivate::leaveModal()
        Leaves modal state for a widget
        Arguments:
            QWidget *widget        A modal widget
 *****************************************************************************/

bool QApplicationPrivate::modalState()
{
    // @todo implement
    return false;
}

void QApplicationPrivate::enterModal_sys(QWidget *widget)
{
    // @todo implement
}

void QApplicationPrivate::leaveModal_sys(QWidget *widget)
{
    // @todo implement
}

/*****************************************************************************
  Popup widget mechanism

  openPopup()
        Adds a widget to the list of popup widgets
        Arguments:
            QWidget *widget        The popup widget to be added

  closePopup()
        Removes a widget from the list of popup widgets
        Arguments:
            QWidget *widget        The popup widget to be removed
 *****************************************************************************/

void QApplicationPrivate::openPopup(QWidget *popup)
{
    // @todo implement
}

void QApplicationPrivate::closePopup(QWidget *popup)
{
    // @todo implement
}

/*****************************************************************************
  Event translation; translates PM events to Qt events
 *****************************************************************************/

QT_END_NAMESPACE
