/****************************************************************************
** $Id: qlibrary_pm.cpp 8 2005-11-16 19:36:46Z dmik $
**
** Implementation of QLibraryPrivate class for Win32
**
** Copyright (C) 2000-2002 Trolltech AS.  All rights reserved.
** Copyright (C) 2004 Norman ASA.  Initial OS/2 Port.
** Copyright (C) 2005 netlabs.org.  Further OS/2 Development.
**
** This file is part of the tools module of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#include <qmap.h>
#include <private/qlibrary_p.h>

#ifdef QT_THREAD_SUPPORT
#  include <private/qmutexpool_p.h>
#endif // QT_THREAD_SUPPORT

#ifndef QT_H
#include "qfile.h"
#endif // QT_H

#ifndef QT_NO_LIBRARY

struct LibInstance {
    LibInstance() { module = 0; refCount = 0; }
    HMODULE module;
    int refCount;
};

static QMap<QString, LibInstance*> *map = 0;
/*
  The platform dependent implementations of
  - loadLibrary
  - freeLibrary
  - resolveSymbol

  It's not too hard to guess what the functions do.
*/

#include "qt_os2.h"

bool QLibraryPrivate::loadLibrary()
{
    if ( pHnd )
	return TRUE;

#ifdef QT_THREAD_SUPPORT
    // protect map creation/access
    QMutexLocker locker( qt_global_mutexpool ?
			 qt_global_mutexpool->get( &map ) : 0 );
#endif // QT_THREAD_SUPPORT

    if ( !map )
	map = new QMap<QString, LibInstance*>;

    QString filename = library->library();
    if ( map->find(filename) != map->end() ) {
	LibInstance *lib = (*map)[filename];
	lib->refCount++;
	pHnd = lib->module;
    }
    else {
        APIRET rc = 0;
        char errModule [256];
        if ( (rc = DosLoadModule(
            errModule, sizeof(errModule),
            QFile::encodeName( filename ).data(), &pHnd
        ))) {
            pHnd = 0;
#if defined(QT_DEBUG) || defined(QT_DEBUG_COMPONENT)
	    qSystemWarning( QString("Failed to load library %1 (reason: %2)!")
                .arg( filename ).arg( errModule ), rc
            );
#endif
        }
	if ( pHnd ) {
	    LibInstance *lib = new LibInstance;
	    lib->module = pHnd;
	    lib->refCount++;
	    map->insert( filename, lib );
	}
    }
    return pHnd != 0;
}

bool QLibraryPrivate::freeLibrary()
{
    if ( !pHnd )
	return TRUE;

#ifdef QT_THREAD_SUPPORT
    // protect map access
    QMutexLocker locker( qt_global_mutexpool ?
			 qt_global_mutexpool->get( &map ) : 0 );
#endif // QT_THREAD_SUPPORT

    bool ok = FALSE;
    QMap<QString, LibInstance*>::iterator it;
    for ( it = map->begin(); it != map->end(); ++it ) {
	LibInstance *lib = *it;
	if ( lib->module == pHnd ) {
	    lib->refCount--;
	    if ( lib->refCount == 0 ) {
		ok = DosFreeModule( pHnd ) == 0;
		if ( ok ) {
		    map->remove( it );
		    if ( map->count() == 0 ) {
			delete map;
			map = 0;
		    }
		}
		delete lib;
	    } else
		ok = TRUE;
	    break;
	}
    }
    if ( ok )
	pHnd = 0;
#if defined(QT_DEBUG) || defined(QT_DEBUG_COMPONENT)
    else
	qSystemWarning( "Failed to unload library!" );
#endif
    return ok;
}

void* QLibraryPrivate::resolveSymbol( const char* f )
{
    if ( !pHnd )
	return 0;

    void* address;
    if ( DosQueryProcAddr( pHnd, 0, f, (PFN*) &address) ) address = 0;
#if defined(QT_DEBUG_COMPONENT)
    if ( !address )
	qSystemWarning( QString("Couldn't resolve symbol \"%1\"").arg( f ) );
#endif

    return address;
}

#endif //QT_NO_LIBRARY
