/* $Id: configure.cmd,v 1.1 2001-09-11 01:27:21 bird Exp $
 *
 * Configuration script.
 * Generates makefile.inc and an empty .depend file.
 *
 * Copyright (c) 1999-2001 knut st. osmundsen (knut.stange.osmundsen@mynd.no)
 *
 * Project Odin Software License can be found in LICENSE.TXT
 *
 */
    call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs';
    call SysLoadFuncs;

    /* Argument defaults */
    fInteractive    = 1;
    fkKrnlLib         = 1;

    /* parse arguments */
    parse arg asArgs.1 asArgs.2 asArgs.3 asArgs.4 asArgs.5 asArgs.6 asArgs.7 asArgs.8 asArgs.9
    asArgs.0 = 0;
    do i = 1 to 9
        if (asArgs.i <> '') then
            asArgs.0 = i;
    end
    do i = 1 to asArgs.0
        if (substr(asArgs.i, 1, 1) = '-' | substr(asArgs.i, 1, 1) = '/')  then
        do
            sArg = translate(substr(asArgs.i, 2));
            ch = substr(sArg, 1, 1);
            select
                when (ch = 'N') then
                    fInteractive = 0;
                when (ch = 'I') then
                    fInteractive = 1;
                when (ch = 'W') then
                    fkKrnlLib = 0;
                when (ch = '?' | ch = 'H' | substr(sArg, 1, 2) = '-H') then
                do
                    say 'Odin32 Configure.cmd. $Revision: 1.1 $.'
                    say 'syntax: Configure.cmd [-n] [-w]'
                    say '  -n   Noninteractive.'
                    say '  -w   Don''t build kKrnlLib.'
                    say '  -h   This text.'
                    exit(1);
                end
                otherwise
                    say 'syntax error ('asArgs.i')';
                    exit(2);
            end
        end
    end

    /* strings */
    sIncFile='Makefile.inc';

    /* delete old target files */
    call SysFileDelete sIncFile;

    /* open target file */
    if (stream(sIncFile, 'c', 'open write' ) <> '') then
    do
        call lineout sIncFile, '################################################################################'
        call lineout sIncFile, '# Generated by 'directory()'\configure.cmd'
        call lineout sIncFile, '################################################################################'
        call lineout sIncFile, ''
        call lineout sIncFile, '################################################################################'
        call lineout sIncFile, '# BASE DIRECTORIES - kKrnlLib'
        call lineout sIncFile, '# Note! These should be absolute paths!'
        call lineout sIncFile, '################################################################################'
        kKrnlLibBase = directory();
        call lineout sIncFile, 'WIN32KBASE       =' kKrnlLibBase;
        call lineout sIncFile, 'WIN32KDEV16      =' kKrnlLibBase'\dev16'
        call lineout sIncFile, 'WIN32KDEV32      =' kKrnlLibBase'\dev32'
        call lineout sIncFile, 'WIN32KELF2LX     =' kKrnlLibBase'\elf2lx'
        call lineout sIncFile, 'WIN32KINCLUDE    =' kKrnlLibBase'\include'
        call lineout sIncFile, 'WIN32KK32        =' kKrnlLibBase'\k32'
        call lineout sIncFile, 'WIN32KLDR        =' kKrnlLibBase'\ldr'
        call lineout sIncFile, 'WIN32KLIB        =' kKrnlLibBase'\lib'
        call lineout sIncFile, 'WIN32KMISC       =' kKrnlLibBase'\misc'
        call lineout sIncFile, 'WIN32KPE2LX      =' kKrnlLibBase'\pe2lx'
        call lineout sIncFile, '!ifdef DEBUG'
        call lineout sIncFile, 'WIN32KBIN        =' kKrnlLibBase'\out\bin\debug.$(CCENV)'
        call lineout sIncFile, 'WIN32KLIST       =' kKrnlLibBase'\out\list\debug.$(CCENV)'
        call lineout sIncFile, 'WIN32KOBJ        =' kKrnlLibBase'\out\object\debug.$(CCENV)'
        call lineout sIncFile, '!else'
        call lineout sIncFile, 'WIN32KBIN        =' kKrnlLibBase'\out\bin\release.$(CCENV)'
        call lineout sIncFile, 'WIN32KLIST       =' kKrnlLibBase'\out\list\release.$(CCENV)'
        call lineout sIncFile, 'WIN32KOBJ        =' kKrnlLibBase'\out\object\release.$(CCENV)'
        call lineout sIncFile, '!endif'
        call lineout sIncFile, 'WIN32KOBJECT     = $(WIN32KOBJ)'
        call lineout sIncFile, ''

        call lineout sIncFile, '################################################################################'
        call lineout sIncFile, '# DDKPATH: base directory of ddk base (i.e. \DDK\BASE not \DDK for DDK v4.0+).'
        call lineout sIncFile, '################################################################################'
        sDDK = SearchPaths('INCLUDE', '..\h\dhcalls.h', 'PATH', '..\h\dhcalls.h', 'BOOKSHELF', '..\base\.\h\dhcalls.h', 'Path to DDK "\BASE" directory (i.e. F:\DDK\BASE):');
        sDDK = ValidatePath(sDDK, 'h\devhdr.h', 'DDK Base Path');
        call lineout sIncFile, 'DDKPATH          =' sDDK
        call lineout sIncFile, ''

        call lineout sIncFile, '################################################################################'
        call lineout sIncFile, '# OS/2 TOOLKIT'
        call lineout sIncFile, '################################################################################'
        sTLKT = SearchPaths('INCLUDE', '..\h\os2.h', 'PATH', '..\h\os2.h', 'BOOKSHELF', '..\h\os2.h', 'Path to OS/2 Toolkit directory:');
        sTLKT = ValidatePath(sTLKT, 'h\bsememf.h', 'OS/2 Toolkit Path');
        call lineout sIncFile, 'TOOLKIT          =' sTLKT
        call lineout sIncFile, ''

        call lineout sIncFile, '################################################################################'
        call lineout sIncFile, '# IBM VisualAge for C++ base path'
        call lineout sIncFile, '################################################################################'
        sVA = Value('CPPMAIN',, 'OS2ENVIRONMENT'); /* not sure if CPPMAIN or CPPLOCAL is the one to search... */
        if (sVA <> '' & stream(sVA'\bin\icc.exe', 'c', 'query exists') = '') then
            sVA = ''
        if (sVA = '') then
            sVA = SearchPaths('PATH', '..\bin\icc.exe', 'BOOKSHELF', '..\bin\icc.exe', 'Path to IBM VisualAge for C++ or IBM C and C++ Compilers, and set its environment you compile:');
        sVA = ValidatePath(sVA, 'bin\icc.exe', 'VisualAge Path');
        call lineout sIncFile, 'VACPATH          =' sVA
        call lineout sIncFile, ''

        call lineout sIncFile, '################################################################################'
        call lineout sIncFile, '# Microsoft C v6.0, v6.0a or v7.0'
        call lineout sIncFile, '################################################################################'
        sMSC = SearchPaths('PATH', '..\binp\c3l.exe', 'INCLUDE', '..\binp\c3l.exe','LIB', '..\binp\c3l.exe', 'Path to Microsoft C v6.0, v6.0a or v7.0 directory:');
        sMSC = ValidatePath(sMSC, 'binp\cl.exe', 'Microsoft C Path');
        call lineout sIncFile, 'MSCPATH          =' sMSC
        call lineout sIncFile, ''

        call lineout sIncFile, '################################################################################'
        call lineout sIncFile, '# Grep'
        call lineout sIncFile, '################################################################################'
        sGrep = SearchPaths('PATH', 'grep.exe', 'Path to UNIX-like grep utility which supports -v.');
        if (sGrep <> '') then
            call lineout sIncFile, 'GREP             =' sGrep || '\grep.exe'
        call lineout sIncFile, ''

        call stream sIncFile, 'c', 'close';

        /*
         * Create output directories.
         */
        '@mkdir out > nul 2> nul'

        '@mkdir out\bin > nul 2> nul'
        '@mkdir out\bin\Release.vac3 > nul 2> nul'
        '@mkdir out\bin\Release.vac36 > nul 2> nul'
        '@mkdir out\bin\Debug.vac3 > nul 2> nul'
        '@mkdir out\bin\Debug.vac36 > nul 2> nul'

        '@mkdir out\list > nul 2> nul'
        '@mkdir out\list\Release.vac3 > nul 2> nul'
        '@mkdir out\list\Release.vac36 > nul 2> nul'
        '@mkdir out\list\Debug.vac3 > nul 2> nul'
        '@mkdir out\list\Debug.vac36 > nul 2> nul'

        '@mkdir out\object > nul 2> nul'
        '@mkdir out\object\Debug.vac3 > nul 2> nul'
        '@mkdir out\object\Debug.vac36 > nul 2> nul'
        '@mkdir out\object\Release.vac3 > nul 2> nul'
        '@mkdir out\object\Release.vac36 > nul 2> nul'

        /*
         * Display output.
         */
        if (0 /*fInteractive = 1*/) then /* currently disabled since we're now called from main config. */
        do
            say 'Configuration completed!'
            say ''
            say 'You should now verify that the settings are correct by listing the file';
            say ''''sIncFile'''';
            say ''
            say 'Remember to do a ''nmake dep'' before making kKrnlLib.'
        end
    end
    else
    do
        say 'oops, failed to open outputfile,' sIncFile;
        exit 1;
    end
    exit 0;



/*****************/
/* function area */
/*****************/


/**
 * SearchPaths
 * Parameters:
 *   Takes pair of <envionment variable name> and <filename> as parameters
 *   As final optional parameter you may specify a question to request the string from the user.
 * Returns:
 *   sPath-sFile ignoring '..\'s in sFile.
 */
SearchPaths: procedure expose fInteractive fkKrnlLib;
    /*
     * Check if there is need to waste time searching.
     * Init local variables.
     */
    if (\fkKrnlLib) then
        return '';
    i = 1;
    sPath = '';

    /*
     * Search for the given environments/files combinations.
     */
    do i = 2 to arg() by 2
        sEnv  = arg(i-1);
        sFile = arg(i);
        /* say i':' sEnv '-' sFile; */
        sPath = SysSearchPath(sEnv, sFile);
        /* say 'SysSearchPath('sEnv',' sFile') ->' sPath; */
        if (sPath <> '') then
           leave;
    end

    /* did we find it? */
    if (sPath = '') then
    do  /*
         * If interactive mode, we'll ask for the the path, else skip it.
         */
        say arg(arg());
        if (fInteractive = 1) then
            sPath = linein();
        else
            say '!ignored!';
    end
    else
    do  /*
         * Trim the result for the file part.
         */
        /* look for .\ or ..\ */
        i = lastpos('.\', sFile);
        if (i <> 0) then
            sFile = substr(sFile, i + 1);

        /* cut equally */
        i = lastpos(sFile, sPath);
        if (i = 0) then
            say '!error! sFile:'sFile  'sPath:'sPath;
        /* debug: say 'sPath:'sPath  'sFile:'sFile */
        sPath = strip(substr(sPath, 1, i-1), 'T', '\');
    end

return sPath;


/**
 * Validate if a file exists to ensure that the given path is valid.
 * @returns The path if valid. If invalid an empty string is returned.
 */
ValidatePath: procedure expose fkKrnlLib
    parse arg sPath, sFile, sDesc

    if (strip(sPath) = "" & \fkKrnlLib) then
        return "";

    rc = stream(sPath'\'sFile, 'c', 'query exists')
    if (rc <> '') then
        return sPath;
    say 'Warning: Validatation of the' sPath 'failed. kKrnlLib.sys will not be built.'
    say '         path='sPath;
return '';

