#include <memory.h>

#define INITGUID
#include "os2ddraw.h"
#include "os2clipper.h"
#define _OS2WIN_H
#define FAR
#include "misc.h"
#include <winerror.h>
#include <odincrt.h>

//******************************************************************************
//******************************************************************************
OS2IDirectDrawClipper::OS2IDirectDrawClipper(OS2IDirectDraw *lpDirectDraw) :
                 Referenced(0), lastError(DD_OK),
                 clipWindow(0)
{
  lpVtbl                  = &Vtbl;
  Vtbl.AddRef             = ClipAddRef;
  Vtbl.Release            = ClipRelease;
  Vtbl.QueryInterface     = ClipQueryInterface;
  Vtbl.GetClipList        = ClipGetClipList;
  Vtbl.GetHWnd            = ClipGetHWnd;
  Vtbl.Initialize         = ClipInitialize;
  Vtbl.IsClipListChanged  = ClipIsClipListChanged;
  Vtbl.SetClipList        = ClipSetClipList;
  Vtbl.SetHWnd            = ClipSetHWnd;

  lpDraw                  = lpDirectDraw;
  lpDraw->Vtbl.AddRef(lpDraw);
  hDive                   = lpDirectDraw->GetDiveInstance();
}
//******************************************************************************
//******************************************************************************
OS2IDirectDrawClipper::~OS2IDirectDrawClipper()
{
  lpDraw->Vtbl.Release(lpDraw);
}
//******************************************************************************
//******************************************************************************
HRESULT __stdcall ClipQueryInterface(THIS This, REFIID riid, LPVOID FAR * ppvObj)
{
  #ifdef DEBUG
    WriteLog("ClipQueryInterface\n");
  #endif

  *ppvObj = NULL;

  if(!IsEqualGUID(riid, IID_IDirectDrawClipper) &&
     !IsEqualGUID(riid, CLSID_DirectDrawClipper))
//&& !IsEqualGUID(riid, IID_IUnknown))
  return E_NOINTERFACE;

  *ppvObj = This;

  ClipAddRef(This);
  return(DD_OK);
}
//******************************************************************************
//******************************************************************************
ULONG   __stdcall ClipAddRef(THIS This)
{
 OS2IDirectDrawClipper *me = (OS2IDirectDrawClipper *)This;

  #ifdef DEBUG
    WriteLog("OS2IDirectDrawClipper::AddRef %d\n", me->Referenced+1);
  #endif

  return ++me->Referenced;
}
//******************************************************************************
//******************************************************************************
ULONG   __stdcall ClipRelease(THIS This)
{
 OS2IDirectDrawClipper *me = (OS2IDirectDrawClipper *)This;

  #ifdef DEBUG
    WriteLog("OS2IDirectDrawClipper::Release %d\n", me->Referenced-1);
  #endif

  if(me->Referenced)
  {
    me->Referenced--;
    if(me->Referenced == 0)
    {
      ODIN_delete( me);
      return(0);
    }
    else
      return me->Referenced;
  }
  else
   return(0);
}
//******************************************************************************
//******************************************************************************
HRESULT __stdcall ClipGetClipList(THIS, LPRECT, LPRGNDATA, LPDWORD)
{
  #ifdef DEBUG
    WriteLog("ClipGetClipList\n");
  #endif

  return(DD_OK);
}
//******************************************************************************
//******************************************************************************
HRESULT __stdcall ClipGetHWnd(THIS This, HWND FAR *pHwnd)
{
 OS2IDirectDrawClipper *me = (OS2IDirectDrawClipper *)This;

  #ifdef DEBUG
    WriteLog("ClipGetHWnd\n");
  #endif

  *pHwnd = me->clipWindow;
  return(DD_OK);
}
//******************************************************************************
//******************************************************************************
HRESULT __stdcall ClipInitialize(THIS, LPDIRECTDRAW, DWORD)
{
  #ifdef DEBUG
    WriteLog("ClipInitialize\n");
  #endif

  return(DDERR_ALREADYINITIALIZED); // Init is done during creation see M$ Doc
}
//******************************************************************************
//******************************************************************************
HRESULT __stdcall ClipIsClipListChanged(THIS, BOOL FAR *)
{
  #ifdef DEBUG
    WriteLog("ClipIsClipListChanged\n");
  #endif

  return(DD_OK);
}
//******************************************************************************
//******************************************************************************
HRESULT __stdcall ClipSetClipList(THIS, LPRGNDATA,DWORD)
{
  #ifdef DEBUG
    WriteLog("ClipSetClipList\n");
  #endif

  return(DD_OK);
}
//******************************************************************************
//DWORD param not used in DirectX 3
//******************************************************************************
HRESULT __stdcall ClipSetHWnd(THIS This, DWORD reserved, HWND hwnd)
{
 OS2IDirectDrawClipper *me = (OS2IDirectDrawClipper *)This;

  #ifdef DEBUG
    WriteLog("ClipSetHWnd\n");
  #endif

  me->clipWindow = hwnd;
  return(DD_OK);
}
//******************************************************************************
//******************************************************************************
