/* $Id: win32wnd.cpp,v 1.6 1999-07-17 11:52:23 sandervl Exp $ */
/*
 * Win32 Window Code for OS/2
 *
 *
 * Copyright 1998-1999 Sander van Leeuwen (sandervl@xs4all.nl)
 *
 * Parts based on Wine Windows code (windows\win.c)
 *
 * Copyright 1993, 1994 Alexandre Julliard
 *
 *
 * Project Odin Software License can be found in LICENSE.TXT
 *
 */
#include <os2win.h>
#include <win.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <assert.h>
#include <misc.h>
#include <handlemanager.h>
#include <win32wnd.h>
#include <spy.h>
#include "wndmsg.h"
#include "hooks.h"
#include <oslibwin.h>

#define HAS_DLGFRAME(style,exStyle) \
    (((exStyle) & WS_EX_DLGMODALFRAME) || \
     (((style) & WS_DLGFRAME) && !((style) & WS_BORDER)))

#define HAS_THICKFRAME(style) \
    (((style) & WS_THICKFRAME) && \
     !(((style) & (WS_DLGFRAME|WS_BORDER)) == WS_DLGFRAME))

//******************************************************************************
//******************************************************************************
Win32Window::Win32Window(DWORD objType) : GenericObject(&windows, objType)
{
  Init();
}
//******************************************************************************
//******************************************************************************
Win32Window::Win32Window(CREATESTRUCTA *lpCreateStructA, ATOM classAtom, BOOL isUnicode)
                        : GenericObject(&windows, OBJTYPE_WINDOW), ChildWindow()
{
  Init();
  this->isUnicode = isUnicode;
  CreateWindowExA(lpCreateStructA, classAtom);
}
//******************************************************************************
//******************************************************************************
void Win32Window::Init()
{
  isUnicode        = FALSE;

  windowName       = NULL;
  wndNameLength    = 0;

  windowText       = NULL;;
  wndTextLength    = 0;

  userWindowLong   = NULL;;
  nrUserWindowLong = 0;

  magic            = WIN32PM_MAGIC;
  OS2Hwnd          = 0;
  OS2HwndFrame     = 0;
  OS2HwndMenu      = 0;
  Win32Hwnd        = 0;

  //CB: what does this code? Win32Hwnd is always 0!
  if(HMHandleAllocate(&Win32Hwnd, (ULONG)this) != 0)
  {
        dprintf(("Win32Window::Init HMHandleAllocate failed!!"));
        DebugInt3();
  }
  Win32Hwnd       &= 0xFFFF;
  Win32Hwnd       |= 0x68000000;

  posx = posy      = 0;
  width = height   = 0;

  dwExStyle        = 0;
  dwStyle          = 0;
  win32wndproc     = 0;
  hInstance        = 0;
  windowId         = 0xFFFFFFFF;        //default = -1
  userData         = 0;

  hwndLinkAfter    = HWND_BOTTOM;
  flags            = 0;
  isIcon           = FALSE;
  owner            = NULL;
  windowClass      = 0;
}
//******************************************************************************
//******************************************************************************
Win32Window::~Win32Window()
{
  if(Win32Hwnd)
        HMHandleFree(Win32Hwnd);
  if(windowName)
        free(windowName);
  if(windowText)
        free(windowText);
  if(userWindowLong)
        free(userWindowLong);
}
//******************************************************************************
//******************************************************************************
BOOL Win32Window::CreateWindowExA(CREATESTRUCTA *cs, ATOM classAtom)
{
 char  buffer[256];
 INT   sw = SW_SHOW;
 POINT maxSize, maxPos, minTrack, maxTrack;

  SetLastError(0);

  /* Find the parent window */
  if (cs->hwndParent)
  {
    	Win32Window *window = GetWindowFromHandle(cs->hwndParent);
    	if(!window) {
                dprintf(("Bad parent %04x\n", cs->hwndParent ));
                SetLastError(ERROR_INVALID_PARAMETER);
		return FALSE;
    	}
        /* Make sure parent is valid */
        if (!window->IsWindow() )
        {
                dprintf(("Bad parent %04x\n", cs->hwndParent ));
                SetLastError(ERROR_INVALID_PARAMETER);
                return FALSE;
        }
  }
  else
  if ((cs->style & WS_CHILD) && !(cs->style & WS_POPUP)) {
        dprintf(("No parent for child window\n" ));
        SetLastError(ERROR_INVALID_PARAMETER);
        return FALSE;  /* WS_CHILD needs a parent, but WS_POPUP doesn't */
  }

  /* Find the window class */
  windowClass = Win32WndClass::FindClass(cs->hInstance, (LPSTR)classAtom);
  if (!windowClass)
  {
        GlobalGetAtomNameA( classAtom, buffer, sizeof(buffer) );
        dprintf(("Bad class '%s'\n", buffer ));
        return 0;
  }

  /* Fix the lpszClass field: from existing programs, it seems ok to call a CreateWindowXXX
   * with an atom as the class name, put some programs expect to have a *REAL* string in
   * lpszClass when the CREATESTRUCT is sent with WM_CREATE
   */
  if (!HIWORD(cs->lpszClass) ) {
        if (isUnicode) {
                GlobalGetAtomNameW( classAtom, (LPWSTR)buffer, sizeof(buffer) );
        }
        else {
                GlobalGetAtomNameA( classAtom, buffer, sizeof(buffer) );
        }
        cs->lpszClass = buffer;
  }

  /* Fix the coordinates */
  if (cs->x == CW_USEDEFAULT || cs->x == CW_USEDEFAULT16)
  {
//        PDB *pdb = PROCESS_Current();

       /* Never believe Microsoft's documentation... CreateWindowEx doc says
        * that if an overlapped window is created with WS_VISIBLE style bit
        * set and the x parameter is set to CW_USEDEFAULT, the system ignores
        * the y parameter. However, disassembling NT implementation (WIN32K.SYS)
        * reveals that
        *
        * 1) not only if checks for CW_USEDEFAULT but also for CW_USEDEFAULT16
        * 2) it does not ignore the y parameter as the docs claim; instead, it
        *    uses it as second parameter to ShowWindow() unless y is either
        *    CW_USEDEFAULT or CW_USEDEFAULT16.
        *
        * The fact that we didn't do 2) caused bogus windows pop up when wine
        * was running apps that were using this obscure feature. Example -
        * calc.exe that comes with Win98 (only Win98, it's different from
        * the one that comes with Win95 and NT)
        */
        if (cs->y != CW_USEDEFAULT && cs->y != CW_USEDEFAULT16) sw = cs->y;

        /* We have saved cs->y, now we can trash it */
#if 0
        if (   !(cs->style & (WS_CHILD | WS_POPUP))
            &&  (pdb->env_db->startup_info->dwFlags & STARTF_USEPOSITION) )
        {
            cs->x = pdb->env_db->startup_info->dwX;
            cs->y = pdb->env_db->startup_info->dwY;
        }
#endif
            cs->x = 0;
            cs->y = 0;
//        }
  }
  if (cs->cx == CW_USEDEFAULT || cs->cx == CW_USEDEFAULT16)
  {
#if 0
        PDB *pdb = PROCESS_Current();
        if (   !(cs->style & (WS_CHILD | WS_POPUP))
            &&  (pdb->env_db->startup_info->dwFlags & STARTF_USESIZE) )
        {
            cs->cx = pdb->env_db->startup_info->dwXSize;
            cs->cy = pdb->env_db->startup_info->dwYSize;
        }
        else
        {
#endif
            cs->cx = 600; /* FIXME */
            cs->cy = 400;
//        }
  }

  //Allocate window words
  nrUserWindowLong = windowClass->getExtraWndWords();
  if(nrUserWindowLong) {
        userWindowLong = (ULONG *)malloc(nrUserWindowLong);
        memset(userWindowLong, 0, nrUserWindowLong);
  }

  if ((cs->style & WS_CHILD) && cs->hwndParent)
  {
	SetParent(cs->hwndParent);
  }
  else
  {
        if (!cs->hwndParent) {
                owner = NULL;
        }
        else
        {
		owner = GetWindowFromHandle(cs->hwndParent);
                if(owner == NULL)
                {
                        dprintf(("HMHandleTranslateToOS2 couldn't find owner window %x!!!", cs->hwndParent));
                        return FALSE;
                }
        }
  }

  setWindowProc(windowClass->getWindowProc());
  hInstance = cs->hInstance;
  dwStyle   = cs->style & ~WS_VISIBLE;
  dwExStyle = cs->dwExStyle;

  hwndLinkAfter = ((cs->style & (WS_CHILD|WS_MAXIMIZE)) == WS_CHILD)
                  ? HWND_BOTTOM : HWND_TOP;

#if 0
//TODO
    /* Call the WH_CBT hook */

    if (HOOK_IsHooked( WH_CBT ))
    {
	CBT_CREATEWNDA cbtc;
        LRESULT ret;

	cbtc.lpcs = cs;
	cbtc.hwndInsertAfter = hwndLinkAfter;
        ret = unicode ? HOOK_CallHooksW(WH_CBT, HCBT_CREATEWND, Win32Hwnd, (LPARAM)&cbtc)
                      : HOOK_CallHooksA(WH_CBT, HCBT_CREATEWND, Win32Hwnd, (LPARAM)&cbtc);
        if (ret)
	{
	    TRACE_(win)("CBT-hook returned 0\n");
	    wndPtr->pDriver->pFinalize(wndPtr);
            retvalue =  0;
            goto end;
	}
    }
#endif

  /* Increment class window counter */
  windowClass->IncreaseWindowCount();

  /* Correct the window style */
  if (!(cs->style & WS_CHILD))
  {
        dwStyle |= WS_CLIPSIBLINGS;
        if (!(cs->style & WS_POPUP))
        {
            dwStyle |= WS_CAPTION;
            flags |= WIN_NEED_SIZE;
        }
  }
  if (cs->dwExStyle & WS_EX_DLGMODALFRAME) dwStyle &= ~WS_THICKFRAME;

  //TODO?
#if 0
  /* Get class or window DC if needed */
  if (classPtr->style & CS_OWNDC) dce = DCE_AllocDCE(hwnd,DCE_WINDOW_DC);
  else if (classPtr->style & CS_CLASSDC) wndPtr->dce = classPtr->dce;
  else wndPtr->dce = NULL;
#endif

  /* Send the WM_GETMINMAXINFO message and fix the size if needed */
  if ((cs->style & WS_THICKFRAME) || !(cs->style & (WS_POPUP | WS_CHILD)))
  {
        GetMinMaxInfo(&maxSize, &maxPos, &minTrack, &maxTrack);
        if (maxSize.x < cs->cx) cs->cx = maxSize.x;
        if (maxSize.y < cs->cy) cs->cy = maxSize.y;
        if (cs->cx < minTrack.x ) cs->cx = minTrack.x;
        if (cs->cy < minTrack.y ) cs->cy = minTrack.y;
  }

  if(cs->style & WS_CHILD)
  {
        if(cs->cx < 0) cs->cx = 0;
        if(cs->cy < 0) cs->cy = 0;
  }
  else
  {
        if (cs->cx <= 0) cs->cx = 1;
        if (cs->cy <= 0) cs->cy = 1;
  }

  rectWindow.left   = cs->x;
  rectWindow.top    = cs->y;
  rectWindow.right  = cs->x + cs->cx;
  rectWindow.bottom = cs->y + cs->cy;
  rectClient        = rectWindow;

  DWORD dwOSWinStyle, dwOSFrameStyle;

  OSLibWinConvertStyle(cs->style, &dwOSWinStyle, &dwOSFrameStyle);

  OS2Hwnd = OSLibWinCreateWindow((getParent()) ? getParent()->getOS2WindowHandle() : 0,
                                 dwOSWinStyle, dwOSFrameStyle, (char *)cs->lpszName,
                                 cs->x, cs->y, cs->cx, cs->cy,
                                 (owner) ? owner->getOS2WindowHandle() : 0,
                                 (hwndLinkAfter == HWND_BOTTOM) ? TRUE : FALSE, &OS2HwndFrame);

  if(OS2Hwnd == 0) {
        dprintf(("Window creation failed!!"));
        return FALSE;
  }
  if(OSLibWinSetWindowULong(OS2Hwnd, OFFSET_WIN32WNDPTR, (ULONG)this) == FALSE) {
        dprintf(("WM_CREATE: WinSetWindowULong %X failed!!", OS2Hwnd));
        return FALSE;
  }
  if(OSLibWinSetWindowULong(OS2Hwnd, OFFSET_WIN32PM_MAGIC, WIN32PM_MAGIC) == FALSE) {
        dprintf(("WM_CREATE: WinSetWindowULong2 %X failed!!", OS2Hwnd));
        return FALSE;
  }
  if(OS2Hwnd != OS2HwndFrame) {
  	if(OSLibWinSetWindowULong(OS2HwndFrame, OFFSET_WIN32WNDPTR, (ULONG)this) == FALSE) {
        	dprintf(("WM_CREATE: WinSetWindowULong %X failed!!", OS2HwndFrame));
        	return FALSE;
  	}
  	if(OSLibWinSetWindowULong(OS2HwndFrame, OFFSET_WIN32PM_MAGIC, WIN32PM_MAGIC) == FALSE) {
        	dprintf(("WM_CREATE: WinSetWindowULong2 %X failed!!", OS2HwndFrame));
        	return FALSE;
  	}
  }
  /* Set the window menu */
  if ((dwStyle & (WS_CAPTION | WS_CHILD)) == WS_CAPTION )
  {
        if (cs->hMenu) SetMenu(cs->hMenu);
        else
        {
                if (windowClass->getMenuNameA()) {
                        cs->hMenu = LoadMenuA(cs->hInstance, windowClass->getMenuNameA());
                        if (cs->hMenu) SetMenu(cs->hMenu );
                }
        }
  }
  else  windowId = (UINT)cs->hMenu;

  /* Send the WM_CREATE message 
   * Perhaps we shouldn't allow width/height changes as well. 
   * See p327 in "Internals". 
   */
  maxPos.x = rectWindow.left; maxPos.y = rectWindow.top;

  if(sendMessage(WM_NCCREATE, 0, (LPARAM)cs) )
  {
        SendNCCalcSize(FALSE, &rectWindow, NULL, NULL, 0, &rectClient );
        OffsetRect(&rectWindow, maxPos.x - rectWindow.left,
                                          maxPos.y - rectWindow.top);
	dprintf(("Sending WM_CREATE"));
        if( (sendMessage(WM_CREATE, 0, (LPARAM)cs )) != -1 )
        {
            /* Send the size messages */
	    dprintf(("Sent WM_CREATE"));

            if (!(flags & WIN_NEED_SIZE))
            {
                /* send it anyway */
	        if (((rectClient.right-rectClient.left) <0)
		    ||((rectClient.bottom-rectClient.top)<0))
		  dprintf(("sending bogus WM_SIZE message 0x%08lx\n",
			MAKELONG(rectClient.right-rectClient.left,
				 rectClient.bottom-rectClient.top)));
                SendMessageA(WM_SIZE, SIZE_RESTORED,
                                MAKELONG(rectClient.right-rectClient.left,
                                         rectClient.bottom-rectClient.top));
                SendMessageA(WM_MOVE, 0,
                                MAKELONG( rectClient.left,
                                          rectClient.top ) );
            }

#if 0
            /* Show the window, maximizing or minimizing if needed */

            if (dwStyle & (WS_MINIMIZE | WS_MAXIMIZE))
            {
		RECT16 newPos;
		UINT16 swFlag = (dwStyle & WS_MINIMIZE) ? SW_MINIMIZE : SW_MAXIMIZE;
                dwStyle &= ~(WS_MAXIMIZE | WS_MINIMIZE);
		WINPOS_MinMaximize(swFlag, &newPos );
                swFlag = ((dwStyle & WS_CHILD) || GetActiveWindow())
                    ? SWP_NOACTIVATE | SWP_NOZORDER | SWP_FRAMECHANGED
                    : SWP_NOZORDER | SWP_FRAMECHANGED;
                SetWindowPos(0, newPos.left, newPos.top,
                             newPos.right, newPos.bottom, swFlag );
            }
#endif

	    if( dwStyle & WS_CHILD && !(dwExStyle & WS_EX_NOPARENTNOTIFY) )
	    {
		/* Notify the parent window only */

		NotifyParent(WM_CREATE, 0, 0);
                if( !IsWindow() )
                {
                    return FALSE;
	        }
	    }

            if (cs->style & WS_VISIBLE) ShowWindow( sw );

#if 0
            /* Call WH_SHELL hook */

            if (!(dwStyle & WS_CHILD) && !owner)
                HOOK_CallHooks16( WH_SHELL, HSHELL_WINDOWCREATED, hwnd, 0 );
#endif
	    return TRUE;
        }
  }
  return FALSE;
}
#if 0
/***********************************************************************
 *           WINPOS_MinMaximize
 *
 * Fill in lpRect and return additional flags to be used with SetWindowPos().
 * This function assumes that 'cmd' is different from the current window
 * state.
 */
UINT Win32Window::MinMaximize(UINT16 cmd, LPRECT16 lpRect )
{
    UINT swpFlags = 0;
    POINT pt, size;
    LPINTERNALPOS lpPos;

    size.x = rectWindow.left; size.y = rectWindow.top;
    lpPos = WINPOS_InitInternalPos( wndPtr, size, &rectWindow );

    if (lpPos && !HOOK_CallHooks16(WH_CBT, HCBT_MINMAX, hwndSelf, cmd))
    {
	if( dwStyle & WS_MINIMIZE )
	{
	    if( !SendMessageA(WM_QUERYOPEN, 0, 0L ) )
		return (SWP_NOSIZE | SWP_NOMOVE);
	    swpFlags |= SWP_NOCOPYBITS;
	}
	switch( cmd )
	{
	    case SW_MINIMIZE:
		 if( dwStyle & WS_MAXIMIZE)
		 {
		     flags |= WIN_RESTORE_MAX;
		     dwStyle &= ~WS_MAXIMIZE;
                 }
                 else
		     flags &= ~WIN_RESTORE_MAX;
		 dwStyle |= WS_MINIMIZE;

#if 0
		 if( flags & WIN_NATIVE )
		     if( pDriver->pSetHostAttr( wndPtr, HAK_ICONICSTATE, TRUE ) )
			 swpFlags |= MINMAX_NOSWP;
#endif

		 lpPos->ptIconPos = WINPOS_FindIconPos( wndPtr, lpPos->ptIconPos );

		 SetRect(lpRect, lpPos->ptIconPos.x, lpPos->ptIconPos.y,
			 GetSystemMetrics(SM_CXICON), GetSystemMetrics(SM_CYICON) );
		 swpFlags |= SWP_NOCOPYBITS;
		 break;

	    case SW_MAXIMIZE:
                CONV_POINT16TO32( &lpPos->ptMaxPos, &pt );
                WINPOS_GetMinMaxInfo( wndPtr, &size, &pt, NULL, NULL );
                CONV_POINT32TO16( &pt, &lpPos->ptMaxPos );

		 if( dwStyle & WS_MINIMIZE )
		 {
		     if( flags & WIN_NATIVE )
			 if( pDriver->pSetHostAttr( wndPtr, HAK_ICONICSTATE, FALSE ) )
			     swpFlags |= MINMAX_NOSWP;

		     WINPOS_ShowIconTitle( wndPtr, FALSE );
		     dwStyle &= ~WS_MINIMIZE;
		 }
                 dwStyle |= WS_MAXIMIZE;

		 SetRect16( lpRect, lpPos->ptMaxPos.x, lpPos->ptMaxPos.y,
				    size.x, size.y );
		 break;

	    case SW_RESTORE:
		 if( dwStyle & WS_MINIMIZE )
		 {
		     if( flags & WIN_NATIVE )
			 if( pDriver->pSetHostAttr( wndPtr, HAK_ICONICSTATE, FALSE ) )
			     swpFlags |= MINMAX_NOSWP;

		     dwStyle &= ~WS_MINIMIZE;
		     WINPOS_ShowIconTitle( wndPtr, FALSE );

		     if( flags & WIN_RESTORE_MAX)
		     {
			 /* Restore to maximized position */
                         CONV_POINT16TO32( &lpPos->ptMaxPos, &pt );
                         WINPOS_GetMinMaxInfo( wndPtr, &size, &pt, NULL, NULL);
                         CONV_POINT32TO16( &pt, &lpPos->ptMaxPos );
			 dwStyle |= WS_MAXIMIZE;
			 SetRect16( lpRect, lpPos->ptMaxPos.x, lpPos->ptMaxPos.y, size.x, size.y );
			 break;
		     }
		 } 
		 else 
		     if( !(dwStyle & WS_MAXIMIZE) ) return (UINT16)(-1);
 		     else dwStyle &= ~WS_MAXIMIZE;

		 /* Restore to normal position */

		*lpRect = lpPos->rectNormal; 
		 lpRect->right -= lpRect->left; 
		 lpRect->bottom -= lpRect->top;

		 break;
	}
    } else swpFlags |= SWP_NOSIZE | SWP_NOMOVE;
    return swpFlags;
}
#endif
/*******************************************************************
 *           GetMinMaxInfo
 *
 * Get the minimized and maximized information for a window.
 */
void Win32Window::GetMinMaxInfo(POINT *maxSize, POINT *maxPos,
                                POINT *minTrack, POINT *maxTrack )
{
    MINMAXINFO MinMax;
    INT xinc, yinc;

    /* Compute default values */

    MinMax.ptMaxSize.x = GetSystemMetrics(SM_CXSCREEN);
    MinMax.ptMaxSize.y = GetSystemMetrics(SM_CYSCREEN);
    MinMax.ptMinTrackSize.x = GetSystemMetrics(SM_CXMINTRACK);
    MinMax.ptMinTrackSize.y = GetSystemMetrics(SM_CYMINTRACK);
    MinMax.ptMaxTrackSize.x = GetSystemMetrics(SM_CXSCREEN);
    MinMax.ptMaxTrackSize.y = GetSystemMetrics(SM_CYSCREEN);

    if (flags & WIN_MANAGED) xinc = yinc = 0;
    else if (HAS_DLGFRAME( dwStyle, dwExStyle ))
    {
        xinc = GetSystemMetrics(SM_CXDLGFRAME);
        yinc = GetSystemMetrics(SM_CYDLGFRAME);
    }
    else
    {
        xinc = yinc = 0;
        if (HAS_THICKFRAME(dwStyle))
        {
            xinc += GetSystemMetrics(SM_CXFRAME);
            yinc += GetSystemMetrics(SM_CYFRAME);
        }
        if (dwStyle & WS_BORDER)
        {
            xinc += GetSystemMetrics(SM_CXBORDER);
            yinc += GetSystemMetrics(SM_CYBORDER);
        }
    }
    MinMax.ptMaxSize.x += 2 * xinc;
    MinMax.ptMaxSize.y += 2 * yinc;

#if 0
    lpPos = (LPINTERNALPOS)GetPropA( hwndSelf, atomInternalPos );
    if( lpPos && !EMPTYPOINT(lpPos->ptMaxPos) )
        CONV_POINT16TO32( &lpPos->ptMaxPos, &MinMax.ptMaxPosition );
    else
    {
#endif
        MinMax.ptMaxPosition.x = -xinc;
        MinMax.ptMaxPosition.y = -yinc;
//    }

    SendMessageA(WM_GETMINMAXINFO, 0, (LPARAM)&MinMax );

      /* Some sanity checks */

    dprintf(("GetMinMaxInfo: %ld %ld / %ld %ld / %ld %ld / %ld %ld\n",
                      MinMax.ptMaxSize.x, MinMax.ptMaxSize.y,
                      MinMax.ptMaxPosition.x, MinMax.ptMaxPosition.y,
                      MinMax.ptMaxTrackSize.x, MinMax.ptMaxTrackSize.y,
                      MinMax.ptMinTrackSize.x, MinMax.ptMinTrackSize.y));
    MinMax.ptMaxTrackSize.x = MAX( MinMax.ptMaxTrackSize.x,
                                   MinMax.ptMinTrackSize.x );
    MinMax.ptMaxTrackSize.y = MAX( MinMax.ptMaxTrackSize.y,
                                   MinMax.ptMinTrackSize.y );

    if (maxSize) *maxSize = MinMax.ptMaxSize;
    if (maxPos) *maxPos = MinMax.ptMaxPosition;
    if (minTrack) *minTrack = MinMax.ptMinTrackSize;
    if (maxTrack) *maxTrack = MinMax.ptMaxTrackSize;
}
/***********************************************************************
 *           WINPOS_SendNCCalcSize
 *
 * Send a WM_NCCALCSIZE message to a window.
 * All parameters are read-only except newClientRect.
 * oldWindowRect, oldClientRect and winpos must be non-NULL only
 * when calcValidRect is TRUE.
 */
LONG Win32Window::SendNCCalcSize(BOOL calcValidRect,
                            RECT *newWindowRect, RECT *oldWindowRect,
                            RECT *oldClientRect, WINDOWPOS *winpos,
                            RECT *newClientRect )
{
   NCCALCSIZE_PARAMS params;
   WINDOWPOS winposCopy;
   LONG result;

   params.rgrc[0] = *newWindowRect;
   if (calcValidRect)
   {
        winposCopy = *winpos;
	params.rgrc[1] = *oldWindowRect;
	params.rgrc[2] = *oldClientRect;
	params.lppos = &winposCopy;
   }
   result = SendMessageA(WM_NCCALCSIZE, calcValidRect,
                          (LPARAM)&params );
   *newClientRect = params.rgrc[0];
   return result;
}
//******************************************************************************
//******************************************************************************
ULONG Win32Window::MsgCreate(HWND hwndOS2, ULONG initParam)
{
  OS2Hwnd = hwndOS2;
  return SendMessageA(WM_CREATE, 0, initParam);
}
//******************************************************************************
//******************************************************************************
ULONG Win32Window::MsgQuit()
{
  return SendMessageA(WM_QUIT, 0, 0);
}
//******************************************************************************
//******************************************************************************
ULONG Win32Window::MsgClose()
{
  return SendMessageA(WM_CLOSE, 0, 0);
}
//******************************************************************************
//******************************************************************************
ULONG Win32Window::MsgDestroy()
{
 ULONG rc;

  rc = SendMessageA(WM_DESTROY, 0, 0);
  delete this;
  return rc;
}
//******************************************************************************
//******************************************************************************
ULONG Win32Window::MsgEnable(BOOL fEnable)
{
  return SendMessageA(WM_ENABLE, fEnable, 0);
}
//******************************************************************************
//TODO: SW_PARENTCLOSING/OPENING flag (lParam)
//******************************************************************************
ULONG Win32Window::MsgShow(BOOL fShow)
{
  return SendMessageA(WM_SHOWWINDOW, fShow, 0);
}
//******************************************************************************
//******************************************************************************
ULONG Win32Window::MsgMove(ULONG xScreen, ULONG yScreen, ULONG xParent, ULONG yParent)
{
  return 0;
}
//******************************************************************************
//TODO: Send WM_NCCALCSIZE message here and correct size if necessary
//******************************************************************************
ULONG Win32Window::MsgSize(ULONG width, ULONG height, BOOL fMinimize, BOOL fMaximize)
{
 WORD fwSizeType = 0;

  if(fMinimize) {
        fwSizeType = SIZE_MINIMIZED;
  }
  else
  if(fMaximize) {
        fwSizeType = SIZE_MAXIMIZED;
  }
  else  fwSizeType = SIZE_RESTORED;

  return SendMessageA(WM_SIZE, fwSizeType, MAKELONG((USHORT)width, (USHORT)height));
}
//******************************************************************************
//******************************************************************************
ULONG Win32Window::MsgActivate(BOOL fActivate, HWND hwnd)
{
  return SendMessageA(WM_ACTIVATE, (fActivate) ? WA_ACTIVE : WA_INACTIVE, hwnd);
}
//******************************************************************************
//******************************************************************************
ULONG Win32Window::MsgSetFocus(HWND hwnd)
{
  return SendMessageA(WM_SETFOCUS, hwnd, 0);
}
//******************************************************************************
//******************************************************************************
ULONG Win32Window::MsgKillFocus(HWND hwnd)
{
  return SendMessageA(WM_KILLFOCUS, hwnd, 0);
}
//******************************************************************************
//******************************************************************************
ULONG Win32Window::MsgButton(ULONG msg, ULONG x, ULONG y)
{
 ULONG win32msg;

  switch(msg) {
        case BUTTON_LEFTDOWN:
                win32msg = WM_LBUTTONDOWN;
                break;
        case BUTTON_LEFTUP:
                win32msg = WM_LBUTTONUP;
                break;
        case BUTTON_LEFTDBLCLICK:
                win32msg = WM_LBUTTONDBLCLK;
                break;
        case BUTTON_RIGHTUP:
                win32msg = WM_RBUTTONUP;
                break;
        case BUTTON_RIGHTDOWN:
                win32msg = WM_RBUTTONDOWN;
                break;
        case BUTTON_RIGHTDBLCLICK:
                win32msg = WM_RBUTTONDBLCLK;
                break;
        default:
                dprintf(("Win32Window::Button: invalid msg!!!!"));
                return 1;
  }
  return SendMessageA(win32msg, 0, MAKELONG(x, OS2TOWIN32POINT(height, y)));
}
//******************************************************************************
//******************************************************************************
ULONG Win32Window::MsgPaint(ULONG tmp1, ULONG tmp2)
{
  return SendMessageA(WM_PAINT, 0, 0);
}
//******************************************************************************
//******************************************************************************
ULONG Win32Window::MsgEraseBackGround(ULONG hps)
{
  return SendMessageA(WM_ERASEBKGND, hps, 0);
}
//******************************************************************************
//******************************************************************************
LRESULT Win32Window::SendMessageA(ULONG Msg, WPARAM wParam, LPARAM lParam)
{
  if(PostSpyMessage(getWindowHandle(), Msg, wParam, lParam) == FALSE)
        dprintf(("SendMessageA %s for %x %x %x", GetMsgText(Msg), getWindowHandle(), wParam, lParam));

  if(HkCBT::OS2HkCBTProc(getWindowHandle(), Msg, wParam, lParam) == TRUE) {//hook swallowed msg
        return(0);
  }
  switch(Msg)
  {
        case WM_CREATE:
        {
                if(win32wndproc(getWindowHandle(), WM_NCCREATE, 0, lParam) == 0) {
                        dprintf(("WM_NCCREATE returned FALSE\n"));
                        return(0); //don't create window
                }
                if(win32wndproc(getWindowHandle(), WM_CREATE, 0, lParam) == 0) {
                        dprintf(("WM_CREATE returned FALSE\n"));
                        return(0); //don't create window
                }
                NotifyParent(Msg, wParam, lParam);

                return(1);
        }
        case WM_LBUTTONDOWN:
        case WM_MBUTTONDOWN:
        case WM_RBUTTONDOWN:
                NotifyParent(Msg, wParam, lParam);
                return win32wndproc(getWindowHandle(), Msg, wParam, lParam);

        case WM_DESTROY:
                win32wndproc(getWindowHandle(), WM_NCDESTROY, 0, 0);
                NotifyParent(Msg, wParam, lParam);
                return win32wndproc(getWindowHandle(), WM_DESTROY, 0, 0);
        default:
                return win32wndproc(getWindowHandle(), Msg, wParam, lParam);
  }
}
//******************************************************************************
//todo, unicode msgs
//******************************************************************************
LRESULT Win32Window::SendMessageW(ULONG Msg, WPARAM wParam, LPARAM lParam)
{
  if(PostSpyMessage(getWindowHandle(), Msg, wParam, lParam) == FALSE)
        dprintf(("SendMessageA %s for %x %x %x", GetMsgText(Msg), getWindowHandle(), wParam, lParam));

  if(HkCBT::OS2HkCBTProc(getWindowHandle(), Msg, wParam, lParam) == TRUE) {//hook swallowed msg
        return(0);
  }
  switch(Msg)
  {
        case WM_CREATE:
        {
                if(win32wndproc(getWindowHandle(), WM_NCCREATE, 0, lParam) == 0) {
                        dprintf(("WM_NCCREATE returned FALSE\n"));
                        return(0); //don't create window
                }
                if(win32wndproc(getWindowHandle(), WM_CREATE, 0, lParam) == 0) {
                        dprintf(("WM_CREATE returned FALSE\n"));
                        return(0); //don't create window
                }
                NotifyParent(Msg, wParam, lParam);

                return(1);
        }
        case WM_LBUTTONDOWN:
        case WM_MBUTTONDOWN:
        case WM_RBUTTONDOWN:
                NotifyParent(Msg, wParam, lParam);
                return win32wndproc(getWindowHandle(), Msg, wParam, lParam);

        case WM_DESTROY:
                win32wndproc(getWindowHandle(), WM_NCDESTROY, 0, 0);
                NotifyParent(Msg, wParam, lParam);
                return win32wndproc(getWindowHandle(), WM_DESTROY, 0, 0);
        default:
                return win32wndproc(getWindowHandle(), Msg, wParam, lParam);
  }
}
//******************************************************************************
//******************************************************************************
BOOL Win32Window::PostMessageA(ULONG msg, WPARAM wParam, LPARAM lParam)
{
 POSTMSG_PACKET *postmsg;

  postmsg = (POSTMSG_PACKET *)malloc(sizeof(POSTMSG_PACKET));
  if(postmsg == NULL) {
	dprintf(("Win32Window::PostMessageA: malloc returned NULL!!"));
	return 0;
  }
  postmsg->Msg    = msg;
  postmsg->wParam = wParam;
  postmsg->lParam = lParam;
  return OSLibPostMessage(OS2Hwnd, WM_WIN32_POSTMESSAGEA, (ULONG)postmsg, 0);
}
//******************************************************************************
//******************************************************************************
BOOL Win32Window::PostMessageW(ULONG msg, WPARAM wParam, LPARAM lParam)
{
 POSTMSG_PACKET *postmsg;

  postmsg = (POSTMSG_PACKET *)malloc(sizeof(POSTMSG_PACKET));
  if(postmsg == NULL) {
	dprintf(("Win32Window::PostMessageW: malloc returned NULL!!"));
	return 0;
  }
  postmsg->Msg    = msg;
  postmsg->wParam = wParam;
  postmsg->lParam = lParam;
  return OSLibPostMessage(OS2Hwnd, WM_WIN32_POSTMESSAGEW, (ULONG)postmsg, 0);
}
//******************************************************************************
//TODO: do we need to inform the parent of the parent (etc) of the child window?
//******************************************************************************
void Win32Window::NotifyParent(UINT Msg, WPARAM wParam, LPARAM lParam)
{
 Win32Window *window = this;
 Win32Window *parentwindow;

   while(window)
   {
        if(window->getStyle() & WS_CHILD && !(window->getExStyle() & WS_EX_NOPARENTNOTIFY) )
        {
                /* Notify the parent window only */
                parentwindow = window->getParent();
                if(parentwindow) {
                        if(Msg == WM_CREATE || Msg == WM_DESTROY) {
                                parentwindow->SendMessageA(WM_PARENTNOTIFY, MAKEWPARAM(Msg, window->getWindowId()), (LPARAM)window->getWindowHandle());
                        }
                        else    parentwindow->SendMessageA(WM_PARENTNOTIFY, MAKEWPARAM(Msg, window->getWindowId()), lParam );
                }
        }
        else    break;

        window = parentwindow;
   }
}
//******************************************************************************
//******************************************************************************
BOOL Win32Window::SetMenu(ULONG hMenu)
{
 PVOID menutemplate;

   if(HMHandleTranslateToOS2(hMenu, (PULONG)&menutemplate) == NO_ERROR) 
   {
	OS2HwndMenu = OSLibWinCreateMenu(OS2HwndFrame, menutemplate);
	if(OS2HwndMenu == 0) {
		dprintf(("Win32Window::SetMenu OS2HwndMenu == 0"));
		return FALSE;
	}
   }
   dprintf(("Win32Window::SetMenu unknown hMenu (%x)", hMenu));
   return FALSE;
}
//******************************************************************************
//******************************************************************************
BOOL Win32Window::ShowWindow(ULONG nCmdShow)
{
 ULONG showstate = 0;

  switch(nCmdShow)
  {
	case SW_SHOW:
	case SW_SHOWDEFAULT: //todo
		showstate = SWPOS_SHOW;
		break;
	case SW_HIDE:
		showstate = SWPOS_HIDE;
		break;
	case SW_MINIMIZE:
		showstate = SWPOS_MINIMIZE;
		break;
	case SW_SHOWMAXIMIZED:
		showstate = SWPOS_MAXIMIZE | SWPOS_SHOW;
		break;
	case SW_SHOWMINIMIZED:
		showstate = SWPOS_MINIMIZE | SWPOS_SHOW;
		break;
	case SW_SHOWMINNOACTIVE:  //TODO
		showstate = SWPOS_MINIMIZE | SWPOS_SHOW;
		break;
	case SW_SHOWNA: //TODO
		showstate = SWPOS_SHOW;
		break;
	case SW_SHOWNOACTIVATE:  //TODO
		showstate = SWPOS_SHOW;
		break;
	case SW_SHOWNORMAL:
		showstate = SWPOS_RESTORE;
		break;
  }
  return OSLibWinShowWindow(OS2HwndFrame, showstate);
}
//******************************************************************************
//******************************************************************************
BOOL Win32Window::SetWindowPos(HWND hwndInsertAfter, int x, int y, int cx, int cy, UINT fuFlags)
{
 Win32Window *window;
 ULONG        setstate = 0;

  switch(hwndInsertAfter) {
  	case HWND_BOTTOM:
		hwndInsertAfter = HWNDOS_BOTTOM;
		break;
	case HWND_TOPMOST: //TODO:
	case HWND_NOTOPMOST: //TODO:
  	case HWND_TOP:
		hwndInsertAfter = HWNDOS_TOP;
		break;
	default:
		window = GetWindowFromHandle(hwndInsertAfter);
		if(window) {
			hwndInsertAfter = window->getOS2WindowHandle();
		}
		else {
			dprintf(("Win32Window::SetWindowPos, unknown hwndInsertAfter %x", hwndInsertAfter));
			hwndInsertAfter = 0;
		}
		break;
		
  }
  setstate = SWPOS_MOVE | SWPOS_SIZE | SWPOS_ACTIVATE | SWPOS_ZORDER;
  if(fuFlags & SWP_DRAWFRAME)
	setstate |= 0; //TODO
  if(fuFlags & SWP_FRAMECHANGED)
	setstate |= 0; //TODO
  if(fuFlags & SWP_HIDEWINDOW)
	setstate &= ~SWPOS_ZORDER;
  if(fuFlags & SWP_NOACTIVATE)
	setstate &= ~SWPOS_ACTIVATE;
  if(fuFlags & SWP_NOCOPYBITS)
	setstate |= 0;		//TODO
  if(fuFlags & SWP_NOMOVE)
	setstate &= ~SWPOS_MOVE;
  if(fuFlags & SWP_NOSIZE)
	setstate &= ~SWPOS_SIZE;
  if(fuFlags & SWP_NOREDRAW)
	setstate |= SWPOS_NOREDRAW;
  if(fuFlags & SWP_NOZORDER)
	setstate &= ~SWPOS_ZORDER;
  if(fuFlags & SWP_SHOWWINDOW)
	setstate |= SWPOS_SHOW;

  return OSLibWinSetWindowPos(OS2HwndFrame, hwndInsertAfter, x, y, cx, cy, setstate);
}
//******************************************************************************
//Also destroys all the child windows (destroy parent, destroy children)
//******************************************************************************
BOOL Win32Window::DestroyWindow()
{
  return OSLibWinDestroyWindow(OS2HwndFrame);
}
//******************************************************************************
//******************************************************************************
HWND Win32Window::GetParent()
{
  if(getParent()) {
	return getParent()->getWindowHandle();
  }
  else	return 0;
}
//******************************************************************************
//******************************************************************************
HWND Win32Window::SetParent(HWND hwndNewParent)
{
 HWND oldhwnd;
 Win32Window *newparent;

   if(getParent()) {
    	oldhwnd = getParent()->getWindowHandle();
   }
   else oldhwnd = 0;

   if(hwndNewParent == 0) {//desktop window = parent
 	setParent(NULL);
        OSLibWinSetParent(getOS2WindowHandle(), OSLIB_HWND_DESKTOP);
        return oldhwnd;
   }
   newparent = GetWindowFromHandle(hwndNewParent);
   if(newparent)
   {
        setParent(newparent);
        OSLibWinSetParent(getOS2WindowHandle(), getParent()->getOS2WindowHandle());
        return oldhwnd;
   }
   SetLastError(ERROR_INVALID_PARAMETER);
   return 0;
}
//******************************************************************************
//******************************************************************************
BOOL Win32Window::IsChild(HWND hwndParent)
{
  if(getParent()) {
	return getParent()->getWindowHandle() == hwndParent;
  }
  else 	return 0;
}
//******************************************************************************
//******************************************************************************
HWND Win32Window::GetTopWindow()
{
  return GetWindow(GW_CHILD);
}
//******************************************************************************
//Don't call WinUpdateWindow as that one also updates the child windows
//Also need to send WM_PAINT directly to the window procedure, which doesn't
//always happen with WinUpdateWindow (could be posted if thread doesn't own window)
//******************************************************************************
BOOL Win32Window::UpdateWindow()
{  
 RECTL rect;

  if(OSLibWinQueryUpdateRect(OS2Hwnd, (PVOID)&rect))
  {//update region not empty
	SendMessageA((isIcon) ? WM_PAINTICON : WM_PAINT, 0, 0);
  }
  return TRUE;
}
//******************************************************************************
//******************************************************************************
BOOL Win32Window::IsIconic()
{
  return OSLibWinIsIconic(OS2HwndFrame);
}
//******************************************************************************
//TODO: not complete nor correct (distinction between top-level, top-most & child windows)
//******************************************************************************
HWND Win32Window::GetWindow(UINT uCmd)
{
 Win32Window  *win32wnd;
 ULONG         magic;
 ULONG         getcmd = 0;
 HWND          hwndRelated;

  dprintf(("GetWindow %x %d NOT COMPLETE", getWindowHandle(), uCmd));
  switch(uCmd)
  {
	case GW_CHILD:
		getcmd = QWOS_TOP;
		break;
	case GW_HWNDFIRST:
		if(getParent()) {
			getcmd = QWOS_TOP; //top of child windows
		}
		else	getcmd = QWOS_TOP; //TODO
		break;
	case GW_HWNDLAST:
		if(getParent()) {
			getcmd = QWOS_BOTTOM; //bottom of child windows
		}
		else	getcmd = QWOS_BOTTOM; //TODO
		break;
	case GW_HWNDNEXT:
		getcmd = QWOS_NEXT;
		break;
	case GW_HWNDPREV:
		getcmd = QWOS_PREV;
		break;
	case GW_OWNER:
		if(owner) {
			return owner->getWindowHandle();
		}
		else 	return 0;
  }
  hwndRelated = OSLibWinQueryWindow(OS2HwndFrame, getcmd);
  if(hwndRelated) 
  {
	win32wnd = (Win32Window *)OSLibWinGetWindowULong(hwndRelated, OFFSET_WIN32WNDPTR);
	magic    = OSLibWinGetWindowULong(hwndRelated, OFFSET_WIN32PM_MAGIC);
	if(CheckMagicDword(magic) && win32wnd)
	{
		return win32wnd->getWindowHandle();
	}
  }
  return 0;
}
//******************************************************************************
//******************************************************************************
HWND Win32Window::SetActiveWindow()
{
  return OSLibWinSetActiveWindow(OS2HwndFrame);
}
//******************************************************************************
//WM_ENABLE is sent to hwnd, but not to it's children (as it should be)
//******************************************************************************
BOOL Win32Window::EnableWindow(BOOL fEnable)
{
  return OSLibWinEnableWindow(OS2HwndFrame, fEnable);
}
//******************************************************************************
//******************************************************************************
BOOL Win32Window::BringWindowToTop()
{
  return SetWindowPos(HWND_TOP, 0, 0, 0, 0, SWP_NOMOVE|SWP_NOSIZE );
}
//******************************************************************************
//******************************************************************************
HWND Win32Window::GetActiveWindow()
{
 HWND          hwndActive;
 Win32Window  *win32wnd;
 ULONG         magic;

  hwndActive = OSLibWinQueryActiveWindow();

  win32wnd = (Win32Window *)OSLibWinGetWindowULong(hwndActive, OFFSET_WIN32WNDPTR);
  magic    = OSLibWinGetWindowULong(hwndActive, OFFSET_WIN32PM_MAGIC);
  if(CheckMagicDword(magic) && win32wnd)
  {
	return win32wnd->getWindowHandle();
  }
  return hwndActive;
}
//******************************************************************************
//******************************************************************************
BOOL Win32Window::IsWindow()
{
  return TRUE;
}
//******************************************************************************
//******************************************************************************
BOOL Win32Window::IsWindowEnabled()
{
  return OSLibWinIsWindowEnabled(OS2Hwnd);
}
//******************************************************************************
//******************************************************************************
BOOL Win32Window::IsWindowVisible()
{
  return OSLibWinIsWindowVisible(OS2Hwnd);
}
//******************************************************************************
//******************************************************************************
LONG Win32Window::SetWindowLongA(int index, ULONG value)
{
 LONG oldval;

   switch(index) {
        case GWL_EXSTYLE:
                oldval = dwExStyle;
                dwExStyle = value;
                return oldval;
        case GWL_STYLE:
                oldval = dwStyle;
                dwStyle = value;
                return oldval;
        case GWL_WNDPROC:
                oldval = (LONG)getWindowProc();
                setWindowProc((WNDPROC)value);
                return oldval;
        case GWL_HINSTANCE:
                oldval = hInstance;
                hInstance = value;
                return oldval;
        case GWL_HWNDPARENT:
		return SetParent((HWND)value);

        case GWL_ID:
                oldval = getWindowId();
                setWindowId(value);
                return oldval;
        case GWL_USERDATA:
                oldval = userData;
                userData = value;
                return oldval;
        default:
                if(index >= 0 && index/4 < nrUserWindowLong)
                {
                        oldval = userWindowLong[index/4];
                        userWindowLong[index/4] = value;
                        return oldval;
                }
                SetLastError(ERROR_INVALID_PARAMETER);
                return 0;
   }
}
//******************************************************************************
//******************************************************************************
ULONG Win32Window::GetWindowLongA(int index)
{
   switch(index) {
        case GWL_EXSTYLE:
                return dwExStyle;
        case GWL_STYLE:
                return dwStyle;
        case GWL_WNDPROC:
                return (ULONG)getWindowProc();
        case GWL_HINSTANCE:
                return hInstance;
        case GWL_HWNDPARENT:
                if(getParent()) {
                        return getParent()->getWindowHandle();
                }
                else    return 0;
        case GWL_ID:
                return getWindowId();
        case GWL_USERDATA:
                return userData;
        default:
                if(index >= 0 && index/4 < nrUserWindowLong)
                {
                        return userWindowLong[index/4];
                }
                SetLastError(ERROR_INVALID_PARAMETER);
                return 0;
   }
}
//******************************************************************************
//******************************************************************************
WORD Win32Window::SetWindowWord(int index, WORD value)
{
 WORD oldval;

   if(index >= 0 && index/4 < nrUserWindowLong)
   {
        oldval = ((WORD *)userWindowLong)[index/2];
        ((WORD *)userWindowLong)[index/2] = value;
        return oldval;
   }
   SetLastError(ERROR_INVALID_PARAMETER);
   return 0;
}
//******************************************************************************
//******************************************************************************
WORD Win32Window::GetWindowWord(int index)
{
   if(index >= 0 && index/4 < nrUserWindowLong)
   {
        return ((WORD *)userWindowLong)[index/2];
   }
   SetLastError(ERROR_INVALID_PARAMETER);
   return 0;
}
//******************************************************************************
//******************************************************************************
Win32Window *Win32Window::GetWindowFromHandle(HWND hwnd)
{
 Win32Window *window;

   if(HIWORD(hwnd) != 0x6800) {
	return NULL;
   }

   if(HMHandleTranslateToOS2(LOWORD(hwnd), (PULONG)&window) == NO_ERROR) {
	return window;
   }
   else return NULL;
}
//******************************************************************************
//******************************************************************************
GenericObject *Win32Window::windows  = NULL;
