/* $Id: win32wndhandle.cpp,v 1.7 2000-03-23 19:24:26 sandervl Exp $ */
/*
 * Win32 Handle Management Code for OS/2
 *
 *
 * Copyright 1998 Sander van Leeuwen (sandervl@xs4all.nl)
 *
 *
 * TODO: The table should be dynamically increased when necessary
 *       This is just a quick and dirty implementation 
 * TODO: Probably need to clean up the table when app closes
 *       (also store PID and remove all handles with PID of terminating app)
 * 
 * Project Odin Software License can be found in LICENSE.TXT
 *
 */

#include <os2win.h>
#include <vmutex.h>
#include "win32wndhandle.h"

#define DBG_LOCALLOG	DBG_win32wndhandle
#include "dbglocal.h"

//******************************************************************************

//NOTE: This must be in the local data segment -> if a shared semaphore was
//      created by a different process, the handle returned by DosOpenMutexSem
//      will be returned in hGlobalTableMutex
HMTX hGlobalTableMutex = 0;

//Global DLL Data
#pragma data_seg(_GLOBALDATA)
ULONG  WindowHandleTable[MAX_WINDOW_HANDLES] = {0};
VMutex tableMutex(VMUTEX_SHARED, &hGlobalTableMutex);
ULONG  lowestFreeIndex = 0;
#pragma data_seg()

//******************************************************************************
//******************************************************************************
BOOL HwAllocateWindowHandle(HWND *hwnd, DWORD dwUserData)
{
  tableMutex.enter(VMUTEX_WAIT_FOREVER, &hGlobalTableMutex);
  if(lowestFreeIndex == -1) {
	//oops, out of handles
	dprintf(("USER32: HwAllocateWindowHandle OUT OF WINDOW HANDLES!!"));
	tableMutex.leave(&hGlobalTableMutex);
	DebugInt3();
	return FALSE;
  }
  *hwnd           = lowestFreeIndex;
  *hwnd          |= WNDHANDLE_MAGIC_HIGHWORD;
  WindowHandleTable[lowestFreeIndex] = dwUserData;

  lowestFreeIndex = -1;

  //find next free handle
  for(int i=0;i<MAX_WINDOW_HANDLES;i++) {
	if(WindowHandleTable[i] == 0) {
		lowestFreeIndex = i;
		break;
	}
  }
  tableMutex.leave(&hGlobalTableMutex);
  return TRUE;
}
//******************************************************************************
//******************************************************************************
void HwFreeWindowHandle(HWND hwnd)
{
  hwnd &= WNDHANDLE_MAGIC_MASK;
  if(hwnd < MAX_WINDOW_HANDLES) {
	tableMutex.enter(VMUTEX_WAIT_FOREVER, &hGlobalTableMutex);
	WindowHandleTable[hwnd] = 0;
	if(lowestFreeIndex == -1 || hwnd < lowestFreeIndex) 
		lowestFreeIndex = hwnd;

	tableMutex.leave(&hGlobalTableMutex);
  }
}
//******************************************************************************
//******************************************************************************
BOOL HwGetWindowHandleData(HWND hwnd, DWORD *pdwUserData)
{
  if((hwnd & 0xFFFF0000) != WNDHANDLE_MAGIC_HIGHWORD) {
	return FALSE; //unknown window (PM?)
  }
  hwnd &= WNDHANDLE_MAGIC_MASK;
  if(hwnd < MAX_WINDOW_HANDLES) {
	*pdwUserData = WindowHandleTable[hwnd];
	return TRUE;
  }
  *pdwUserData = 0;
  return FALSE;
}
//******************************************************************************
//******************************************************************************
